/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * GupWasserkoerper.java
 *
 * Created on 19.10.2011, 11:49:19
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.ComponentRegistry;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;

import de.cismet.cids.custom.wrrl_db_mv.commons.WRRLUtil;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class GupWasserkoerper extends javax.swing.JPanel implements CidsBeanRenderer, EditorSaveListener {

    //~ Static fields/initializers ---------------------------------------------

    private static final MetaClass MC = ClassCacheMultiple.getMetaClass(
            WRRLUtil.DOMAIN_NAME,
            "wk_fg");

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private boolean readOnly = false;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.tools.gui.RoundedPanel glassPanel;
    private javax.swing.JLabel lblHeading2;
    private javax.swing.JLabel lblScreenshot;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo2;
    private de.cismet.tools.gui.RoundedPanel panInfo1;
    private javax.swing.JPanel panInfoContent1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form GupMassnahmeSohle.
     */
    public GupWasserkoerper() {
        this(false);
    }

    /**
     * Creates new form GupMassnahmeSohle.
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public GupWasserkoerper(final boolean readOnly) {
        this.readOnly = readOnly;
        initComponents();

        setReadOnly(readOnly);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        panInfo1 = new de.cismet.tools.gui.RoundedPanel();
        panHeadInfo2 = new de.cismet.tools.gui.SemiRoundedPanel();
        lblHeading2 = new javax.swing.JLabel();
        panInfoContent1 = new javax.swing.JPanel();
        lblScreenshot = new javax.swing.JLabel();
        glassPanel = new de.cismet.tools.gui.RoundedPanel();

        setMaximumSize(new java.awt.Dimension(2147483647, 265));
        setMinimumSize(new java.awt.Dimension(390, 265));
        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(390, 265));
        setLayout(new java.awt.GridBagLayout());

        panHeadInfo2.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo2.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo2.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo2.setLayout(new java.awt.FlowLayout());

        lblHeading2.setForeground(new java.awt.Color(255, 255, 255));
        panHeadInfo2.add(lblHeading2);

        panInfo1.add(panHeadInfo2, java.awt.BorderLayout.NORTH);

        panInfoContent1.setMinimumSize(new java.awt.Dimension(390, 245));
        panInfoContent1.setOpaque(false);
        panInfoContent1.setPreferredSize(new java.awt.Dimension(390, 245));
        panInfoContent1.setLayout(new java.awt.GridBagLayout());

        lblScreenshot.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/wk_fg_screenshot.jpg"))); // NOI18N
        lblScreenshot.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        lblScreenshot.setMaximumSize(new java.awt.Dimension(360, 218));
        lblScreenshot.setMinimumSize(new java.awt.Dimension(360, 218));
        lblScreenshot.setPreferredSize(new java.awt.Dimension(360, 218));
        lblScreenshot.addMouseListener(new java.awt.event.MouseAdapter() {

                @Override
                public void mouseClicked(final java.awt.event.MouseEvent evt) {
                    lblScreenshotMouseClicked(evt);
                }
            });
        panInfoContent1.add(lblScreenshot, new java.awt.GridBagConstraints());

        panInfo1.add(panInfoContent1, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 15, 15, 15);
        add(panInfo1, gridBagConstraints);

        glassPanel.setAlpha(0);
        glassPanel.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(glassPanel, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lblScreenshotMouseClicked(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_lblScreenshotMouseClicked
        if (cidsBean != null) {
            ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObject(cidsBean.getMetaObject(), "");
        }
    }                                                                             //GEN-LAST:event_lblScreenshotMouseClicked

    @Override
    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
//        bindingGroup.unbind();
        this.cidsBean = cidsBean;

        if (cidsBean != null) {
//            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
//                bindingGroup,
//                cidsBean);
//            bindingGroup.bind();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  name  DOCUMENT ME!
     */
    public void setBeanName(final String name) {
        lblHeading2.setText(name);

        new Thread(new Runnable() {

                @Override
                public void run() {
                    try {
                        if (cidsBean == null) {
                            final String query = "select " + MC.getID() + ", " + MC.getPrimaryKey() + " from "
                                        + MC.getTableName() + " where wk_k = '" + name + "'";
                            final MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);

                            if ((metaObjects != null) && (metaObjects.length > 0)) {
                                cidsBean = metaObjects[0].getBean();
                            }

                            EventQueue.invokeLater(new Runnable() {

                                    @Override
                                    public void run() {
                                        lblScreenshot.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
                                    }
                                });
                        }
                    } catch (Exception e) {
                    }
                }
            }).start();
    }

    /**
     * DOCUMENT ME!
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public void setReadOnly(final boolean readOnly) {
        if (readOnly) {
            glassPanel.addMouseListener(new MouseAdapter() {
                });
        } else {
            for (final MouseListener ml : glassPanel.getMouseListeners()) {
                glassPanel.removeMouseListener(ml);
            }
        }
    }

    @Override
    public void dispose() {
//        bindingGroup.unbind();
    }

    @Override
    public String getTitle() {
        return "Umlandinfo";
    }

    @Override
    public void setTitle(final String title) {
    }

    @Override
    public void editorClosed(final EditorClosedEvent event) {
    }

    @Override
    public boolean prepareForSave() {
        return true;
    }
}
