/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JTextField;

import de.cismet.cids.custom.wrrl_db_mv.util.FgskHelper;
import de.cismet.cids.custom.wrrl_db_mv.util.NumberConverter;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.cids.editors.DefaultCustomObjectEditor;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class KartierabschnittBesUferbelastungen extends javax.swing.JPanel implements DisposableCidsBeanStore {

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private JTextField[] left;
    private JTextField[] right;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cbKeineL;
    private javax.swing.JCheckBox cbKeineR;
    private javax.swing.JLabel lblEl;
    private javax.swing.JLabel lblHeading;
    private javax.swing.JLabel lblL;
    private javax.swing.JLabel lblMue;
    private javax.swing.JLabel lblR;
    private javax.swing.JLabel lblSo;
    private javax.swing.JLabel lblSpacing;
    private javax.swing.JLabel lblSt;
    private javax.swing.JLabel lblTs;
    private javax.swing.JLabel lblkeine;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo;
    private de.cismet.tools.gui.RoundedPanel panInfo;
    private javax.swing.JPanel panInfoContent;
    private javax.swing.JTextField txtEll;
    private javax.swing.JTextField txtElr;
    private javax.swing.JTextField txtMuel;
    private javax.swing.JTextField txtMuer;
    private javax.swing.JTextField txtSol;
    private javax.swing.JTextField txtSor;
    private javax.swing.JTextField txtStl;
    private javax.swing.JTextField txtStr;
    private javax.swing.JTextField txtTsl;
    private javax.swing.JTextField txtTsr;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WkFgPanOne.
     */
    public KartierabschnittBesUferbelastungen() {
        initComponents();
        left = new JTextField[5];
        left[0] = txtMuel;
        left[1] = txtEll;
        left[2] = txtSol;
        left[3] = txtStl;
        left[4] = txtTsl;

        right = new JTextField[5];
        right[0] = txtMuer;
        right[1] = txtElr;
        right[2] = txtSor;
        right[3] = txtStr;
        right[4] = txtTsr;

        final FocusListener lisl = new FocusListener() {

                @Override
                public void focusGained(final FocusEvent e) {
                }

                @Override
                public void focusLost(final FocusEvent e) {
                    FgskHelper.fillNvCheckbox(cbKeineL, left);
                }
            };

        final FocusListener lisr = new FocusListener() {

                @Override
                public void focusGained(final FocusEvent e) {
                }

                @Override
                public void focusLost(final FocusEvent e) {
                    FgskHelper.fillNvCheckbox(cbKeineR, right);
                }
            };

        FgskHelper.addListenerForNvCheck(lisl, left);
        FgskHelper.addListenerForNvCheck(lisr, right);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        panInfo = new de.cismet.tools.gui.RoundedPanel();
        panHeadInfo = new de.cismet.tools.gui.SemiRoundedPanel();
        lblHeading = new javax.swing.JLabel();
        panInfoContent = new javax.swing.JPanel();
        lblL = new javax.swing.JLabel();
        lblSpacing = new javax.swing.JLabel();
        lblR = new javax.swing.JLabel();
        lblMue = new javax.swing.JLabel();
        lblSt = new javax.swing.JLabel();
        lblTs = new javax.swing.JLabel();
        lblEl = new javax.swing.JLabel();
        lblSo = new javax.swing.JLabel();
        txtMuel = new javax.swing.JTextField();
        txtStl = new javax.swing.JTextField();
        txtTsl = new javax.swing.JTextField();
        txtEll = new javax.swing.JTextField();
        txtSol = new javax.swing.JTextField();
        txtMuer = new javax.swing.JTextField();
        txtStr = new javax.swing.JTextField();
        txtTsr = new javax.swing.JTextField();
        txtElr = new javax.swing.JTextField();
        txtSor = new javax.swing.JTextField();
        lblkeine = new javax.swing.JLabel();
        cbKeineL = new javax.swing.JCheckBox();
        cbKeineR = new javax.swing.JCheckBox();

        setMinimumSize(new java.awt.Dimension(1100, 250));
        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(1100, 250));
        setLayout(new java.awt.BorderLayout());

        panHeadInfo.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setLayout(new java.awt.FlowLayout());

        lblHeading.setForeground(new java.awt.Color(255, 255, 255));
        lblHeading.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittBesUferbelastungen.lblHeading.text")); // NOI18N
        panHeadInfo.add(lblHeading);

        panInfo.add(panHeadInfo, java.awt.BorderLayout.NORTH);

        panInfoContent.setMinimumSize(new java.awt.Dimension(1057, 250));
        panInfoContent.setOpaque(false);
        panInfoContent.setLayout(new java.awt.GridBagLayout());

        lblL.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittUferstrukturenEditor.lblL.text")); // NOI18N
        lblL.setMaximumSize(new java.awt.Dimension(120, 17));
        lblL.setMinimumSize(new java.awt.Dimension(20, 17));
        lblL.setPreferredSize(new java.awt.Dimension(20, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblL, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weighty = 1.0;
        panInfoContent.add(lblSpacing, gridBagConstraints);

        lblR.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittBesUferbelastungen.lblR.text")); // NOI18N
        lblR.setMaximumSize(new java.awt.Dimension(120, 17));
        lblR.setMinimumSize(new java.awt.Dimension(20, 17));
        lblR.setPreferredSize(new java.awt.Dimension(20, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblR, gridBagConstraints);

        lblMue.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittBesUferbelastungen.lblMue.text"));        // NOI18N
        lblMue.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittBesUferbelastungen.lblMue.toolTipText")); // NOI18N
        lblMue.setMaximumSize(new java.awt.Dimension(120, 17));
        lblMue.setMinimumSize(new java.awt.Dimension(40, 17));
        lblMue.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblMue, gridBagConstraints);

        lblSt.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittBesUferbelastungen.lblSt.text"));        // NOI18N
        lblSt.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittBesUferbelastungen.lblSt.toolTipText")); // NOI18N
        lblSt.setMaximumSize(new java.awt.Dimension(120, 17));
        lblSt.setMinimumSize(new java.awt.Dimension(40, 17));
        lblSt.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblSt, gridBagConstraints);

        lblTs.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittBesUferbelastungen.lblTs.text"));        // NOI18N
        lblTs.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittBesUferbelastungen.lblTs.toolTipText")); // NOI18N
        lblTs.setMaximumSize(new java.awt.Dimension(120, 17));
        lblTs.setMinimumSize(new java.awt.Dimension(40, 17));
        lblTs.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblTs, gridBagConstraints);

        lblEl.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittBesUferbelastungen.lblEl.text"));        // NOI18N
        lblEl.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittBesUferbelastungen.lblEl.toolTipText")); // NOI18N
        lblEl.setMaximumSize(new java.awt.Dimension(120, 17));
        lblEl.setMinimumSize(new java.awt.Dimension(40, 17));
        lblEl.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblEl, gridBagConstraints);

        lblSo.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittBesUferbelastungen.lblSo.text"));        // NOI18N
        lblSo.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittBesUferbelastungen.lblSo.toolTipText")); // NOI18N
        lblSo.setMaximumSize(new java.awt.Dimension(120, 17));
        lblSo.setMinimumSize(new java.awt.Dimension(40, 17));
        lblSo.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblSo, gridBagConstraints);

        txtMuel.setMinimumSize(new java.awt.Dimension(40, 20));
        txtMuel.setPreferredSize(new java.awt.Dimension(40, 20));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.uferbelastungen_mue_links}"),
                txtMuel,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtMuel, gridBagConstraints);

        txtStl.setMinimumSize(new java.awt.Dimension(40, 20));
        txtStl.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.uferbelastungen_st_links}"),
                txtStl,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtStl, gridBagConstraints);

        txtTsl.setMinimumSize(new java.awt.Dimension(40, 20));
        txtTsl.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.uferbelastungen_ts_links}"),
                txtTsl,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtTsl, gridBagConstraints);

        txtEll.setMinimumSize(new java.awt.Dimension(40, 20));
        txtEll.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.uferbelastungen_el_links}"),
                txtEll,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtEll, gridBagConstraints);

        txtSol.setMinimumSize(new java.awt.Dimension(40, 20));
        txtSol.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.uferbelastungen_so_links}"),
                txtSol,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtSol, gridBagConstraints);

        txtMuer.setMinimumSize(new java.awt.Dimension(40, 20));
        txtMuer.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.uferbelastungen_mue_rechts}"),
                txtMuer,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtMuer, gridBagConstraints);

        txtStr.setMinimumSize(new java.awt.Dimension(40, 20));
        txtStr.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.uferbelastungen_st_rechts}"),
                txtStr,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtStr, gridBagConstraints);

        txtTsr.setMinimumSize(new java.awt.Dimension(40, 20));
        txtTsr.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.uferbelastungen_ts_rechts}"),
                txtTsr,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtTsr, gridBagConstraints);

        txtElr.setMinimumSize(new java.awt.Dimension(40, 20));
        txtElr.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.uferbelastungen_el_rechts}"),
                txtElr,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtElr, gridBagConstraints);

        txtSor.setMinimumSize(new java.awt.Dimension(40, 20));
        txtSor.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.uferbelastungen_so_rechts}"),
                txtSor,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtSor, gridBagConstraints);

        lblkeine.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUferbelastungen.class,
                "KartierabschnittBesUferbelastungen.lblkeine.text")); // NOI18N
        lblkeine.setMaximumSize(new java.awt.Dimension(120, 17));
        lblkeine.setMinimumSize(new java.awt.Dimension(40, 17));
        lblkeine.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblkeine, gridBagConstraints);

        cbKeineL.setContentAreaFilled(false);
        cbKeineL.addChangeListener(new javax.swing.event.ChangeListener() {

                @Override
                public void stateChanged(final javax.swing.event.ChangeEvent evt) {
                    cbKeineLStateChanged(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(cbKeineL, gridBagConstraints);

        cbKeineR.setContentAreaFilled(false);
        cbKeineR.addChangeListener(new javax.swing.event.ChangeListener() {

                @Override
                public void stateChanged(final javax.swing.event.ChangeEvent evt) {
                    cbKeineRStateChanged(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(cbKeineR, gridBagConstraints);

        panInfo.add(panInfoContent, java.awt.BorderLayout.CENTER);

        add(panInfo, java.awt.BorderLayout.CENTER);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbKeineLStateChanged(final javax.swing.event.ChangeEvent evt) { //GEN-FIRST:event_cbKeineLStateChanged
        FgskHelper.nvCheckBoxStateChange(this, cbKeineL, left);
    }                                                                            //GEN-LAST:event_cbKeineLStateChanged

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbKeineRStateChanged(final javax.swing.event.ChangeEvent evt) { //GEN-FIRST:event_cbKeineRStateChanged
        FgskHelper.nvCheckBoxStateChange(this, cbKeineR, right);
    }                                                                            //GEN-LAST:event_cbKeineRStateChanged

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                this.cidsBean);
            bindingGroup.bind();
            FgskHelper.fillNvCheckbox(cbKeineL, left);
            FgskHelper.fillNvCheckbox(cbKeineR, right);
        }
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
    }
}
