/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JTextField;

import de.cismet.cids.custom.wrrl_db_mv.util.FgskHelper;
import de.cismet.cids.custom.wrrl_db_mv.util.NumberConverter;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.cids.editors.DefaultCustomObjectEditor;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class KartierabschnittBesUmfeld extends javax.swing.JPanel implements DisposableCidsBeanStore {

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private JTextField[] left;
    private JTextField[] right;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cbKeineL;
    private javax.swing.JCheckBox cbKeineR;
    private javax.swing.JLabel lblAa;
    private javax.swing.JLabel lblAw;
    private javax.swing.JLabel lblFm;
    private javax.swing.JLabel lblHeading;
    private javax.swing.JLabel lblL;
    private javax.swing.JLabel lblQ;
    private javax.swing.JLabel lblR;
    private javax.swing.JLabel lblSo;
    private javax.swing.JLabel lblSpacing;
    private javax.swing.JLabel lblW;
    private javax.swing.JLabel lblkeine;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo;
    private de.cismet.tools.gui.RoundedPanel panInfo;
    private javax.swing.JPanel panInfoContent;
    private javax.swing.JTextField txtAaL;
    private javax.swing.JTextField txtAaR;
    private javax.swing.JTextField txtAwL;
    private javax.swing.JTextField txtAwR;
    private javax.swing.JTextField txtFmL;
    private javax.swing.JTextField txtFmR;
    private javax.swing.JTextField txtQL;
    private javax.swing.JTextField txtQR;
    private javax.swing.JTextField txtSoL;
    private javax.swing.JTextField txtSoR;
    private javax.swing.JTextField txtWL;
    private javax.swing.JTextField txtWR;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WkFgPanOne.
     */
    public KartierabschnittBesUmfeld() {
        initComponents();
        left = new JTextField[6];
        left[0] = txtAaL;
        left[1] = txtAwL;
        left[2] = txtFmL;
        left[3] = txtQL;
        left[4] = txtSoL;
        left[5] = txtWL;

        right = new JTextField[6];
        right[0] = txtAaR;
        right[1] = txtAwR;
        right[2] = txtFmR;
        right[3] = txtQR;
        right[4] = txtSoR;
        right[5] = txtWR;

        final FocusListener lisl = new FocusListener() {

                @Override
                public void focusGained(final FocusEvent e) {
                }

                @Override
                public void focusLost(final FocusEvent e) {
                    FgskHelper.fillNvCheckbox(cbKeineL, left);
                }
            };

        final FocusListener lisr = new FocusListener() {

                @Override
                public void focusGained(final FocusEvent e) {
                }

                @Override
                public void focusLost(final FocusEvent e) {
                    FgskHelper.fillNvCheckbox(cbKeineR, right);
                }
            };

        FgskHelper.addListenerForNvCheck(lisl, left);
        FgskHelper.addListenerForNvCheck(lisr, right);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        panInfo = new de.cismet.tools.gui.RoundedPanel();
        panHeadInfo = new de.cismet.tools.gui.SemiRoundedPanel();
        lblHeading = new javax.swing.JLabel();
        panInfoContent = new javax.swing.JPanel();
        lblL = new javax.swing.JLabel();
        lblSpacing = new javax.swing.JLabel();
        lblR = new javax.swing.JLabel();
        lblFm = new javax.swing.JLabel();
        lblQ = new javax.swing.JLabel();
        lblAa = new javax.swing.JLabel();
        lblAw = new javax.swing.JLabel();
        lblW = new javax.swing.JLabel();
        lblSo = new javax.swing.JLabel();
        txtFmL = new javax.swing.JTextField();
        txtQL = new javax.swing.JTextField();
        txtAaL = new javax.swing.JTextField();
        txtAwL = new javax.swing.JTextField();
        txtWL = new javax.swing.JTextField();
        txtSoL = new javax.swing.JTextField();
        txtFmR = new javax.swing.JTextField();
        txtQR = new javax.swing.JTextField();
        txtAaR = new javax.swing.JTextField();
        txtAwR = new javax.swing.JTextField();
        txtWR = new javax.swing.JTextField();
        txtSoR = new javax.swing.JTextField();
        lblkeine = new javax.swing.JLabel();
        cbKeineL = new javax.swing.JCheckBox();
        cbKeineR = new javax.swing.JCheckBox();

        setMinimumSize(new java.awt.Dimension(1100, 250));
        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(1100, 250));
        setLayout(new java.awt.BorderLayout());

        panHeadInfo.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setLayout(new java.awt.FlowLayout());

        lblHeading.setForeground(new java.awt.Color(255, 255, 255));
        lblHeading.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblHeading.text")); // NOI18N
        panHeadInfo.add(lblHeading);

        panInfo.add(panHeadInfo, java.awt.BorderLayout.NORTH);

        panInfoContent.setMinimumSize(new java.awt.Dimension(1057, 250));
        panInfoContent.setOpaque(false);
        panInfoContent.setLayout(new java.awt.GridBagLayout());

        lblL.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittUferstrukturenEditor.lblL.text")); // NOI18N
        lblL.setMaximumSize(new java.awt.Dimension(120, 17));
        lblL.setMinimumSize(new java.awt.Dimension(20, 17));
        lblL.setPreferredSize(new java.awt.Dimension(20, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblL, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weighty = 1.0;
        panInfoContent.add(lblSpacing, gridBagConstraints);

        lblR.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblR.text")); // NOI18N
        lblR.setMaximumSize(new java.awt.Dimension(120, 17));
        lblR.setMinimumSize(new java.awt.Dimension(20, 17));
        lblR.setPreferredSize(new java.awt.Dimension(20, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblR, gridBagConstraints);

        lblFm.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblFm.text"));        // NOI18N
        lblFm.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblFm.toolTipText")); // NOI18N
        lblFm.setMaximumSize(new java.awt.Dimension(120, 17));
        lblFm.setMinimumSize(new java.awt.Dimension(40, 17));
        lblFm.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblFm, gridBagConstraints);

        lblQ.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblQ.text"));        // NOI18N
        lblQ.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblQ.toolTipText")); // NOI18N
        lblQ.setMaximumSize(new java.awt.Dimension(120, 17));
        lblQ.setMinimumSize(new java.awt.Dimension(40, 17));
        lblQ.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblQ, gridBagConstraints);

        lblAa.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblAa.text"));        // NOI18N
        lblAa.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblAa.toolTipText")); // NOI18N
        lblAa.setMaximumSize(new java.awt.Dimension(120, 17));
        lblAa.setMinimumSize(new java.awt.Dimension(40, 17));
        lblAa.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblAa, gridBagConstraints);

        lblAw.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblAw.text"));        // NOI18N
        lblAw.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblAw.toolTipText")); // NOI18N
        lblAw.setMaximumSize(new java.awt.Dimension(120, 17));
        lblAw.setMinimumSize(new java.awt.Dimension(40, 17));
        lblAw.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblAw, gridBagConstraints);

        lblW.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblW.text"));        // NOI18N
        lblW.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblW.toolTipText")); // NOI18N
        lblW.setMaximumSize(new java.awt.Dimension(120, 17));
        lblW.setMinimumSize(new java.awt.Dimension(40, 17));
        lblW.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblW, gridBagConstraints);

        lblSo.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblSo.text"));                  // NOI18N
        lblSo.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUferstrukturen.lblnboe.toolTipText")); // NOI18N
        lblSo.setMaximumSize(new java.awt.Dimension(120, 17));
        lblSo.setMinimumSize(new java.awt.Dimension(40, 17));
        lblSo.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblSo, gridBagConstraints);

        txtFmL.setMinimumSize(new java.awt.Dimension(40, 20));
        txtFmL.setPreferredSize(new java.awt.Dimension(40, 20));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.umfeldstrukturen_fm_links}"),
                txtFmL,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtFmL, gridBagConstraints);

        txtQL.setMinimumSize(new java.awt.Dimension(40, 20));
        txtQL.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.umfeldstrukturen_q_links}"),
                txtQL,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtQL, gridBagConstraints);

        txtAaL.setMinimumSize(new java.awt.Dimension(40, 20));
        txtAaL.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.umfeldstrukturen_aa_links}"),
                txtAaL,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtAaL, gridBagConstraints);

        txtAwL.setMinimumSize(new java.awt.Dimension(40, 20));
        txtAwL.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.umfeldstrukturen_aw_links}"),
                txtAwL,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtAwL, gridBagConstraints);

        txtWL.setMinimumSize(new java.awt.Dimension(40, 20));
        txtWL.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.umfeldstrukturen_w_links}"),
                txtWL,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtWL, gridBagConstraints);

        txtSoL.setMinimumSize(new java.awt.Dimension(40, 20));
        txtSoL.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.umfeldstrukturen_so_links}"),
                txtSoL,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtSoL, gridBagConstraints);

        txtFmR.setMinimumSize(new java.awt.Dimension(40, 20));
        txtFmR.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.umfeldstrukturen_fm_rechts}"),
                txtFmR,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtFmR, gridBagConstraints);

        txtQR.setMinimumSize(new java.awt.Dimension(40, 20));
        txtQR.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.umfeldstrukturen_q_rechts}"),
                txtQR,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtQR, gridBagConstraints);

        txtAaR.setMinimumSize(new java.awt.Dimension(40, 20));
        txtAaR.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.umfeldstrukturen_aa_rechts}"),
                txtAaR,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtAaR, gridBagConstraints);

        txtAwR.setMinimumSize(new java.awt.Dimension(40, 20));
        txtAwR.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.umfeldstrukturen_aw_rechts}"),
                txtAwR,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtAwR, gridBagConstraints);

        txtWR.setMinimumSize(new java.awt.Dimension(40, 20));
        txtWR.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.umfeldstrukturen_w_rechts}"),
                txtWR,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtWR, gridBagConstraints);

        txtSoR.setMinimumSize(new java.awt.Dimension(40, 20));
        txtSoR.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.umfeldstrukturen_so_rechts}"),
                txtSoR,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtSoR, gridBagConstraints);

        lblkeine.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittBesUmfeld.class,
                "KartierabschnittBesUmfeld.lblkeine.text")); // NOI18N
        lblkeine.setMaximumSize(new java.awt.Dimension(120, 17));
        lblkeine.setMinimumSize(new java.awt.Dimension(40, 17));
        lblkeine.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblkeine, gridBagConstraints);

        cbKeineL.setContentAreaFilled(false);
        cbKeineL.addChangeListener(new javax.swing.event.ChangeListener() {

                @Override
                public void stateChanged(final javax.swing.event.ChangeEvent evt) {
                    cbKeineLStateChanged(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(cbKeineL, gridBagConstraints);

        cbKeineR.setContentAreaFilled(false);
        cbKeineR.addChangeListener(new javax.swing.event.ChangeListener() {

                @Override
                public void stateChanged(final javax.swing.event.ChangeEvent evt) {
                    cbKeineRStateChanged(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(cbKeineR, gridBagConstraints);

        panInfo.add(panInfoContent, java.awt.BorderLayout.CENTER);

        add(panInfo, java.awt.BorderLayout.CENTER);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbKeineLStateChanged(final javax.swing.event.ChangeEvent evt) { //GEN-FIRST:event_cbKeineLStateChanged
        FgskHelper.nvCheckBoxStateChange(this, cbKeineL, left);
    }                                                                            //GEN-LAST:event_cbKeineLStateChanged

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbKeineRStateChanged(final javax.swing.event.ChangeEvent evt) { //GEN-FIRST:event_cbKeineRStateChanged
        FgskHelper.nvCheckBoxStateChange(this, cbKeineR, right);
    }                                                                            //GEN-LAST:event_cbKeineRStateChanged

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                this.cidsBean);
            bindingGroup.bind();
        }
        FgskHelper.fillNvCheckbox(cbKeineL, left);
        FgskHelper.fillNvCheckbox(cbKeineR, right);
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
    }
}
