/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JTextField;

import de.cismet.cids.custom.wrrl_db_mv.util.FgskHelper;
import de.cismet.cids.custom.wrrl_db_mv.util.NumberConverter;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.cids.editors.DefaultCustomObjectEditor;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class KartierabschnittSchaeUmfeldstrukturen extends javax.swing.JPanel implements DisposableCidsBeanStore {

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private JTextField[] left;
    private JTextField[] right;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cbKeineL;
    private javax.swing.JCheckBox cbKeineR;
    private javax.swing.JLabel lblAg;
    private javax.swing.JLabel lblBv;
    private javax.swing.JLabel lblFt;
    private javax.swing.JLabel lblGua;
    private javax.swing.JLabel lblHeading;
    private javax.swing.JLabel lblHw;
    private javax.swing.JLabel lblL;
    private javax.swing.JLabel lblMa;
    private javax.swing.JLabel lblR;
    private javax.swing.JLabel lblSo;
    private javax.swing.JLabel lblSpacing;
    private javax.swing.JLabel lblkeine;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo;
    private de.cismet.tools.gui.RoundedPanel panInfo;
    private javax.swing.JPanel panInfoContent;
    private javax.swing.JTextField txtAgl;
    private javax.swing.JTextField txtAgr;
    private javax.swing.JTextField txtBvl;
    private javax.swing.JTextField txtBvr;
    private javax.swing.JTextField txtFtl;
    private javax.swing.JTextField txtFtr;
    private javax.swing.JTextField txtGual;
    private javax.swing.JTextField txtGuar;
    private javax.swing.JTextField txtHwl;
    private javax.swing.JTextField txtHwr;
    private javax.swing.JTextField txtMal;
    private javax.swing.JTextField txtMar;
    private javax.swing.JTextField txtSol;
    private javax.swing.JTextField txtSor;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WkFgPanOne.
     */
    public KartierabschnittSchaeUmfeldstrukturen() {
        initComponents();
        left = new JTextField[7];
        left[0] = txtAgl;
        left[1] = txtBvl;
        left[2] = txtFtl;
        left[3] = txtGual;
        left[4] = txtHwl;
        left[5] = txtMal;
        left[6] = txtSol;

        right = new JTextField[7];
        right[0] = txtAgr;
        right[1] = txtBvr;
        right[2] = txtFtr;
        right[3] = txtGuar;
        right[4] = txtHwr;
        right[5] = txtMar;
        right[6] = txtSor;

        final FocusListener lisl = new FocusListener() {

                @Override
                public void focusGained(final FocusEvent e) {
                }

                @Override
                public void focusLost(final FocusEvent e) {
                    FgskHelper.fillNvCheckbox(cbKeineL, left);
                }
            };

        final FocusListener lisr = new FocusListener() {

                @Override
                public void focusGained(final FocusEvent e) {
                }

                @Override
                public void focusLost(final FocusEvent e) {
                    FgskHelper.fillNvCheckbox(cbKeineR, right);
                }
            };

        FgskHelper.addListenerForNvCheck(lisl, left);
        FgskHelper.addListenerForNvCheck(lisr, right);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        panInfo = new de.cismet.tools.gui.RoundedPanel();
        panHeadInfo = new de.cismet.tools.gui.SemiRoundedPanel();
        lblHeading = new javax.swing.JLabel();
        panInfoContent = new javax.swing.JPanel();
        lblL = new javax.swing.JLabel();
        lblSpacing = new javax.swing.JLabel();
        lblR = new javax.swing.JLabel();
        lblAg = new javax.swing.JLabel();
        lblFt = new javax.swing.JLabel();
        lblGua = new javax.swing.JLabel();
        lblBv = new javax.swing.JLabel();
        lblMa = new javax.swing.JLabel();
        lblHw = new javax.swing.JLabel();
        lblSo = new javax.swing.JLabel();
        txtAgl = new javax.swing.JTextField();
        txtFtl = new javax.swing.JTextField();
        txtGual = new javax.swing.JTextField();
        txtBvl = new javax.swing.JTextField();
        txtMal = new javax.swing.JTextField();
        txtHwl = new javax.swing.JTextField();
        txtSol = new javax.swing.JTextField();
        txtAgr = new javax.swing.JTextField();
        txtFtr = new javax.swing.JTextField();
        txtGuar = new javax.swing.JTextField();
        txtBvr = new javax.swing.JTextField();
        txtMar = new javax.swing.JTextField();
        txtHwr = new javax.swing.JTextField();
        txtSor = new javax.swing.JTextField();
        lblkeine = new javax.swing.JLabel();
        cbKeineL = new javax.swing.JCheckBox();
        cbKeineR = new javax.swing.JCheckBox();

        setMinimumSize(new java.awt.Dimension(1100, 250));
        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(1100, 250));
        setLayout(new java.awt.BorderLayout());

        panHeadInfo.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setLayout(new java.awt.FlowLayout());

        lblHeading.setForeground(new java.awt.Color(255, 255, 255));
        lblHeading.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblHeading.text")); // NOI18N
        panHeadInfo.add(lblHeading);

        panInfo.add(panHeadInfo, java.awt.BorderLayout.NORTH);

        panInfoContent.setMinimumSize(new java.awt.Dimension(1057, 250));
        panInfoContent.setOpaque(false);
        panInfoContent.setLayout(new java.awt.GridBagLayout());

        lblL.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittUferstrukturenEditor.lblL.text")); // NOI18N
        lblL.setMaximumSize(new java.awt.Dimension(120, 17));
        lblL.setMinimumSize(new java.awt.Dimension(20, 17));
        lblL.setPreferredSize(new java.awt.Dimension(20, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblL, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weighty = 1.0;
        panInfoContent.add(lblSpacing, gridBagConstraints);

        lblR.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblR.text")); // NOI18N
        lblR.setMaximumSize(new java.awt.Dimension(120, 17));
        lblR.setMinimumSize(new java.awt.Dimension(20, 17));
        lblR.setPreferredSize(new java.awt.Dimension(20, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblR, gridBagConstraints);

        lblAg.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblAg.text"));        // NOI18N
        lblAg.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblAg.toolTipText")); // NOI18N
        lblAg.setMaximumSize(new java.awt.Dimension(120, 17));
        lblAg.setMinimumSize(new java.awt.Dimension(40, 17));
        lblAg.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblAg, gridBagConstraints);

        lblFt.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblFt.text"));        // NOI18N
        lblFt.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblFt.toolTipText")); // NOI18N
        lblFt.setMaximumSize(new java.awt.Dimension(120, 17));
        lblFt.setMinimumSize(new java.awt.Dimension(40, 17));
        lblFt.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblFt, gridBagConstraints);

        lblGua.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblGua.text"));        // NOI18N
        lblGua.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblGua.toolTipText")); // NOI18N
        lblGua.setMaximumSize(new java.awt.Dimension(120, 17));
        lblGua.setMinimumSize(new java.awt.Dimension(40, 17));
        lblGua.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblGua, gridBagConstraints);

        lblBv.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblBv.text"));        // NOI18N
        lblBv.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblBv.toolTipText")); // NOI18N
        lblBv.setMaximumSize(new java.awt.Dimension(120, 17));
        lblBv.setMinimumSize(new java.awt.Dimension(40, 17));
        lblBv.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblBv, gridBagConstraints);

        lblMa.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblMa.text"));        // NOI18N
        lblMa.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblMa.toolTipText")); // NOI18N
        lblMa.setMaximumSize(new java.awt.Dimension(120, 17));
        lblMa.setMinimumSize(new java.awt.Dimension(40, 17));
        lblMa.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblMa, gridBagConstraints);

        lblHw.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblHw.text"));      // NOI18N
        lblHw.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittBesUferstrukturen.lblnboe.toolTipText")); // NOI18N
        lblHw.setMaximumSize(new java.awt.Dimension(120, 17));
        lblHw.setMinimumSize(new java.awt.Dimension(40, 17));
        lblHw.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblHw, gridBagConstraints);

        lblSo.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblSo.text"));        // NOI18N
        lblSo.setToolTipText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblSo.toolTipText")); // NOI18N
        lblSo.setMaximumSize(new java.awt.Dimension(120, 17));
        lblSo.setMinimumSize(new java.awt.Dimension(40, 17));
        lblSo.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblSo, gridBagConstraints);

        txtAgl.setMinimumSize(new java.awt.Dimension(40, 20));
        txtAgl.setPreferredSize(new java.awt.Dimension(40, 20));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_ag_links}"),
                txtAgl,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtAgl, gridBagConstraints);

        txtFtl.setMinimumSize(new java.awt.Dimension(40, 20));
        txtFtl.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_ft_links}"),
                txtFtl,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtFtl, gridBagConstraints);

        txtGual.setMinimumSize(new java.awt.Dimension(40, 20));
        txtGual.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_gua_links}"),
                txtGual,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtGual, gridBagConstraints);

        txtBvl.setMinimumSize(new java.awt.Dimension(40, 20));
        txtBvl.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_bv_links}"),
                txtBvl,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtBvl, gridBagConstraints);

        txtMal.setMinimumSize(new java.awt.Dimension(40, 20));
        txtMal.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_ma_links}"),
                txtMal,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtMal, gridBagConstraints);

        txtHwl.setMinimumSize(new java.awt.Dimension(40, 20));
        txtHwl.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_hw_links}"),
                txtHwl,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtHwl, gridBagConstraints);

        txtSol.setMinimumSize(new java.awt.Dimension(40, 20));
        txtSol.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_so_links}"),
                txtSol,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtSol, gridBagConstraints);

        txtAgr.setMinimumSize(new java.awt.Dimension(40, 20));
        txtAgr.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_ag_rechts}"),
                txtAgr,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtAgr, gridBagConstraints);

        txtFtr.setMinimumSize(new java.awt.Dimension(40, 20));
        txtFtr.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_ft_rechts}"),
                txtFtr,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtFtr, gridBagConstraints);

        txtGuar.setMinimumSize(new java.awt.Dimension(40, 20));
        txtGuar.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_gua_rechts}"),
                txtGuar,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtGuar, gridBagConstraints);

        txtBvr.setMinimumSize(new java.awt.Dimension(40, 20));
        txtBvr.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_bv_rechts}"),
                txtBvr,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtBvr, gridBagConstraints);

        txtMar.setMinimumSize(new java.awt.Dimension(40, 20));
        txtMar.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_ma_rechts}"),
                txtMar,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtMar, gridBagConstraints);

        txtHwr.setMinimumSize(new java.awt.Dimension(40, 20));
        txtHwr.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_hw_rechts}"),
                txtHwr,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtHwr, gridBagConstraints);

        txtSor.setMinimumSize(new java.awt.Dimension(40, 20));
        txtSor.setPreferredSize(new java.awt.Dimension(40, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.s_umfeldstrukturen_so_rechts}"),
                txtSor,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(txtSor, gridBagConstraints);

        lblkeine.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSchaeUmfeldstrukturen.class,
                "KartierabschnittSchaeUmfeldstrukturen.lblkeine.text")); // NOI18N
        lblkeine.setMaximumSize(new java.awt.Dimension(120, 17));
        lblkeine.setMinimumSize(new java.awt.Dimension(40, 17));
        lblkeine.setPreferredSize(new java.awt.Dimension(40, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblkeine, gridBagConstraints);

        cbKeineL.setContentAreaFilled(false);
        cbKeineL.addChangeListener(new javax.swing.event.ChangeListener() {

                @Override
                public void stateChanged(final javax.swing.event.ChangeEvent evt) {
                    cbKeineLStateChanged(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(cbKeineL, gridBagConstraints);

        cbKeineR.setContentAreaFilled(false);
        cbKeineR.addChangeListener(new javax.swing.event.ChangeListener() {

                @Override
                public void stateChanged(final javax.swing.event.ChangeEvent evt) {
                    cbKeineRStateChanged(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(cbKeineR, gridBagConstraints);

        panInfo.add(panInfoContent, java.awt.BorderLayout.CENTER);

        add(panInfo, java.awt.BorderLayout.CENTER);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbKeineLStateChanged(final javax.swing.event.ChangeEvent evt) { //GEN-FIRST:event_cbKeineLStateChanged
        FgskHelper.nvCheckBoxStateChange(this, cbKeineL, left);
    }                                                                            //GEN-LAST:event_cbKeineLStateChanged

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbKeineRStateChanged(final javax.swing.event.ChangeEvent evt) { //GEN-FIRST:event_cbKeineRStateChanged
        FgskHelper.nvCheckBoxStateChange(this, cbKeineR, right);
    }                                                                            //GEN-LAST:event_cbKeineRStateChanged

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                this.cidsBean);
            bindingGroup.bind();
            FgskHelper.fillNvCheckbox(cbKeineL, left);
            FgskHelper.fillNvCheckbox(cbKeineR, right);
        }
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
    }
}
