/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JOptionPane;

import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.NumberConverter;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.cids.editors.DefaultCustomObjectEditor;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class KartierabschnittSohlenstrukturen extends javax.swing.JPanel implements DisposableCidsBeanStore {

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cbNe;
    private javax.swing.JLabel lblHeading;
    private javax.swing.JLabel lblKolke;
    private javax.swing.JLabel lblNe;
    private javax.swing.JLabel lblRiffle;
    private javax.swing.JLabel lblTotholz;
    private javax.swing.JLabel lblWurzelflaechen;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo;
    private de.cismet.tools.gui.RoundedPanel panInfo;
    private javax.swing.JPanel panInfoContent;
    private javax.swing.JTextField tfKolke;
    private javax.swing.JTextField tfRiffle;
    private javax.swing.JTextField tfTotholz;
    private javax.swing.JTextField tfWurzelflaechen;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WkFgPanOne.
     */
    public KartierabschnittSohlenstrukturen() {
        initComponents();
        final FocusListener lis = new FocusListener() {

                @Override
                public void focusGained(final FocusEvent e) {
                }

                @Override
                public void focusLost(final FocusEvent e) {
                    fillNE();
                }
            };
        tfKolke.addFocusListener(lis);
        tfRiffle.addFocusListener(lis);
        tfTotholz.addFocusListener(lis);
        tfWurzelflaechen.addFocusListener(lis);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        panInfo = new de.cismet.tools.gui.RoundedPanel();
        panHeadInfo = new de.cismet.tools.gui.SemiRoundedPanel();
        lblHeading = new javax.swing.JLabel();
        panInfoContent = new javax.swing.JPanel();
        lblRiffle = new javax.swing.JLabel();
        lblTotholz = new javax.swing.JLabel();
        lblWurzelflaechen = new javax.swing.JLabel();
        tfRiffle = new javax.swing.JTextField();
        tfTotholz = new javax.swing.JTextField();
        tfWurzelflaechen = new javax.swing.JTextField();
        lblKolke = new javax.swing.JLabel();
        tfKolke = new javax.swing.JTextField();
        cbNe = new javax.swing.JCheckBox();
        lblNe = new javax.swing.JLabel();

        setMinimumSize(new java.awt.Dimension(1100, 250));
        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(1100, 250));
        setLayout(new java.awt.BorderLayout());

        panHeadInfo.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setLayout(new java.awt.FlowLayout());

        lblHeading.setForeground(new java.awt.Color(255, 255, 255));
        lblHeading.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlenstrukturen.class,
                "KartierabschnittSohlenstrukturen.lblHeading.text_1")); // NOI18N
        panHeadInfo.add(lblHeading);

        panInfo.add(panHeadInfo, java.awt.BorderLayout.NORTH);

        panInfoContent.setMinimumSize(new java.awt.Dimension(1057, 250));
        panInfoContent.setOpaque(false);
        panInfoContent.setLayout(new java.awt.GridBagLayout());

        lblRiffle.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlenstrukturen.class,
                "KartierabschnittSohlenstrukturen.lblRiffle.text")); // NOI18N
        lblRiffle.setMaximumSize(new java.awt.Dimension(120, 17));
        lblRiffle.setMinimumSize(new java.awt.Dimension(140, 17));
        lblRiffle.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblRiffle, gridBagConstraints);

        lblTotholz.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlenstrukturen.class,
                "KartierabschnittSohlenstrukturen.lblTotholz.text")); // NOI18N
        lblTotholz.setMaximumSize(new java.awt.Dimension(120, 17));
        lblTotholz.setMinimumSize(new java.awt.Dimension(140, 17));
        lblTotholz.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblTotholz, gridBagConstraints);

        lblWurzelflaechen.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlenstrukturen.class,
                "KartierabschnittSohlenstrukturen.lblWurzelflaechen.text")); // NOI18N
        lblWurzelflaechen.setMaximumSize(new java.awt.Dimension(120, 17));
        lblWurzelflaechen.setMinimumSize(new java.awt.Dimension(140, 17));
        lblWurzelflaechen.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblWurzelflaechen, gridBagConstraints);

        tfRiffle.setMinimumSize(new java.awt.Dimension(50, 20));
        tfRiffle.setPreferredSize(new java.awt.Dimension(50, 20));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlenstrukturen_rip}"),
                tfRiffle,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 10);
        panInfoContent.add(tfRiffle, gridBagConstraints);

        tfTotholz.setMinimumSize(new java.awt.Dimension(50, 20));
        tfTotholz.setPreferredSize(new java.awt.Dimension(50, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlenstrukturen_th}"),
                tfTotholz,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent.add(tfTotholz, gridBagConstraints);

        tfWurzelflaechen.setMinimumSize(new java.awt.Dimension(50, 20));
        tfWurzelflaechen.setPreferredSize(new java.awt.Dimension(50, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlenstrukturen_wu}"),
                tfWurzelflaechen,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent.add(tfWurzelflaechen, gridBagConstraints);

        lblKolke.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlenstrukturen.class,
                "KartierabschnittSohlenstrukturen.lblKolke.text")); // NOI18N
        lblKolke.setMaximumSize(new java.awt.Dimension(120, 17));
        lblKolke.setMinimumSize(new java.awt.Dimension(140, 17));
        lblKolke.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblKolke, gridBagConstraints);

        tfKolke.setMinimumSize(new java.awt.Dimension(50, 20));
        tfKolke.setPreferredSize(new java.awt.Dimension(50, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlenstrukturen_ko}"),
                tfKolke,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent.add(tfKolke, gridBagConstraints);

        cbNe.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlenstrukturen.class,
                "KartierabschnittSohlenstrukturen.cbNe.text")); // NOI18N
        cbNe.setContentAreaFilled(false);
        cbNe.addChangeListener(new javax.swing.event.ChangeListener() {

                @Override
                public void stateChanged(final javax.swing.event.ChangeEvent evt) {
                    cbNeStateChanged(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 3, 5, 10);
        panInfoContent.add(cbNe, gridBagConstraints);

        lblNe.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlenstrukturen.class,
                "KartierabschnittSohlenstrukturen.lblNe.text")); // NOI18N
        lblNe.setMaximumSize(new java.awt.Dimension(120, 17));
        lblNe.setMinimumSize(new java.awt.Dimension(140, 17));
        lblNe.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblNe, gridBagConstraints);

        panInfo.add(panInfoContent, java.awt.BorderLayout.CENTER);

        add(panInfo, java.awt.BorderLayout.CENTER);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbNeStateChanged(final javax.swing.event.ChangeEvent evt) { //GEN-FIRST:event_cbNeStateChanged
        if (cbNe.isSelected()) {
            boolean nothing = true;
            nothing &= (CidsBeanSupport.textToDouble(tfKolke, 0.0) == 0.0);
            nothing &= (CidsBeanSupport.textToDouble(tfRiffle, 0.0) == 0.0);
            nothing &= (CidsBeanSupport.textToDouble(tfTotholz, 0.0) == 0.0);
            nothing &= (CidsBeanSupport.textToDouble(tfWurzelflaechen, 0.0) == 0.0);

            if (nothing) {
                tfKolke.setText("0.0");
                tfRiffle.setText("0.0");
                tfTotholz.setText("0.0");
                tfWurzelflaechen.setText("0.0");
            } else {
                JOptionPane.showMessageDialog(
                    StaticSwingTools.getParentFrame(this),
                    "Es sind bereits Felder auf einen Wert ungleich Null gesetzt.",
                    "Felder gesetzt",
                    JOptionPane.INFORMATION_MESSAGE);
                cbNe.setSelected(false);
            }
        }
    } //GEN-LAST:event_cbNeStateChanged

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                this.cidsBean);
            bindingGroup.bind();
            fillNE();
        }
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
    }

    /**
     * DOCUMENT ME!
     */
    private void fillNE() {
        boolean nothing = true;
        nothing &= (CidsBeanSupport.textToDouble(tfKolke, 1.0) == 0.0);
        nothing &= (CidsBeanSupport.textToDouble(tfRiffle, 1.0) == 0.0);
        nothing &= (CidsBeanSupport.textToDouble(tfTotholz, 1.0) == 0.0);
        nothing &= (CidsBeanSupport.textToDouble(tfWurzelflaechen, 1.0) == 0.0);

        cbNe.setSelected(nothing);
    }
}
