/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import org.apache.log4j.Logger;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JTextField;

import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.NumberConverter;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.cids.editors.DefaultCustomObjectEditor;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class KartierabschnittSohlensubstrat extends javax.swing.JPanel implements DisposableCidsBeanStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(KartierabschnittSohlensubstrat.class);

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cbNe;
    private javax.swing.JLabel lblBloecke;
    private javax.swing.JLabel lblGes;
    private javax.swing.JLabel lblHeading;
    private javax.swing.JLabel lblKies;
    private javax.swing.JLabel lblKuenSub;
    private javax.swing.JLabel lblNe;
    private javax.swing.JLabel lblSand;
    private javax.swing.JLabel lblSchlamm;
    private javax.swing.JLabel lblSteine;
    private javax.swing.JLabel lblTon;
    private javax.swing.JLabel lblTorf;
    private javax.swing.JLabel lblTotholz;
    private javax.swing.JLabel lblWurzeln;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo;
    private de.cismet.tools.gui.RoundedPanel panInfo;
    private javax.swing.JPanel panInfoContent;
    private javax.swing.JTextField tfBloecke;
    private javax.swing.JTextField tfKies;
    private javax.swing.JTextField tfKuenSub;
    private javax.swing.JTextField tfSand;
    private javax.swing.JTextField tfSchlamm;
    private javax.swing.JTextField tfSteine;
    private javax.swing.JTextField tfTon;
    private javax.swing.JTextField tfTorf;
    private javax.swing.JTextField tfTotholz;
    private javax.swing.JTextField tfWurzeln;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WkFgPanOne.
     */
    public KartierabschnittSohlensubstrat() {
        initComponents();

        final FocusListener lis = new FocusListener() {

                @Override
                public void focusGained(final FocusEvent e) {
                }

                @Override
                public void focusLost(final FocusEvent e) {
                    fillGesamt();
                    round(e.getComponent());
                }
            };

        tfBloecke.addFocusListener(lis);
        tfKies.addFocusListener(lis);
        tfKuenSub.addFocusListener(lis);
        tfSand.addFocusListener(lis);
        tfSchlamm.addFocusListener(lis);
        tfSteine.addFocusListener(lis);
        tfTon.addFocusListener(lis);
        tfTorf.addFocusListener(lis);
        tfTotholz.addFocusListener(lis);
        tfWurzeln.addFocusListener(lis);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        panInfo = new de.cismet.tools.gui.RoundedPanel();
        panHeadInfo = new de.cismet.tools.gui.SemiRoundedPanel();
        lblHeading = new javax.swing.JLabel();
        panInfoContent = new javax.swing.JPanel();
        lblTon = new javax.swing.JLabel();
        lblSand = new javax.swing.JLabel();
        lblKies = new javax.swing.JLabel();
        tfTon = new javax.swing.JTextField();
        tfSand = new javax.swing.JTextField();
        tfKies = new javax.swing.JTextField();
        lblSteine = new javax.swing.JLabel();
        tfSteine = new javax.swing.JTextField();
        lblBloecke = new javax.swing.JLabel();
        tfBloecke = new javax.swing.JTextField();
        lblSchlamm = new javax.swing.JLabel();
        tfSchlamm = new javax.swing.JTextField();
        lblTorf = new javax.swing.JLabel();
        tfTorf = new javax.swing.JTextField();
        lblTotholz = new javax.swing.JLabel();
        tfTotholz = new javax.swing.JTextField();
        tfWurzeln = new javax.swing.JTextField();
        lblWurzeln = new javax.swing.JLabel();
        tfKuenSub = new javax.swing.JTextField();
        lblKuenSub = new javax.swing.JLabel();
        cbNe = new javax.swing.JCheckBox();
        lblNe = new javax.swing.JLabel();
        lblGes = new javax.swing.JLabel();

        setMinimumSize(new java.awt.Dimension(1100, 250));
        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(1100, 250));
        setLayout(new java.awt.BorderLayout());

        panHeadInfo.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setLayout(new java.awt.FlowLayout());

        lblHeading.setForeground(new java.awt.Color(255, 255, 255));
        lblHeading.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.lblHeading.text_1")); // NOI18N
        panHeadInfo.add(lblHeading);

        panInfo.add(panHeadInfo, java.awt.BorderLayout.NORTH);

        panInfoContent.setMinimumSize(new java.awt.Dimension(1057, 250));
        panInfoContent.setOpaque(false);
        panInfoContent.setLayout(new java.awt.GridBagLayout());

        lblTon.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.lblTon.text")); // NOI18N
        lblTon.setMaximumSize(new java.awt.Dimension(120, 17));
        lblTon.setMinimumSize(new java.awt.Dimension(140, 17));
        lblTon.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblTon, gridBagConstraints);

        lblSand.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.lblSand.text")); // NOI18N
        lblSand.setMaximumSize(new java.awt.Dimension(120, 17));
        lblSand.setMinimumSize(new java.awt.Dimension(140, 17));
        lblSand.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblSand, gridBagConstraints);

        lblKies.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.lblKies.text")); // NOI18N
        lblKies.setMaximumSize(new java.awt.Dimension(120, 17));
        lblKies.setMinimumSize(new java.awt.Dimension(140, 17));
        lblKies.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblKies, gridBagConstraints);

        tfTon.setMinimumSize(new java.awt.Dimension(50, 20));
        tfTon.setPreferredSize(new java.awt.Dimension(50, 20));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlensubstrat_ton}"),
                tfTon,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 10);
        panInfoContent.add(tfTon, gridBagConstraints);

        tfSand.setMinimumSize(new java.awt.Dimension(50, 20));
        tfSand.setPreferredSize(new java.awt.Dimension(50, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlensubstrat_san}"),
                tfSand,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent.add(tfSand, gridBagConstraints);

        tfKies.setMinimumSize(new java.awt.Dimension(50, 20));
        tfKies.setPreferredSize(new java.awt.Dimension(50, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlensubstrat_kie}"),
                tfKies,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent.add(tfKies, gridBagConstraints);

        lblSteine.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.lblSteine.text")); // NOI18N
        lblSteine.setMaximumSize(new java.awt.Dimension(120, 17));
        lblSteine.setMinimumSize(new java.awt.Dimension(140, 17));
        lblSteine.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblSteine, gridBagConstraints);

        tfSteine.setMinimumSize(new java.awt.Dimension(50, 20));
        tfSteine.setPreferredSize(new java.awt.Dimension(50, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlensubstrat_ste}"),
                tfSteine,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent.add(tfSteine, gridBagConstraints);

        lblBloecke.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.lblBloecke.text")); // NOI18N
        lblBloecke.setMaximumSize(new java.awt.Dimension(120, 17));
        lblBloecke.setMinimumSize(new java.awt.Dimension(140, 17));
        lblBloecke.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblBloecke, gridBagConstraints);

        tfBloecke.setMinimumSize(new java.awt.Dimension(50, 20));
        tfBloecke.setPreferredSize(new java.awt.Dimension(50, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlensubstrat_blo}"),
                tfBloecke,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent.add(tfBloecke, gridBagConstraints);

        lblSchlamm.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.lblSchlamm.text")); // NOI18N
        lblSchlamm.setMaximumSize(new java.awt.Dimension(120, 17));
        lblSchlamm.setMinimumSize(new java.awt.Dimension(140, 17));
        lblSchlamm.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblSchlamm, gridBagConstraints);

        tfSchlamm.setMinimumSize(new java.awt.Dimension(50, 20));
        tfSchlamm.setPreferredSize(new java.awt.Dimension(50, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlensubstrat_sch}"),
                tfSchlamm,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent.add(tfSchlamm, gridBagConstraints);

        lblTorf.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.lblTorf.text")); // NOI18N
        lblTorf.setMaximumSize(new java.awt.Dimension(120, 17));
        lblTorf.setMinimumSize(new java.awt.Dimension(140, 17));
        lblTorf.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblTorf, gridBagConstraints);

        tfTorf.setMinimumSize(new java.awt.Dimension(50, 20));
        tfTorf.setPreferredSize(new java.awt.Dimension(50, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlensubstrat_tor}"),
                tfTorf,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent.add(tfTorf, gridBagConstraints);

        lblTotholz.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.lblTotholz.text")); // NOI18N
        lblTotholz.setMaximumSize(new java.awt.Dimension(120, 17));
        lblTotholz.setMinimumSize(new java.awt.Dimension(140, 17));
        lblTotholz.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblTotholz, gridBagConstraints);

        tfTotholz.setMinimumSize(new java.awt.Dimension(50, 20));
        tfTotholz.setPreferredSize(new java.awt.Dimension(50, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlensubstrat_tot}"),
                tfTotholz,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent.add(tfTotholz, gridBagConstraints);

        tfWurzeln.setMinimumSize(new java.awt.Dimension(50, 20));
        tfWurzeln.setPreferredSize(new java.awt.Dimension(50, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlensubstrat_wur}"),
                tfWurzeln,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent.add(tfWurzeln, gridBagConstraints);

        lblWurzeln.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.lblWurzeln.text")); // NOI18N
        lblWurzeln.setMaximumSize(new java.awt.Dimension(120, 17));
        lblWurzeln.setMinimumSize(new java.awt.Dimension(140, 17));
        lblWurzeln.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblWurzeln, gridBagConstraints);

        tfKuenSub.setMinimumSize(new java.awt.Dimension(50, 20));
        tfKuenSub.setPreferredSize(new java.awt.Dimension(50, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.sohlensubstrat_kue}"),
                tfKuenSub,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(NumberConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        panInfoContent.add(tfKuenSub, gridBagConstraints);

        lblKuenSub.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.lblKuenSub.text")); // NOI18N
        lblKuenSub.setMaximumSize(new java.awt.Dimension(120, 17));
        lblKuenSub.setMinimumSize(new java.awt.Dimension(140, 17));
        lblKuenSub.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblKuenSub, gridBagConstraints);

        cbNe.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.cbNe.text")); // NOI18N
        cbNe.setContentAreaFilled(false);
        cbNe.addChangeListener(new javax.swing.event.ChangeListener() {

                @Override
                public void stateChanged(final javax.swing.event.ChangeEvent evt) {
                    cbNeStateChanged(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 3, 5, 10);
        panInfoContent.add(cbNe, gridBagConstraints);

        lblNe.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.lblNe.text")); // NOI18N
        lblNe.setMaximumSize(new java.awt.Dimension(120, 17));
        lblNe.setMinimumSize(new java.awt.Dimension(140, 17));
        lblNe.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblNe, gridBagConstraints);

        lblGes.setText(org.openide.util.NbBundle.getMessage(
                KartierabschnittSohlensubstrat.class,
                "KartierabschnittSohlensubstrat.lblGes.text")); // NOI18N
        lblGes.setMaximumSize(new java.awt.Dimension(120, 17));
        lblGes.setMinimumSize(new java.awt.Dimension(140, 17));
        lblGes.setPreferredSize(new java.awt.Dimension(140, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInfoContent.add(lblGes, gridBagConstraints);

        panInfo.add(panInfoContent, java.awt.BorderLayout.CENTER);

        add(panInfo, java.awt.BorderLayout.CENTER);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbNeStateChanged(final javax.swing.event.ChangeEvent evt) { //GEN-FIRST:event_cbNeStateChanged
        boolean nothing = true;
        nothing &= CidsBeanSupport.textToDouble(tfBloecke, 0.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfKies, 0.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfKuenSub, 0.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfSand, 0.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfSchlamm, 0.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfSteine, 0.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfTon, 0.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfTorf, 0.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfTotholz, 0.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfWurzeln, 0.0) == 0.0;

        cbNe.setSelected(nothing);

        if (nothing) {
            tfBloecke.setText("0");
            tfKies.setText("0");
            tfKuenSub.setText("0");
            tfSand.setText("0");
            tfSchlamm.setText("0");
            tfSteine.setText("0");
            tfTon.setText("0");
            tfTorf.setText("0");
            tfTotholz.setText("0");
            tfWurzeln.setText("0");
        }
    } //GEN-LAST:event_cbNeStateChanged

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                this.cidsBean);
            bindingGroup.bind();
            fillGesamt();
            roundAll();
        }
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
    }

    /**
     * DOCUMENT ME!
     */
    private void fillGesamt() {
        double ges = 0.0;
        ges += CidsBeanSupport.textToDouble(tfBloecke, 0.0);
        ges += CidsBeanSupport.textToDouble(tfKies, 0.0);
        ges += CidsBeanSupport.textToDouble(tfKuenSub, 0.0);
        ges += CidsBeanSupport.textToDouble(tfSand, 0.0);
        ges += CidsBeanSupport.textToDouble(tfSchlamm, 0.0);
        ges += CidsBeanSupport.textToDouble(tfSteine, 0.0);
        ges += CidsBeanSupport.textToDouble(tfTon, 0.0);
        ges += CidsBeanSupport.textToDouble(tfTorf, 0.0);
        ges += CidsBeanSupport.textToDouble(tfTotholz, 0.0);
        ges += CidsBeanSupport.textToDouble(tfWurzeln, 0.0);
        lblGes.setText("gesamt: " + Double.valueOf(ges).intValue() + " %");

        boolean nothing = true;
        nothing &= CidsBeanSupport.textToDouble(tfBloecke, 1.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfKies, 1.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfKuenSub, 1.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfSand, 1.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfSchlamm, 1.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfSteine, 1.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfTon, 1.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfTorf, 1.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfTotholz, 1.0) == 0.0;
        nothing &= CidsBeanSupport.textToDouble(tfWurzeln, 1.0) == 0.0;

        if (nothing) {
            cbNe.setSelected(true);
        } else {
            cbNe.setSelected(false);
        }
    }

    /**
     * DOCUMENT ME!
     */
    private void roundAll() {
        round(tfBloecke);
        round(tfKies);
        round(tfKuenSub);
        round(tfSand);
        round(tfSchlamm);
        round(tfSteine);
        round(tfTon);
        round(tfTorf);
        round(tfTotholz);
        round(tfWurzeln);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  c  DOCUMENT ME!
     */
    private void round(final Component c) {
        if (c == null) {
            LOG.warn("substrate percentage round: component is null, illegal listener registration?");          // NOI18N
        } else {
            if (c instanceof JTextField) {
                final JTextField jtf = (JTextField)c;
                if (!jtf.getText().isEmpty()) {
                    final Double value = CidsBeanSupport.textToDouble(jtf, 0.0);
                    jtf.setText(String.valueOf(Math.round(value)));
                }
            } else {
                LOG.warn("substate percentage round: component no JTextField, illegal listener registration?"); // NOI18N
            }
        }
    }
}
