/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * GupMassnahmeSohle.java
 *
 * Created on 04.04.2012, 11:49:19
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import de.cismet.cids.client.tools.DevelopmentTools;

import de.cismet.cids.custom.wrrl_db_mv.util.RendererTools;
import de.cismet.cids.custom.wrrl_db_mv.util.ScrollableComboBox;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class PersonEditor extends javax.swing.JPanel implements CidsBeanRenderer, EditorSaveListener {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            PersonEditor.class);

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private boolean readOnly = false;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JLabel lblEmail;
    private javax.swing.JLabel lblFax;
    private javax.swing.JLabel lblHsnr;
    private javax.swing.JLabel lblName;
    private javax.swing.JLabel lblOrt;
    private javax.swing.JLabel lblPlz;
    private javax.swing.JLabel lblStrasse;
    private javax.swing.JLabel lblTel;
    private javax.swing.JLabel lblVorname;
    private javax.swing.JTextField tfEmail;
    private javax.swing.JTextField tfFax;
    private javax.swing.JTextField tfHsnr;
    private javax.swing.JTextField tfName;
    private javax.swing.JTextField tfOrt;
    private javax.swing.JTextField tfPlz;
    private javax.swing.JTextField tfStrasse;
    private javax.swing.JTextField tfTel;
    private javax.swing.JTextField tfVorname;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form GupMassnahmeSohle.
     */
    public PersonEditor() {
        this(false);
    }

    /**
     * Creates new form GupMassnahmeSohle.
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public PersonEditor(final boolean readOnly) {
        this.readOnly = readOnly;
        initComponents();

        if (readOnly) {
            RendererTools.makeReadOnly(tfEmail);
            RendererTools.makeReadOnly(tfFax);
            RendererTools.makeReadOnly(tfHsnr);
            RendererTools.makeReadOnly(tfName);
            RendererTools.makeReadOnly(tfOrt);
            RendererTools.makeReadOnly(tfPlz);
            RendererTools.makeReadOnly(tfStrasse);
            RendererTools.makeReadOnly(tfTel);
            RendererTools.makeReadOnly(tfVorname);
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        lblVorname = new javax.swing.JLabel();
        lblName = new javax.swing.JLabel();
        tfVorname = new javax.swing.JTextField();
        tfName = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        lblStrasse = new javax.swing.JLabel();
        tfStrasse = new javax.swing.JTextField();
        lblHsnr = new javax.swing.JLabel();
        tfHsnr = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        lblPlz = new javax.swing.JLabel();
        tfPlz = new javax.swing.JTextField();
        lblOrt = new javax.swing.JLabel();
        tfOrt = new javax.swing.JTextField();
        lblTel = new javax.swing.JLabel();
        tfTel = new javax.swing.JTextField();
        lblFax = new javax.swing.JLabel();
        tfFax = new javax.swing.JTextField();
        lblEmail = new javax.swing.JLabel();
        tfEmail = new javax.swing.JTextField();

        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(994, 500));
        setLayout(new java.awt.GridBagLayout());

        lblVorname.setFont(new java.awt.Font("Ubuntu", 1, 15));                                                       // NOI18N
        lblVorname.setText(org.openide.util.NbBundle.getMessage(PersonEditor.class, "PersonEditor.lblVorname.text")); // NOI18N
        lblVorname.setMaximumSize(new java.awt.Dimension(150, 17));
        lblVorname.setMinimumSize(new java.awt.Dimension(100, 17));
        lblVorname.setPreferredSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(25, 15, 5, 5);
        add(lblVorname, gridBagConstraints);

        lblName.setFont(new java.awt.Font("Ubuntu", 1, 15));                                                    // NOI18N
        lblName.setText(org.openide.util.NbBundle.getMessage(PersonEditor.class, "PersonEditor.lblName.text")); // NOI18N
        lblName.setMaximumSize(new java.awt.Dimension(150, 17));
        lblName.setMinimumSize(new java.awt.Dimension(100, 17));
        lblName.setPreferredSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(25, 15, 5, 5);
        add(lblName, gridBagConstraints);

        tfVorname.setMinimumSize(new java.awt.Dimension(200, 27));
        tfVorname.setPreferredSize(new java.awt.Dimension(200, 27));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.vorname}"),
                tfVorname,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(25, 5, 5, 5);
        add(tfVorname, gridBagConstraints);

        tfName.setMinimumSize(new java.awt.Dimension(200, 27));
        tfName.setPreferredSize(new java.awt.Dimension(200, 27));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.name}"),
                tfName,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(25, 5, 5, 5);
        add(tfName, gridBagConstraints);

        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.GridBagLayout());

        lblStrasse.setFont(new java.awt.Font("Ubuntu", 1, 15));                                                       // NOI18N
        lblStrasse.setText(org.openide.util.NbBundle.getMessage(PersonEditor.class, "PersonEditor.lblStrasse.text")); // NOI18N
        lblStrasse.setMaximumSize(new java.awt.Dimension(150, 17));
        lblStrasse.setMinimumSize(new java.awt.Dimension(100, 17));
        lblStrasse.setPreferredSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        jPanel1.add(lblStrasse, gridBagConstraints);

        tfStrasse.setMinimumSize(new java.awt.Dimension(100, 27));
        tfStrasse.setPreferredSize(new java.awt.Dimension(100, 27));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.strasse}"),
                tfStrasse,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel1.add(tfStrasse, gridBagConstraints);

        lblHsnr.setFont(new java.awt.Font("Ubuntu", 1, 15));                                                    // NOI18N
        lblHsnr.setText(org.openide.util.NbBundle.getMessage(PersonEditor.class, "PersonEditor.lblHsnr.text")); // NOI18N
        lblHsnr.setMaximumSize(new java.awt.Dimension(150, 17));
        lblHsnr.setMinimumSize(new java.awt.Dimension(150, 17));
        lblHsnr.setPreferredSize(new java.awt.Dimension(75, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        jPanel1.add(lblHsnr, gridBagConstraints);

        tfHsnr.setMinimumSize(new java.awt.Dimension(100, 27));
        tfHsnr.setPreferredSize(new java.awt.Dimension(100, 27));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.hsnr}"),
                tfHsnr,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel1.add(tfHsnr, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jPanel1, gridBagConstraints);

        jPanel2.setOpaque(false);
        jPanel2.setLayout(new java.awt.GridBagLayout());

        lblPlz.setFont(new java.awt.Font("Ubuntu", 1, 15));                                                   // NOI18N
        lblPlz.setText(org.openide.util.NbBundle.getMessage(PersonEditor.class, "PersonEditor.lblPlz.text")); // NOI18N
        lblPlz.setMaximumSize(new java.awt.Dimension(150, 17));
        lblPlz.setMinimumSize(new java.awt.Dimension(150, 17));
        lblPlz.setPreferredSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        jPanel2.add(lblPlz, gridBagConstraints);

        tfPlz.setMinimumSize(new java.awt.Dimension(100, 27));
        tfPlz.setPreferredSize(new java.awt.Dimension(100, 27));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.plz}"),
                tfPlz,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel2.add(tfPlz, gridBagConstraints);

        lblOrt.setFont(new java.awt.Font("Ubuntu", 1, 15));                                                   // NOI18N
        lblOrt.setText(org.openide.util.NbBundle.getMessage(PersonEditor.class, "PersonEditor.lblOrt.text")); // NOI18N
        lblOrt.setMaximumSize(new java.awt.Dimension(150, 17));
        lblOrt.setMinimumSize(new java.awt.Dimension(100, 17));
        lblOrt.setPreferredSize(new java.awt.Dimension(75, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        jPanel2.add(lblOrt, gridBagConstraints);

        tfOrt.setMinimumSize(new java.awt.Dimension(100, 27));
        tfOrt.setPreferredSize(new java.awt.Dimension(100, 27));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.ort}"),
                tfOrt,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel2.add(tfOrt, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jPanel2, gridBagConstraints);

        lblTel.setFont(new java.awt.Font("Ubuntu", 1, 15));                                                   // NOI18N
        lblTel.setText(org.openide.util.NbBundle.getMessage(PersonEditor.class, "PersonEditor.lblTel.text")); // NOI18N
        lblTel.setMaximumSize(new java.awt.Dimension(150, 17));
        lblTel.setMinimumSize(new java.awt.Dimension(100, 17));
        lblTel.setPreferredSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        add(lblTel, gridBagConstraints);

        tfTel.setMinimumSize(new java.awt.Dimension(100, 27));
        tfTel.setPreferredSize(new java.awt.Dimension(100, 27));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.tel}"),
                tfTel,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(tfTel, gridBagConstraints);

        lblFax.setFont(new java.awt.Font("Ubuntu", 1, 15));                                                   // NOI18N
        lblFax.setText(org.openide.util.NbBundle.getMessage(PersonEditor.class, "PersonEditor.lblFax.text")); // NOI18N
        lblFax.setMaximumSize(new java.awt.Dimension(150, 17));
        lblFax.setMinimumSize(new java.awt.Dimension(100, 17));
        lblFax.setPreferredSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        add(lblFax, gridBagConstraints);

        tfFax.setMinimumSize(new java.awt.Dimension(200, 27));
        tfFax.setPreferredSize(new java.awt.Dimension(200, 27));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.fax}"),
                tfFax,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(tfFax, gridBagConstraints);

        lblEmail.setFont(new java.awt.Font("Ubuntu", 1, 15));                                                     // NOI18N
        lblEmail.setText(org.openide.util.NbBundle.getMessage(PersonEditor.class, "PersonEditor.lblEmail.text")); // NOI18N
        lblEmail.setMaximumSize(new java.awt.Dimension(150, 17));
        lblEmail.setMinimumSize(new java.awt.Dimension(100, 17));
        lblEmail.setPreferredSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        add(lblEmail, gridBagConstraints);

        tfEmail.setMinimumSize(new java.awt.Dimension(100, 27));
        tfEmail.setPreferredSize(new java.awt.Dimension(100, 27));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.email}"),
                tfEmail,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(tfEmail, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        this.cidsBean = cidsBean;

        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                cidsBean);
            bindingGroup.bind();
        }
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
    }

    @Override
    public String getTitle() {
        return "Person - Kontaktdaten";
    }

    @Override
    public void setTitle(final String title) {
    }

    @Override
    public void editorClosed(final EditorClosedEvent event) {
    }

    @Override
    public boolean prepareForSave() {
        return true;
    }

    /**
     * DOCUMENT ME!
     *
     * @param   args  DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    public static void main(final String[] args) throws Exception {
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost(
            "WRRL_DB_MV",
            "Administratoren",
            "admin",
            "x",
            "person",
            1,
            1280,
            1024);
    }
}
