/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * WkFgEditor.java
 *
 * Created on 04.08.2010, 13:13:12
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import javax.swing.JComponent;
import javax.swing.JPanel;

import de.cismet.cids.custom.wrrl_db_mv.util.TabbedPaneUITransparent;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

import de.cismet.tools.gui.FooterComponentProvider;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class SwstnEditor extends JPanel implements CidsBeanRenderer, EditorSaveListener, FooterComponentProvider {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(SwstnEditor.class);

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel lblFoot;
    private javax.swing.JPanel panFooter;
    private de.cismet.cids.custom.objecteditors.wrrl_db_mv.SwstnPanOne swstnPanOne1;
    private de.cismet.cids.custom.objecteditors.wrrl_db_mv.SwstnPanThree swstnPanThree1;
    private de.cismet.cids.custom.objecteditors.wrrl_db_mv.SwstnPanTwo swstnPanTwo1;
    private javax.swing.JTabbedPane tpMain;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WkFgEditor.
     */
    public SwstnEditor() {
        initComponents();
        tpMain.setUI(new TabbedPaneUITransparent());
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            swstnPanOne1.setCidsBean(cidsBean);
            swstnPanTwo1.setCidsBean(cidsBean);
            swstnPanThree1.setCidsBean(cidsBean);
        } else {
            lblFoot.setText("");
        }
    }

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        panFooter = new javax.swing.JPanel();
        lblFoot = new javax.swing.JLabel();
        tpMain = new javax.swing.JTabbedPane();
        swstnPanOne1 = new de.cismet.cids.custom.objecteditors.wrrl_db_mv.SwstnPanOne();
        swstnPanTwo1 = new de.cismet.cids.custom.objecteditors.wrrl_db_mv.SwstnPanTwo();
        jPanel1 = new javax.swing.JPanel();
        swstnPanThree1 = new de.cismet.cids.custom.objecteditors.wrrl_db_mv.SwstnPanThree();

        panFooter.setOpaque(false);
        panFooter.setLayout(new java.awt.GridBagLayout());

        lblFoot.setFont(new java.awt.Font("Tahoma", 1, 12));
        lblFoot.setForeground(new java.awt.Color(255, 255, 255));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(7, 25, 7, 25);
        panFooter.add(lblFoot, gridBagConstraints);

        setLayout(new java.awt.GridBagLayout());
        add(tpMain, new java.awt.GridBagConstraints());
        tpMain.getAccessibleContext().setAccessibleName("Qualitaetsinformationen 1");

        swstnPanOne1.setMinimumSize(new java.awt.Dimension(475, 535));
        swstnPanOne1.setPreferredSize(new java.awt.Dimension(475, 535));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 10);
        add(swstnPanOne1, gridBagConstraints);

        swstnPanTwo1.setMinimumSize(new java.awt.Dimension(475, 535));
        swstnPanTwo1.setPreferredSize(new java.awt.Dimension(475, 535));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 5, 5);
        add(swstnPanTwo1, gridBagConstraints);

        jPanel1.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        add(jPanel1, gridBagConstraints);

        swstnPanThree1.setMinimumSize(new java.awt.Dimension(750, 200));
        swstnPanThree1.setPreferredSize(new java.awt.Dimension(750, 200));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        add(swstnPanThree1, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public void dispose() {
        swstnPanOne1.dispose();
        swstnPanTwo1.dispose();
        swstnPanThree1.dispose();
    }

    @Override
    public String getTitle() {
        return "SWSTN " + String.valueOf(cidsBean);
    }

    @Override
    public void setTitle(final String title) {
        // NOP
    }

    @Override
    public void editorClosed(final EditorClosedEvent event) {
        // TODO ?
    }

    @Override
    public boolean prepareForSave() {
        return swstnPanOne1.prepareForSave();
    }

    @Override
    public JComponent getFooterComponent() {
        return panFooter;
    }
}
