/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * WkFgPanOne.java
 *
 * Created on 04.08.2010, 13:44:05
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.server.middleware.types.MetaClass;

import java.util.Collection;

import javax.swing.JDialog;
import javax.swing.JOptionPane;

import de.cismet.cids.custom.wrrl_db_mv.commons.WRRLUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.ScrollableComboBox;
import de.cismet.cids.custom.wrrl_db_mv.util.UIUtil;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.converters.SqlTimestampToUtilDateConverter;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class SwstnPanThree extends javax.swing.JPanel implements DisposableCidsBeanStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final MetaClass MONITORINT_MC;
    private static final MetaClass QE_TYPES_MC;

    static {
        MONITORINT_MC = ClassCacheMultiple.getMetaClass(WRRLUtil.DOMAIN_NAME, "wfd.int_monitor_net_code");
        QE_TYPES_MC = ClassCacheMultiple.getMetaClass(WRRLUtil.DOMAIN_NAME, "wfd.quality_element_type_code");
    }

    //~ Instance fields --------------------------------------------------------

    private SqlTimestampToUtilDateConverter dateConverter = new SqlTimestampToUtilDateConverter();

    private CidsBean cidsBean;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnAddMonitor;
    private javax.swing.JButton btnAddQe;
    private javax.swing.JButton btnMenMonitorAbort;
    private javax.swing.JButton btnMenMonitorOk;
    private javax.swing.JButton btnMenQeAbort;
    private javax.swing.JButton btnMenQeOk;
    private javax.swing.JButton btnRemMonitor;
    private javax.swing.JButton btnRemQe;
    private javax.swing.JComboBox cbMonitorCataloge;
    private javax.swing.JComboBox cbQeCataloge;
    private javax.swing.JDialog dlgMonitorCataloge;
    private javax.swing.JDialog dlgQeCataloge;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel lblLabCoords;
    private javax.swing.JLabel lblMonitorCataloge;
    private javax.swing.JLabel lblQeCataloge;
    private javax.swing.JLabel lblSitetype;
    private javax.swing.JList lstMonitor;
    private javax.swing.JList lstQe;
    private javax.swing.JPanel panContrMonitor;
    private javax.swing.JPanel panContrQe;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo;
    private de.cismet.tools.gui.RoundedPanel panInfo;
    private javax.swing.JPanel panInfoContent;
    private javax.swing.JPanel panMenButtonsMonitor;
    private javax.swing.JPanel panMenButtonsQe;
    private javax.swing.JScrollPane scpMonitor;
    private javax.swing.JScrollPane scpQe;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WkFgPanOne.
     */
    public SwstnPanThree() {
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        dlgMonitorCataloge = new JDialog(StaticSwingTools.getParentFrame(this));
        lblMonitorCataloge = new javax.swing.JLabel();
        cbMonitorCataloge = new ScrollableComboBox(MONITORINT_MC, true, true);
        panMenButtonsMonitor = new javax.swing.JPanel();
        btnMenMonitorAbort = new javax.swing.JButton();
        btnMenMonitorOk = new javax.swing.JButton();
        dlgQeCataloge = new JDialog(StaticSwingTools.getParentFrame(this));
        lblQeCataloge = new javax.swing.JLabel();
        cbQeCataloge = new ScrollableComboBox(QE_TYPES_MC, true, true);
        panMenButtonsQe = new javax.swing.JPanel();
        btnMenQeAbort = new javax.swing.JButton();
        btnMenQeOk = new javax.swing.JButton();
        panInfo = new de.cismet.tools.gui.RoundedPanel();
        panHeadInfo = new de.cismet.tools.gui.SemiRoundedPanel();
        jLabel1 = new javax.swing.JLabel();
        panInfoContent = new javax.swing.JPanel();
        lblLabCoords = new javax.swing.JLabel();
        lblSitetype = new javax.swing.JLabel();
        panContrMonitor = new javax.swing.JPanel();
        btnAddMonitor = new javax.swing.JButton();
        btnRemMonitor = new javax.swing.JButton();
        scpMonitor = new javax.swing.JScrollPane();
        lstMonitor = new javax.swing.JList();
        scpQe = new javax.swing.JScrollPane();
        lstQe = new javax.swing.JList();
        panContrQe = new javax.swing.JPanel();
        btnAddQe = new javax.swing.JButton();
        btnRemQe = new javax.swing.JButton();

        dlgMonitorCataloge.setMinimumSize(new java.awt.Dimension(260, 150));
        dlgMonitorCataloge.getContentPane().setLayout(new java.awt.GridBagLayout());

        lblMonitorCataloge.setText(org.openide.util.NbBundle.getMessage(
                SwstnPanThree.class,
                "SwstnPanThree.lblMonitorCataloge.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        dlgMonitorCataloge.getContentPane().add(lblMonitorCataloge, gridBagConstraints);

        cbMonitorCataloge.setMinimumSize(new java.awt.Dimension(650, 18));
        cbMonitorCataloge.setPreferredSize(new java.awt.Dimension(650, 18));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        dlgMonitorCataloge.getContentPane().add(cbMonitorCataloge, gridBagConstraints);

        panMenButtonsMonitor.setLayout(new java.awt.GridBagLayout());

        btnMenMonitorAbort.setText(org.openide.util.NbBundle.getMessage(
                SwstnPanThree.class,
                "WkFgPanOne.btnMenImpactSrcAbort.text")); // NOI18N
        btnMenMonitorAbort.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnMenMonitorAbortActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panMenButtonsMonitor.add(btnMenMonitorAbort, gridBagConstraints);

        btnMenMonitorOk.setText(org.openide.util.NbBundle.getMessage(
                SwstnPanThree.class,
                "WkFgPanOne.btnMenImpactSrcOk.text")); // NOI18N
        btnMenMonitorOk.setMaximumSize(new java.awt.Dimension(85, 23));
        btnMenMonitorOk.setMinimumSize(new java.awt.Dimension(85, 23));
        btnMenMonitorOk.setPreferredSize(new java.awt.Dimension(85, 23));
        btnMenMonitorOk.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnMenMonitorOkActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panMenButtonsMonitor.add(btnMenMonitorOk, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        dlgMonitorCataloge.getContentPane().add(panMenButtonsMonitor, gridBagConstraints);

        dlgQeCataloge.setMinimumSize(new java.awt.Dimension(260, 150));
        dlgQeCataloge.getContentPane().setLayout(new java.awt.GridBagLayout());

        lblQeCataloge.setText(org.openide.util.NbBundle.getMessage(
                SwstnPanThree.class,
                "SwstnPanThree.lblQeCataloge.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        dlgQeCataloge.getContentPane().add(lblQeCataloge, gridBagConstraints);

        cbQeCataloge.setMinimumSize(new java.awt.Dimension(650, 18));
        cbQeCataloge.setPreferredSize(new java.awt.Dimension(650, 18));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        dlgQeCataloge.getContentPane().add(cbQeCataloge, gridBagConstraints);

        panMenButtonsQe.setLayout(new java.awt.GridBagLayout());

        btnMenQeAbort.setText(org.openide.util.NbBundle.getMessage(
                SwstnPanThree.class,
                "WkFgPanOne.btnMenImpactSrcAbort.text")); // NOI18N
        btnMenQeAbort.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnMenQeAbortActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panMenButtonsQe.add(btnMenQeAbort, gridBagConstraints);

        btnMenQeOk.setText(org.openide.util.NbBundle.getMessage(
                SwstnPanThree.class,
                "WkFgPanOne.btnMenImpactSrcOk.text")); // NOI18N
        btnMenQeOk.setMaximumSize(new java.awt.Dimension(85, 23));
        btnMenQeOk.setMinimumSize(new java.awt.Dimension(85, 23));
        btnMenQeOk.setPreferredSize(new java.awt.Dimension(85, 23));
        btnMenQeOk.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnMenQeOkActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panMenButtonsQe.add(btnMenQeOk, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        dlgQeCataloge.getContentPane().add(panMenButtonsQe, gridBagConstraints);

        setMinimumSize(new java.awt.Dimension(995, 175));
        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(995, 175));
        setLayout(new java.awt.BorderLayout());

        panHeadInfo.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setLayout(new java.awt.FlowLayout());

        jLabel1.setForeground(new java.awt.Color(255, 255, 255));
        jLabel1.setText("Messnetze und Qualitätskomponenten");
        panHeadInfo.add(jLabel1);

        panInfo.add(panHeadInfo, java.awt.BorderLayout.NORTH);

        panInfoContent.setOpaque(false);
        panInfoContent.setLayout(new java.awt.GridBagLayout());

        lblLabCoords.setText("Messnetze");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 5);
        panInfoContent.add(lblLabCoords, gridBagConstraints);

        lblSitetype.setText("Überwachte Qualitätskomponenten");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 15, 15);
        panInfoContent.add(lblSitetype, gridBagConstraints);

        panContrMonitor.setOpaque(false);
        panContrMonitor.setLayout(new java.awt.GridBagLayout());

        btnAddMonitor.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_add_mini.png"))); // NOI18N
        btnAddMonitor.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnAddMonitorActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        panContrMonitor.add(btnAddMonitor, gridBagConstraints);

        btnRemMonitor.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_remove_mini.png"))); // NOI18N
        btnRemMonitor.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnRemMonitorActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        panContrMonitor.add(btnRemMonitor, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        panInfoContent.add(panContrMonitor, gridBagConstraints);

        scpMonitor.setMinimumSize(new java.awt.Dimension(675, 80));
        scpMonitor.setPreferredSize(new java.awt.Dimension(675, 80));

        lstMonitor.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);

        org.jdesktop.beansbinding.ELProperty eLProperty = org.jdesktop.beansbinding.ELProperty.create(
                "${cidsBean.monitornet}");
        org.jdesktop.swingbinding.JListBinding jListBinding = org.jdesktop.swingbinding.SwingBindings
                    .createJListBinding(
                        org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                        this,
                        eLProperty,
                        lstMonitor);
        bindingGroup.addBinding(jListBinding);

        scpMonitor.setViewportView(lstMonitor);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 5);
        panInfoContent.add(scpMonitor, gridBagConstraints);

        scpQe.setMinimumSize(new java.awt.Dimension(675, 80));
        scpQe.setPreferredSize(new java.awt.Dimension(675, 80));

        lstQe.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);

        eLProperty = org.jdesktop.beansbinding.ELProperty.create("${cidsBean.qe_types}");
        jListBinding = org.jdesktop.swingbinding.SwingBindings.createJListBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                eLProperty,
                lstQe);
        bindingGroup.addBinding(jListBinding);

        scpQe.setViewportView(lstQe);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInfoContent.add(scpQe, gridBagConstraints);

        panContrQe.setOpaque(false);
        panContrQe.setLayout(new java.awt.GridBagLayout());

        btnAddQe.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_add_mini.png"))); // NOI18N
        btnAddQe.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnAddQeActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        panContrQe.add(btnAddQe, gridBagConstraints);

        btnRemQe.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_remove_mini.png"))); // NOI18N
        btnRemQe.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnRemQeActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        panContrQe.add(btnRemQe, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        panInfoContent.add(panContrQe, gridBagConstraints);

        panInfo.add(panInfoContent, java.awt.BorderLayout.CENTER);

        add(panInfo, java.awt.BorderLayout.CENTER);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnAddMonitorActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnAddMonitorActionPerformed
        dlgMonitorCataloge.setSize(750, 150);
        StaticSwingTools.showDialog(StaticSwingTools.getParentFrame(this), dlgMonitorCataloge, true);
    }                                                                                 //GEN-LAST:event_btnAddMonitorActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnRemMonitorActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnRemMonitorActionPerformed
        final Object selection = lstMonitor.getSelectedValue();
        if (selection != null) {
            final int answer = JOptionPane.showConfirmDialog(
                    StaticSwingTools.getParentFrame(this),
                    "Soll das Messnetz wirklich entfern werden?",
                    "Messnetz entfernen",
                    JOptionPane.YES_NO_OPTION);
            if (answer == JOptionPane.YES_OPTION) {
                try {
                    final CidsBean beanToDelete = (CidsBean)selection;
                    final Object beanColl = cidsBean.getProperty("monitornet");
                    if (beanColl instanceof Collection) {
                        ((Collection)beanColl).remove(beanToDelete);
                    }
                } catch (Exception e) {
                    UIUtil.showExceptionToUser(e, this);
                }
            }
        }
    }                                                                                 //GEN-LAST:event_btnRemMonitorActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnMenMonitorAbortActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnMenMonitorAbortActionPerformed
        dlgMonitorCataloge.setVisible(false);
    }                                                                                      //GEN-LAST:event_btnMenMonitorAbortActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnMenMonitorOkActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnMenMonitorOkActionPerformed
        final Object selection = cbMonitorCataloge.getSelectedItem();
        if (selection instanceof CidsBean) {
            final CidsBean selectedBean = (CidsBean)selection;
            final Collection<CidsBean> colToAdd = CidsBeanSupport.getBeanCollectionFromProperty(cidsBean, "monitornet");
            if (colToAdd != null) {
                if (!colToAdd.contains(selectedBean)) {
                    colToAdd.add(selectedBean);
                } else {
                    JOptionPane.showMessageDialog(
                        this,
                        "Die Messstation ist dem ausgewählten Messnetz bereits zugewiesen.");
                }
            }
        }
        dlgMonitorCataloge.setVisible(false);
    }                                                                                   //GEN-LAST:event_btnMenMonitorOkActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnAddQeActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnAddQeActionPerformed
        dlgQeCataloge.setSize(750, 150);
        StaticSwingTools.showDialog(StaticSwingTools.getParentFrame(this), dlgQeCataloge, true);
    }                                                                            //GEN-LAST:event_btnAddQeActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnRemQeActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnRemQeActionPerformed
        final Object selection = lstQe.getSelectedValue();
        if (selection != null) {
            final int answer = JOptionPane.showConfirmDialog(
                    StaticSwingTools.getParentFrame(this),
                    "Soll die Qualitätskomponente wirklich entfern werden?",
                    "Qualitätskomponente entfernen",
                    JOptionPane.YES_NO_OPTION);
            if (answer == JOptionPane.YES_OPTION) {
                try {
                    final CidsBean beanToDelete = (CidsBean)selection;
                    final Object beanColl = cidsBean.getProperty("qe_types");
                    if (beanColl instanceof Collection) {
                        ((Collection)beanColl).remove(beanToDelete);
                    }
                } catch (Exception e) {
                    UIUtil.showExceptionToUser(e, this);
                }
            }
        }
    }                                                                            //GEN-LAST:event_btnRemQeActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnMenQeAbortActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnMenQeAbortActionPerformed
        dlgQeCataloge.setVisible(false);
    }                                                                                 //GEN-LAST:event_btnMenQeAbortActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnMenQeOkActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnMenQeOkActionPerformed
        final Object selection = cbQeCataloge.getSelectedItem();
        if (selection instanceof CidsBean) {
            final CidsBean selectedBean = (CidsBean)selection;
            final Collection<CidsBean> colToAdd = CidsBeanSupport.getBeanCollectionFromProperty(cidsBean, "qe_types");
            if (colToAdd != null) {
                if (!colToAdd.contains(selectedBean)) {
                    colToAdd.add(selectedBean);
                } else {
                    JOptionPane.showMessageDialog(
                        StaticSwingTools.getParentFrame(this),
                        "Die ausgewählte Qualitätskomponente ist der Messstation bereits zugewiesen.");
                }
            }
        }
        dlgQeCataloge.setVisible(false);
    }                                                                              //GEN-LAST:event_btnMenQeOkActionPerformed

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                this.cidsBean);
            bindingGroup.bind();
        }
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
    }
}
