/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * WfdDeMeasureTypeGroup.java
 *
 * Created on 20.12.2011, 16:21:15
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.tools.CacheException;
import Sirius.navigator.tools.MetaObjectCache;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

import de.cismet.cids.custom.wrrl_db_mv.commons.WRRLUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.StringIntValueComparator;
import de.cismet.cids.custom.wrrl_db_mv.util.UIUtil;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;

import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class WfdDeMeasureTypeGroupEditor extends javax.swing.JPanel implements CidsBeanRenderer,
    EditorSaveListener,
    CidsBeanDropListener {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            WfdDeMeasureTypeGroupEditor.class);
    private static final MetaClass MASSNAHMEN_TYP_MC;
    private static final ConnectionContext cc = ConnectionContext.create(
            AbstractConnectionContext.Category.EDITOR,
            "WfdDeMeasureTypeGroupEditor");

    static {
        MASSNAHMEN_TYP_MC = ClassCacheMultiple.getMetaClass(
                WRRLUtil.DOMAIN_NAME,
                "wfd.de_measure_type_code"); // NOI18N
    }

    //~ Instance fields --------------------------------------------------------

    ArrayList<CidsBean> toDelete = new ArrayList<CidsBean>();

    private CidsBean cidsBean;
    private String title;
    private final MeasureTypeModelAll measureModelAll = new MeasureTypeModelAll();
    private boolean readOnly = false;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnAddIndikator;
    private javax.swing.JButton btnMassnahmenTypAllAbort;
    private javax.swing.JButton btnMassnahmenTypAllOk;
    private javax.swing.JButton btnRemIndikator;
    private javax.swing.JDialog dlgMassnahmenTypAll;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane6;
    private javax.swing.JList jlIndikator;
    private javax.swing.JList jlMassnahmenAllCataloge;
    private javax.swing.JLabel lblMassnahmenTypAllCataloge;
    private javax.swing.JLabel lblName;
    private javax.swing.JPanel panInfoContent3;
    private javax.swing.JPanel panMassnahmen;
    private javax.swing.JPanel panMenButtonsMassnahmenTyp1;
    private javax.swing.JTextField txtValProjekt_nr;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WfdDeMeasureTypeGroup.
     */
    public WfdDeMeasureTypeGroupEditor() {
        this(false);
    }

    /**
     * Creates new form WfdDeMeasureTypeGroup.
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public WfdDeMeasureTypeGroupEditor(final boolean readOnly) {
        this.readOnly = readOnly;
        initComponents();

        if (!readOnly) {
            try {
                new CidsBeanDropTarget(this);
            } catch (Exception ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("error while creating CidsBeanDropTarget", ex);
                }
            }
        } else {
            panMassnahmen.setVisible(false);
            txtValProjekt_nr.setEnabled(false);
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        dlgMassnahmenTypAll = new JDialog(StaticSwingTools.getParentFrame(this));
        panMenButtonsMassnahmenTyp1 = new javax.swing.JPanel();
        btnMassnahmenTypAllAbort = new javax.swing.JButton();
        btnMassnahmenTypAllOk = new javax.swing.JButton();
        jScrollPane6 = new javax.swing.JScrollPane();
        jlMassnahmenAllCataloge = new javax.swing.JList();
        lblMassnahmenTypAllCataloge = new javax.swing.JLabel();
        lblName = new javax.swing.JLabel();
        panInfoContent3 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jlIndikator = new javax.swing.JList();
        panMassnahmen = new javax.swing.JPanel();
        btnRemIndikator = new javax.swing.JButton();
        btnAddIndikator = new javax.swing.JButton();
        txtValProjekt_nr = new javax.swing.JTextField();

        dlgMassnahmenTypAll.setTitle(org.openide.util.NbBundle.getMessage(
                WfdDeMeasureTypeGroupEditor.class,
                "WfdDeMeasureTypeGroupEditor.dlgMassnahmenTypAll.title")); // NOI18N
        dlgMassnahmenTypAll.getContentPane().setLayout(new java.awt.GridBagLayout());

        panMenButtonsMassnahmenTyp1.setLayout(new java.awt.GridBagLayout());

        btnMassnahmenTypAllAbort.setText(org.openide.util.NbBundle.getMessage(
                WfdDeMeasureTypeGroupEditor.class,
                "WfdDeMeasureTypeGroupEditor.btnMassnahmenTypAllAbort.text")); // NOI18N
        btnMassnahmenTypAllAbort.setMinimumSize(new java.awt.Dimension(105, 23));
        btnMassnahmenTypAllAbort.setPreferredSize(new java.awt.Dimension(105, 23));
        btnMassnahmenTypAllAbort.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnMassnahmenTypAllAbortActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 0);
        panMenButtonsMassnahmenTyp1.add(btnMassnahmenTypAllAbort, gridBagConstraints);

        btnMassnahmenTypAllOk.setText(org.openide.util.NbBundle.getMessage(
                WfdDeMeasureTypeGroupEditor.class,
                "WfdDeMeasureTypeGroupEditor.btnMassnahmenTypAllOk.text")); // NOI18N
        btnMassnahmenTypAllOk.setMaximumSize(new java.awt.Dimension(85, 23));
        btnMassnahmenTypAllOk.setMinimumSize(new java.awt.Dimension(105, 23));
        btnMassnahmenTypAllOk.setPreferredSize(new java.awt.Dimension(105, 23));
        btnMassnahmenTypAllOk.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnMassnahmenTypAllOkActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        panMenButtonsMassnahmenTyp1.add(btnMassnahmenTypAllOk, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        dlgMassnahmenTypAll.getContentPane().add(panMenButtonsMassnahmenTyp1, gridBagConstraints);

        jScrollPane6.setMinimumSize(new java.awt.Dimension(750, 200));
        jScrollPane6.setPreferredSize(new java.awt.Dimension(750, 200));

        jlMassnahmenAllCataloge.setModel(measureModelAll);
        jScrollPane6.setViewportView(jlMassnahmenAllCataloge);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        dlgMassnahmenTypAll.getContentPane().add(jScrollPane6, gridBagConstraints);

        lblMassnahmenTypAllCataloge.setText(org.openide.util.NbBundle.getMessage(
                WfdDeMeasureTypeGroupEditor.class,
                "WfdDeMeasureTypeGroupEditor.lblMassnahmenTypAllCataloge.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 5);
        dlgMassnahmenTypAll.getContentPane().add(lblMassnahmenTypAllCataloge, gridBagConstraints);

        setLayout(new java.awt.GridBagLayout());

        lblName.setText(org.openide.util.NbBundle.getMessage(
                WfdDeMeasureTypeGroupEditor.class,
                "WfdDeMeasureTypeGroupEditor.lblName.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 10, 10);
        add(lblName, gridBagConstraints);

        panInfoContent3.setOpaque(false);
        panInfoContent3.setLayout(new java.awt.GridBagLayout());

        jScrollPane2.setMinimumSize(new java.awt.Dimension(290, 100));
        jScrollPane2.setPreferredSize(new java.awt.Dimension(490, 100));

        jlIndikator.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);

        final org.jdesktop.beansbinding.ELProperty eLProperty = org.jdesktop.beansbinding.ELProperty.create(
                "${cidsBean.types}");
        final org.jdesktop.swingbinding.JListBinding jListBinding = org.jdesktop.swingbinding.SwingBindings
                    .createJListBinding(
                        org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                        this,
                        eLProperty,
                        jlIndikator);
        bindingGroup.addBinding(jListBinding);

        jScrollPane2.setViewportView(jlIndikator);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 15, 10);
        panInfoContent3.add(jScrollPane2, gridBagConstraints);

        panMassnahmen.setOpaque(false);
        panMassnahmen.setLayout(new java.awt.GridBagLayout());

        btnRemIndikator.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_remove_16.png"))); // NOI18N
        btnRemIndikator.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnRemIndikatorActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        panMassnahmen.add(btnRemIndikator, gridBagConstraints);

        btnAddIndikator.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_add_16.png"))); // NOI18N
        btnAddIndikator.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnAddIndikatorActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        panMassnahmen.add(btnAddIndikator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 30, 5, 30);
        panInfoContent3.add(panMassnahmen, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 590;
        gridBagConstraints.ipady = 83;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 27, 0);
        add(panInfoContent3, gridBagConstraints);

        txtValProjekt_nr.setDisabledTextColor(new java.awt.Color(26, 26, 26));
        txtValProjekt_nr.setMinimumSize(new java.awt.Dimension(215, 20));
        txtValProjekt_nr.setPreferredSize(new java.awt.Dimension(215, 20));

        final org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.name}"),
                txtValProjekt_nr,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 10);
        add(txtValProjekt_nr, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnAddIndikatorActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnAddIndikatorActionPerformed
        dlgMassnahmenTypAll.setSize(790, 350);
        StaticSwingTools.showDialog(StaticSwingTools.getParentFrame(this), dlgMassnahmenTypAll, true);
    }                                                                                   //GEN-LAST:event_btnAddIndikatorActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnRemIndikatorActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnRemIndikatorActionPerformed
        final Object selection = jlIndikator.getSelectedValue();
        if (selection != null) {
            final int answer = JOptionPane.showConfirmDialog(
                    StaticSwingTools.getParentFrame(this),
                    "Soll der ausgewählte Maßnahmentyp wirklich gelöscht werden?",
                    "Maßnahmentyp entfernen",
                    JOptionPane.YES_NO_OPTION);
            if (answer == JOptionPane.YES_OPTION) {
                try {
                    final CidsBean beanToDelete = (CidsBean)selection;
                    final Object beanColl = cidsBean.getProperty("types");              // NOI18N
                    if (beanColl instanceof Collection) {
                        ((Collection)beanColl).remove(beanToDelete);
                        toDelete.add(beanToDelete);
//                        beanToDelete.delete();
                    }
                } catch (final Exception e) {
                    UIUtil.showExceptionToUser(e, this);
                }
            }
        }
    }                                                                                   //GEN-LAST:event_btnRemIndikatorActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnMassnahmenTypAllOkActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnMassnahmenTypAllOkActionPerformed
        final Object[] selectedObjects = jlMassnahmenAllCataloge.getSelectedValues();

        if (selectedObjects != null) {
            final Thread t = new Thread(new Runnable() {

                        @Override
                        public void run() {
                            for (final Object selection : selectedObjects) {
                                addMeasureTypeCode((CidsBean)selection);
                            }
                        }
                    });
            t.start();
        }

        jlMassnahmenAllCataloge.setSelectedIndex(0);
        dlgMassnahmenTypAll.setVisible(false);
    } //GEN-LAST:event_btnMassnahmenTypAllOkActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnMassnahmenTypAllAbortActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnMassnahmenTypAllAbortActionPerformed
        dlgMassnahmenTypAll.setVisible(false);
    }                                                                                            //GEN-LAST:event_btnMassnahmenTypAllAbortActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  measureTypeCode  DOCUMENT ME!
     */
    private void addMeasureTypeCode(final CidsBean measureTypeCode) {
        final List<CidsBean> beans = CidsBeanSupport.getBeanCollectionFromProperty(
                cidsBean,
                "types");
        if ((measureTypeCode instanceof CidsBean) && !beans.contains((CidsBean)measureTypeCode)) {
            beans.add(measureTypeCode);
        }
    }

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                cidsBean);
            bindingGroup.bind();
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getTitle() {
        return title;
    }

    @Override
    public void setTitle(final String title) {
        this.title = title;
    }

    @Override
    public void editorClosed(final EditorClosedEvent event) {
    }

    @Override
    public boolean prepareForSave() {
        cidsBean.getMetaObject().setAllClasses();
        return true;
    }

    @Override
    public void beansDropped(final ArrayList<CidsBean> beans) {
        if ((cidsBean != null) && !readOnly) {
            for (final CidsBean bean : beans) {
                if (bean.getClass().getName().equals("de.cismet.cids.dynamics.Wfd.de_measure_type_code")) {
                    addMeasureTypeCode(bean);
                }
            }
        }
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private class MeasureTypeModelAll implements ListModel {

        //~ Instance fields ----------------------------------------------------

        private List<CidsBean> types;
        private List<ListDataListener> listener = new ArrayList<ListDataListener>();
        private boolean initialized = false;

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new MeasureTypeModel object.
         */
        public MeasureTypeModelAll() {
            final Thread t = new Thread(new Runnable() {

                        @Override
                        public void run() {
                            MetaObject[] metaObjects = null;

                            try {
                                final String query = "select " + MASSNAHMEN_TYP_MC.getID() + ","
                                            + MASSNAHMEN_TYP_MC.getPrimaryKey() + " from "
                                            + MASSNAHMEN_TYP_MC.getTableName(); // NOI18N
                                metaObjects = MetaObjectCache.getInstance()
                                            .getMetaObjectsByQuery(query, MASSNAHMEN_TYP_MC, false, cc);
                            } catch (CacheException e) {
                                metaObjects = new MetaObject[0];
                            }

                            types = new ArrayList<CidsBean>();

                            for (final MetaObject tmp : metaObjects) {
                                types.add(tmp.getBean());
                            }

                            Collections.sort(types, new StringIntValueComparator());
                            initialized = true;

                            fireContentsChanged();
                        }
                    });

            t.start();
        }

        //~ Methods ------------------------------------------------------------

        @Override
        public int getSize() {
            if (initialized) {
                return types.size();
            } else {
                return 0;
            }
        }

        @Override
        public Object getElementAt(final int index) {
            if (initialized) {
                return types.get(index);
            } else {
                return null;
            }
        }

        /**
         * DOCUMENT ME!
         */
        public void fireContentsChanged() {
            final ListDataEvent e = new ListDataEvent(
                    this,
                    ListDataEvent.CONTENTS_CHANGED,
                    0,
                    ((initialized) ? types.size() : 0));

            // fire event
            for (final ListDataListener l : listener) {
                l.contentsChanged(e);
            }
        }

        @Override
        public void addListDataListener(final ListDataListener l) {
            listener.add(l);
        }

        @Override
        public void removeListDataListener(final ListDataListener l) {
            listener.remove(l);
        }
    }
}
