/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * WkFgPanOne.java
 *
 * Created on 04.08.2010, 13:44:05
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.UIUtil;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;

import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class WirkungPan extends javax.swing.JPanel implements DisposableCidsBeanStore,
    CidsBeanDropListener,
    EditorSaveListener {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(WirkungPan.class);
    private static final int FG_ART = 1;
    private static final int SG_ART = 2;
    private static final int KG_ART = 3;
    private static final int GW_ART = 4;
    private static final int PLE_ART = 5;
    private static final int FGE_ART = 7;
    private static final int BG_ART = 6;

    //~ Instance fields --------------------------------------------------------

    private WbModel wbListModel = new WbModel();
    private CidsBean cidsBean;
    private boolean readOnly = false;
    private ArrayList<CidsBean> beansToDelete = new ArrayList<CidsBean>();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnRemWirkung;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JList lstWirkung;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo;
    private de.cismet.tools.gui.RoundedPanel panInfo;
    private javax.swing.JPanel panInfoContent;
    private javax.swing.JPanel panwirk;
    private javax.swing.JScrollPane scpWirkung;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WkFgPanOne.
     */
    public WirkungPan() {
        this(false);
    }

    /**
     * Creates new form WkFgPanOne.
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public WirkungPan(final boolean readOnly) {
        this.readOnly = readOnly;
        initComponents();

        lstWirkung.setModel(wbListModel);
        if (!readOnly) {
            try {
                new CidsBeanDropTarget(this);
            } catch (Exception ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("error while creating CidsBeanDropTarget", ex);
                }
            }
        } else {
            panwirk.setVisible(false);
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        panInfo = new de.cismet.tools.gui.RoundedPanel();
        panHeadInfo = new de.cismet.tools.gui.SemiRoundedPanel();
        jLabel1 = new javax.swing.JLabel();
        panInfoContent = new javax.swing.JPanel();
        panwirk = new javax.swing.JPanel();
        btnRemWirkung = new javax.swing.JButton();
        scpWirkung = new javax.swing.JScrollPane();
        lstWirkung = new javax.swing.JList();

        setMinimumSize(new java.awt.Dimension(995, 175));
        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(995, 175));
        setLayout(new java.awt.BorderLayout());

        panHeadInfo.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setLayout(new java.awt.FlowLayout());

        jLabel1.setForeground(new java.awt.Color(255, 255, 255));
        jLabel1.setText("Wirkung");
        panHeadInfo.add(jLabel1);

        panInfo.add(panHeadInfo, java.awt.BorderLayout.NORTH);

        panInfoContent.setOpaque(false);
        panInfoContent.setLayout(new java.awt.GridBagLayout());

        panwirk.setOpaque(false);
        panwirk.setLayout(new java.awt.GridBagLayout());

        btnRemWirkung.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_remove_mini.png"))); // NOI18N
        btnRemWirkung.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnRemWirkungActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        panwirk.add(btnRemWirkung, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 20);
        panInfoContent.add(panwirk, gridBagConstraints);

        scpWirkung.setMinimumSize(new java.awt.Dimension(300, 60));
        scpWirkung.setPreferredSize(new java.awt.Dimension(300, 60));

        lstWirkung.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        scpWirkung.setViewportView(lstWirkung);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        panInfoContent.add(scpWirkung, gridBagConstraints);

        panInfo.add(panInfoContent, java.awt.BorderLayout.CENTER);

        add(panInfo, java.awt.BorderLayout.CENTER);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnRemWirkungActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnRemWirkungActionPerformed
        final Object selection = lstWirkung.getSelectedValue();
        if (selection != null) {
            String typeString = "den Wasserkörper";
            final Object kind = ((CidsBean)selection).getProperty("art");

            if (kind != null) {
                if (kind.equals(PLE_ART)) {
                    typeString = "die Planungseinheit";
                } else if (kind.equals(FGE_ART)) {
                    typeString = "die Flussgebietseinheit";
                } else if (kind.equals(BG_ART)) {
                    typeString = "das Bearbeitungsgebiet";
                }
            }

            final int answer = JOptionPane.showConfirmDialog(
                    StaticSwingTools.getParentFrame(this),
                    "Soll die Wirkung auf "
                            + typeString
                            + " '"
                            + selection.toString()
                            + "' wirklich gelöscht werden?",
                    "Wirkung entfernen",
                    JOptionPane.YES_NO_OPTION);
            if (answer == JOptionPane.YES_OPTION) {
                try {
                    final CidsBean bean = (CidsBean)selection;
                    removeWB(bean);
                    wbListModel.removeElement(bean);
                } catch (Exception e) {
                    UIUtil.showExceptionToUser(e, this);
                }
            }
        }
    } //GEN-LAST:event_btnRemWirkungActionPerformed

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
        }
        wbListModel.setElements();
    }

    @Override
    public void dispose() {
        setCidsBean(null);
    }

    @Override
    public void beansDropped(final ArrayList<CidsBean> beans) {
        if ((cidsBean != null) && !readOnly) {
            for (final CidsBean bean : beans) {
                if (bean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_fg")
                            || bean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_sg")
                            || bean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_kg")
                            || bean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_gw")
                            || bean.getClass().getName().equals("de.cismet.cids.dynamics.Planungseinheit")
                            || bean.getClass().getName().equals("de.cismet.cids.dynamics.Flussgebietseinheit")
                            || bean.getClass().getName().equals("de.cismet.cids.dynamics.Bearbeitungsgebiet")) {
                    addWB(bean);
                }
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  bean  DOCUMENT ME!
     */
    private void removeWB(final CidsBean bean) {
        final Object beanColl = cidsBean.getProperty("wirkung_wk");
        if (beanColl instanceof Collection) {
            ((Collection)beanColl).remove(bean);
            try {
                bean.delete();
                beansToDelete.add(bean);
            } catch (final Exception e) {
                LOG.error("Error while deleting a bean.", e);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  wkBean  propertyName DOCUMENT ME!
     */
    private void addWB(final CidsBean wkBean) {
        final CidsBean wirkung = addWB(cidsBean, wkBean);

        if (wirkung != null) {
            wbListModel.addElement(wirkung);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   measureType  DOCUMENT ME!
     * @param   wkBean       DOCUMENT ME!
     *
     * @return  the newly created Wirkung object
     */
    public static CidsBean addWB(final CidsBean measureType, final CidsBean wkBean) {
        final Collection<CidsBean> collection = (Collection<CidsBean>)measureType.getProperty("wirkung_wk");

        if (collection == null) {
            LOG.error("Collection of property wirkung_wk is null");
            return null;
        }

        try {
            final CidsBean w = CidsBeanSupport.createNewCidsBeanFromTableName("wirkung_wk");
            w.setProperty("wk_id", wkBean.getProperty("id"));

            if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_fg")) {
                w.setProperty("art", FG_ART);
                w.setProperty("name", wkBean.getProperty("wk_k"));
            } else if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_sg")) {
                w.setProperty("art", SG_ART);
                w.setProperty("name", wkBean.getProperty("wk_k"));
            } else if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_kg")) {
                w.setProperty("art", KG_ART);
                w.setProperty("name", wkBean.getProperty("name"));
            } else if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_gw")) {
                w.setProperty("art", GW_ART);
                w.setProperty("name", wkBean.getProperty("name"));
            } else if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Planungseinheit")) {
                w.setProperty("art", PLE_ART);
                w.setProperty("name", wkBean.getProperty("kuerzel"));
            } else if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Flussgebietseinheit")) {
                w.setProperty("art", FGE_ART);
                w.setProperty("name", wkBean.getProperty("nr"));
            } else if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Bearbeitungsgebiet")) {
                w.setProperty("art", BG_ART);
                w.setProperty("name", wkBean.getProperty("kuerzel"));
            } else {
                LOG.error("Invalid bean type found.");
                return null;
            }
            if (!containsWirkung(collection, w)) {
                collection.add(w);

                return w;
            } else {
                return null;
            }
        } catch (Exception e) {
            LOG.error("Cannot add object.", e);
            return null;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   collection  DOCUMENT ME!
     * @param   wirkung     DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private static boolean containsWirkung(final Collection<CidsBean> collection, final CidsBean wirkung) {
        final Object art = wirkung.getProperty("art");
        final Object id = wirkung.getProperty("wk_id");

        for (final CidsBean tmp : collection) {
            if (tmp.getProperty("wk_id").equals(id) && tmp.getProperty("art").equals(art)) {
                return true;
            }
        }

        return false;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  w  DOCUMENT ME!
     */
    public void addWirkungToListModel(final CidsBean w) {
        wbListModel.addElement(w);
    }

    @Override
    public void editorClosed(final EditorClosedEvent event) {
    }

    @Override
    public boolean prepareForSave() {
        for (final CidsBean bean : beansToDelete) {
            try {
                bean.persist();
            } catch (final Exception e) {
                LOG.error("Error while deleting bean", e); // NOI18N
            }
        }
        beansToDelete.clear();

        return true;
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private class WbModel implements ListModel {

        //~ Instance fields ----------------------------------------------------

        List<ListDataListener> listDataListener = new ArrayList<ListDataListener>();
        List<CidsBean> elements = new ArrayList<CidsBean>();

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new WbModel object.
         */
        public WbModel() {
            setElements();
        }

        //~ Methods ------------------------------------------------------------

        @Override
        public int getSize() {
            return elements.size();
        }

        @Override
        public Object getElementAt(final int index) {
            return elements.get(index);
        }

        @Override
        public void addListDataListener(final ListDataListener l) {
            listDataListener.add(l);
        }

        @Override
        public void removeListDataListener(final ListDataListener l) {
            listDataListener.remove(l);
        }

        /**
         * DOCUMENT ME!
         *
         * @param  o  DOCUMENT ME!
         */
        public void removeElement(final CidsBean o) {
            elements.remove(o);
            fireContentChangedEvent();
        }

        /**
         * DOCUMENT ME!
         *
         * @param  o  DOCUMENT ME!
         */
        public void addElement(final CidsBean o) {
            elements.add(o);
            fireContentChangedEvent();
        }

        /**
         * DOCUMENT ME!
         */
        private void fireContentChangedEvent() {
            final ListDataEvent event = new ListDataEvent(this, ListDataEvent.CONTENTS_CHANGED, 0, elements.size());

            for (final ListDataListener listener : listDataListener) {
                listener.contentsChanged(event);
            }
        }

        /**
         * DOCUMENT ME!
         */
        public void setElements() {
            elements.clear();
            if (cidsBean != null) {
                final Collection<CidsBean> collection = (Collection<CidsBean>)cidsBean.getProperty("wirkung_wk");
                if (collection != null) {
                    for (final CidsBean bean : collection) {
                        elements.add(bean);
                    }
                }
            }

            fireContentChangedEvent();
        }

        /**
         * DOCUMENT ME!
         */
        public void clear() {
            elements.clear();
            fireContentChangedEvent();
        }
    }
}
