/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * WkFgPanOne.java
 *
 * Created on 04.08.2010, 13:44:05
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import java.awt.EventQueue;

import java.util.Collections;
import java.util.List;

import javax.swing.ComboBoxModel;
import javax.swing.JOptionPane;

import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.LawaTableModel;
import de.cismet.cids.custom.wrrl_db_mv.util.ScrollableComboBox;
import de.cismet.cids.custom.wrrl_db_mv.util.TeileComparator;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.cids.editors.DefaultCustomObjectEditor;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   stefan
 * @version  $Revision$, $Date$
 */
public class WkFgPanFourteen extends javax.swing.JPanel implements DisposableCidsBeanStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(WkFgPanTen.class);

    //~ Instance fields --------------------------------------------------------

    private final LawaTableModel model = new LawaTableModel();
    private CidsBean cidsBean;
    private List<CidsBean> teile;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.cids.editors.DefaultBindableReferenceCombo cbAktTyp;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JButton jbBer;
    private javax.swing.JButton jbReadOnly;
    private javax.swing.JButton jbUeber;
    private javax.swing.JTable jtMstTab1;
    private javax.swing.JLabel lblAktTyp;
    private javax.swing.JLabel lblBem;
    private javax.swing.JLabel lblBerTyp;
    private javax.swing.JLabel lblBerTypVal;
    private javax.swing.JLabel lblHeading;
    private javax.swing.JLabel lblSpace;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo;
    private de.cismet.tools.gui.RoundedPanel panInfo;
    private javax.swing.JPanel panInfoContent;
    private javax.swing.JTextField txtIndpolBemerk;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WkFgPanOne.
     */
    public WkFgPanFourteen() {
        initComponents();
        jScrollPane1.getViewport().setOpaque(false);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        panInfo = new de.cismet.tools.gui.RoundedPanel();
        panHeadInfo = new de.cismet.tools.gui.SemiRoundedPanel();
        lblHeading = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        panInfoContent = new javax.swing.JPanel();
        lblSpace = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane4 = new javax.swing.JScrollPane();
        jtMstTab1 = new javax.swing.JTable();
        jbReadOnly = new javax.swing.JButton();
        lblAktTyp = new javax.swing.JLabel();
        cbAktTyp = new ScrollableComboBox();
        lblBerTyp = new javax.swing.JLabel();
        lblBem = new javax.swing.JLabel();
        txtIndpolBemerk = new javax.swing.JTextField();
        jbUeber = new javax.swing.JButton();
        lblBerTypVal = new javax.swing.JLabel();
        jbBer = new javax.swing.JButton();

        setMinimumSize(new java.awt.Dimension(910, 650));
        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(910, 650));
        setLayout(new java.awt.BorderLayout());

        panHeadInfo.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setLayout(new java.awt.FlowLayout());

        lblHeading.setForeground(new java.awt.Color(255, 255, 255));
        lblHeading.setText(org.openide.util.NbBundle.getMessage(
                WkFgPanFourteen.class,
                "WkFgPanFourteen.lblHeading.text")); // NOI18N
        panHeadInfo.add(lblHeading);

        panInfo.add(panHeadInfo, java.awt.BorderLayout.NORTH);

        jScrollPane1.setBorder(null);
        jScrollPane1.setOpaque(false);

        panInfoContent.setMaximumSize(new java.awt.Dimension(888, 400));
        panInfoContent.setMinimumSize(new java.awt.Dimension(888, 400));
        panInfoContent.setOpaque(false);
        panInfoContent.setPreferredSize(new java.awt.Dimension(888, 400));
        panInfoContent.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weighty = 1.0;
        panInfoContent.add(lblSpace, gridBagConstraints);

        jPanel3.setOpaque(false);
        jPanel3.setPreferredSize(new java.awt.Dimension(1100, 240));
        jPanel3.setLayout(new java.awt.GridBagLayout());

        jScrollPane4.setMinimumSize(new java.awt.Dimension(800, 170));
        jScrollPane4.setOpaque(false);
        jScrollPane4.setPreferredSize(new java.awt.Dimension(900, 170));

        jtMstTab1.setModel(model);
        jScrollPane4.setViewportView(jtMstTab1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 5, 10);
        jPanel3.add(jScrollPane4, gridBagConstraints);

        jbReadOnly.setText(org.openide.util.NbBundle.getMessage(
                WkFgPanFourteen.class,
                "WKfGPanFourteen.jbReadOnly.text")); // NOI18N
        jbReadOnly.setMaximumSize(new java.awt.Dimension(210, 29));
        jbReadOnly.setMinimumSize(new java.awt.Dimension(210, 29));
        jbReadOnly.setPreferredSize(new java.awt.Dimension(210, 29));
        jbReadOnly.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jbReadOnlyActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 5);
        jPanel3.add(jbReadOnly, gridBagConstraints);

        lblAktTyp.setText(org.openide.util.NbBundle.getMessage(
                WkFgPanFourteen.class,
                "WkFgPanFourteen.lblAktTyp.text")); // NOI18N
        lblAktTyp.setMaximumSize(new java.awt.Dimension(220, 40));
        lblAktTyp.setMinimumSize(new java.awt.Dimension(220, 40));
        lblAktTyp.setPreferredSize(new java.awt.Dimension(220, 40));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        jPanel3.add(lblAktTyp, gridBagConstraints);

        cbAktTyp.setEnabled(false);
        cbAktTyp.setMinimumSize(new java.awt.Dimension(150, 20));
        cbAktTyp.setPreferredSize(new java.awt.Dimension(150, 20));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.lawa_type}"),
                cbAktTyp,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        cbAktTyp.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cbAktTypActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 15, 10);
        jPanel3.add(cbAktTyp, gridBagConstraints);

        lblBerTyp.setText(org.openide.util.NbBundle.getMessage(
                WkFgPanFourteen.class,
                "WkFgPanFourteen.lblBerTyp.text")); // NOI18N
        lblBerTyp.setMaximumSize(new java.awt.Dimension(220, 50));
        lblBerTyp.setMinimumSize(new java.awt.Dimension(220, 50));
        lblBerTyp.setPreferredSize(new java.awt.Dimension(220, 50));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        jPanel3.add(lblBerTyp, gridBagConstraints);

        lblBem.setText(org.openide.util.NbBundle.getMessage(WkFgPanFourteen.class, "WkFgPanFourteen.lblBem.text")); // NOI18N
        lblBem.setMaximumSize(new java.awt.Dimension(220, 40));
        lblBem.setMinimumSize(new java.awt.Dimension(220, 40));
        lblBem.setPreferredSize(new java.awt.Dimension(220, 40));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        jPanel3.add(lblBem, gridBagConstraints);

        txtIndpolBemerk.setEditable(false);
        txtIndpolBemerk.setMinimumSize(new java.awt.Dimension(300, 20));
        txtIndpolBemerk.setPreferredSize(new java.awt.Dimension(300, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.lawa_bemerkung}"),
                txtIndpolBemerk,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 15, 10);
        jPanel3.add(txtIndpolBemerk, gridBagConstraints);

        jbUeber.setText(org.openide.util.NbBundle.getMessage(WkFgPanFourteen.class, "WkFgPanFourteen.jbUeber.text")); // NOI18N
        jbUeber.setMaximumSize(new java.awt.Dimension(210, 29));
        jbUeber.setMinimumSize(new java.awt.Dimension(210, 29));
        jbUeber.setPreferredSize(new java.awt.Dimension(210, 29));
        jbUeber.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jbUeberActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 5);
        jPanel3.add(jbUeber, gridBagConstraints);

        lblBerTypVal.setMaximumSize(new java.awt.Dimension(150, 20));
        lblBerTypVal.setMinimumSize(new java.awt.Dimension(150, 20));
        lblBerTypVal.setPreferredSize(new java.awt.Dimension(150, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 15, 10);
        jPanel3.add(lblBerTypVal, gridBagConstraints);

        jbBer.setText(org.openide.util.NbBundle.getMessage(WkFgPanFourteen.class, "WkFgPanFourteen.jbBer.text")); // NOI18N
        jbBer.setMaximumSize(new java.awt.Dimension(210, 29));
        jbBer.setMinimumSize(new java.awt.Dimension(210, 29));
        jbBer.setPreferredSize(new java.awt.Dimension(210, 29));
        jbBer.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jbBerActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel3.add(jbBer, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        panInfoContent.add(jPanel3, gridBagConstraints);

        jScrollPane1.setViewportView(panInfoContent);

        panInfo.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        add(panInfo, java.awt.BorderLayout.CENTER);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbAktTypActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cbAktTypActionPerformed
        // TODO add your handling code here:
    } //GEN-LAST:event_cbAktTypActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jbBerActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jbBerActionPerformed
        new Thread(new Runnable() {

                @Override
                public void run() {
                    model.refreshData();
                    double max = 0.0;
                    int code = -1;

                    for (int i = 0; i < (model.getRowCount() - 1); ++i) {
                        try {
                            if (((String)model.getValueAt(i, 0)).equals(LawaTableModel.NO_TYPE)) {
                                // no type cannot be the preferred type
                                continue;
                            }
                            final String percVal = (String)model.getValueAt(i, 1);
                            final double val = Double.parseDouble(percVal);
                            final int codeTmp = Integer.parseInt(((String)model.getValueAt(i, 0)).substring(0, 2));

                            if ((val > max) || ((val == max) && (codeTmp > code))) {
                                if (((codeTmp != 11) && (codeTmp != 12)) || (val > 50)) {
                                    max = val;
                                    code = codeTmp;
                                }
                            }
                        } catch (NumberFormatException e) {
                            LOG.warn("Lawa type with invalid number found.", e);
                        }
                    }

                    if (code != -1) {
                        final ComboBoxModel cmodel = cbAktTyp.getModel();
                        CidsBean calculatedLawaType = null;
                        for (int i = 0; i < cmodel.getSize(); ++i) {
                            final CidsBean bean = (CidsBean)cmodel.getElementAt(i);
                            if (bean.getProperty("value").equals(code)) {
                                calculatedLawaType = bean;
                                break;
                            }
                        }

                        if (calculatedLawaType != null) {
                            final CidsBean type = calculatedLawaType;

                            EventQueue.invokeLater(new Runnable() {

                                    @Override
                                    public void run() {
                                        lblBerTypVal.setText(type.toString());
                                    }
                                });
                        }
                    } else {
                        JOptionPane.showMessageDialog(
                            StaticSwingTools.getParentFrame(WkFgPanFourteen.this),
                            "Es konnte kein LAWA-Typ aus den Anteilen der Detailtypen berechnet werden.",
                            "Berechnung nicht möglich",
                            JOptionPane.WARNING_MESSAGE);
                    }
                }
            }).start();
    } //GEN-LAST:event_jbBerActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jbReadOnlyActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jbReadOnlyActionPerformed
        txtIndpolBemerk.setEditable(true);
        cbAktTyp.setEditable(true);
        cbAktTyp.setEnabled(true);
    }                                                                              //GEN-LAST:event_jbReadOnlyActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jbUeberActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jbUeberActionPerformed
        new Thread(new Runnable() {

                @Override
                public void run() {
                    if (!lblBerTypVal.getText().trim().equals("")) {
                        jbReadOnlyActionPerformed(evt);

                        final int code = Integer.parseInt(lblBerTypVal.getText().substring(0, 2));
                        final ComboBoxModel cmodel = cbAktTyp.getModel();
                        CidsBean calculatedLawaType = null;

                        for (int i = 0; i < cmodel.getSize(); ++i) {
                            final CidsBean bean = (CidsBean)cmodel.getElementAt(i);
                            if (bean.getProperty("value").equals(code)) {
                                calculatedLawaType = bean;
                                break;
                            }
                        }

                        if (calculatedLawaType != null) {
                            final CidsBean selected = calculatedLawaType;
                            EventQueue.invokeLater(new Runnable() {

                                    @Override
                                    public void run() {
                                        cbAktTyp.setSelectedItem(selected);
                                    }
                                });
                        }
                    } else {
                        JOptionPane.showMessageDialog(
                            StaticSwingTools.getParentFrame(WkFgPanFourteen.this),
                            "Es wurde noch kein LAWA-Typ berechnet.",
                            "Kein LAWA-Typ berechnet",
                            JOptionPane.INFORMATION_MESSAGE);
                    }
                }
            }).start();
    } //GEN-LAST:event_jbUeberActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                this.cidsBean);
            bindingGroup.bind();
            teile = CidsBeanSupport.getBeanCollectionFromProperty(cidsBean, "teile");
            if (teile != null) {
                Collections.sort(teile, new TeileComparator());
            }
            model.setCidsBean(cidsBean);
            model.setTeile(teile);
//            model.refreshData();
        }
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
    }
}
