/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 *  Copyright (C) 2010 jruiz
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * WkKgEditor.java
 *
 * Created on 04.10.2010, 10:29:53
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import de.cismet.cids.custom.wrrl_db_mv.commons.WRRLUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.TabbedPaneUITransparent;
import de.cismet.cids.custom.wrrl_db_mv.util.WrrlEditorTester;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class WkGwEditor extends javax.swing.JPanel implements CidsBeanRenderer, EditorSaveListener {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(WkGwEditor.class);

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private final org.jdesktop.beansbinding.BindingGroup bindingGroup;
    private boolean readOnly = false;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblFoot;
    private javax.swing.JLabel lblSpacingBottom;
    private javax.swing.JPanel panAllgemeines;
    private javax.swing.JPanel panChemMon;
    private javax.swing.JPanel panFooter;
    private javax.swing.JLabel panSpace3;
    private javax.swing.JTabbedPane tpMain;
    private de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkGwPanOne wkGwPanOne1;
    private de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkGwPanSeven wkGwPanSeven1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WkKgEditor.
     */
    public WkGwEditor() {
        this(false);
    }

    /**
     * Creates new form WkKgEditor.
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public WkGwEditor(final boolean readOnly) {
        this.readOnly = readOnly;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        initComponents();
        final boolean isAdmin = SessionManager.getSession()
                    .getUser()
                    .getUserGroup()
                    .getName()
                    .equalsIgnoreCase("administratoren");

        if (!isAdmin) {
            panChemMon.setVisible(false);
            tpMain.remove(panChemMon);
        }

        tpMain.setUI(new TabbedPaneUITransparent());
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        panFooter = new javax.swing.JPanel();
        lblFoot = new javax.swing.JLabel();
        tpMain = new javax.swing.JTabbedPane();
        panAllgemeines = new javax.swing.JPanel();
        lblSpacingBottom = new javax.swing.JLabel();
        wkGwPanOne1 = new WkGwPanOne(readOnly);
        panChemMon = new javax.swing.JPanel();
        wkGwPanSeven1 = new de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkGwPanSeven();
        panSpace3 = new javax.swing.JLabel();

        panFooter.setOpaque(false);
        panFooter.setLayout(new java.awt.GridBagLayout());

        lblFoot.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        lblFoot.setForeground(new java.awt.Color(255, 255, 255));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(7, 25, 7, 25);
        panFooter.add(lblFoot, gridBagConstraints);

        setLayout(new java.awt.BorderLayout());

        panAllgemeines.setOpaque(false);
        panAllgemeines.setLayout(new java.awt.GridBagLayout());

        lblSpacingBottom.setText(org.openide.util.NbBundle.getMessage(
                WkGwEditor.class,
                "WkGwEditor.lblSpacingBottom.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        panAllgemeines.add(lblSpacingBottom, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 10, 0);
        panAllgemeines.add(wkGwPanOne1, gridBagConstraints);

        tpMain.addTab(org.openide.util.NbBundle.getMessage(
                WkGwEditor.class,
                "WkGwEditor.panAllgemeines.TabConstraints.tabTitle"),
            panAllgemeines); // NOI18N

        panChemMon.setOpaque(false);
        panChemMon.setLayout(new java.awt.GridBagLayout());

        wkGwPanSeven1.setMinimumSize(new java.awt.Dimension(910, 850));
        wkGwPanSeven1.setPreferredSize(new java.awt.Dimension(910, 850));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 10, 0);
        panChemMon.add(wkGwPanSeven1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        panChemMon.add(panSpace3, gridBagConstraints);

        tpMain.addTab(org.openide.util.NbBundle.getMessage(
                WkGwEditor.class,
                "WkGwEditor.panChemMon.TabConstraints.tabTitle",
                new Object[] {}),
            panChemMon); // NOI18N

        add(tpMain, java.awt.BorderLayout.CENTER);
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            wkGwPanOne1.setCidsBean(cidsBean);
            wkGwPanSeven1.setCidsBean(cidsBean);
            bindingGroup.bind();

            cidsBean.addPropertyChangeListener(new PropertyChangeListener() {

                    @Override
                    public void propertyChange(final PropertyChangeEvent pce) {
                        if (pce.getPropertyName().equals("name")) {
                            try {
                                cidsBean.setProperty("ms_cd_gb", "DEMV_" + (String)pce.getNewValue());
                            } catch (Exception ex) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("autosetting ms_cd_gb failed", ex);
                                }
                            }
                        }
                    }
                });

            cidsBean.addPropertyChangeListener(new PropertyChangeListener() {

                    @Override
                    public void propertyChange(final PropertyChangeEvent pce) {
                        if (pce.getPropertyName().equals("ms_cd_gb")) {
                            try {
                                cidsBean.setProperty("eu_cd_gb", "DE_GB_" + (String)pce.getNewValue());
                            } catch (Exception ex) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("autosetting eu_cd_gb failed", ex);
                                }
                            }
                        }
                    }
                });

            cidsBean.addPropertyChangeListener(new PropertyChangeListener() {

                    @Override
                    public void propertyChange(final PropertyChangeEvent pce) {
                        if (pce.getPropertyName().equals("nitrat")
                                    || pce.getPropertyName().equals("pesticides")
                                    || pce.getPropertyName().equals("actsubpest")
                                    || pce.getPropertyName().equals("annex_ii")
                                    || pce.getPropertyName().equals("othpl")) {
                            try {
                                int worstCaseValue = 0;
                                final String[] props = { "nitrat", "pesticides", "actsubpest", "annex_ii", "othpl" };
                                int worstCasePropIndex = 0;
                                for (int propIndex = 0; propIndex < props.length; propIndex++) {
                                    final String prop = props[propIndex];
                                    final String baseValue = (String)((CidsBean)cidsBean.getProperty(prop)).getProperty(
                                            "value");
                                    int propValue = 0;
                                    try {
                                        propValue = Integer.valueOf(baseValue);
                                    } catch (Exception ex) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug("baseValInt cast", ex);
                                        }
                                    }

                                    if (propValue >= worstCaseValue) {
                                        worstCasePropIndex = propIndex;
                                        worstCaseValue = propValue;
                                    }
                                }
                                cidsBean.setProperty(
                                    "chem_stat",
                                    (CidsBean)cidsBean.getProperty(props[worstCasePropIndex]));
                            } catch (Exception ex) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("autosetting chem_stat failed", ex);
                                }
                            }
                        }
                    }
                });
        }
    }

    @Override
    public void dispose() {
        wkGwPanOne1.dispose();
        wkGwPanSeven1.dispose();
        bindingGroup.unbind();
    }

    @Override
    public String getTitle() {
        return "Wasserkörper " + String.valueOf(cidsBean);
    }

    @Override
    public void setTitle(final String title) {
        // NOP
    }

    @Override
    public void editorClosed(final EditorClosedEvent event) {
        // TODO ?
    }

    @Override
    public boolean prepareForSave() {
        return true;
    }

    /**
     * DOCUMENT ME!
     *
     * @param   args  DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    public static void main(final String[] args) throws Exception {
        new WrrlEditorTester("wk_gw", WkGwEditor.class, WRRLUtil.DOMAIN_NAME).run();
    }
}
