/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * ExcemptionPan.java
 *
 * Created on 10.08.2010, 11:48:00
 */
package de.cismet.cids.custom.objectrenderer.wrrl_db_mv;

import Sirius.server.middleware.types.MetaClass;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

import java.util.Collection;

import javax.swing.JDialog;
import javax.swing.JPanel;

import de.cismet.cids.custom.wrrl_db_mv.commons.WRRLUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.DateConverter;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   stefan
 * @version  $Revision$, $Date$
 */
public class ExcemptionRenderer extends JPanel implements DisposableCidsBeanStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final MetaClass EX_JUST_MC;

    static {
        EX_JUST_MC = ClassCacheMultiple.getMetaClass(WRRLUtil.DOMAIN_NAME, "EX_JUSTIFICATION");
    }

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnJustfificationAbort;
    private javax.swing.JButton btnJustfificationOk;
    private javax.swing.JComboBox cbJustfificationCataloge;
    private javax.swing.JDialog dlgJustificationCataloge;
    private javax.swing.JLabel lblExCat;
    private javax.swing.JLabel lblExDate;
    private javax.swing.JLabel lblExJus;
    private javax.swing.JLabel lblExTyp;
    private javax.swing.JLabel lblHeading;
    private javax.swing.JLabel lblJustfification;
    private javax.swing.JLabel lblValCat;
    private javax.swing.JLabel lblValDate;
    private javax.swing.JLabel lblValTyp;
    private javax.swing.JList lstExJus;
    private de.cismet.tools.gui.RoundedPanel panContent;
    private de.cismet.tools.gui.SemiRoundedPanel panHeadInfo;
    private javax.swing.JPanel panMenButtonsJustfification;
    private javax.swing.JScrollPane scpExJus;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form ExcemptionPan.
     */
    public ExcemptionRenderer() {
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        dlgJustificationCataloge = new JDialog(StaticSwingTools.getParentFrame(this));
        lblJustfification = new javax.swing.JLabel();
        final DefaultBindableReferenceCombo cb = new DefaultBindableReferenceCombo(EX_JUST_MC, true, true);
        cbJustfificationCataloge = cb;
        panMenButtonsJustfification = new javax.swing.JPanel();
        btnJustfificationAbort = new javax.swing.JButton();
        btnJustfificationOk = new javax.swing.JButton();
        panContent = new de.cismet.tools.gui.RoundedPanel();
        lblExCat = new javax.swing.JLabel();
        lblExTyp = new javax.swing.JLabel();
        lblExDate = new javax.swing.JLabel();
        lblExJus = new javax.swing.JLabel();
        scpExJus = new javax.swing.JScrollPane();
        lstExJus = new javax.swing.JList();
        panHeadInfo = new de.cismet.tools.gui.SemiRoundedPanel();
        lblHeading = new javax.swing.JLabel();
        lblValCat = new javax.swing.JLabel();
        lblValTyp = new javax.swing.JLabel();
        lblValDate = new javax.swing.JLabel();

        dlgJustificationCataloge.getContentPane().setLayout(new java.awt.GridBagLayout());

        lblJustfification.setText("Begründung");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        dlgJustificationCataloge.getContentPane().add(lblJustfification, gridBagConstraints);

        cbJustfificationCataloge.setMinimumSize(new java.awt.Dimension(250, 18));
        cbJustfificationCataloge.setPreferredSize(new java.awt.Dimension(250, 18));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        dlgJustificationCataloge.getContentPane().add(cbJustfificationCataloge, gridBagConstraints);

        panMenButtonsJustfification.setLayout(new java.awt.GridBagLayout());

        btnJustfificationAbort.setText("Abbrechen");
        btnJustfificationAbort.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnJustfificationAbortActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panMenButtonsJustfification.add(btnJustfificationAbort, gridBagConstraints);

        btnJustfificationOk.setText("Ok");
        btnJustfificationOk.setMaximumSize(new java.awt.Dimension(85, 23));
        btnJustfificationOk.setMinimumSize(new java.awt.Dimension(85, 23));
        btnJustfificationOk.setPreferredSize(new java.awt.Dimension(85, 23));
        btnJustfificationOk.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnJustfificationOkActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panMenButtonsJustfification.add(btnJustfificationOk, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        dlgJustificationCataloge.getContentPane().add(panMenButtonsJustfification, gridBagConstraints);

        setOpaque(false);
        setLayout(new java.awt.BorderLayout());

        panContent.setLayout(new java.awt.GridBagLayout());

        lblExCat.setText("Kategorie");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 15, 5, 5);
        panContent.add(lblExCat, gridBagConstraints);

        lblExTyp.setText("Typ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        panContent.add(lblExTyp, gridBagConstraints);

        lblExDate.setText("Datum");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        panContent.add(lblExDate, gridBagConstraints);

        lblExJus.setText("Begründung");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 15, 5);
        panContent.add(lblExJus, gridBagConstraints);

        scpExJus.setMinimumSize(new java.awt.Dimension(300, 50));
        scpExJus.setPreferredSize(new java.awt.Dimension(300, 50));

        lstExJus.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);

        final org.jdesktop.beansbinding.ELProperty eLProperty = org.jdesktop.beansbinding.ELProperty.create(
                "${cidsBean.ex_jus}");
        final org.jdesktop.swingbinding.JListBinding jListBinding = org.jdesktop.swingbinding.SwingBindings
                    .createJListBinding(
                        org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_ONCE,
                        this,
                        eLProperty,
                        lstExJus);
        bindingGroup.addBinding(jListBinding);

        scpExJus.setViewportView(lstExJus);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 107;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 15, 10);
        panContent.add(scpExJus, gridBagConstraints);

        panHeadInfo.setBackground(new java.awt.Color(51, 51, 51));
        panHeadInfo.setMinimumSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setPreferredSize(new java.awt.Dimension(109, 24));
        panHeadInfo.setLayout(new java.awt.FlowLayout());

        lblHeading.setForeground(new java.awt.Color(255, 255, 255));
        lblHeading.setText("Informationen zur Ausnahme");
        panHeadInfo.add(lblHeading);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        panContent.add(panHeadInfo, gridBagConstraints);

        lblValCat.setMaximumSize(new java.awt.Dimension(300, 20));
        lblValCat.setPreferredSize(new java.awt.Dimension(300, 20));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.ex_cat.code}"),
                lblValCat,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("<nicht gesetzt>");
        binding.setSourceUnreadableValue("<nicht gesetzt>");
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 5);
        panContent.add(lblValCat, gridBagConstraints);

        lblValTyp.setMaximumSize(new java.awt.Dimension(300, 20));
        lblValTyp.setPreferredSize(new java.awt.Dimension(300, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.ex_typ.description}"),
                lblValTyp,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("<nicht gesetzt>");
        binding.setSourceUnreadableValue("<nicht gesetzt>");
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblValTyp, gridBagConstraints);

        lblValDate.setMaximumSize(new java.awt.Dimension(300, 20));
        lblValDate.setPreferredSize(new java.awt.Dimension(300, 20));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.ex_date.date}"),
                lblValDate,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("<nicht gesetzt>");
        binding.setSourceUnreadableValue("<nicht gesetzt>");
        binding.setConverter(DateConverter.getInstance());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblValDate, gridBagConstraints);

        add(panContent, java.awt.BorderLayout.CENTER);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnJustfificationAbortActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnJustfificationAbortActionPerformed
        dlgJustificationCataloge.setVisible(false);
    }                                                                                          //GEN-LAST:event_btnJustfificationAbortActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnJustfificationOkActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnJustfificationOkActionPerformed
        final Object selection = cbJustfificationCataloge.getSelectedItem();
        if (selection instanceof CidsBean) {
            final CidsBean selectedBean = (CidsBean)selection;
            final Collection<CidsBean> colToAdd = CidsBeanSupport.getBeanCollectionFromProperty(cidsBean, "ex_jus");
            if (colToAdd != null) {
                if (!colToAdd.contains(selectedBean)) {
                    colToAdd.add(selectedBean);
                }
            }
        }
        dlgJustificationCataloge.setVisible(false);
    }                                                                                       //GEN-LAST:event_btnJustfificationOkActionPerformed

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                this.cidsBean);
            bindingGroup.bind();

            final DateFormat sdf = SimpleDateFormat.getDateInstance();

            if (cidsBean.getProperty("ex_date") != null) {
                final Object date = cidsBean.getProperty("ex_date.date");
                if (date != null) {
                    lblValDate.setText(sdf.format(date));
                } else {
                    lblValDate.setText("");
                }
            }
        }
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
    }
}
