/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.objectrenderer.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;

import org.apache.log4j.Logger;

import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.cismet.cids.custom.actions.wrrl_db_mv.FgskSplitArToolbarItem;
import de.cismet.cids.custom.reports.FgskReport;
import de.cismet.cids.custom.reports.QBWReport;
import de.cismet.cids.custom.tostringconverter.wrrl_db_mv.FgskKartierabschnittToStringConverter;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;

/**
 * DOCUMENT ME!
 *
 * @author   mscholl
 * @version  $Revision$, $Date$
 */
public class QuerbauwerkeTitleComponent extends javax.swing.JPanel {

    //~ Static fields/initializers ---------------------------------------------

    private static Logger LOG = Logger.getLogger(FgskSplitArToolbarItem.class);

    //~ Instance fields --------------------------------------------------------

    private final transient ActionListener printL;

    private transient CidsBean cidsBean;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnReport;
    private javax.swing.JLabel lblTitle;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form FgskKartierabschnittTitleComponent.
     */
    public QuerbauwerkeTitleComponent() {
        initComponents();
        this.printL = new PrintListener();

        btnReport.addActionListener(WeakListeners.create(ActionListener.class, printL, btnReport));
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  title  DOCUMENT ME!
     */
    private void setTitle(final String title) {
        if (EventQueue.isDispatchThread()) {
            lblTitle.setText(title);
        } else {
            EventQueue.invokeLater(new Runnable() {

                    @Override
                    public void run() {
                        lblTitle.setText(title);
                    }
                });
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  cidsBean  DOCUMENT ME!
     */
    public void setCidsBean(final CidsBean cidsBean) {
        this.cidsBean = cidsBean;

        setTitle(String.valueOf(cidsBean));
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        lblTitle = new javax.swing.JLabel();
        btnReport = new javax.swing.JButton();

        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        lblTitle.setFont(new java.awt.Font("Tahoma", 1, 18)); // NOI18N
        lblTitle.setForeground(new java.awt.Color(255, 255, 255));
        lblTitle.setText(NbBundle.getMessage(
                QuerbauwerkeTitleComponent.class,
                "QuerbauwerkeTitleComponent.lblTitle.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(lblTitle, gridBagConstraints);

        btnReport.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objectrenderer/wrrl_db_mv/printer.png")));         // NOI18N
        btnReport.setText(NbBundle.getMessage(
                QuerbauwerkeTitleComponent.class,
                "QuerbauwerkeTitleComponent.btnReport.text"));                                                    // NOI18N
        btnReport.setBorderPainted(false);
        btnReport.setContentAreaFilled(false);
        btnReport.setFocusPainted(false);
        btnReport.setPressedIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objectrenderer/wrrl_db_mv/printer_pressed.png"))); // NOI18N
        if (showPrintButton()) {
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
            gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
            add(btnReport, gridBagConstraints);
        }
    }                                                                                                             // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private boolean showPrintButton() {
        try {
            return SessionManager.getSession().getUser().getUserGroup().getName().equalsIgnoreCase("administratoren")
                        || SessionManager.getConnection()
                        .hasConfigAttr(
                                SessionManager.getSession().getUser(),
                                "printQbw",
                                ConnectionContext.create(
                                    AbstractConnectionContext.Category.OTHER,
                                    QuerbauwerkeTitleComponent.class.getName()));
        } catch (Exception e) {
            LOG.error("Cannot check print permission");
            return false;
        }
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private final class PrintListener implements ActionListener {

        //~ Methods ------------------------------------------------------------

        @Override
        public void actionPerformed(final ActionEvent e) {
            final QBWReport report = new QBWReport(cidsBean);
            report.print();
        }
    }
}
