/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 *  Copyright (C) 2010 jweintraut
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * SwstnRenderer.java
 *
 * Created on 25.10.2010, 12:53:48
 */
package de.cismet.cids.custom.objectrenderer.wrrl_db_mv;

import org.jdesktop.beansbinding.BindingGroup;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

/**
 * DOCUMENT ME!
 *
 * @author   jweintraut
 * @version  $Revision$, $Date$
 */
public class SwstnRenderer extends javax.swing.JPanel implements CidsBeanRenderer {

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    private BindingGroup bindingGroup;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel panSpacingBottom;
    private de.cismet.cids.custom.objectrenderer.wrrl_db_mv.SwstnPanOne swstnPanOne1;
    private de.cismet.cids.custom.objectrenderer.wrrl_db_mv.SwstnPanThree swstnPanThree1;
    private de.cismet.cids.custom.objectrenderer.wrrl_db_mv.SwstnPanTwo swstnPanTwo1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form SwstnRenderer.
     */
    public SwstnRenderer() {
        bindingGroup = new BindingGroup();
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        swstnPanOne1 = new de.cismet.cids.custom.objectrenderer.wrrl_db_mv.SwstnPanOne();
        swstnPanTwo1 = new de.cismet.cids.custom.objectrenderer.wrrl_db_mv.SwstnPanTwo();
        swstnPanThree1 = new de.cismet.cids.custom.objectrenderer.wrrl_db_mv.SwstnPanThree();
        panSpacingBottom = new javax.swing.JPanel();

        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        swstnPanOne1.setMinimumSize(new java.awt.Dimension(464, 424));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 15, 15);
        add(swstnPanOne1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 15, 0);
        add(swstnPanTwo1, gridBagConstraints);

        swstnPanThree1.setMinimumSize(new java.awt.Dimension(752, 144));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 0, 0, 0);
        add(swstnPanThree1, gridBagConstraints);

        panSpacingBottom.setOpaque(false);

        final javax.swing.GroupLayout panSpacingBottomLayout = new javax.swing.GroupLayout(panSpacingBottom);
        panSpacingBottom.setLayout(panSpacingBottomLayout);
        panSpacingBottomLayout.setHorizontalGroup(
            panSpacingBottomLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));
        panSpacingBottomLayout.setVerticalGroup(
            panSpacingBottomLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(panSpacingBottom, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        this.cidsBean = cidsBean;

        if (cidsBean != null) {
            swstnPanOne1.setCidsBean(cidsBean);
            swstnPanTwo1.setCidsBean(cidsBean);
            swstnPanThree1.setCidsBean(cidsBean);
        }
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
        swstnPanOne1.dispose();
        swstnPanTwo1.dispose();
        swstnPanThree1.dispose();
    }

    @Override
    public String getTitle() {
        return org.openide.util.NbBundle.getMessage(SwstnRenderer.class, "SwstnRenderer.title")
                    + String.valueOf(cidsBean);
    }

    @Override
    public void setTitle(final String title) {
        // NOP
    }
}
