/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import net.sf.jasperreports.engine.JRDataSource;

import java.awt.image.BufferedImage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import java.text.DecimalFormat;

import java.util.Base64;
import java.util.Collection;
import java.util.StringTokenizer;

import javax.imageio.ImageIO;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class ConversionUtils {

    //~ Static fields/initializers ---------------------------------------------

    private static final DecimalFormat format = new DecimalFormat("0.00");

    static {
        final java.text.DecimalFormatSymbols symbols = new java.text.DecimalFormatSymbols();
        symbols.setDecimalSeparator(',');
        symbols.setGroupingSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        format.setGroupingUsed(true);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param   d  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static String numberToString(final Object d) {
        if (d == null) {
            return "";
        } else {
            return format.format(d);
        }
    }

    /**
     * Converts the given image to a base64 string.
     *
     * @param   i  the image to convert
     *
     * @return  a base64 string representation of the given image
     *
     * @throws  IOException  DOCUMENT ME!
     */
    public static String image2String(final BufferedImage i) throws IOException {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write(i, "png", out);

        return Base64.getEncoder().encodeToString(out.toByteArray());
    }

    /**
     * Converts the given base64 string to an image.
     *
     * @param   s  the string to convert (a base64 representation of an image)
     *
     * @return  the image that was generated by the given base 64 string
     *
     * @throws  IOException  DOCUMENT ME!
     */
    public static BufferedImage String2Image(final String s) throws IOException {
        final ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));

        return ImageIO.read(in);
    }

    /**
     * Converts the given collection to a base64 string.
     *
     * @param   c  i the collection to convert
     *
     * @return  a base64 string representation of the given image
     *
     * @throws  IOException  DOCUMENT ME!
     */
    public static String jrDataSource2String(final JRDataSource c) throws IOException {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        final ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(c);
        oout.flush();

        return Base64.getEncoder().encodeToString(out.toByteArray());
    }

    /**
     * Converts the given base64 string to an image.
     *
     * @param   s  the string to convert (a base64 representation of an image)
     *
     * @return  the image that was generated by the given base 64 string
     *
     * @throws  Exception  DOCUMENT ME!
     */
    public static JRDataSource String2JRDataSource(final String s) throws Exception {
        final ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
        final ObjectInputStream oin = new ObjectInputStream(in);

        return (JRDataSource)oin.readObject();
    }

    /**
     * DOCUMENT ME!
     *
     * @param   t  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static boolean isValidTimeString(final String t) {
        if (t.matches("\\d{1,2}?:\\d{1,2}?") || t.matches("\\d{1,2}?:\\d{1,2}?:\\d{1,2}?")) {
            final StringTokenizer st = new StringTokenizer(t, ":");
            int count = 0;

            while (st.hasMoreTokens()) {
                if (count == 0) {
                    try {
                        final int hours = Integer.parseInt(st.nextToken());

                        if ((hours < 0) || (hours > 23)) {
                            return false;
                        }
                    } catch (NumberFormatException e) {
                        return false;
                    }
                } else {
                    try {
                        final int number = Integer.parseInt(st.nextToken());

                        if ((number < 0) || (number > 59)) {
                            return false;
                        }
                    } catch (NumberFormatException e) {
                        return false;
                    }
                }

                ++count;
            }
            return true;
        } else {
            return false;
        }
    }
}
