/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.wrrl_db_mv.util;

import org.jdom.Element;

import org.openide.util.NbBundle;
import org.openide.util.lookup.ServiceProvider;

import de.cismet.lookupoptions.*;

import de.cismet.tools.configuration.NoWriteError;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
@ServiceProvider(service = OptionsPanelController.class)
public class WrrlMapOptionsPanel extends AbstractOptionsPanel implements OptionsPanelController {

    //~ Static fields/initializers ---------------------------------------------

    private static final String OPTION_NAME = NbBundle.getMessage(
            WrrlMapOptionsPanel.class,
            "WrrlMapOptionsPanel.OPTION_NAME");
    private static boolean changeMapWindowActive = true;

    //~ Instance fields --------------------------------------------------------

    private final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(this.getClass());

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jcChangeMapPosition;
    private javax.swing.JLabel lblTitle;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new GeometryOptionsPanel object.
     */
    public WrrlMapOptionsPanel() {
        super(OPTION_NAME, WrrlOptionsCategory.class);
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public void update() {
        jcChangeMapPosition.setSelected(changeMapWindowActive);
    }

    @Override
    public void applyChanges() {
        changeMapWindowActive = jcChangeMapPosition.isSelected();
    }

    @Override
    public boolean isChanged() {
        return changeMapWindowActive != jcChangeMapPosition.isSelected();
    }

    @Override
    public String getTooltip() {
        return org.openide.util.NbBundle.getMessage(WrrlMapOptionsPanel.class,
                "WrrlMapOptionsPanel.tooltip"); // NOI18N
    }

    @Override
    public void configure(final Element parent) {
        if (parent != null) {
            final Element e = parent.getChild("WrrlMapOptionsPanel");
            if (e != null) {
                final String attrValue = e.getAttributeValue("changeMapWindow");
                final boolean tmp = Boolean.parseBoolean(attrValue);

                changeMapWindowActive = tmp;
                jcChangeMapPosition.setSelected(tmp);
            }
        }
    }

    @Override
    public Element getConfiguration() throws NoWriteError {
        final Element conf = new Element("WrrlMapOptionsPanel");
        conf.setAttribute("changeMapWindow", String.valueOf(changeMapWindowActive));

        return conf;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static boolean isChangeMapWindowActive() {
        return changeMapWindowActive;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        lblTitle = new javax.swing.JLabel();
        jcChangeMapPosition = new javax.swing.JCheckBox();

        lblTitle.setText(org.openide.util.NbBundle.getMessage(
                WrrlMapOptionsPanel.class,
                "WrrlMapOptionsPanel.lblTitle.text")); // NOI18N

        jcChangeMapPosition.setSelected(true);
        jcChangeMapPosition.setText(org.openide.util.NbBundle.getMessage(
                WrrlMapOptionsPanel.class,
                "WrrlMapOptionsPanel.jcChangeMapPosition.text")); // NOI18N
        jcChangeMapPosition.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jcChangeMapPositionActionPerformed(evt);
                }
            });

        final javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
                layout.createSequentialGroup().addContainerGap().addGroup(
                    layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addComponent(lblTitle)
                                .addComponent(jcChangeMapPosition)).addContainerGap(16, Short.MAX_VALUE)));
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
                layout.createSequentialGroup().addContainerGap().addComponent(lblTitle).addPreferredGap(
                    javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(jcChangeMapPosition)
                            .addContainerGap(39, Short.MAX_VALUE)));
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jcChangeMapPositionActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jcChangeMapPositionActionPerformed
    }                                                                                       //GEN-LAST:event_jcChangeMapPositionActionPerformed
}
