/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * AbschnittsinfoMember.java
 *
 * Created on 21.10.2011, 10:47:29
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import org.jdesktop.swingx.JXPanel;

import java.awt.Color;
import java.awt.Font;

import javax.swing.JComponent;
import javax.swing.border.LineBorder;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;

import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.Section;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten
 * @version  $Revision$, $Date$
 */
public class AbschnittsinfoMember extends JXPanel implements BandMember, Section, CidsBeanStore {

    //~ Instance fields --------------------------------------------------------

    CidsBean abschnittsInfo;
    double from;
    double to;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel labText;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form AbschnittsinfoMember.
     */
    public AbschnittsinfoMember() {
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        final java.awt.GridBagConstraints gridBagConstraints;

        labText = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        labText.setFont(new java.awt.Font("Ubuntu", 0, 10)); // NOI18N
        labText.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(labText, gridBagConstraints);
    }                                                        // </editor-fold>//GEN-END:initComponents

    @Override
    public JComponent getBandMemberComponent() {
        return this;
    }

    @Override
    public double getMax() {
        return ((to > from) ? to : from);
    }

    @Override
    public double getMin() {
        return ((to > from) ? from : to);
    }

    @Override
    public double getFrom() {
        return from;
    }

    @Override
    public double getTo() {
        return to;
    }

    @Override
    public CidsBean getCidsBean() {
        return abschnittsInfo;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        abschnittsInfo = cidsBean;
        from = (Double)abschnittsInfo.getProperty("linie.von.wert");
        to = (Double)abschnittsInfo.getProperty("linie.bis.wert");
    }

    /**
     * DOCUMENT ME!
     *
     * @param  text  DOCUMENT ME!
     */
    public void setText(final String text) {
        labText.setText(text);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  font  DOCUMENT ME!
     */
    public void setTextFont(final Font font) {
        labText.setFont(font);
    }
    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public Font getTextFont() {
        return labText.getFont();
    }

    /**
     * DOCUMENT ME!
     *
     * @param  visible  DOCUMENT ME!
     */
    public void setTextVisible(final boolean visible) {
        labText.setVisible(visible);
    }

    /**
     * DOCUMENT ME!
     *
     * @param   visible  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public boolean isTextVisible(final boolean visible) {
        return labText.isVisible();
    }

    /**
     * DOCUMENT ME!
     *
     * @param  border  DOCUMENT ME!
     */
    public void setMemberBorder(final boolean border) {
        if (!border) {
            setBorder(null);
        } else {
            setBorder(new LineBorder(Color.BLACK));
        }
    }
}
