/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import Sirius.server.middleware.types.MetaClass;

import org.apache.log4j.Logger;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.image.BufferedImage;

import java.io.InputStream;

import java.net.URL;
import java.net.URLEncoder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import de.cismet.cids.custom.wrrl_db_mv.commons.WRRLUtil;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.cids.server.search.MetaObjectNodeServerSearch;

import de.cismet.cids.tools.search.clientstuff.CidsWindowSearch;

import de.cismet.security.WebAccessManager;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
@org.openide.util.lookup.ServiceProvider(service = CidsWindowSearch.class)
public class LosDiagram extends javax.swing.JPanel implements CidsWindowSearch, CidsBeanDropListener {

    //~ Static fields/initializers ---------------------------------------------

    private static Logger LOG = Logger.getLogger(LosDiagram.class);

    //~ Instance fields --------------------------------------------------------

    private MassnahmenHistoryListModel model = new MassnahmenHistoryListModel();
    private int index = 0;
    private CidsBean bean;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lblImage;
    private javax.swing.JLabel lblPlan;
    private javax.swing.JLabel lblPlanlab;
    private javax.swing.JPanel panDetail;
    private javax.swing.JPanel panLos;
    private javax.swing.JPanel panOverview;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form MassnahmenHistory.
     */
    public LosDiagram() {
        initComponents();
        setName("Losverteilung");
        panDetail.setVisible(false);
        try {
            new CidsBeanDropTarget(this);
        } catch (final Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error while creating CidsBeanDropTarget", ex); // NOI18N
            }
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        panOverview = new javax.swing.JPanel();
        lblPlanlab = new javax.swing.JLabel();
        lblPlan = new javax.swing.JLabel();
        lblImage = new javax.swing.JLabel();
        panDetail = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        panLos = new javax.swing.JPanel();

        addComponentListener(new java.awt.event.ComponentAdapter() {

                @Override
                public void componentResized(final java.awt.event.ComponentEvent evt) {
                    formComponentResized(evt);
                }
            });
        setLayout(new java.awt.GridBagLayout());

        panOverview.setLayout(new java.awt.GridBagLayout());

        lblPlanlab.setText(org.openide.util.NbBundle.getMessage(LosDiagram.class, "LosDiagram.lblPlanlab.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panOverview.add(lblPlanlab, gridBagConstraints);

        lblPlan.setText(org.openide.util.NbBundle.getMessage(LosDiagram.class, "LosDiagram.lblPlan.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panOverview.add(lblPlan, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 5, 0);
        add(panOverview, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(lblImage, gridBagConstraints);

        panDetail.setLayout(new java.awt.BorderLayout());

        jScrollPane1.setOpaque(false);

        panLos.setOpaque(false);
        panLos.setLayout(new java.awt.GridBagLayout());
        jScrollPane1.setViewportView(panLos);

        panDetail.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(panDetail, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void formComponentResized(final java.awt.event.ComponentEvent evt) { //GEN-FIRST:event_formComponentResized
        if (bean != null) {
            drawDiagram(bean);
        }
    }                                                                            //GEN-LAST:event_formComponentResized

    /**
     * DOCUMENT ME!
     *
     * @return    DOCUMENT ME!
     *
     * @Override  DOCUMENT ME!
     */
    @Override
    public JComponent getSearchWindowComponent() {
        return this;
    }
    /**
     * DOCUMENT ME!
     *
     * @return    DOCUMENT ME!
     *
     * @Override  DOCUMENT ME!
     */
    @Override
    public MetaObjectNodeServerSearch getServerSearch() {
        return null;
    }
    /**
     * DOCUMENT ME!
     *
     * @return    DOCUMENT ME!
     *
     * @Override  DOCUMENT ME!
     */
    @Override
    public ImageIcon getIcon() {
//        return new javax.swing.ImageIcon(getClass().getResource(
//                    "/de/cismet/cids/custom/icons/wrrl-db-mv/raisePoly.png"));
        final MetaClass los = ClassCacheMultiple.getMetaClass(WRRLUtil.DOMAIN_NAME, "gup_los");
        return new javax.swing.ImageIcon(los.getIconData());
    }
    /**
     * DOCUMENT ME!
     *
     * @param     beans  DOCUMENT ME!
     *
     * @Override  DOCUMENT ME!
     */
    @Override
    public void beansDropped(final ArrayList<CidsBean> beans) {
        if ((beans != null) && (beans.size() > 0)) {
            final CidsBean bean = beans.get(0);

            if (bean.getClass().getName().equals("de.cismet.cids.dynamics.Gup_planungsabschnitt")) {
                lblPlan.setText(bean.toString());
                this.bean = bean;
                drawDiagram(bean);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  bean  DOCUMENT ME!
     */
    private void drawDiagram(final CidsBean bean) {
        String url = "http://chart.googleapis.com/chart?cht=p3&";
        int width = getWidth();
        int height = getHeight() / 2;
        String data = "chd=t:";
        String label = "";
        final Map<Integer, MassnType> dataMap = new HashMap<Integer, MassnType>();
        lblPlanlab.setText("Planungsabschnitt");
        if (width < 250) {
            width = 250;
        }

        if (height < 100) {
            height = 100;
        }

        if ((width * height) > 300000) {
            final double quot = Math.sqrt((width * height) / 300000.0);
            width = (int)(width / quot);
            height = (int)(height / quot);
        }

        final String size = "chs=" + width + "x" + height;

        final List<CidsBean> beans = bean.getBeanCollectionProperty("massnahmen");

        for (final CidsBean maBean : beans) {
            Integer id = (Integer)maBean.getProperty("los.id");

            if (id == null) {
                id = -1;
            }
            MassnType type = dataMap.get(id);

            if (type == null) {
                if (id == -1) {
                    type = new MassnType("nicht zugewiesen", null);
                } else {
                    type = new MassnType((String)maBean.getProperty("los.bezeichnung"),
                            (CidsBean)maBean.getProperty("los"));
                }
                dataMap.put(id, type);
            }

            type.increaseCounter();
            type.addMassnBean(maBean);
        }

        final Set<Integer> keys = dataMap.keySet();
        boolean first = true;
        index = 0;
        panDetail.setVisible(true);
        panLos.removeAll();
//        panDetail.setPreferredSize(new Dimension(width, height - 30));
//        panDetail.setMaximumSize(new Dimension(width, height - 30));
//        jScrollPane1.setPreferredSize(new Dimension(width, height - 30));
//        jScrollPane1.setMaximumSize(new Dimension(width, height - 30));

        for (final Integer key : keys) {
            final MassnType type = dataMap.get(key);

            if (first) {
                first = false;
                data += type.getCounter();
                label += type.getName();
            } else {
                data += "," + type.getCounter();
                label += "|" + type.getName();
            }

            addLos(type);
        }

        try {
            url += size;
            url += "&" + data;
//            label = "chl=" + URLEncoder.encode(label, "UTF-8");
//            url += "&" + label;

            if (LOG.isDebugEnabled()) {
                LOG.debug("url: " + url);
            }

            lblImage.setIcon(getImageIconFromUrl(url));
        } catch (Exception e) {
            LOG.error("Error while trying to retrieve the chart.", e);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   url  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    private ImageIcon getImageIconFromUrl(final String url) throws Exception {
        final WebAccessManager wam = WebAccessManager.getInstance();

        final InputStream is = wam.doRequest(new URL(url));
        final ImageInputStream iis = ImageIO.createImageInputStream(is);
        final Iterator<ImageReader> itReader = ImageIO.getImageReaders(iis);

        final ImageReader reader = itReader.next();

        final ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(iis, true, true);

        final BufferedImage image;

        try {
            image = reader.read(0, param);
            return new ImageIcon(image);
        } catch (Exception e) {
            throw e;
        } finally {
            reader.dispose();
            iis.close();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  type  massnBean DOCUMENT ME!
     */
    private void addLos(final MassnType type) {
        final GridBagConstraints constraint = new GridBagConstraints(
                0,
                ++index,
                1,
                1,
                1,
                0,
                GridBagConstraints.NORTHWEST,
                GridBagConstraints.NONE,
                new Insets(2, 5, 2, 5),
                0,
                0);

        final LosPanel los = new LosPanel();
        los.setBeans(type.getLos(), type.getMassnBeans());

        panLos.add(los, constraint);
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private class MassnType {

        //~ Instance fields ----------------------------------------------------

        private String name;
        private int counter = 0;
        private CidsBean los;
        private List<CidsBean> massnBeans = new ArrayList<CidsBean>();

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new MassnType object.
         *
         * @param  name  DOCUMENT ME!
         * @param  los   DOCUMENT ME!
         */
        public MassnType(final String name, final CidsBean los) {
            this.name = name;
            this.los = los;
        }

        //~ Methods ------------------------------------------------------------

        /**
         * DOCUMENT ME!
         */
        public void increaseCounter() {
            ++counter;
        }

        /**
         * DOCUMENT ME!
         *
         * @param  massnBean  DOCUMENT ME!
         */
        public void addMassnBean(final CidsBean massnBean) {
            getMassnBeans().add(massnBean);
        }

        /**
         * DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        public int getCounter() {
            return counter;
        }

        /**
         * DOCUMENT ME!
         *
         * @return  the name
         */
        public String getName() {
            return name;
        }

        /**
         * DOCUMENT ME!
         *
         * @return  the los
         */
        public CidsBean getLos() {
            return los;
        }

        /**
         * DOCUMENT ME!
         *
         * @return  the massnBeans
         */
        public List<CidsBean> getMassnBeans() {
            return massnBeans;
        }
    }
}
