/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.method.MethodManager;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.ui.ComponentRegistry;

import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.middleware.types.Node;
import Sirius.server.newuser.permission.Policy;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.util.List;

import javax.swing.JLabel;

import de.cismet.cids.dynamics.CidsBean;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class LosPanel extends javax.swing.JPanel {

    //~ Instance fields --------------------------------------------------------

    private int index = 0;
    private CidsBean los;
    private List<CidsBean> massnBeans;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblLos;
    private javax.swing.JLabel lblSearchResult;
    private javax.swing.JPanel panMassn;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form LosPanel.
     */
    public LosPanel() {
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        lblLos = new javax.swing.JLabel();
        lblSearchResult = new javax.swing.JLabel();
        panMassn = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        lblLos.setText(org.openide.util.NbBundle.getMessage(LosPanel.class, "LosPanel.lblLos.text")); // NOI18N
        lblLos.addMouseListener(new java.awt.event.MouseAdapter() {

                @Override
                public void mouseClicked(final java.awt.event.MouseEvent evt) {
                    lblLosMouseClicked(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 0, 5);
        add(lblLos, gridBagConstraints);

        lblSearchResult.setForeground(new java.awt.Color(13, 108, 249));
        lblSearchResult.setText(org.openide.util.NbBundle.getMessage(LosPanel.class, "LosPanel.lblSearchResult.text")); // NOI18N
        lblSearchResult.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        lblSearchResult.addMouseListener(new java.awt.event.MouseAdapter() {

                @Override
                public void mouseClicked(final java.awt.event.MouseEvent evt) {
                    lblSearchResultMouseClicked(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(lblSearchResult, gridBagConstraints);

        panMassn.setOpaque(false);
        panMassn.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(panMassn, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lblLosMouseClicked(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_lblLosMouseClicked
        if (los != null) {
            final MetaObjectNode metaObjectNode = new MetaObjectNode(
                    -1,
                    SessionManager.getSession().getUser().getDomain(),
                    los.getMetaObject(),
                    null,
                    null,
                    true,
                    Policy.createWIKIPolicy(),
                    -1,
                    null,
                    false);
            final ObjectTreeNode otn = new ObjectTreeNode(metaObjectNode);
            ComponentRegistry.getRegistry().showComponent(ComponentRegistry.ATTRIBUTE_EDITOR);
            ComponentRegistry.getRegistry().getAttributeEditor().setTreeNode(otn);
        }
    }                                                                      //GEN-LAST:event_lblLosMouseClicked

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lblSearchResultMouseClicked(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_lblSearchResultMouseClicked
        final Node[] nodes = new Node[massnBeans.size()];
        int index = 0;

        for (final CidsBean tmp : massnBeans) {
            nodes[index++] = new MetaObjectNode(tmp);
        }

        MethodManager.getManager().showSearchResults(null, nodes, false);
    } //GEN-LAST:event_lblSearchResultMouseClicked

    /**
     * DOCUMENT ME!
     *
     * @param  los    DOCUMENT ME!
     * @param  massn  DOCUMENT ME!
     */
    public void setBeans(final CidsBean los, final List<CidsBean> massn) {
        this.los = los;
        this.massnBeans = massn;

        if (los != null) {
            final String name = (los.getProperty("bezeichnung") != null) ? los.getProperty("bezeichnung").toString()
                                                                         : "unbenannt";
            lblLos.setText("Los: " + name);
            lblLos.setForeground(new Color(13, 108, 249));
            lblLos.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        } else {
            lblLos.setText("Kein Los");
        }

        for (final CidsBean tmp : massn) {
            addMassn(tmp);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  massnBean  DOCUMENT ME!
     */
    public void addMassn(final CidsBean massnBean) {
        final GridBagConstraints constraint = new GridBagConstraints(
                0,
                ++index,
                1,
                1,
                1,
                0,
                GridBagConstraints.NORTHWEST,
                GridBagConstraints.NONE,
                new Insets(2, 15, 2, 5),
                0,
                0);

        final JLabel massnLab = new JLabel(massnBean.toString());

        panMassn.add(massnLab, constraint);
    }
}
