/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.actions.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.method.MethodManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.middleware.types.Node;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wrrl_db_mv.server.search.FgskIdByIntersectionSearch;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WKKSearchBySingleStation;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateLinearReferencedMarksListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedLineFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class FgskDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(FgskDialog.class);
    private static final MetaClass MC_FGSK = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"fgsk_kartierabschnitt");
    private static final MetaClass MC_STATION = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"station");
    private static final MetaClass MC_STATIONLINIE = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"station_linie");
    private static final MetaClass MC_GEOM = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"geom");
    private static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.OTHER, (String)"FgskDialog");
    private static final List<String> exceptions = new ArrayList<String>();
    private MappingComponent mappingComponent = null;
    private String interactionModeWhenFinished = "";
    private final Double[] positions;
    private CidsBean routeBean = null;
    private final ArrayList<KartierAbschnitt> kartierAbschnitte = new ArrayList<E>();
    private boolean allValid;
    private MetaObject[] mos;
    private List<Integer> removedIndices = new ArrayList<Integer>();
    private JButton cmdCancel;
    private JButton cmdOk;
    private JButton cmdRemove;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JTable jTable1;
    private JLabel lblLeftCaption;
    private JLabel lblLeftCaption1;
    private JLabel lblLeftDescription;
    private JLabel lblLeftDescription1;
    private JLabel lblRightCaption;
    private JPanel panDesc;
    private JPanel panSettings;

    /*
     * Unable to fully structure code
     */
    public FgskDialog(boolean modal, MappingComponent mappingComponent) {
        super(StaticSwingTools.getParentFrame((Component)mappingComponent), modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.cmdOk);
        this.mappingComponent = mappingComponent;
        this.cmdOk.setEnabled(false);
        marksListener = (CreateLinearReferencedMarksListener)mappingComponent.getInputListener("LINEMEASUREMENT");
        selectedPFeature = marksListener.getSelectedLinePFeature();
        this.positions = marksListener.getMarkPositionsOfSelectedFeature();
        if (selectedPFeature != null && (feature = selectedPFeature.getFeature()) != null && feature instanceof CidsFeature && (cidsFeature = (Double[])feature).getMetaClass().getName().equals("route")) {
            this.routeBean = cidsFeature.getMetaObject().getBean();
        }
        if (this.routeBean != null) {
            if (this.positions != null && this.positions.length > 0) {
                fromPosition = null;
                cidsFeature = this.positions;
                var7_9 = cidsFeature.length;
                for (var8_11 = 0; var8_11 < var7_9; ++var8_11) {
                    position = cidsFeature[var8_11];
                    toPosition = position;
                    if (fromPosition != null) {
                        this.kartierAbschnitte.add(new KartierAbschnitt(fromPosition.intValue(), toPosition.intValue()));
                    }
                    fromPosition = toPosition;
                }
            } else {
                try {
                    MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"fgsk_kartierabschnitt");
                    query = "select " + MC.getID() + ", m." + MC.getPrimaryKey() + " from " + MC.getTableName();
                    query = query + " m join station_linie sl on (m.linie = sl.id) join station von on (sl.von = von.id)";
                    query = query + " WHERE not coalesce(historisch, false) and von.route = " + this.routeBean.getProperty("id");
                    query = query + " order by von.wert asc";
                    this.mos = SessionManager.getSession().getConnection().getMetaObjectByQuery(SessionManager.getSession().getUser(), query, FgskDialog.CC);
                    if (this.mos == null || this.mos.length <= 0) ** GOTO lbl48
                    for (MetaObject mo : this.mos) {
                        fromPosition = (Double)mo.getBean().getProperty("linie.von.wert");
                        toPosition = (Double)mo.getBean().getProperty("linie.bis.wert");
                        if (fromPosition == null) continue;
                        this.kartierAbschnitte.add(new KartierAbschnitt(fromPosition.intValue(), toPosition.intValue()));
                    }
                }
                catch (Exception e) {
                    FgskDialog.LOG.error((Object)"Error while retrieving kartierabschnitte", (Throwable)e);
                }
            }
        }
lbl48:
        // 6 sources

        this.allValid = true;
        for (index = 0; index < this.kartierAbschnitte.size(); ++index) {
            kartierAbschnitt = this.kartierAbschnitte.get(index);
            ((DefaultTableModel)this.jTable1.getModel()).addRow(new Object[]{index, kartierAbschnitt.getVon(), kartierAbschnitt.getBis()});
            if (kartierAbschnitt.isValid()) continue;
            this.allValid = false;
        }
        this.cmdRemove.setVisible(this.mos != null);
        this.cmdOk.setEnabled(this.positions != null && this.positions.length > 1 || this.mos != null && this.mos.length > 1);
    }

    private void initComponents() {
        this.panDesc = new JPanel();
        this.lblLeftCaption = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.lblLeftDescription = new JLabel();
        this.lblLeftCaption1 = new JLabel();
        this.lblLeftDescription1 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.panSettings = new JPanel();
        this.lblRightCaption = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jSeparator4 = new JSeparator();
        this.cmdRemove = new JButton();
        this.jPanel1 = new JPanel();
        this.cmdOk = new JButton();
        this.cmdCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(FgskDialog.class, (String)"FgskDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.panDesc.setBackground(new Color(216, 228, 248));
        this.panDesc.setMinimumSize(new Dimension(270, 400));
        this.panDesc.setPreferredSize(new Dimension(270, 400));
        this.panDesc.setLayout(new GridBagLayout());
        this.lblLeftCaption.setFont(new Font("Tahoma", 1, 11));
        this.lblLeftCaption.setText(NbBundle.getMessage(FgskDialog.class, (String)"FgskDialog.lblLeftCaption.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.panDesc.add((Component)this.lblLeftCaption, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.panDesc.add((Component)this.jSeparator2, gridBagConstraints);
        this.lblLeftDescription.setText(NbBundle.getMessage(FgskDialog.class, (String)"FgskDialog.lblLeftDescription.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.panDesc.add((Component)this.lblLeftDescription, gridBagConstraints);
        this.lblLeftCaption1.setFont(new Font("Tahoma", 1, 11));
        this.lblLeftCaption1.setText(NbBundle.getMessage(FgskDialog.class, (String)"FgskDialog.lblLeftCaption1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 12, 0, 0);
        this.panDesc.add((Component)this.lblLeftCaption1, gridBagConstraints);
        this.lblLeftDescription1.setText(NbBundle.getMessage(FgskDialog.class, (String)"FgskDialog.lblLeftDescription1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.panDesc.add((Component)this.lblLeftDescription1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.panDesc.add((Component)this.jSeparator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.panDesc, gridBagConstraints);
        this.panSettings.setMinimumSize(new Dimension(50, 50));
        this.panSettings.setLayout(new GridBagLayout());
        this.lblRightCaption.setFont(new Font("Tahoma", 1, 11));
        this.lblRightCaption.setText(NbBundle.getMessage(FgskDialog.class, (String)"FgskDialog.lblRightCaption.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.panSettings.add((Component)this.lblRightCaption, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.panSettings.add((Component)this.jSeparator1, gridBagConstraints);
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"#", "von", "bis"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.setSelectionMode(2);
        this.jTable1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                FgskDialog.this.jTable1KeyTyped(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTable1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 5, 0);
        this.panSettings.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        this.panSettings.add((Component)this.jSeparator4, gridBagConstraints);
        this.cmdRemove.setText(NbBundle.getMessage(FgskDialog.class, (String)"FgskDialog.cmdRemove.text"));
        this.cmdRemove.setMaximumSize(new Dimension(160, 27));
        this.cmdRemove.setMinimumSize(new Dimension(160, 27));
        this.cmdRemove.setPreferredSize(new Dimension(160, 27));
        this.cmdRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FgskDialog.this.cmdRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 6, 12, 12);
        this.panSettings.add((Component)this.cmdRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.getContentPane().add((Component)this.panSettings, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.cmdOk.setMnemonic('O');
        this.cmdOk.setText(NbBundle.getMessage(FgskDialog.class, (String)"FgskDialog.cmdOk.text"));
        this.cmdOk.setMaximumSize(new Dimension(100, 27));
        this.cmdOk.setMinimumSize(new Dimension(100, 27));
        this.cmdOk.setPreferredSize(new Dimension(100, 27));
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FgskDialog.this.cmdOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(6, 6, 12, 12);
        this.jPanel1.add((Component)this.cmdOk, gridBagConstraints);
        this.cmdCancel.setMnemonic('A');
        this.cmdCancel.setText(NbBundle.getMessage(FgskDialog.class, (String)"FgskDialog.cmdCancel.text"));
        this.cmdCancel.setMaximumSize(new Dimension(100, 27));
        this.cmdCancel.setMinimumSize(new Dimension(100, 27));
        this.cmdCancel.setPreferredSize(new Dimension(100, 27));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FgskDialog.this.cmdCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(6, 12, 12, 0);
        this.jPanel1.add((Component)this.cmdCancel, gridBagConstraints);
        this.jPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jProgressBar1.setVisible(false);
        this.jProgressBar1.setString(NbBundle.getMessage(FgskDialog.class, (String)"FgskDialog.jProgressBar1.string"));
        this.jProgressBar1.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 12, 0);
        this.jPanel1.add((Component)this.jProgressBar1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        int returnOption;
        if (!this.allValid && (returnOption = JOptionPane.showOptionDialog(StaticSwingTools.getParentFrame((Component)this), "<html>Die Regeln zur Mindest- oder H\u00f6chstl\u00e4nge<br/>von Kartierabschnitten werden verletzt.", "Vorsicht", -1, 2, null, new String[]{"Abbrechen", "Trotzdem Fortfahren"}, "Abbrechen")) == 0) {
            this.cmdCancelActionPerformed(null);
            return;
        }
        ArrayList<Integer> histFgskAbschn = new ArrayList<Integer>();
        if (this.mos == null) {
            try {
                int returnOption2;
                FgskIdByIntersectionSearch search = new FgskIdByIntersectionSearch(this.routeBean.getMetaObject().getId(), this.positions[0].doubleValue(), this.positions[this.positions.length - 1].doubleValue());
                Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
                ArrayList resArray = (ArrayList)res;
                if (resArray != null && resArray.size() > 0 && ((ArrayList)resArray.get(0)).size() > 0) {
                    for (ArrayList l : resArray) {
                        histFgskAbschn.add((Integer)l.get(0));
                    }
                }
                if (histFgskAbschn.size() > 0 && (returnOption2 = JOptionPane.showOptionDialog(StaticSwingTools.getParentFrame((Component)this), "<html>An der angegebenen Stelle existieren bereits Kartierabschnitt.", "Vorsicht", -1, 2, null, new String[]{"Abbrechen", "Fortfahren"}, "Abbrechen")) == 0) {
                    this.cmdCancelActionPerformed(null);
                    return;
                }
            }
            catch (ConnectionException search) {
                // empty catch block
            }
        }
        this.cmdOk.setEnabled(false);
        this.cmdCancel.setEnabled(false);
        this.jProgressBar1.setVisible(true);
        SwingWorker<Collection<Node>, Void> sw = new SwingWorker<Collection<Node>, Void>(){

            @Override
            protected Collection<Node> doInBackground() throws Exception {
                MetaObject mo;
                int i;
                ArrayList<Node> r = new ArrayList<Node>();
                FgskDialog.this.jProgressBar1.setMaximum(FgskDialog.this.positions.length * 2 - 1);
                int numOfPersisted = 0;
                Geometry routeGeom = (Geometry)((CidsBean)FgskDialog.this.routeBean.getProperty("geom")).getProperty("geo_field");
                if (FgskDialog.this.mos != null) {
                    for (i = 0; i < FgskDialog.this.mos.length; ++i) {
                        if (FgskDialog.this.removedIndices.contains(i)) continue;
                        try {
                            mo = FgskDialog.this.mos[i];
                            CidsBean histBean = mo.getBean();
                            histBean.setProperty("historisch", (Object)Boolean.TRUE);
                            histBean.persist();
                            FgskDialog.this.jProgressBar1.setValue(numOfPersisted++);
                            continue;
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Cannot adjust old object", (Throwable)e);
                        }
                    }
                }
                if (FgskDialog.this.mos == null) {
                    ArrayList<CidsBean> stationenBeans = new ArrayList<CidsBean>();
                    for (Double position : FgskDialog.this.positions) {
                        try {
                            Geometry pointGeom = LinearReferencedPointFeature.getPointOnLine((double)position, (Geometry)routeGeom);
                            CidsBean pointGeomBean = MC_GEOM.getEmptyInstance().getBean();
                            pointGeomBean.setProperty("geo_field", (Object)pointGeom);
                            CidsBean toPointBean = MC_STATION.getEmptyInstance().getBean();
                            toPointBean.setProperty("real_point", (Object)pointGeomBean);
                            toPointBean.setProperty("wert", (Object)Integer.valueOf(position.intValue()).doubleValue());
                            toPointBean.setProperty("route", (Object)FgskDialog.this.routeBean);
                            stationenBeans.add(toPointBean.persist());
                            FgskDialog.this.jProgressBar1.setValue(numOfPersisted++);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"error while creating point bean", (Throwable)ex);
                        }
                    }
                    CidsBean fromPointBean = null;
                    Iterator histBean = stationenBeans.iterator();
                    while (histBean.hasNext()) {
                        CidsBean stationenBean;
                        CidsBean toPointBean = stationenBean = (CidsBean)histBean.next();
                        if (fromPointBean != null) {
                            int fromValue = ((Double)fromPointBean.getProperty("wert")).intValue();
                            int toValue = ((Double)toPointBean.getProperty("wert")).intValue();
                            Geometry lineGeom = LinearReferencedLineFeature.createSubline((double)fromValue, (double)toValue, (Geometry)routeGeom);
                            CidsBean lineGeomBean = MC_GEOM.getEmptyInstance().getBean();
                            lineGeomBean.setProperty("geo_field", (Object)lineGeom);
                            CidsBean lineBean = MC_STATIONLINIE.getEmptyInstance().getBean();
                            lineBean.setProperty("von", (Object)fromPointBean);
                            lineBean.setProperty("bis", (Object)toPointBean);
                            lineBean.setProperty("geom", (Object)lineGeomBean);
                            CidsBean fgskBean = MC_FGSK.getEmptyInstance().getBean();
                            fgskBean.setProperty("linie", (Object)lineBean);
                            fgskBean.setProperty("erfassungsdatum", (Object)new Timestamp(System.currentTimeMillis()));
                            fgskBean.setProperty("av_time", (Object)new Timestamp(System.currentTimeMillis()));
                            fgskBean.setProperty("av_user", (Object)SessionManager.getSession().getUser().toString());
                            fgskBean.setProperty("gwk", FgskDialog.this.routeBean.getProperty("gwk"));
                            try {
                                if (lineBean != null && FgskDialog.this.routeBean != null) {
                                    Double vonWert = (Double)lineBean.getProperty("von.wert");
                                    Double bisWert = (Double)lineBean.getProperty("bis.wert");
                                    if (vonWert != null && bisWert != null) {
                                        double wert = (bisWert + vonWert) / 2.0;
                                        WKKSearchBySingleStation search = new WKKSearchBySingleStation(String.valueOf(FgskDialog.this.routeBean.getProperty("id")), String.valueOf(wert));
                                        Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
                                        ArrayList resArray = (ArrayList)res;
                                        if (resArray != null && resArray.size() > 0 && ((ArrayList)resArray.get(0)).size() > 0) {
                                            Object o = ((ArrayList)resArray.get(0)).get(0);
                                            if (o instanceof String) {
                                                fgskBean.setProperty("wkk", (Object)o.toString());
                                            }
                                        } else {
                                            LOG.error((Object)"Server error in getWk_k(). Cids server search return null. See the server logs for further information");
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Error while determining the water body", (Throwable)e);
                            }
                            r.add((Node)new MetaObjectNode(fgskBean.persist()));
                            FgskDialog.this.jProgressBar1.setValue(numOfPersisted++);
                        }
                        fromPointBean = toPointBean;
                    }
                } else {
                    for (i = 0; i < FgskDialog.this.mos.length; ++i) {
                        if (FgskDialog.this.removedIndices.contains(i)) continue;
                        try {
                            mo = FgskDialog.this.mos[i];
                            CidsBean newBean = CidsBeanSupport.cloneCidsBean(mo.getBean(), false, exceptions);
                            newBean.setProperty("linie", (Object)CidsBeanSupport.cloneStationline((CidsBean)mo.getBean().getProperty("linie")));
                            newBean.setProperty("historisch", (Object)Boolean.FALSE);
                            r.add((Node)new MetaObjectNode(newBean.persist()));
                            continue;
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Cannot adjust old object", (Throwable)e);
                        }
                    }
                }
                return r;
            }

            @Override
            protected void done() {
                try {
                    Collection r = (Collection)this.get();
                    MethodManager.getManager().showSearchResults(null, r.toArray(new Node[r.size()]), false);
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while creating beans", (Throwable)ex);
                }
                FgskDialog.this.cmdOk.setEnabled(true);
                FgskDialog.this.cmdCancel.setEnabled(true);
                FgskDialog.this.jProgressBar1.setVisible(false);
                FgskDialog.this.dispose();
            }
        };
        sw.execute();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.mappingComponent.setInteractionMode(this.interactionModeWhenFinished);
        this.dispose();
    }

    private void jTable1KeyTyped(KeyEvent evt) {
        if (this.mos != null && evt.getKeyChar() == '\u007f') {
            this.removeParts();
        }
    }

    private void cmdRemoveActionPerformed(ActionEvent evt) {
        if (this.mos != null) {
            this.removeParts();
        }
    }

    private void removeParts() {
        int[] selectedRows = this.jTable1.getSelectedRows();
        if (selectedRows != null && selectedRows.length > 0) {
            ArrayList<Integer> rows = new ArrayList<Integer>();
            for (int row : selectedRows) {
                rows.add(row);
            }
            Collections.sort(rows, Collections.reverseOrder());
            Object object = rows.iterator();
            while (object.hasNext()) {
                Integer row = (Integer)object.next();
                Integer index = (Integer)((DefaultTableModel)this.jTable1.getModel()).getValueAt(row, 0);
                this.removedIndices.add(index);
                ((DefaultTableModel)this.jTable1.getModel()).removeRow(row);
            }
        }
    }

    private Double min(Double[] pos) {
        Double res = Double.MAX_VALUE;
        Double[] doubleArray = pos;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double d = doubleArray[i];
            if (!(d < res)) continue;
            res = d;
        }
        return res;
    }

    private Double max(Double[] pos) {
        Double res = Double.MIN_VALUE;
        Double[] doubleArray = pos;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double d = doubleArray[i];
            if (!(d > res)) continue;
            res = d;
        }
        return res;
    }

    private void changeStationLine(CidsBean stationLine, Double fromVal, Double tillVal) {
        try {
            Geometry lineGeom;
            Geometry pointGeom;
            Double from = (Double)stationLine.getProperty("von.wert");
            Double till = (Double)stationLine.getProperty("bis.wert");
            CidsBean fromStation = (CidsBean)stationLine.getProperty("von");
            CidsBean tillStation = (CidsBean)stationLine.getProperty("bis");
            boolean rightOrder = from <= till;
            Geometry routeGeom = (Geometry)((CidsBean)this.routeBean.getProperty("geom")).getProperty("geo_field");
            if (!rightOrder) {
                Double tmp = from;
                from = till;
                till = tmp;
                CidsBean tmpStat = fromStation;
                fromStation = tillStation;
                tillStation = tmpStat;
            }
            if (!fromVal.equals(from)) {
                CidsBean newFromStat = CidsBeanSupport.cloneStation(fromStation);
                pointGeom = LinearReferencedPointFeature.getPointOnLine((double)fromVal, (Geometry)routeGeom);
                newFromStat.setProperty("wert", (Object)fromVal);
                newFromStat.setProperty("real_point.geo_field", (Object)pointGeom);
                lineGeom = LinearReferencedLineFeature.createSubline((double)fromVal, (double)tillVal, (Geometry)routeGeom);
                stationLine.setProperty("geom.geo_field", (Object)lineGeom);
                if (rightOrder) {
                    stationLine.setProperty("von", (Object)newFromStat);
                } else {
                    stationLine.setProperty("bis", (Object)newFromStat);
                }
            }
            if (!tillVal.equals(till)) {
                CidsBean newTillStat = CidsBeanSupport.cloneStation(tillStation);
                pointGeom = LinearReferencedPointFeature.getPointOnLine((double)tillVal, (Geometry)routeGeom);
                newTillStat.setProperty("wert", (Object)tillVal);
                newTillStat.setProperty("real_point.geo_field", (Object)pointGeom);
                lineGeom = LinearReferencedLineFeature.createSubline((double)fromVal, (double)tillVal, (Geometry)routeGeom);
                stationLine.setProperty("geom.geo_field", (Object)lineGeom);
                if (rightOrder) {
                    stationLine.setProperty("bis", (Object)newTillStat);
                } else {
                    stationLine.setProperty("von", (Object)newTillStat);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while dividing station line", (Throwable)e);
        }
    }

    public String getInteractionWhenFinished() {
        return this.interactionModeWhenFinished;
    }

    public void setInteractionModeWhenFinished(String interactionModeWhenFinished) {
        this.interactionModeWhenFinished = interactionModeWhenFinished;
    }

    static {
        exceptions.add("av_user");
        exceptions.add("av_date");
        exceptions.add("linie");
    }

    private class MyTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            KartierAbschnitt kartierAbschnitt = (KartierAbschnitt)FgskDialog.this.kartierAbschnitte.get(row);
            String tooltip = null;
            int distance = kartierAbschnitt.getDistance();
            if (kartierAbschnitt.isTooShort()) {
                tooltip = "<html>Mit " + distance + " Metern ist dieser Kartierabschnitt zu kurz,<br/>er sollte mindestens 50 Meter lang sein.";
            } else if (kartierAbschnitt.isTooLong()) {
                tooltip = "<html>Mit " + distance + " Metern ist dieser Kartierabschnitt zu lang,<br/>er sollte h\u00f6chstens 400 Meter lang sein.";
            }
            this.setToolTipText(tooltip);
            if (!kartierAbschnitt.isValid()) {
                this.setOpaque(true);
                this.setBackground(Color.RED);
                this.setForeground(Color.WHITE);
            } else {
                this.setBackground(null);
                this.setForeground(null);
            }
            this.setText(value.toString());
            return this;
        }
    }

    private class KartierAbschnitt {
        private final int von;
        private final int bis;

        public KartierAbschnitt(int von, int bis) {
            this.von = von;
            this.bis = bis;
        }

        public int getBis() {
            return this.bis;
        }

        public int getVon() {
            return this.von;
        }

        public boolean isValid() {
            return !this.isTooShort() && !this.isTooLong();
        }

        public boolean isTooShort() {
            return this.getDistance() < 50;
        }

        public boolean isTooLong() {
            return this.getDistance() > 400;
        }

        public int getDistance() {
            return Math.abs(this.von - this.bis);
        }
    }
}

