/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.actions.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.method.MethodManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.middleware.types.Node;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.FgskKartierabschnittEditor;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanCache;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.CidsClientToolbarItem;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class FgskSplitArToolbarItem
extends AbstractAction
implements CidsClientToolbarItem {
    private static final MetaClass MC_FGSK = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"fgsk_kartierabschnitt");
    private static Logger LOG = Logger.getLogger(FgskSplitArToolbarItem.class);

    public FgskSplitArToolbarItem() {
        this.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/wrrl-db-mv/fgskSplit.png")));
        this.setTooltip("Kartierabschnitt teilen (au\u00dferhalb Route)");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MappingComponent mappingComponent = CismapBroker.getInstance().getMappingComponent();
        Frame parentFrame = StaticSwingTools.getParentFrame((Component)mappingComponent);
        Collection features = mappingComponent.getFeatureCollection().getSelectedFeatures();
        if (features.size() != 2) {
            JOptionPane.showMessageDialog(parentFrame, "Es muss genau ein FGSK-Objekt und eine Linie selektiert sein.", "Fehler", 0);
        } else {
            Feature feature = features.toArray(new Feature[0])[0];
            Feature feature2 = features.toArray(new Feature[0])[1];
            if (!(feature instanceof CidsFeature)) {
                feature = features.toArray(new Feature[0])[1];
            }
            if (!(feature2 instanceof PureNewFeature)) {
                feature2 = features.toArray(new Feature[0])[0];
            }
            if (!(feature instanceof CidsFeature) || !(feature2 instanceof PureNewFeature)) {
                JOptionPane.showMessageDialog(parentFrame, "Es muss genau ein FGSK-Objekt und eine Linie selektiert sein.", "Fehler", 0);
            } else {
                CidsFeature cidsFeature = (CidsFeature)feature;
                boolean isKartierabschnitt = cidsFeature.getMetaClass().getTableName().equalsIgnoreCase("fgsk_kartierabschnitt");
                if (!isKartierabschnitt) {
                    JOptionPane.showMessageDialog(parentFrame, "Bei dem selektierten Objekt handelt es sich nicht um ein Kartierabschnitt.", "Fehler", 0);
                } else {
                    CidsBean openBean = FgskKartierabschnittEditor.getCurrentlyOpenBean();
                    CidsBean cidsBean = cidsFeature.getMetaObject().getBean();
                    if (openBean != null) {
                        JOptionPane.showMessageDialog(parentFrame, "Der Editor des Kartierabschnitts muss vor dem Teilen geschlossen werden.", "Fehler", 0);
                    } else {
                        MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"fgsk_kartierabschnitt");
                        String query = "select " + MC.getID() + ", splitFgsk from splitFgsk(" + cidsFeature.getMetaObject().getId() + ", '" + feature2.getGeometry().toText() + "')";
                        try {
                            CidsBeanCache.getInstance().clear();
                            MetaObject[] mos = SessionManager.getSession().getConnection().getMetaObjectByQuery(SessionManager.getSession().getUser(), query, ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.OTHER, (String)FgskSplitArToolbarItem.class.getName()));
                            ArrayList<MetaObjectNode> nodes = new ArrayList<MetaObjectNode>();
                            for (MetaObject tmp : mos) {
                                nodes.add(new MetaObjectNode(tmp.getBean()));
                            }
                            MethodManager.getManager().showSearchResults(null, nodes.toArray(new Node[nodes.size()]), false);
                        }
                        catch (ConnectionException ex) {
                            LOG.error((Object)"Error while splitting FGSK object", (Throwable)ex);
                        }
                    }
                }
            }
        }
    }

    public String getSorterString() {
        return "Z";
    }

    public boolean isVisible() {
        try {
            return MC_FGSK.getPermissions().hasWritePermission(SessionManager.getSession().getUser()) && SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "splitArFgsk", ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.OTHER, (String)FgskSplitArToolbarItem.class.getName()));
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot check config attr", (Throwable)e);
            return false;
        }
    }

    private void setIcon(Icon i) {
        this.putValue("SmallIcon", i);
    }

    private void setTooltip(String text) {
        this.putValue("ShortDescription", text);
    }
}

