/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.actions.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.method.MethodManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.middleware.types.Node;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wrrl_db_mv.commons.linearreferencing.LinearReferencingConstants;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WKKSearchBySingleStation;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanCache;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedLineFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class FgskSplitDialog
extends JDialog {
    private static Logger LOG = Logger.getLogger(LinearReferencingConstants.class);
    private static final MetaClass MC_FGSK = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"fgsk_kartierabschnitt");
    private static final MetaClass MC_STATION = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"station");
    private static final MetaClass MC_STATIONLINIE = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"station_linie");
    private static final MetaClass MC_GEOM = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"geom");
    private MappingComponent mappingComponent = null;
    private final CidsBean fgskBean;
    private boolean sliderUpdateBlocked = false;
    private boolean spinnerUpdateBlocked = false;
    private ButtonGroup buttonGroup1;
    private JButton cmdCancel;
    private JButton cmdOk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JProgressBar jProgressBar1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSlider jSlider1;
    private JSpinner jSpinner1;
    private JLabel lblFromIcon;
    private JLabel lblLeftCaption;
    private JLabel lblLeftCaption1;
    private JLabel lblLeftCaption2;
    private JLabel lblLeftDescription;
    private JLabel lblLeftDescription1;
    private JLabel lblLeftDescription2;
    private JLabel lblRightCaption;
    private JLabel lblToIcon;
    private JPanel panDesc;
    private JPanel panLine;
    private JPanel panSettings;

    public FgskSplitDialog(CidsBean fgskBean, MappingComponent mappingComponent) {
        super(StaticSwingTools.getParentFrame((Component)mappingComponent), true);
        this.fgskBean = fgskBean;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.cmdOk);
        this.mappingComponent = mappingComponent;
    }

    private int getStationMinimum() {
        return ((Double)this.fgskBean.getProperty("linie.von.wert")).intValue();
    }

    private void sliderValueChanged() {
        if (!this.spinnerUpdateBlocked) {
            block4: {
                this.spinnerUpdateBlocked = true;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("set spinner value " + this.jSlider1.getValue()));
                    }
                    this.jSpinner1.setValue(this.jSlider1.getValue());
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)"error while changing spinner", (Throwable)ex);
                }
            }
            this.spinnerUpdateBlocked = false;
        }
    }

    private int getStationMaximum() {
        return ((Double)this.fgskBean.getProperty("linie.bis.wert")).intValue();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.panDesc = new JPanel();
        this.lblLeftCaption = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.lblLeftDescription = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.lblLeftCaption1 = new JLabel();
        this.lblLeftDescription1 = new JLabel();
        this.lblLeftCaption2 = new JLabel();
        this.lblLeftDescription2 = new JLabel();
        this.cmdOk = new JButton();
        this.cmdCancel = new JButton();
        this.panSettings = new JPanel();
        this.lblRightCaption = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jSlider1 = new JSlider();
        this.lblFromIcon = new JLabel();
        this.panLine = new JPanel();
        this.lblToIcon = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.setDefaultCloseOperation(2);
        this.panDesc.setBackground(new Color(216, 228, 248));
        this.lblLeftCaption.setFont(new Font("Tahoma", 1, 11));
        this.lblLeftCaption.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.lblLeftCaption.text"));
        this.lblLeftDescription.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.lblLeftDescription.text"));
        this.lblLeftCaption1.setFont(new Font("Tahoma", 1, 11));
        this.lblLeftCaption1.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.lblLeftCaption1.text"));
        this.lblLeftDescription1.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.lblLeftDescription1.text"));
        this.lblLeftCaption2.setFont(new Font("Tahoma", 1, 11));
        this.lblLeftCaption2.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.lblLeftCaption2.text"));
        this.lblLeftDescription2.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.lblLeftDescription2.text"));
        GroupLayout panDescLayout = new GroupLayout(this.panDesc);
        this.panDesc.setLayout(panDescLayout);
        panDescLayout.setHorizontalGroup(panDescLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panDescLayout.createSequentialGroup().addContainerGap().addGroup(panDescLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panDescLayout.createSequentialGroup().addComponent(this.lblLeftDescription1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -1, 247, Short.MAX_VALUE).addContainerGap()).addGroup(panDescLayout.createSequentialGroup().addComponent(this.lblLeftCaption).addGap(354, 354, 354)).addGroup(panDescLayout.createSequentialGroup().addComponent(this.lblLeftCaption1).addContainerGap(71, Short.MAX_VALUE)).addGroup(panDescLayout.createSequentialGroup().addComponent(this.lblLeftDescription, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(panDescLayout.createSequentialGroup().addGroup(panDescLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblLeftCaption2).addComponent(this.lblLeftDescription2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panDescLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panDescLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 253, Short.MAX_VALUE).addComponent(this.jLabel5).addContainerGap()).addGroup(panDescLayout.createSequentialGroup().addComponent(this.jSeparator3, -2, 241, -2).addContainerGap(-1, Short.MAX_VALUE)))))));
        panDescLayout.setVerticalGroup(panDescLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panDescLayout.createSequentialGroup().addContainerGap().addComponent(this.lblLeftCaption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panDescLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2, -2, 2, -2).addComponent(this.lblLeftDescription1, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.lblLeftCaption1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblLeftDescription, -2, -1, -2).addGroup(panDescLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panDescLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 108, Short.MAX_VALUE).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, 6, -2)).addGroup(panDescLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.lblLeftCaption2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblLeftDescription2, -2, -1, -2).addContainerGap()))));
        this.cmdOk.setMnemonic('O');
        this.cmdOk.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.cmdOk.text"));
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FgskSplitDialog.this.cmdOkActionPerformed(evt);
            }
        });
        this.cmdCancel.setMnemonic('A');
        this.cmdCancel.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.cmdCancel.text"));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FgskSplitDialog.this.cmdCancelActionPerformed(evt);
            }
        });
        this.lblRightCaption.setFont(new Font("Tahoma", 1, 11));
        this.lblRightCaption.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.lblRightCaption.text"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(String.valueOf(this.getStationMinimum()));
        this.jLabel1.setMaximumSize(new Dimension(80, 16));
        this.jLabel1.setMinimumSize(new Dimension(80, 16));
        this.jLabel1.setPreferredSize(new Dimension(80, 16));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText(String.valueOf(this.getStationMaximum()));
        this.jLabel2.setMaximumSize(new Dimension(80, 16));
        this.jLabel2.setMinimumSize(new Dimension(80, 16));
        this.jLabel2.setPreferredSize(new Dimension(80, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jSpinner1.setModel(new SpinnerNumberModel(0, 0, 0, 1));
        this.jSpinner1.setEditor(new JSpinner.NumberEditor(this.jSpinner1, ""));
        this.jSpinner1.setMinimumSize(new Dimension(80, 26));
        this.jSpinner1.setPreferredSize(new Dimension(80, 26));
        this.jSpinner1.setValue(this.getStationMinimum() + Math.abs((this.getStationMaximum() - this.getStationMinimum()) / 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.jPanel1.add((Component)this.jSpinner1, gridBagConstraints);
        ((SpinnerNumberModel)this.jSpinner1.getModel()).setMinimum(Integer.valueOf(this.getStationMinimum()));
        ((SpinnerNumberModel)this.jSpinner1.getModel()).setMaximum(Integer.valueOf(this.getStationMaximum()));
        ((JSpinner.DefaultEditor)this.jSpinner1.getEditor()).getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                FgskSplitDialog.this.spinnerChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                FgskSplitDialog.this.spinnerChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                FgskSplitDialog.this.spinnerChanged();
            }
        });
        this.jSlider1.setMaximum(this.getStationMaximum());
        this.jSlider1.setMinimum(this.getStationMinimum());
        this.jSlider1.setPaintTrack(false);
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FgskSplitDialog.this.jSlider1StateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel1.add((Component)this.jSlider1, gridBagConstraints);
        this.lblFromIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/station.png")));
        this.lblFromIcon.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.lblFromIcon.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.lblFromIcon, gridBagConstraints);
        this.panLine.setBackground(new Color(255, 91, 0));
        this.panLine.setMinimumSize(new Dimension(10, 3));
        this.panLine.setPreferredSize(new Dimension(100, 3));
        this.panLine.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.jPanel1.add((Component)this.panLine, gridBagConstraints);
        this.lblToIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/station.png")));
        this.lblToIcon.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.lblToIcon.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.lblToIcon, gridBagConstraints);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel5, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.jRadioButton1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel1.add((Component)this.jRadioButton1, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.jRadioButton2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel1.add((Component)this.jRadioButton2, gridBagConstraints);
        this.jLabel3.setText(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        GroupLayout panSettingsLayout = new GroupLayout(this.panSettings);
        this.panSettings.setLayout(panSettingsLayout);
        panSettingsLayout.setHorizontalGroup(panSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panSettingsLayout.createSequentialGroup().addContainerGap().addComponent(this.lblRightCaption).addContainerGap(310, Short.MAX_VALUE)).addComponent(this.jSeparator4, -1, 410, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, 410, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 410, Short.MAX_VALUE));
        panSettingsLayout.setVerticalGroup(panSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panSettingsLayout.createSequentialGroup().addContainerGap().addComponent(this.lblRightCaption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, 252, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator4, -2, -1, -2)));
        this.jProgressBar1.setVisible(false);
        this.jProgressBar1.setString(NbBundle.getMessage(FgskSplitDialog.class, (String)"FgskSplitDialog.jProgressBar1.string"));
        this.jProgressBar1.setStringPainted(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jProgressBar1, -1, 416, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmdCancel, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdOk, -2, 107, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.panDesc, -2, 241, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panSettings, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.panSettings, -1, -1, Short.MAX_VALUE).addComponent(this.panDesc, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmdOk).addComponent(this.cmdCancel)).addComponent(this.jProgressBar1, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void spinnerChanged() {
        block10: {
            JFormattedTextField.AbstractFormatter formatter = ((JSpinner.DefaultEditor)this.jSpinner1.getEditor()).getTextField().getFormatter();
            String text = ((JSpinner.DefaultEditor)this.jSpinner1.getEditor()).getTextField().getText();
            if (!text.isEmpty()) {
                try {
                    block11: {
                        int value = (Integer)formatter.stringToValue(text);
                        if (this.sliderUpdateBlocked) break block10;
                        this.sliderUpdateBlocked = true;
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("set slider value " + value));
                            }
                            this.jSlider1.setValue(value);
                        }
                        catch (Exception ex) {
                            if (!LOG.isDebugEnabled()) break block11;
                            LOG.debug((Object)"error while changing slider", (Throwable)ex);
                        }
                    }
                    this.sliderUpdateBlocked = false;
                }
                catch (ParseException ex) {
                    block12: {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"error parsing spinner", (Throwable)ex);
                        }
                        if (this.sliderUpdateBlocked) break block10;
                        this.sliderUpdateBlocked = true;
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("set slider value " + (Integer)this.jSpinner1.getValue()));
                            }
                            this.jSlider1.setValue((Integer)this.jSpinner1.getValue());
                        }
                        catch (Exception ex2) {
                            if (!LOG.isDebugEnabled()) break block12;
                            LOG.debug((Object)"error while changing slider", (Throwable)ex2);
                        }
                    }
                    this.sliderUpdateBlocked = false;
                }
            }
        }
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        if (this.jSpinner1.getValue().equals(this.getStationMinimum()) || this.jSpinner1.getValue().equals(this.getStationMaximum())) {
            JOptionPane.showMessageDialog(this, "Die L\u00e4nge der resultierenden Kartierabschnitte muss > 0 sein.", "Fehler", 0);
            return;
        }
        this.cmdOk.setEnabled(false);
        this.cmdCancel.setEnabled(false);
        this.jProgressBar1.setVisible(true);
        SwingWorker<Collection<Node>, Void> sw = new SwingWorker<Collection<Node>, Void>(){

            @Override
            protected Collection<Node> doInBackground() throws Exception {
                return FgskSplitDialog.this.splitFgskBean(FgskSplitDialog.this.fgskBean, FgskSplitDialog.this.jRadioButton2.isSelected(), ((Integer)FgskSplitDialog.this.jSpinner1.getValue()).intValue());
            }

            @Override
            protected void done() {
                try {
                    Collection r = (Collection)this.get();
                    if (r != null) {
                        MethodManager.getManager().showSearchResults(null, r.toArray(new Node[r.size()]), false);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while splitting fgsk", (Throwable)ex);
                }
                FgskSplitDialog.this.cmdOk.setEnabled(true);
                FgskSplitDialog.this.cmdCancel.setEnabled(true);
                FgskSplitDialog.this.jProgressBar1.setVisible(false);
                FgskSplitDialog.this.dispose();
            }
        };
        sw.execute();
    }

    private Collection<Node> splitFgskBean(CidsBean oldBean, boolean fromToSplit, double splitValue) throws Exception {
        this.jProgressBar1.setMaximum(3);
        oldBean = SessionManager.getProxy().getMetaObject(oldBean.getPrimaryKeyValue().intValue(), oldBean.getMetaObject().getClassID(), oldBean.getMetaObject().getDomain()).getBean();
        String oldAbschnitt = (String)oldBean.getProperty("gewaesser_abschnitt");
        String oldSubAbschnitt = oldAbschnitt + (fromToSplit ? ".2" : ".1");
        String newSubAbschnitt = oldAbschnitt + (fromToSplit ? ".1" : ".2");
        CidsBeanCache.getInstance().clear();
        CidsBean line = CidsBeanCache.getInstance().getCachedBeanFor((CidsBean)oldBean.getProperty("linie"));
        oldBean.setProperty("linie", (Object)line);
        line.setProperty("von", (Object)CidsBeanCache.getInstance().getCachedBeanFor((CidsBean)line.getProperty("von")));
        line.setProperty("bis", (Object)CidsBeanCache.getInstance().getCachedBeanFor((CidsBean)line.getProperty("bis")));
        CidsBean oldFromPointBean = (CidsBean)oldBean.getProperty("linie.von");
        CidsBean oldToPointBean = (CidsBean)oldBean.getProperty("linie.bis");
        CidsBean oldSplitPointBean = fromToSplit ? oldFromPointBean : oldToPointBean;
        CidsBean oldRouteBean = (CidsBean)oldSplitPointBean.getProperty("route");
        Geometry oldRouteGeom = (Geometry)oldRouteBean.getProperty("geom.geo_field");
        double fromPointValue = this.getStationMinimum();
        double toPointValue = this.getStationMaximum();
        Geometry splitPointGeom = LinearReferencedPointFeature.getPointOnLine((double)splitValue, (Geometry)oldRouteGeom);
        Geometry fromLineGeom = LinearReferencedLineFeature.createSubline((double)fromPointValue, (double)splitValue, (Geometry)oldRouteGeom);
        Geometry toLineGeom = LinearReferencedLineFeature.createSubline((double)splitValue, (double)toPointValue, (Geometry)oldRouteGeom);
        Geometry oldUpdatedLineGeom = fromToSplit ? toLineGeom : fromLineGeom;
        CidsBean newSplitPointBean = MC_STATION.getEmptyInstance().getBean();
        newSplitPointBean.setProperty("real_point", (Object)MC_GEOM.getEmptyInstance().getBean());
        newSplitPointBean.setProperty("real_point.geo_field", (Object)splitPointGeom);
        newSplitPointBean.setProperty("route", (Object)oldRouteBean);
        newSplitPointBean.setProperty("wert", (Object)splitValue);
        CidsBean persistedNewSplitPointBean = newSplitPointBean.persist();
        this.jProgressBar1.setValue(1);
        oldBean.setProperty("linie.geom.geo_field", (Object)oldUpdatedLineGeom);
        oldBean.setProperty("linie." + (fromToSplit ? "von" : "bis"), (Object)persistedNewSplitPointBean);
        oldBean.setProperty("gewaesser_abschnitt", (Object)oldSubAbschnitt);
        CidsBean persistedOldBean = oldBean.persist();
        this.jProgressBar1.setValue(2);
        CidsBean newfgskBean = MC_FGSK.getEmptyInstance().getBean();
        CidsBean newLinieBean = MC_STATIONLINIE.getEmptyInstance().getBean();
        CidsBean newlineGeomBean = MC_GEOM.getEmptyInstance().getBean();
        Geometry newLineGeom = fromToSplit ? fromLineGeom : toLineGeom;
        newLinieBean.setProperty("geom", (Object)newlineGeomBean);
        newLinieBean.setProperty("geom.geo_field", (Object)newLineGeom);
        newLinieBean.setProperty(fromToSplit ? "bis" : "von", (Object)persistedNewSplitPointBean);
        newLinieBean.setProperty(fromToSplit ? "von" : "bis", (Object)oldSplitPointBean);
        newfgskBean.setProperty("erfassungsdatum", (Object)new Timestamp(System.currentTimeMillis()));
        newfgskBean.setProperty("gewaesser_abschnitt", (Object)newSubAbschnitt);
        newfgskBean.setProperty("linie", (Object)newLinieBean);
        newfgskBean.setProperty("gwk", oldRouteBean.getProperty("gwk"));
        try {
            if (newLinieBean != null && oldRouteBean != null) {
                Double vonWert = (Double)newLinieBean.getProperty("von.wert");
                Double bisWert = (Double)newLinieBean.getProperty("bis.wert");
                if (vonWert != null && bisWert != null) {
                    double wert = (bisWert + vonWert) / 2.0;
                    WKKSearchBySingleStation search = new WKKSearchBySingleStation(String.valueOf(oldRouteBean.getProperty("id")), String.valueOf(wert));
                    Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
                    ArrayList resArray = (ArrayList)res;
                    if (resArray != null && resArray.size() > 0 && ((ArrayList)resArray.get(0)).size() > 0) {
                        Object o = ((ArrayList)resArray.get(0)).get(0);
                        if (o instanceof String) {
                            newfgskBean.setProperty("wkk", (Object)o.toString());
                        }
                    } else {
                        LOG.error((Object)"Server error in getWk_k(). Cids server search return null. See the server logs for further information");
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while determining the water body", (Throwable)e);
        }
        CidsBean persistedNewFgskBean = newfgskBean.persist();
        this.jProgressBar1.setValue(3);
        MetaObjectNode firstSearchNode = fromToSplit ? new MetaObjectNode(persistedNewFgskBean) : new MetaObjectNode(persistedOldBean);
        MetaObjectNode secondSearchNode = fromToSplit ? new MetaObjectNode(persistedOldBean) : new MetaObjectNode(persistedNewFgskBean);
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add((Node)firstSearchNode);
        nodes.add((Node)secondSearchNode);
        CidsBeanCache.getInstance().clear();
        return nodes;
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        this.sliderValueChanged();
    }
}

