/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.actions.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.custom.actions.wrrl_db_mv.FgskSplitDialog;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.FgskKartierabschnittEditor;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.CidsClientToolbarItem;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class FgskSplitToolbarItem
extends AbstractAction
implements CidsClientToolbarItem {
    private static final MetaClass MC_FGSK = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"fgsk_kartierabschnitt");

    public FgskSplitToolbarItem() {
        this.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/wrrl-db-mv/fgskSplit.png")));
        this.setTooltip("Kartierabschnitt teilen");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MappingComponent mappingComponent = CismapBroker.getInstance().getMappingComponent();
        Frame parentFrame = StaticSwingTools.getParentFrame((Component)mappingComponent);
        Collection features = mappingComponent.getFeatureCollection().getSelectedFeatures();
        if (features.size() != 1) {
            JOptionPane.showMessageDialog(parentFrame, "Es muss genau ein Objekt selektiert sein.", "Fehler", 0);
        } else {
            Feature feature = features.toArray(new Feature[0])[0];
            if (!(feature instanceof CidsFeature)) {
                JOptionPane.showMessageDialog(parentFrame, "Es muss genau ein Objekt selektiert sein.", "Fehler", 0);
            } else {
                CidsFeature cidsFeature = (CidsFeature)feature;
                boolean isKartierabschnitt = cidsFeature.getMetaClass().getTableName().equalsIgnoreCase("fgsk_kartierabschnitt");
                if (!isKartierabschnitt) {
                    JOptionPane.showMessageDialog(parentFrame, "Bei dem selektierten Objekt handelt es sich nicht um ein Kartierabschnitt.", "Fehler", 0);
                } else {
                    CidsBean openBean = FgskKartierabschnittEditor.getCurrentlyOpenBean();
                    CidsBean cidsBean = cidsFeature.getMetaObject().getBean();
                    if (openBean != null) {
                        JOptionPane.showMessageDialog(parentFrame, "Der Editor des Kartierabschnitts muss vor dem Teilen geschlossen werden.", "Fehler", 0);
                    } else {
                        FgskSplitDialog dialog = new FgskSplitDialog(cidsBean, mappingComponent);
                        StaticSwingTools.showDialog((JDialog)dialog);
                    }
                }
            }
        }
    }

    public String getSorterString() {
        return "Z";
    }

    public boolean isVisible() {
        return MC_FGSK.getPermissions().hasWritePermission(SessionManager.getSession().getUser());
    }

    private void setIcon(Icon i) {
        this.putValue("SmallIcon", i);
    }

    private void setTooltip(String text) {
        this.putValue("ShortDescription", text);
    }
}

