/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.actions.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.types.treenode.RootTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.tree.MetaCatalogueTree;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.actions.wrrl_db_mv.SetHintDialog;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.utils.MetaClassCacheService;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.CommonFeatureAction;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SetHintAction
extends AbstractAction
implements CommonFeatureAction {
    private static final Logger LOG = Logger.getLogger(SetHintAction.class);
    private Feature feature;
    private MetaClass geoHintMetaClass;
    private boolean isCurrentUserAllowedToSetHint;

    public SetHintAction() {
        super(NbBundle.getMessage(SetHintAction.class, (String)"SetHintAction.name"), new ImageIcon(SetHintAction.class.getResource("/de/cismet/cids/custom/actions/wrrl_db_mv/tag_blue_add.png")));
        try {
            MetaClassCacheService classcache = (MetaClassCacheService)Lookup.getDefault().lookup(MetaClassCacheService.class);
            this.geoHintMetaClass = classcache.getMetaClass(SessionManager.getSession().getUser().getDomain(), "geo_hint");
            this.isCurrentUserAllowedToSetHint = this.geoHintMetaClass.getPermissions().hasWritePermission(SessionManager.getSession().getUser());
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while trying to set up SetHintAction. There was a problem with the lookup mechanism or session handling.", (Throwable)e);
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SetHintDialog dlgSetHint = new SetHintDialog((JComponent)CismapBroker.getInstance().getMappingComponent());
        StaticSwingTools.showDialog((JDialog)dlgSetHint);
        if (dlgSetHint.wasCancelled()) {
            return;
        }
        int priorityId = 2;
        if (dlgSetHint.getPriorityProperty().equals((Object)SetHintDialog.Priority.HIGH)) {
            priorityId = 1;
        } else if (dlgSetHint.getPriorityProperty().equals((Object)SetHintDialog.Priority.LOW)) {
            priorityId = 3;
        }
        CidsBean persistedHint = null;
        try {
            MetaClass priorityMetaClass = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"priority");
            MetaObject priorityMetaObject = SessionManager.getProxy().getMetaObject(priorityId, priorityMetaClass.getID(), "WRRL_DB_MV");
            CidsBean hint = CidsBeanSupport.createNewCidsBeanFromTableName("geo_hint");
            CidsBean geometry = CidsBeanSupport.createNewCidsBeanFromTableName("geom");
            User usr = SessionManager.getSession().getUser();
            hint.setProperty("usr", (Object)(usr.getName() + "@" + usr.getUserGroup().getName()));
            hint.setProperty("timestamp", (Object)new Timestamp(System.currentTimeMillis()));
            hint.setProperty("name", (Object)dlgSetHint.getNameProperty());
            hint.setProperty("comment", (Object)dlgSetHint.getCommentProperty());
            hint.setProperty("priority", (Object)priorityMetaObject.getBean());
            int srid = this.feature.getGeometry().getSRID();
            int defaultSrid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getDefaultCrs());
            if (srid == CismapBroker.getInstance().getDefaultCrsAlias()) {
                srid = defaultSrid;
            }
            if (srid != defaultSrid) {
                this.feature.setGeometry(CrsTransformer.transformToDefaultCrs((Geometry)this.feature.getGeometry()));
            }
            this.feature.getGeometry().setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
            geometry.setProperty("geo_field", (Object)this.feature.getGeometry());
            hint.setProperty("geometry", (Object)geometry);
            persistedHint = hint.persist();
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not persist new entity for table 'geo_hint'.", (Throwable)ex);
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(SetHintAction.class, (String)"SetHintAction.actionPerformed(ActionEvent).errorMessage"), NbBundle.getMessage(SetHintAction.class, (String)"SetHintAction.actionPerformed(ActionEvent).errorTitle"), 0);
        }
        if (persistedHint == null) {
            LOG.error((Object)"Could not persist new entity for table 'geo_hint'.");
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(SetHintAction.class, (String)"SetHintAction.actionPerformed(ActionEvent).errorMessage"), NbBundle.getMessage(SetHintAction.class, (String)"SetHintAction.actionPerformed(ActionEvent).errorTitle"), 0);
            return;
        }
        this.updateMappingComponent(persistedHint);
        this.updateCatalogueTree();
    }

    private void updateCatalogueTree() {
        MetaCatalogueTree catalogueTree = ComponentRegistry.getRegistry().getCatalogueTree();
        DefaultTreeModel catalogueTreeModel = (DefaultTreeModel)catalogueTree.getModel();
        Enumeration expandedPaths = catalogueTree.getExpandedDescendants(new TreePath(catalogueTreeModel.getRoot()));
        TreePath selectionPath = catalogueTree.getSelectionPath();
        RootTreeNode rootTreeNode = null;
        try {
            rootTreeNode = new RootTreeNode(SessionManager.getProxy().getRoots());
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Updating catalogue tree after successful insertion of 'geo_hint' entity failed.", (Throwable)ex);
            return;
        }
        catalogueTreeModel.setRoot((TreeNode)rootTreeNode);
        catalogueTreeModel.reload();
        if (selectionPath == null) {
            while (expandedPaths.hasMoreElements()) {
                TreePath expandedPath = (TreePath)expandedPaths.nextElement();
                if (selectionPath != null && selectionPath.getPathCount() >= selectionPath.getPathCount()) continue;
                selectionPath = expandedPath;
            }
        }
        catalogueTree.exploreSubtree(selectionPath);
    }

    private void updateMappingComponent(CidsBean persistedHint) throws IllegalArgumentException {
        MappingComponent mappingComponent = CismapBroker.getInstance().getMappingComponent();
        mappingComponent.getFeatureCollection().removeFeature(this.feature);
        mappingComponent.getFeatureCollection().addFeature((Feature)new CidsFeature(persistedHint.getMetaObject()));
    }

    public void setSourceFeature(Feature source) {
        this.feature = source;
    }

    public Feature getSourceFeature() {
        return this.feature;
    }

    public boolean isActive() {
        return this.isCurrentUserAllowedToSetHint && this.feature instanceof PureNewFeature;
    }

    public int getSorter() {
        return 10;
    }
}

