/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.featurerenderer.wrrl_db_mv;

import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.featurerenderer.CustomCidsFeatureRenderer;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.tools.gui.ImageUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class FotodokumentationFeatureRenderer
extends CustomCidsFeatureRenderer {
    private static final Logger log = Logger.getLogger(FotodokumentationFeatureRenderer.class);
    public static final BufferedImage ARROW;
    public static final FeatureAnnotationSymbol ARROW_NULL;

    public void assign() {
    }

    public FeatureAnnotationSymbol getPointSymbol() {
        List<CidsBean> fotos = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, "fotos");
        for (CidsBean foto : fotos) {
            Object winkelObj = foto.getProperty("angle");
            if (!(winkelObj instanceof Integer)) continue;
            int winkel = (Integer)winkelObj;
            BufferedImage rotatedArrow = ImageUtil.rotateImage((BufferedImage)ARROW, (double)winkel);
            FeatureAnnotationSymbol symb = new FeatureAnnotationSymbol((Image)rotatedArrow);
            symb.setSweetSpotX(0.5);
            symb.setSweetSpotY(0.5);
            return symb;
        }
        return ARROW_NULL;
    }

    static {
        try {
            URL arrowUrl = FotodokumentationFeatureRenderer.class.getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/angle.png");
            ARROW = ImageIO.read(arrowUrl);
            ARROW_NULL = new FeatureAnnotationSymbol(new ImageIcon("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/angle_null.png").getImage());
        }
        catch (Exception ex) {
            log.fatal((Object)ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

