/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.featurerenderer.wrrl_db_mv;

import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.featurerenderer.CustomCidsFeatureRenderer;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.sql.Timestamp;
import java.text.DateFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class GeoHintFeatureRenderer
extends CustomCidsFeatureRenderer {
    private static final Color GEOHINT_COLOR_HIGH_PRIORITY = new Color(255, 0, 0);
    private static final Color GEOHINT_COLOR_NORMAL_PRIORITY = new Color(255, 255, 0);
    private static final Color GEOHINT_COLOR_LOW_PRIORITY = new Color(0, 255, 0);
    private static final Color GEOHINT_COLOR_FALLBACK = new Color(0, 0, 255);
    private static Logger LOG = Logger.getLogger(GeoHintFeatureRenderer.class);
    private JPanel pnlMore;
    private JLabel lblUsrAndTimestamp;
    private JTextArea txtAComment;

    public GeoHintFeatureRenderer() {
        this.initComponents();
    }

    private void initComponents() {
        this.pnlMore = new JPanel();
        this.lblUsrAndTimestamp = new JLabel();
        this.txtAComment = new JTextArea();
        this.txtAComment.setLineWrap(true);
        this.txtAComment.setWrapStyleWord(true);
        this.txtAComment.setEditable(false);
        this.txtAComment.setBorder(null);
        this.pnlMore.setLayout(new BorderLayout());
        this.pnlMore.add((Component)this.lblUsrAndTimestamp, "First");
        this.pnlMore.add((Component)this.txtAComment, "Center");
        this.add(this.pnlMore);
    }

    public void setMetaObject(MetaObject metaObject) throws ConnectionException {
        super.setMetaObject(metaObject);
        if (this.cidsBean != null) {
            String usr = (String)this.cidsBean.getProperty("usr");
            String comment = (String)this.cidsBean.getProperty("comment");
            Timestamp timestamp = (Timestamp)this.cidsBean.getProperty("timestamp");
            String date = DateFormat.getDateInstance().format(timestamp);
            String time = DateFormat.getTimeInstance().format(timestamp);
            this.lblUsrAndTimestamp.setText(NbBundle.getMessage(GeoHintFeatureRenderer.class, (String)"GeoHintFeatureRenderer.lblUsrAndTimestamp.text", (Object)usr, (Object)date, (Object)time));
            this.txtAComment.setText(comment);
        }
    }

    public Paint getLinePaint(CidsFeature subFeature) {
        return this.getFillingStyle();
    }

    public Paint getFillingStyle() {
        CidsBean priorityBean;
        Object priority;
        Color result = GEOHINT_COLOR_FALLBACK;
        if (this.cidsBean != null && (priority = this.cidsBean.getProperty("priority")) instanceof CidsBean && (priorityBean = (CidsBean)priority).getProperty("id") instanceof Integer) {
            Integer priorityValue = (Integer)priorityBean.getProperty("id");
            if (priorityValue == 1) {
                result = GEOHINT_COLOR_HIGH_PRIORITY;
            } else if (priorityValue == 2) {
                result = GEOHINT_COLOR_NORMAL_PRIORITY;
            } else if (priorityValue == 3) {
                result = GEOHINT_COLOR_LOW_PRIORITY;
            }
        }
        return result;
    }

    public void assign() {
    }
}

