/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.LinearReferencedPointEditorListener;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.StationEditor;
import de.cismet.cids.custom.wrrl_db_mv.util.BewirtschaftungsendeHelper;
import de.cismet.cids.custom.wrrl_db_mv.util.MapUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.UIUtil;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.features.FeatureGroup;
import de.cismet.cismap.commons.features.FeatureGroups;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.tools.gui.FooterComponentProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class BewirtschaftungsendeEditor
extends JPanel
implements CidsBeanRenderer,
FooterComponentProvider,
EditorSaveListener {
    private static final Logger LOG = Logger.getLogger(BewirtschaftungsendeEditor.class);
    MappingComponent MAPPING_COMPONENT = CismapBroker.getInstance().getMappingComponent();
    private final BewirtschaftungsendeHelper helper = new BewirtschaftungsendeHelper();
    private CidsBean cidsBean;
    private final PropertyChangeListener helperListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == BewirtschaftungsendeEditor.this.helper && evt.getPropertyName().equals("wk")) {
                CidsBean wkBean = (CidsBean)evt.getNewValue();
                if (wkBean != null) {
                    BewirtschaftungsendeEditor.this.lblWk.setText((String)wkBean.getProperty("wk_k"));
                } else {
                    BewirtschaftungsendeEditor.this.lblWk.setText("-");
                }
            }
        }
    };
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JLabel lblBemerkungKey;
    private JLabel lblFoot;
    private JPanel lblSpacingBottom;
    private JLabel lblStatKey;
    private JLabel lblWk;
    private JPanel panFooter;
    private JScrollPane scpBemerkung;
    private StationEditor stationEditor1;
    private JTextArea txtBemerkungValue;
    private BindingGroup bindingGroup;

    public BewirtschaftungsendeEditor() {
        this.initComponents();
        this.stationEditor1.setFirstStationInCurrentBB(true);
        this.stationEditor1.addListener(new LinearReferencedPointEditorListener(){

            @Override
            public void pointCreated() {
                block2: {
                    try {
                        BewirtschaftungsendeEditor.this.cidsBean.setProperty("stat", (Object)BewirtschaftungsendeEditor.this.stationEditor1.getCidsBean());
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block2;
                        LOG.debug((Object)"error while assigning new station-cidsbean to the cidsbean", (Throwable)ex);
                    }
                }
            }
        });
        this.helper.addPropertyChangeListener(this.helperListener);
    }

    private void zoomToFeatures() {
        MapUtil.zoomToFeatureCollection(this.stationEditor1.getZoomFeatures());
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.helper.setCidsBean(cidsBean);
        this.bindingGroup.unbind();
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            this.bindingGroup.bind();
            CidsFeature cidsFeature = new CidsFeature(cidsBean.getMetaObject());
            ArrayList features = new ArrayList();
            features.addAll(FeatureGroups.expandAll((FeatureGroup)cidsFeature));
            this.MAPPING_COMPONENT.getFeatureCollection().removeFeatures(features);
            UIUtil.setLastModifier(cidsBean, this.lblFoot);
            this.zoomToFeatures();
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFooter = new JPanel();
        this.lblFoot = new JLabel();
        this.jPanel2 = new JPanel();
        this.lblBemerkungKey = new JLabel();
        this.stationEditor1 = new StationEditor();
        this.scpBemerkung = new JScrollPane();
        this.txtBemerkungValue = new JTextArea();
        this.lblStatKey = new JLabel();
        this.jLabel1 = new JLabel();
        this.lblWk = new JLabel();
        this.lblSpacingBottom = new JPanel();
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new GridBagLayout());
        this.lblFoot.setFont(new Font("Tahoma", 1, 12));
        this.lblFoot.setForeground(new Color(255, 255, 255));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 25, 7, 25);
        this.panFooter.add((Component)this.lblFoot, gridBagConstraints);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.lblBemerkungKey.setText("Bemerkung");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblBemerkungKey, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.stat}"), (Object)this.stationEditor1, (Property)BeanProperty.create((String)"cidsBean"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.stationEditor1, gridBagConstraints);
        this.txtBemerkungValue.setColumns(30);
        this.txtBemerkungValue.setLineWrap(true);
        this.txtBemerkungValue.setRows(10);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bemerkung}"), (Object)this.txtBemerkungValue, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.scpBemerkung.setViewportView(this.txtBemerkungValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.scpBemerkung, gridBagConstraints);
        this.lblStatKey.setText("Station");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblStatKey, gridBagConstraints);
        this.jLabel1.setText("Wasserk\u00f6rper");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblWk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.lblSpacingBottom.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.lblSpacingBottom, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public void dispose() {
        this.helper.dispose();
        this.helper.removeListener(this.helperListener);
        this.stationEditor1.dispose();
        this.bindingGroup.unbind();
    }

    public String getTitle() {
        return String.valueOf(this.cidsBean);
    }

    public void setTitle(String title) {
    }

    public static void main(String[] args) throws Exception {
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost((String)"WRRL_DB_MV", (String)"Administratoren", (String)"admin", (String)"sb", (String)"bewirtschaftungsende", (int)1, (int)1280, (int)1024);
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        if (this.cidsBean != null) {
            try {
                this.cidsBean.setProperty("av_user", (Object)SessionManager.getSession().getUser().toString());
                this.cidsBean.setProperty("av_time", (Object)new Timestamp(System.currentTimeMillis()));
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return true;
    }
}

