/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.tools.CacheException;
import Sirius.navigator.tools.MetaObjectCache;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.ChemieMstMessungenPanOne;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkFgEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkFgPanThirteen;
import de.cismet.cids.custom.wrrl_db_mv.util.QualityStatusCodeSupportingComparator;
import de.cismet.cids.custom.wrrl_db_mv.util.RendererTools;
import de.cismet.cids.custom.wrrl_db_mv.util.ScrollableComboBox;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.gui.FooterComponentProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class ChemieMstMessungenEditor
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener,
FooterComponentProvider {
    private static final Logger LOG = Logger.getLogger(ChemieMstMessungenEditor.class);
    private static final String[][] STOFF_HEADER = new String[][]{{"Stoffname", "substance_code.name_de"}, {"Messwert", "messwert"}, {"Einheit", "einheit"}, {"Grenzwert", "grenzwert"}, {"UQN-Art", "uqn_type.value"}, {"Jahr", "jahr_messung"}};
    private boolean readOnly = false;
    private CidsBean cidsBean;
    private DefaultBindableReferenceCombo cbChemZust;
    private DefaultBindableReferenceCombo cbDiffStInklUbiqSchUN;
    private DefaultBindableReferenceCombo cbFlussspez;
    private ChemieMstMessungenPanOne chemieMstMessungenPanOne1;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JLabel lblChemZustGes;
    private JLabel lblDiffStInklUbiqSchUN;
    private JLabel lblFlussspez;
    private JLabel lblFoot;
    private JLabel lblUQN6;
    private JLabel lblUQN8;
    private JPanel panAnl6;
    private JPanel panAnl8;
    private JPanel panFooter;
    private JTextField txtChemZustBem;
    private JTextField txtDiffStInklUbiqSchUN;
    private JTextField txtFlussspez;
    private BindingGroup bindingGroup;

    public ChemieMstMessungenEditor() {
        this(false);
    }

    public ChemieMstMessungenEditor(boolean readOnly) {
        this.readOnly = readOnly;
        this.initComponents();
        RendererTools.makeReadOnly((JComboBox)this.cbChemZust);
        RendererTools.makeReadOnly((JComboBox)this.cbDiffStInklUbiqSchUN);
        RendererTools.makeReadOnly((JComboBox)this.cbFlussspez);
        this.txtChemZustBem.setEditable(false);
        this.txtDiffStInklUbiqSchUN.setEditable(false);
        this.txtFlussspez.setEditable(false);
        this.clearForm();
        this.jPanel4.addMouseListener(new MouseAdapter(){
            boolean isHandCursor = false;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.isMouseOver(e)) {
                    try {
                        BrowserLauncher.openURL((String)"https://www.gesetze-im-internet.de/ogewv_2016/anlage_7.html");
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)ex, (Throwable)ex);
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!this.isHandCursor && this.isMouseOver(e)) {
                    ChemieMstMessungenEditor.this.jPanel4.setCursor(Cursor.getPredefinedCursor(12));
                    this.isHandCursor = true;
                } else if (this.isHandCursor) {
                    ChemieMstMessungenEditor.this.jPanel4.setCursor(Cursor.getPredefinedCursor(0));
                    this.isHandCursor = false;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.isHandCursor) {
                    ChemieMstMessungenEditor.this.jPanel4.setCursor(Cursor.getPredefinedCursor(0));
                    this.isHandCursor = false;
                }
            }

            private boolean isMouseOver(MouseEvent e) {
                return e.getPoint().x > 10 && e.getPoint().x < 85 && e.getPoint().y < 18;
            }
        });
        this.lblDiffStInklUbiqSchUN.addMouseListener(new MouseAdapter(){
            boolean isHandCursor = false;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.isMouseOver(e)) {
                    try {
                        BrowserLauncher.openURL((String)"https://www.gesetze-im-internet.de/ogewv_2016/anlage_8.html");
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)ex, (Throwable)ex);
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!this.isHandCursor && this.isMouseOver(e)) {
                    ChemieMstMessungenEditor.this.lblDiffStInklUbiqSchUN.setCursor(Cursor.getPredefinedCursor(12));
                    this.isHandCursor = true;
                } else if (this.isHandCursor) {
                    ChemieMstMessungenEditor.this.lblDiffStInklUbiqSchUN.setCursor(Cursor.getPredefinedCursor(0));
                    this.isHandCursor = false;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.isHandCursor) {
                    ChemieMstMessungenEditor.this.lblDiffStInklUbiqSchUN.setCursor(Cursor.getPredefinedCursor(0));
                    this.isHandCursor = false;
                }
            }

            private boolean isMouseOver(MouseEvent e) {
                return e.getPoint().x > 0 && e.getPoint().x < 285 && e.getPoint().y < 18;
            }
        });
        this.txtChemZustBem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String chemGesBem = (String)ChemieMstMessungenEditor.this.cidsBean.getProperty("chem_stat_bemerkung");
                if (chemGesBem != null && chemGesBem.startsWith("http")) {
                    try {
                        BrowserLauncher.openURL((String)chemGesBem);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)ex, (Throwable)ex);
                    }
                }
            }
        });
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.setCidsBean(cidsBean, null);
    }

    public void setCidsBean(final CidsBean cidsBean, final CidsBean parent) {
        this.bindingGroup.unbind();
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            String chemGesBem;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean);
            if (!this.readOnly) {
                this.setEnable(true);
            }
            this.bindingGroup.bind();
            if (parent != null && !this.readOnly) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        cidsBean.addPropertyChangeListener((PropertyChangeListener)new SubObjectPropertyChangedListener(parent));
                    }
                });
            }
            if ((chemGesBem = (String)cidsBean.getProperty("chem_stat_bemerkung")) != null && chemGesBem.startsWith("http")) {
                this.txtChemZustBem.setForeground(new Color(28, 72, 227));
            } else {
                this.txtChemZustBem.setForeground(new Color(93, 93, 93));
            }
            if (cidsBean.getProperty("messstelle") instanceof CidsBean) {
                this.refreshUQN((CidsBean)cidsBean.getProperty("messstelle"));
            }
        } else {
            if (!this.readOnly) {
                this.setEnable(false);
            }
            this.clearForm();
        }
        if (this.readOnly) {
            this.setEnable(false);
        }
        this.lblFoot.setText("");
        this.chemieMstMessungenPanOne1.setCidsBean(cidsBean);
    }

    public void refreshUQN(final CidsBean messstelle) {
        Thread t = new Thread(){

            @Override
            public void run() {
                List stoffList = ChemieMstMessungenEditor.this.getChemMst(messstelle);
                final ArrayList<CidsBean> anl6 = new ArrayList<CidsBean>();
                final ArrayList<CidsBean> anl8 = new ArrayList<CidsBean>();
                for (CidsBean stoff : stoffList) {
                    Boolean anl6Val = (Boolean)stoff.getProperty("substance_code.anl_6");
                    Boolean anl8Val = (Boolean)stoff.getProperty("substance_code.anl_8");
                    if (anl6Val != null && anl6Val.booleanValue()) {
                        anl6.add(stoff);
                        continue;
                    }
                    if (anl8Val == null || !anl8Val.booleanValue()) continue;
                    anl8.add(stoff);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JScrollPane scrollPane;
                        WkFgPanThirteen.UQNTable tab;
                        ChemieMstMessungenEditor.this.panAnl6.removeAll();
                        ChemieMstMessungenEditor.this.panAnl8.removeAll();
                        if (anl6 == null || anl6.isEmpty()) {
                            JLabel lblUQN6Val = new JLabel();
                            lblUQN6Val.setMinimumSize(new Dimension(380, 20));
                            lblUQN6Val.setPreferredSize(new Dimension(380, 20));
                            lblUQN6Val.setText("keine UQN \u00dcberschreitungen");
                            ChemieMstMessungenEditor.this.panAnl6.add((Component)lblUQN6Val, "Center");
                        } else {
                            tab = new WkFgPanThirteen.UQNTable(anl6, STOFF_HEADER);
                            scrollPane = new JScrollPane((Component)((Object)tab));
                            scrollPane.setMinimumSize(new Dimension(580, 100));
                            scrollPane.setPreferredSize(new Dimension(580, 100));
                            scrollPane.setOpaque(false);
                            ChemieMstMessungenEditor.this.panAnl6.add((Component)scrollPane, "Center");
                        }
                        if (anl8 == null || anl8.isEmpty()) {
                            JLabel lblUQN8Val = new JLabel();
                            lblUQN8Val.setMinimumSize(new Dimension(380, 20));
                            lblUQN8Val.setPreferredSize(new Dimension(380, 20));
                            lblUQN8Val.setText("keine UQN \u00dcberschreitungen");
                            ChemieMstMessungenEditor.this.panAnl8.add((Component)lblUQN8Val, "Center");
                        } else {
                            tab = new WkFgPanThirteen.UQNTable(anl8, STOFF_HEADER);
                            scrollPane = new JScrollPane((Component)((Object)tab));
                            scrollPane.setMinimumSize(new Dimension(580, 100));
                            scrollPane.setPreferredSize(new Dimension(580, 100));
                            scrollPane.setOpaque(false);
                            ChemieMstMessungenEditor.this.panAnl8.add((Component)scrollPane, "Center");
                        }
                    }
                });
            }
        };
        t.start();
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void clearForm() {
        this.lblFoot.setText("");
    }

    private void setEnable(final boolean enable) {
        EventQueue.invokeLater(new Thread("Enable editor"){

            @Override
            public void run() {
                ChemieMstMessungenEditor.this.chemieMstMessungenPanOne1.setEnable(enable);
            }
        });
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFooter = new JPanel();
        this.lblFoot = new JLabel();
        this.jPanel4 = new JPanel();
        this.chemieMstMessungenPanOne1 = new ChemieMstMessungenPanOne();
        this.lblChemZustGes = new JLabel();
        this.lblDiffStInklUbiqSchUN = new JLabel();
        this.lblUQN6 = new JLabel();
        this.lblFlussspez = new JLabel();
        this.lblUQN8 = new JLabel();
        this.cbChemZust = new ScrollableComboBox(null, false, false, new QualityStatusCodeSupportingComparator());
        this.txtChemZustBem = new JTextField();
        this.cbDiffStInklUbiqSchUN = new ScrollableComboBox(null, false, false, new QualityStatusCodeSupportingComparator());
        this.txtDiffStInklUbiqSchUN = new JTextField();
        this.cbFlussspez = new ScrollableComboBox(null, false, false, new QualityStatusCodeSupportingComparator());
        this.txtFlussspez = new JTextField();
        this.panAnl8 = new JPanel();
        this.panAnl6 = new JPanel();
        this.jPanel1 = new JPanel();
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new GridBagLayout());
        this.lblFoot.setFont(new Font("Tahoma", 1, 12));
        this.lblFoot.setForeground(new Color(255, 255, 255));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 25, 7, 25);
        this.panFooter.add((Component)this.lblFoot, gridBagConstraints);
        this.setMinimumSize(new Dimension(910, 1400));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(910, 1400));
        this.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)), NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.jPanel4.border.title", (Object[])new Object[0]), 0, 0, new Font("Dialog", 0, 12), new Color(28, 72, 227)));
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.jPanel4.add((Component)this.chemieMstMessungenPanOne1, gridBagConstraints);
        this.lblChemZustGes.setText(NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.lblChemZustGes.text_1", (Object[])new Object[0]));
        this.lblChemZustGes.setToolTipText(NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.lblChemZustGes.toolTipText", (Object[])new Object[0]));
        this.lblChemZustGes.setMinimumSize(new Dimension(420, 20));
        this.lblChemZustGes.setPreferredSize(new Dimension(420, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.lblChemZustGes, gridBagConstraints);
        this.lblDiffStInklUbiqSchUN.setForeground(new Color(28, 72, 227));
        this.lblDiffStInklUbiqSchUN.setText(NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.lblDiffStInklUbiqSchUN.text", (Object[])new Object[0]));
        this.lblDiffStInklUbiqSchUN.setToolTipText(NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.lblDiffStInklUbiqSchUN.toolTipText", (Object[])new Object[0]));
        this.lblDiffStInklUbiqSchUN.setMinimumSize(new Dimension(420, 20));
        this.lblDiffStInklUbiqSchUN.setPreferredSize(new Dimension(420, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.lblDiffStInklUbiqSchUN, gridBagConstraints);
        this.lblUQN6.setText(NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.lblUQN6.text", (Object[])new Object[0]));
        this.lblUQN6.setToolTipText(NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.lblUQN6.toolTipText", (Object[])new Object[0]));
        this.lblUQN6.setMinimumSize(new Dimension(420, 20));
        this.lblUQN6.setPreferredSize(new Dimension(420, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.lblUQN6, gridBagConstraints);
        this.lblUQN6.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.lblUQN6.AccessibleContext.accessibleName", (Object[])new Object[0]));
        this.lblUQN6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.lblUQN6.AccessibleContext.accessibleDescription", (Object[])new Object[0]));
        this.lblFlussspez.setText(NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.lblFlussspez.text", (Object[])new Object[0]));
        this.lblFlussspez.setToolTipText(NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.lblFlussspez.toolTipText", (Object[])new Object[0]));
        this.lblFlussspez.setMinimumSize(new Dimension(420, 20));
        this.lblFlussspez.setPreferredSize(new Dimension(420, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.lblFlussspez, gridBagConstraints);
        this.lblUQN8.setText(NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.lblUQN8.text", (Object[])new Object[0]));
        this.lblUQN8.setMinimumSize(new Dimension(420, 20));
        this.lblUQN8.setPreferredSize(new Dimension(420, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.lblUQN8, gridBagConstraints);
        this.lblUQN8.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.lblUQN8.AccessibleContext.accessibleName", (Object[])new Object[0]));
        this.lblUQN8.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ChemieMstMessungenEditor.class, (String)"ChemieMstMessungenEditor.lblUQN8.AccessibleContext.accessibleDescription", (Object[])new Object[0]));
        this.cbChemZust.setMaximumSize(new Dimension(225, 20));
        this.cbChemZust.setMinimumSize(new Dimension(225, 20));
        this.cbChemZust.setPreferredSize(new Dimension(225, 20));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.chem_stat}"), (Object)this.cbChemZust, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.cbChemZust.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChemieMstMessungenEditor.this.cbChemZustActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.cbChemZust, gridBagConstraints);
        this.txtChemZustBem.setMinimumSize(new Dimension(100, 20));
        this.txtChemZustBem.setPreferredSize(new Dimension(300, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.chem_stat_bemerkung}"), (Object)this.txtChemZustBem, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.txtChemZustBem, gridBagConstraints);
        this.cbDiffStInklUbiqSchUN.setMaximumSize(new Dimension(225, 20));
        this.cbDiffStInklUbiqSchUN.setMinimumSize(new Dimension(225, 20));
        this.cbDiffStInklUbiqSchUN.setPreferredSize(new Dimension(225, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.propristoffeohneubiqstoffe}"), (Object)this.cbDiffStInklUbiqSchUN, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.cbDiffStInklUbiqSchUN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChemieMstMessungenEditor.this.cbDiffStInklUbiqSchUNActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.cbDiffStInklUbiqSchUN, gridBagConstraints);
        this.txtDiffStInklUbiqSchUN.setMinimumSize(new Dimension(100, 20));
        this.txtDiffStInklUbiqSchUN.setPreferredSize(new Dimension(300, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.propristoffeohneubiqstoffebemerkung}"), (Object)this.txtDiffStInklUbiqSchUN, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.txtDiffStInklUbiqSchUN, gridBagConstraints);
        this.cbFlussspez.setMaximumSize(new Dimension(225, 20));
        this.cbFlussspez.setMinimumSize(new Dimension(225, 20));
        this.cbFlussspez.setPreferredSize(new Dimension(225, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.flussgebietsspezifische_schadstoffe}"), (Object)this.cbFlussspez, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.cbFlussspez.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChemieMstMessungenEditor.this.cbFlussspezActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.cbFlussspez, gridBagConstraints);
        this.txtFlussspez.setMinimumSize(new Dimension(100, 20));
        this.txtFlussspez.setPreferredSize(new Dimension(300, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.flussgebietsspezifische_schadstoffe_bem}"), (Object)this.txtFlussspez, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.txtFlussspez, gridBagConstraints);
        this.panAnl8.setOpaque(false);
        this.panAnl8.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.panAnl8, gridBagConstraints);
        this.panAnl6.setOpaque(false);
        this.panAnl6.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.panAnl6, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.jPanel4, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void cbChemZustActionPerformed(ActionEvent evt) {
    }

    private void cbDiffStInklUbiqSchUNActionPerformed(ActionEvent evt) {
    }

    private void cbFlussspezActionPerformed(ActionEvent evt) {
    }

    public static void setColorOfField(JTextField mit, Number oD, boolean reverseColors, Color foregroundColor) {
        mit.setDisabledTextColor(new Color(139, 142, 143));
        mit.setBackground(new Color(245, 246, 247));
        if (mit.getText() == null || mit.getText().equals("") || mit.getText().equals("<nicht gesetzt>")) {
            mit.setBackground(new Color(245, 246, 247));
            return;
        }
        if (oD == null) {
            mit.setBackground(new Color(245, 246, 247));
            return;
        }
        try {
            double mitD = Double.parseDouble(mit.getText().replace(",", "."));
            if (reverseColors) {
                mit.setBackground(ChemieMstMessungenEditor.calcColorReverse(mitD, oD.doubleValue()));
            } else {
                mit.setBackground(ChemieMstMessungenEditor.calcColor(mitD, oD.doubleValue()));
            }
            if (mit.getBackground().equals(Color.RED)) {
                mit.setDisabledTextColor(new Color(255, 255, 255));
            }
        }
        catch (NumberFormatException e) {
            mit.setOpaque(false);
        }
    }

    public static Color calcColor(double mittel, double o) {
        if (mittel <= o) {
            return Color.GREEN;
        }
        return Color.RED;
    }

    public static Color calcColorReverse(double mittel, double o) {
        if (mittel >= o) {
            return Color.GREEN;
        }
        return Color.RED;
    }

    public void dispose() {
        this.bindingGroup.unbind();
    }

    public String getTitle() {
        return String.valueOf(this.cidsBean);
    }

    public void setTitle(String title) {
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        return true;
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    private List<CidsBean> getChemMst(CidsBean messstelle) {
        ArrayList<CidsBean> data = new ArrayList<CidsBean>();
        try {
            MetaObject[] metaObjects;
            MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"chemie_mst_stoff");
            String query = "select " + MC.getID() + ", m." + MC.getPrimaryKey() + " from " + MC.getTableName();
            query = query + " m";
            query = query + " WHERE mst = " + messstelle.getProperty("id");
            for (MetaObject mo : metaObjects = MetaObjectCache.getInstance().getMetaObjectsByQuery(query, MC, false, WkFgEditor.CONNECTION_CONTEXT)) {
                data.add(mo.getBean());
            }
        }
        catch (CacheException e) {
            LOG.error((Object)"Error while trying to receive measurements.", (Throwable)e);
        }
        return data;
    }

    public class SubObjectPropertyChangedListener
    implements PropertyChangeListener {
        private final CidsBean parent;

        public SubObjectPropertyChangedListener(CidsBean parent) {
            this.parent = parent;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.parent != null) {
                this.parent.setArtificialChangeFlag(true);
            }
        }
    }
}

