/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.ChemieMstMessungenEditor;
import de.cismet.cids.custom.wrrl_db_mv.util.CoordinateConverter;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class ChemieMstStammdatenEditor
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener,
FooterComponentProvider,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(ChemieMstStammdatenEditor.class);
    private static final MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"chemie_mst_messungen");
    private boolean readOnly = false;
    private CidsBean cidsBean;
    private int measureNumber = 0;
    private boolean noDocumentUpdate = false;
    private final List<CidsBean> beansToSave = new ArrayList<CidsBean>();
    private JButton btnBack1;
    private JButton btnForward;
    private ChemieMstMessungenEditor chemieMstMessungenEditor1;
    private JLabel lblFoot;
    private JLabel lblGew;
    private JLabel lblGewVal;
    private JLabel lblHR;
    private JLabel lblHRVal;
    private JLabel lblHeading;
    private JLabel lblLage;
    private JLabel lblLageVal;
    private JLabel lblLawa;
    private JLabel lblLawaVal;
    private JLabel lblMst;
    private JLabel lblMstCodeVal;
    private JLabel lblWk;
    private JLabel lblWkVal;
    private JPanel panFooter;
    private SemiRoundedPanel panHeadInfo;
    private RoundedPanel panInfo;
    private JPanel panInfoContent;
    private JPanel panScr;
    private JPanel panStamm;
    private JTextField txtJahr;
    private BindingGroup bindingGroup;

    public ChemieMstStammdatenEditor() {
        this(false);
    }

    public ChemieMstStammdatenEditor(final boolean readOnly) {
        this.readOnly = readOnly;
        this.initComponents();
        this.txtJahr.getDocument().addDocumentListener(this);
        if (readOnly) {
            this.lblWkVal.setForeground(Color.BLUE);
            this.lblWkVal.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    CidsBean bean = (CidsBean)ChemieMstStammdatenEditor.this.cidsBean.getProperty("wk_fg");
                    if (bean != null && readOnly) {
                        ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObjectNode(new MetaObjectNode(bean), false);
                    }
                }
            });
        }
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean);
            this.txtJahr.setText(String.valueOf(new GregorianCalendar().get(1)));
            this.refreshMeasures();
            this.bindingGroup.bind();
            this.chemieMstMessungenEditor1.refreshUQN(cidsBean);
        } else {
            this.chemieMstMessungenEditor1.setCidsBean(null);
        }
        this.lblFoot.setText("");
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFooter = new JPanel();
        this.lblFoot = new JLabel();
        this.panInfo = new RoundedPanel();
        this.panHeadInfo = new SemiRoundedPanel();
        this.lblHeading = new JLabel();
        this.panInfoContent = new JPanel();
        this.panStamm = new JPanel();
        this.lblGew = new JLabel();
        this.lblLage = new JLabel();
        this.lblMstCodeVal = new JLabel();
        this.lblGewVal = new JLabel();
        this.lblLageVal = new JLabel();
        this.lblWk = new JLabel();
        this.lblHR = new JLabel();
        this.lblLawa = new JLabel();
        this.lblWkVal = new JLabel();
        this.lblHRVal = new JLabel();
        this.lblLawaVal = new JLabel();
        this.lblMst = new JLabel();
        this.panScr = new JPanel();
        this.txtJahr = new JTextField();
        this.btnBack1 = new JButton();
        this.btnForward = new JButton();
        this.chemieMstMessungenEditor1 = new ChemieMstMessungenEditor(this.readOnly);
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new GridBagLayout());
        this.lblFoot.setFont(new Font("Tahoma", 1, 12));
        this.lblFoot.setForeground(new Color(255, 255, 255));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 25, 7, 25);
        this.panFooter.add((Component)this.lblFoot, gridBagConstraints);
        this.setMinimumSize(new Dimension(1400, 1200));
        this.setPreferredSize(new Dimension(1400, 1200));
        this.setLayout(new GridBagLayout());
        this.panInfo.setMinimumSize(new Dimension(1400, 1200));
        this.panInfo.setPreferredSize(new Dimension(1400, 1200));
        this.panHeadInfo.setBackground(new Color(51, 51, 51));
        this.panHeadInfo.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading.setForeground(new Color(255, 255, 255));
        this.lblHeading.setText("Messstation");
        this.panHeadInfo.add((Component)this.lblHeading);
        this.panInfo.add((Component)this.panHeadInfo, (Object)"North");
        this.panInfoContent.setOpaque(false);
        this.panInfoContent.setLayout(new GridBagLayout());
        this.panStamm.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)), "Stammdaten"));
        this.panStamm.setOpaque(false);
        this.panStamm.setLayout(new GridBagLayout());
        this.lblGew.setText(NbBundle.getMessage(ChemieMstStammdatenEditor.class, (String)"BioMstStammdatenEditor.lblGew.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblGew, gridBagConstraints);
        this.lblLage.setText(NbBundle.getMessage(ChemieMstStammdatenEditor.class, (String)"BioMstStammdatenEditor.lblLage.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblLage, gridBagConstraints);
        this.lblMstCodeVal.setMinimumSize(new Dimension(200, 20));
        this.lblMstCodeVal.setPreferredSize(new Dimension(200, 20));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.messstelle}"), (Object)this.lblMstCodeVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"error");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblMstCodeVal, gridBagConstraints);
        this.lblGewVal.setMinimumSize(new Dimension(200, 20));
        this.lblGewVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gewaesser}"), (Object)this.lblGewVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"error");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblGewVal, gridBagConstraints);
        this.lblLageVal.setMinimumSize(new Dimension(200, 20));
        this.lblLageVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.lage}"), (Object)this.lblLageVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"error");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblLageVal, gridBagConstraints);
        this.lblWk.setText(NbBundle.getMessage(ChemieMstStammdatenEditor.class, (String)"BioMstStammdatenEditor.lblWk.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panStamm.add((Component)this.lblWk, gridBagConstraints);
        this.lblHR.setText(NbBundle.getMessage(ChemieMstStammdatenEditor.class, (String)"BioMstStammdatenEditor.lblHR.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panStamm.add((Component)this.lblHR, gridBagConstraints);
        this.lblLawa.setText(NbBundle.getMessage(ChemieMstStammdatenEditor.class, (String)"BioMstStammdatenEditor.lblLawa.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panStamm.add((Component)this.lblLawa, gridBagConstraints);
        this.lblWkVal.setMinimumSize(new Dimension(200, 20));
        this.lblWkVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.wk_fg.wk_k}"), (Object)this.lblWkVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<nicht gesetzt>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panStamm.add((Component)this.lblWkVal, gridBagConstraints);
        this.lblHRVal.setMinimumSize(new Dimension(200, 20));
        this.lblHRVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geom}"), (Object)this.lblHRVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"/");
        binding.setSourceUnreadableValue((Object)"<nicht gesetzt>");
        binding.setConverter((Converter)new CoordinateConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panStamm.add((Component)this.lblHRVal, gridBagConstraints);
        this.lblLawaVal.setMinimumSize(new Dimension(200, 20));
        this.lblLawaVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.wk_fg.lawa_type.value}-${cidsBean.wk_fg.lawa_type.name}"), (Object)this.lblLawaVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<nicht gesetzt>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panStamm.add((Component)this.lblLawaVal, gridBagConstraints);
        this.lblMst.setText(NbBundle.getMessage(ChemieMstStammdatenEditor.class, (String)"BioMstStammdatenEditor.lblMst.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblMst, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.panInfoContent.add((Component)this.panStamm, gridBagConstraints);
        this.panScr.setOpaque(false);
        this.panScr.setLayout(new GridBagLayout());
        this.txtJahr.setMinimumSize(new Dimension(100, 20));
        this.txtJahr.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panScr.add((Component)this.txtJahr, gridBagConstraints);
        this.btnBack1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-left.png")));
        this.btnBack1.setBorder(null);
        this.btnBack1.setBorderPainted(false);
        this.btnBack1.setContentAreaFilled(false);
        this.btnBack1.setFocusPainted(false);
        this.btnBack1.setMaximumSize(new Dimension(30, 30));
        this.btnBack1.setMinimumSize(new Dimension(30, 30));
        this.btnBack1.setPreferredSize(new Dimension(30, 30));
        this.btnBack1.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-left-pressed.png")));
        this.btnBack1.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-left-selected.png")));
        this.btnBack1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChemieMstStammdatenEditor.this.btnBack1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panScr.add((Component)this.btnBack1, gridBagConstraints);
        this.btnForward.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-right.png")));
        this.btnForward.setBorder(null);
        this.btnForward.setBorderPainted(false);
        this.btnForward.setContentAreaFilled(false);
        this.btnForward.setFocusPainted(false);
        this.btnForward.setMaximumSize(new Dimension(30, 30));
        this.btnForward.setMinimumSize(new Dimension(30, 30));
        this.btnForward.setPreferredSize(new Dimension(30, 30));
        this.btnForward.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-right-pressed.png")));
        this.btnForward.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-right-selected.png")));
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChemieMstStammdatenEditor.this.btnForwardActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panScr.add((Component)this.btnForward, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.panInfoContent.add((Component)this.panScr, gridBagConstraints);
        this.chemieMstMessungenEditor1.setMinimumSize(new Dimension(1000, 950));
        this.chemieMstMessungenEditor1.setPreferredSize(new Dimension(1000, 950));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panInfoContent.add((Component)this.chemieMstMessungenEditor1, gridBagConstraints);
        this.panInfo.add((Component)this.panInfoContent, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.add((Component)this.panInfo, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void btnBack1ActionPerformed(ActionEvent evt) {
        int year = this.getCurrentlyEnteredYear();
        if (--this.measureNumber < 0) {
            this.measureNumber = 0;
            --year;
        }
        this.noDocumentUpdate = true;
        this.txtJahr.setText(String.valueOf(year));
        this.noDocumentUpdate = false;
        final int newYear = year;
        WaitingDialogThread<YearAndMeasure> wdt = new WaitingDialogThread<YearAndMeasure>(StaticSwingTools.getParentFrame((Component)this), true, "Lade Messwerte", null, 100){

            protected YearAndMeasure doInBackground() throws Exception {
                CidsBean measure = null;
                int measureYear = newYear;
                while ((measure = ChemieMstStammdatenEditor.this.getDataForYear(measureYear, ChemieMstStammdatenEditor.this.measureNumber)) == null && --measureYear > 2006) {
                }
                return new YearAndMeasure(measure, ++measureYear);
            }

            protected void done() {
                try {
                    YearAndMeasure measure = (YearAndMeasure)this.get();
                    ChemieMstStammdatenEditor.this.noDocumentUpdate = true;
                    ChemieMstStammdatenEditor.this.txtJahr.setText(String.valueOf(measure.getYear()));
                    ChemieMstStammdatenEditor.this.noDocumentUpdate = false;
                    ChemieMstStammdatenEditor.this.showNewMeasure(measure.getMeasure());
                }
                catch (Exception e) {
                    LOG.error((Object)"Erro while searching measure values", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private void btnForwardActionPerformed(ActionEvent evt) {
        final int year = this.getCurrentlyEnteredYear();
        ++this.measureNumber;
        WaitingDialogThread<YearAndMeasure> wdt = new WaitingDialogThread<YearAndMeasure>(StaticSwingTools.getParentFrame((Component)this), true, "Lade Messwerte", null, 100){

            protected YearAndMeasure doInBackground() throws Exception {
                CidsBean measure = ChemieMstStammdatenEditor.this.getDataForYear(year, ChemieMstStammdatenEditor.this.measureNumber);
                if (measure == null) {
                    ChemieMstStammdatenEditor.this.measureNumber = 0;
                    int measureYear = year + 1;
                    measure = null;
                    int currentYear = new GregorianCalendar().get(1);
                    while ((measure = ChemieMstStammdatenEditor.this.getDataForYear(measureYear, ChemieMstStammdatenEditor.this.measureNumber)) == null && ++measureYear <= currentYear) {
                    }
                    return new YearAndMeasure(measure, --measureYear);
                }
                return new YearAndMeasure(measure, year);
            }

            protected void done() {
                try {
                    YearAndMeasure measure = (YearAndMeasure)this.get();
                    ChemieMstStammdatenEditor.this.noDocumentUpdate = true;
                    ChemieMstStammdatenEditor.this.txtJahr.setText(String.valueOf(measure.getYear()));
                    ChemieMstStammdatenEditor.this.noDocumentUpdate = false;
                    ChemieMstStammdatenEditor.this.showNewMeasure(measure.getMeasure());
                }
                catch (Exception e) {
                    LOG.error((Object)"Erro while searching measure values", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private void saveLastMeasure() {
        CidsBean lastMeasure;
        if (!this.readOnly && (lastMeasure = this.chemieMstMessungenEditor1.getCidsBean()) != null && !this.beansToSave.contains(lastMeasure)) {
            this.beansToSave.add(lastMeasure);
        }
    }

    private void refreshMeasures() {
        int year = this.getCurrentlyEnteredYear();
        this.measureNumber = 0;
        final CidsBean measure = this.getDataForYear(year, this.measureNumber);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChemieMstStammdatenEditor.this.showNewMeasure(measure);
            }
        });
    }

    private void showNewMeasure(CidsBean measure) {
        this.saveLastMeasure();
        this.chemieMstMessungenEditor1.setCidsBean(measure, this.cidsBean);
    }

    private int getCurrentlyEnteredYear() {
        try {
            return Integer.parseInt(this.txtJahr.getText());
        }
        catch (NumberFormatException e) {
            return new GregorianCalendar().get(1);
        }
    }

    public void dispose() {
        this.bindingGroup.unbind();
        this.beansToSave.clear();
    }

    public String getTitle() {
        return String.valueOf(this.cidsBean);
    }

    public void setTitle(String title) {
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        this.saveLastMeasure();
        for (CidsBean tmp : this.beansToSave) {
            try {
                tmp.persist();
            }
            catch (Exception e) {
                LOG.error((Object)"Exception ehile saving the last measure.", (Throwable)e);
            }
        }
        this.beansToSave.clear();
        return true;
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    private CidsBean getDataForYear(int year, int number) {
        try {
            String query = "select " + MC.getID() + ", m." + MC.getPrimaryKey() + " from " + MC.getTableName();
            query = query + " m, chemie_mst_stammdaten s";
            query = query + " WHERE m.messstelle = s.id AND s.id = " + this.cidsBean.getProperty("id");
            query = query + " AND messjahr = " + year + " order by id asc";
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            if (metaObjects != null && number >= 0 && number < metaObjects.length) {
                CidsBean retVal = metaObjects[number].getBean();
                int index = -1;
                index = this.beansToSave.indexOf(retVal);
                if (index != -1) {
                    return this.beansToSave.get(index);
                }
                this.beansToSave.add(retVal);
                return retVal;
            }
            return null;
        }
        catch (ConnectionException e) {
            LOG.error((Object)"Error while trying to receive measurements.", (Throwable)e);
            return null;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.noDocumentUpdate && e.getDocument().getLength() == 4) {
            this.refreshMeasures();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.noDocumentUpdate && e.getDocument().getLength() == 4) {
            this.refreshMeasures();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private static class YearAndMeasure {
        private CidsBean measure;
        private int year;

        public YearAndMeasure(CidsBean measure, int year) {
            this.measure = measure;
            this.year = year;
        }

        public CidsBean getMeasure() {
            return this.measure;
        }

        public void setMeasure(CidsBean measure) {
            this.measure = measure;
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }
    }
}

