/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.FgskKartierabschnittErgebnisse;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.FgskKartierabschnittGewaesserumfeld;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.FgskKartierabschnittKartierabschnitt;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.FgskKartierabschnittLaengsprofil;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.FgskKartierabschnittLaufentwicklung;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.FgskKartierabschnittQuerprofil;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.FgskKartierabschnittSohlenverbau;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.FgskKartierabschnittUferstruktur;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.Calc;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.CalcCache;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.ValidationException;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WKKSearchBySingleStation;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.TabbedPaneUITransparent;
import de.cismet.cids.custom.wrrl_db_mv.util.TimestampConverter;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.BeanInitializer;
import de.cismet.cids.editors.BeanInitializerForcePaste;
import de.cismet.cids.editors.BeanInitializerProvider;
import de.cismet.cids.editors.DefaultBeanInitializer;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class FgskKartierabschnittEditor
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener,
FooterComponentProvider,
PropertyChangeListener,
BeanInitializerProvider {
    private static final transient Logger LOG = Logger.getLogger(FgskKartierabschnittEditor.class);
    private static FgskKartierabschnittEditor lastInstance = null;
    private static CidsBean lastBean = null;
    private static boolean open = false;
    private boolean readOnly = false;
    private CidsBean cidsBean;
    private final transient ChangeListener calcL;
    private final transient PropertyChangeListener excL;
    private String wkk = null;
    private transient int selectedTabIndex;
    private FgskKartierabschnittErgebnisse fgskKartierabschnittErgebnisse1;
    private FgskKartierabschnittGewaesserumfeld fgskKartierabschnittGewaesserumfeld1;
    private FgskKartierabschnittKartierabschnitt fgskKartierabschnittKartierabschnitt1;
    private FgskKartierabschnittLaengsprofil fgskKartierabschnittLaengsprofil1;
    private FgskKartierabschnittLaufentwicklung fgskKartierabschnittLaufentwicklung1;
    private FgskKartierabschnittQuerprofil fgskKartierabschnittQuerprofil1;
    private FgskKartierabschnittSohlenverbau fgskKartierabschnittSohlenverbau1;
    private FgskKartierabschnittUferstruktur fgskKartierabschnittUferstruktur1;
    private JLabel lblFoot;
    private JPanel panErgebnisse;
    private JPanel panFooter;
    private JPanel panGewaesserumfeld;
    private JPanel panKartierabschnitt;
    private JPanel panLaengsprofil;
    private JPanel panLaufentwicklung;
    private JPanel panQuerprofil;
    private JPanel panSohlenstruktur;
    private JPanel panUferstruktur;
    private JTabbedPane tpMain;

    public FgskKartierabschnittEditor() {
        this(false);
    }

    public FgskKartierabschnittEditor(boolean readOnly) {
        this.readOnly = readOnly;
        this.initComponents();
        this.tpMain.setUI(new TabbedPaneUITransparent());
        if (readOnly) {
            this.fgskKartierabschnittKartierabschnitt1.setReadOnly(readOnly);
            this.fgskKartierabschnittLaufentwicklung1.setReadOnly(readOnly);
            this.fgskKartierabschnittLaengsprofil1.setReadOnly(readOnly);
            this.fgskKartierabschnittQuerprofil1.setReadOnly(readOnly);
            this.fgskKartierabschnittSohlenverbau1.setReadOnly(readOnly);
            this.fgskKartierabschnittUferstruktur1.setReadOnly(readOnly);
            this.fgskKartierabschnittGewaesserumfeld1.setReadOnly(readOnly);
        } else {
            CalcCache.getInstance().init();
        }
        this.calcL = new CalcListener();
        this.tpMain.addChangeListener(WeakListeners.change((ChangeListener)this.calcL, (Object)this.tpMain));
        this.selectedTabIndex = this.tpMain.getSelectedIndex();
        this.excL = new ExceptionPropertyChangeListener();
    }

    public void setCidsBean(final CidsBean cidsBean) {
        if (EventQueue.isDispatchThread()) {
            this.setCidsBeanInternal(cidsBean);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        FgskKartierabschnittEditor.this.setCidsBeanInternal(cidsBean);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private void setCidsBeanInternal(CidsBean cidsBean) {
        if (this.cidsBean != null) {
            this.cidsBean.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.cidsBean = cidsBean;
        cidsBean.addPropertyChangeListener((PropertyChangeListener)this);
        if (!this.readOnly) {
            lastInstance = this;
            lastBean = cidsBean;
            open = true;
        }
        if (cidsBean != null) {
            this.fgskKartierabschnittKartierabschnitt1.setCidsBean(cidsBean);
            this.fgskKartierabschnittLaufentwicklung1.setCidsBean(cidsBean);
            this.fgskKartierabschnittLaengsprofil1.setCidsBean(cidsBean);
            this.fgskKartierabschnittQuerprofil1.setCidsBean(cidsBean);
            this.fgskKartierabschnittSohlenverbau1.setCidsBean(cidsBean);
            this.fgskKartierabschnittUferstruktur1.setCidsBean(cidsBean);
            this.fgskKartierabschnittGewaesserumfeld1.setCidsBean(cidsBean);
            this.fgskKartierabschnittErgebnisse1.setCidsBean(cidsBean);
            this.handleException();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    FgskKartierabschnittEditor.this.refreshLabels();
                }
            }).start();
            this.cidsBean.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.excL, (Object)cidsBean));
        }
        this.fillFooter();
        if (!this.readOnly) {
            Calc.getInstance().removeAllRatings(this.cidsBean);
        }
    }

    public static CidsBean getCurrentlyOpenBean() {
        if (open) {
            return lastBean;
        }
        return null;
    }

    private void fillFooter() {
        if (this.cidsBean != null) {
            Object avUser = this.cidsBean.getProperty("av_user");
            Object avTime = this.cidsBean.getProperty("av_time");
            if (avUser == null) {
                avUser = "(unbekannt)";
            }
            avTime = avTime instanceof Timestamp ? TimestampConverter.getInstance().convertForward((Timestamp)avTime) : "(unbekannt)";
            this.lblFoot.setText("Zuletzt bearbeitet von " + avUser + " am " + avTime);
        } else {
            this.lblFoot.setText("");
        }
    }

    public void refreshLabels() {
        CidsBean statLine = (CidsBean)this.cidsBean.getProperty("linie");
        CidsBean route = (CidsBean)this.cidsBean.getProperty("linie.von.route");
        Boolean isAr = (Boolean)this.cidsBean.getProperty("linie.von.ohne_route");
        String wkk = "<nicht gesetzt>";
        try {
            if (!(statLine == null || route == null || isAr != null && isAr.booleanValue())) {
                Double vonWert = (Double)statLine.getProperty("von.wert");
                Double bisWert = (Double)statLine.getProperty("bis.wert");
                if (vonWert != null && bisWert != null) {
                    double wert = (bisWert + vonWert) / 2.0;
                    WKKSearchBySingleStation search = new WKKSearchBySingleStation(String.valueOf(route.getProperty("id")), String.valueOf(wert));
                    Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
                    ArrayList resArray = (ArrayList)res;
                    if (resArray != null && resArray.size() > 0 && ((ArrayList)resArray.get(0)).size() > 0) {
                        Object o = ((ArrayList)resArray.get(0)).get(0);
                        if (o instanceof String) {
                            wkk = o.toString();
                        }
                    } else {
                        LOG.error((Object)"Server error in getWk_k(). Cids server search return null. See the server logs for further information");
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while determining the water body", (Throwable)e);
        }
        this.setWkk(wkk);
    }

    private void handleException() {
        if (this.cidsBean == null) {
            return;
        }
        boolean exc = FgskKartierabschnittEditor.isException(this.cidsBean);
        for (int i = 1; i < this.tpMain.getTabCount() - 1; ++i) {
            this.tpMain.setEnabledAt(i, !exc);
        }
        if (exc || !this.readOnly) {
            try {
                this.cidsBean.setProperty("punktzahl_gesamt", (Object)0.0);
                this.cidsBean.setProperty("punktzahl_sohle", null);
                this.cidsBean.setProperty("punktzahl_ufer", null);
                this.cidsBean.setProperty("punktzahl_land", null);
                this.cidsBean.setProperty("laufentwicklung_summe_punktzahl", null);
                this.cidsBean.setProperty("laufentwicklung_anzahl_kriterien", null);
                this.cidsBean.setProperty("laengsprofil_summe_punktzahl", null);
                this.cidsBean.setProperty("laengsprofil_anzahl_kriterien", null);
                this.cidsBean.setProperty("querprofil_summe_punktzahl", null);
                this.cidsBean.setProperty("querprofil_anzahl_kriterien", null);
                this.cidsBean.setProperty("sohlenstruktur_summe_punktzahl", null);
                this.cidsBean.setProperty("sohlenstruktur_anzahl_kriterien", null);
                this.cidsBean.setProperty("uferstruktur_summe_punktzahl", null);
                this.cidsBean.setProperty("uferstruktur_anzahl_kriterien", null);
                this.cidsBean.setProperty("uferstruktur_summe_punktzahl_links", null);
                this.cidsBean.setProperty("uferstruktur_anzahl_kriterien_links", null);
                this.cidsBean.setProperty("uferstruktur_summe_punktzahl_rechts", null);
                this.cidsBean.setProperty("uferstruktur_anzahl_kriterien_rechts", null);
                this.cidsBean.setProperty("gewaesserumfeld_summe_punktzahl", null);
                this.cidsBean.setProperty("gewaesserumfeld_anzahl_kriterien", null);
                this.cidsBean.setProperty("gewaesserumfeld_summe_punktzahl_links", null);
                this.cidsBean.setProperty("gewaesserumfeld_anzahl_kriterien_links", null);
                this.cidsBean.setProperty("gewaesserumfeld_summe_punktzahl_rechts", null);
                this.cidsBean.setProperty("gewaesserumfeld_anzahl_kriterien_rechts", null);
                this.fgskKartierabschnittErgebnisse1.refreshGueteklasse();
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while setting a calculation property", (Throwable)ex);
            }
        }
    }

    public static boolean isException(CidsBean kaBean) {
        if (kaBean == null) {
            throw new IllegalArgumentException("cidsBean must not be null");
        }
        CidsBean exception = (CidsBean)kaBean.getProperty("sonderfall_id");
        return exception != null && !Integer.valueOf(0).equals(exception.getProperty("value"));
    }

    public static boolean isPiped(CidsBean kaBean) {
        if (kaBean == null) {
            throw new IllegalArgumentException("cidsBean must not be null");
        }
        CidsBean exception = (CidsBean)kaBean.getProperty("sonderfall_id");
        return exception != null && Integer.valueOf(1).equals(exception.getProperty("value"));
    }

    public static boolean isPreFieldMapping(CidsBean kaBean) {
        Boolean vorkartierung = (Boolean)kaBean.getProperty("vorkatierung");
        return vorkartierung != null && vorkartierung != false;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void initComponents() {
        this.panFooter = new JPanel();
        this.lblFoot = new JLabel();
        this.tpMain = new JTabbedPane();
        this.panKartierabschnitt = new JPanel();
        this.fgskKartierabschnittKartierabschnitt1 = new FgskKartierabschnittKartierabschnitt(this.readOnly);
        this.panLaufentwicklung = new JPanel();
        this.fgskKartierabschnittLaufentwicklung1 = new FgskKartierabschnittLaufentwicklung();
        this.panLaengsprofil = new JPanel();
        this.fgskKartierabschnittLaengsprofil1 = new FgskKartierabschnittLaengsprofil();
        this.panQuerprofil = new JPanel();
        this.fgskKartierabschnittQuerprofil1 = new FgskKartierabschnittQuerprofil();
        this.panSohlenstruktur = new JPanel();
        this.fgskKartierabschnittSohlenverbau1 = new FgskKartierabschnittSohlenverbau();
        this.panUferstruktur = new JPanel();
        this.fgskKartierabschnittUferstruktur1 = new FgskKartierabschnittUferstruktur();
        this.panGewaesserumfeld = new JPanel();
        this.fgskKartierabschnittGewaesserumfeld1 = new FgskKartierabschnittGewaesserumfeld();
        this.panErgebnisse = new JPanel();
        this.fgskKartierabschnittErgebnisse1 = new FgskKartierabschnittErgebnisse();
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new GridBagLayout());
        this.lblFoot.setFont(new Font("Tahoma", 1, 12));
        this.lblFoot.setForeground(new Color(255, 255, 255));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 25, 7, 25);
        this.panFooter.add((Component)this.lblFoot, gridBagConstraints);
        this.setMinimumSize(new Dimension(1100, 780));
        this.setPreferredSize(new Dimension(1100, 780));
        this.setLayout(new BorderLayout());
        this.tpMain.setMinimumSize(new Dimension(1100, 770));
        this.tpMain.setPreferredSize(new Dimension(1100, 770));
        this.panKartierabschnitt.setOpaque(false);
        this.panKartierabschnitt.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.panKartierabschnitt.add((Component)this.fgskKartierabschnittKartierabschnitt1, gridBagConstraints);
        this.tpMain.addTab(NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.panKartierabschnitt.TabConstraints.tabTitle"), this.panKartierabschnitt);
        this.panLaufentwicklung.setOpaque(false);
        this.panLaufentwicklung.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.panLaufentwicklung.add((Component)this.fgskKartierabschnittLaufentwicklung1, gridBagConstraints);
        this.tpMain.addTab(NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.panLaufentwicklung.TabConstraints.tabTitle"), this.panLaufentwicklung);
        this.panLaengsprofil.setOpaque(false);
        this.panLaengsprofil.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.panLaengsprofil.add((Component)this.fgskKartierabschnittLaengsprofil1, gridBagConstraints);
        this.tpMain.addTab(NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.panLaengsprofil.TabConstraints.tabTitle"), this.panLaengsprofil);
        this.panQuerprofil.setOpaque(false);
        this.panQuerprofil.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.panQuerprofil.add((Component)this.fgskKartierabschnittQuerprofil1, gridBagConstraints);
        this.tpMain.addTab(NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.panQuerprofil.TabConstraints.tabTitle"), this.panQuerprofil);
        this.panSohlenstruktur.setOpaque(false);
        this.panSohlenstruktur.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.panSohlenstruktur.add((Component)this.fgskKartierabschnittSohlenverbau1, gridBagConstraints);
        this.tpMain.addTab(NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.panSohlenstruktur.TabConstraints.tabTitle"), this.panSohlenstruktur);
        this.panUferstruktur.setOpaque(false);
        this.panUferstruktur.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.panUferstruktur.add((Component)this.fgskKartierabschnittUferstruktur1, gridBagConstraints);
        this.tpMain.addTab(NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.panUferstruktur.TabConstraints.tabTitle"), this.panUferstruktur);
        this.panGewaesserumfeld.setOpaque(false);
        this.panGewaesserumfeld.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.panGewaesserumfeld.add((Component)this.fgskKartierabschnittGewaesserumfeld1, gridBagConstraints);
        this.tpMain.addTab(NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.panGewaesserumfeld.TabConstraints.tabTitle"), this.panGewaesserumfeld);
        this.panErgebnisse.setOpaque(false);
        this.panErgebnisse.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.panErgebnisse.add((Component)this.fgskKartierabschnittErgebnisse1, gridBagConstraints);
        this.tpMain.addTab(NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.panErgebnisse.TabConstraints.tabTitle"), this.panErgebnisse);
        this.add((Component)this.tpMain, "First");
    }

    public void dispose() {
        if (this.cidsBean != null) {
            this.cidsBean.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.fgskKartierabschnittKartierabschnitt1.dispose();
        this.fgskKartierabschnittLaufentwicklung1.dispose();
        this.fgskKartierabschnittLaengsprofil1.dispose();
        this.fgskKartierabschnittQuerprofil1.dispose();
        this.fgskKartierabschnittSohlenverbau1.dispose();
        this.fgskKartierabschnittUferstruktur1.dispose();
        this.fgskKartierabschnittGewaesserumfeld1.dispose();
        this.fgskKartierabschnittErgebnisse1.dispose();
        if (!this.readOnly) {
            open = false;
        }
    }

    public String getTitle() {
        return NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.getTitle().returnValuePart") + String.valueOf(this.cidsBean);
    }

    public void setTitle(String title) {
    }

    public void editorClosed(EditorClosedEvent event) {
        this.fgskKartierabschnittKartierabschnitt1.editorClosed(event);
    }

    public boolean prepareForSave() {
        boolean res = this.fgskKartierabschnittKartierabschnitt1.prepareForSave();
        res &= this.fgskKartierabschnittQuerprofil1.prepareForSave();
        Double von = (Double)this.cidsBean.getProperty("linie.von.wert");
        Double bis = (Double)this.cidsBean.getProperty("linie.bis.wert");
        if (von != null && bis != null) {
            double length = Math.abs(bis - von);
            if (length < 5.0) {
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Ein Abschnitt darf nicht k\u00fcrzer als 5m sein.", "Warnung", 0);
                return false;
            }
            if (length > 400.0 || length < 50.0) {
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Ein Abschnitt sollte nicht k\u00fcrzer als 50m und nicht l\u00e4nger als 400m sein.", "Warnung", 0);
            }
        }
        if (res && this.cidsBean != null) {
            Object ed;
            try {
                this.cidsBean.setProperty("av_user", (Object)SessionManager.getSession().getUser().toString());
            }
            catch (Exception ex) {
                LOG.error((Object)"Cannot save the current user.", (Throwable)ex);
            }
            try {
                this.cidsBean.setProperty("av_time", (Object)new Timestamp(System.currentTimeMillis()));
            }
            catch (Exception ex) {
                LOG.error((Object)"Cannot save the current time.", (Throwable)ex);
            }
            try {
                this.cidsBean.setProperty("gwk", this.cidsBean.getProperty("linie.von.route.gwk"));
            }
            catch (Exception ex) {
                LOG.error((Object)"Cannot save the current gwk.", (Throwable)ex);
            }
            try {
                if (this.wkk != null) {
                    this.cidsBean.setProperty("wkk", (Object)this.wkk);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Cannot save the current gwk.", (Throwable)ex);
            }
            this.performCalculations(this.tpMain.getComponentAt(this.selectedTabIndex), this.panErgebnisse);
            Boolean vorkartierung = (Boolean)this.cidsBean.getProperty("vorkatierung");
            Integer type = (Integer)this.cidsBean.getProperty("gewaessertyp_id.value");
            if (vorkartierung == null || !vorkartierung.booleanValue()) {
                List<CidsBean> subTypes = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, "gewaessersubtyp");
                if (type != null && (type == 14 || type == 15)) {
                    boolean found = false;
                    if (subTypes != null) {
                        for (CidsBean tmp : subTypes) {
                            String val = (String)tmp.getProperty("value");
                            if (val == null || !val.equals("M") && !val.equals("S")) continue;
                            found = true;
                        }
                    }
                    if (!found) {
                        JOptionPane.showMessageDialog(this, "Der Gew\u00e4ssersubtyp muss M oder S sein, wenn der Gew\u00e4ssertyp 14 oder 15 ist.", "Ung\u00fcltiger Gew\u00e4sseersubtyp", 2);
                        return false;
                    }
                }
                Double ton = (Double)this.cidsBean.getProperty("sohlensubstrat_ton");
                Double sand = (Double)this.cidsBean.getProperty("sohlensubstrat_san");
                Double kies = (Double)this.cidsBean.getProperty("sohlensubstrat_kie");
                Double stein = (Double)this.cidsBean.getProperty("sohlensubstrat_ste");
                Double block = (Double)this.cidsBean.getProperty("sohlensubstrat_blo");
                Double schlamm = (Double)this.cidsBean.getProperty("sohlensubstrat_sch");
                Double torf = (Double)this.cidsBean.getProperty("sohlensubstrat_tor");
                Double toth = (Double)this.cidsBean.getProperty("sohlensubstrat_tot");
                Double wurzeln = (Double)this.cidsBean.getProperty("sohlensubstrat_wur");
                Double kuenstlich = (Double)this.cidsBean.getProperty("sohlensubstrat_kue");
                double ges = this.coalesce(ton, 0.0) + this.coalesce(sand, 0.0) + this.coalesce(kies, 0.0) + this.coalesce(stein, 0.0) + this.coalesce(block, 0.0) + this.coalesce(schlamm, 0.0) + this.coalesce(torf, 0.0) + this.coalesce(toth, 0.0) + this.coalesce(wurzeln, 0.0) + this.coalesce(kuenstlich, 0.0);
                if (ges != 0.0 && ges != 100.0) {
                    JOptionPane.showMessageDialog(this, "Die Summe der Sohlsubstrate muss entweder 100 oder 0 ergeben.", "Ung\u00fcltige Sohlsubstrate", 2);
                    return false;
                }
            }
            if ((ed = this.cidsBean.getProperty("erfassungsdatum")) instanceof Date) {
                Date year2010 = new Date(110, 0, 1, 0, 0, 0);
                Date now = new Date();
                Date today = new Date(now.getYear(), now.getMonth(), now.getDate(), 23, 59, 59);
                if (((Date)ed).after(today) || ((Date)ed).before(year2010)) {
                    JOptionPane.showMessageDialog(this, "Die Erfassungszeit muss zwischen 2010 und jetzt sein.", "Ung\u00fcltige Erfassungszeit", 2);
                    return false;
                }
            }
        }
        return res;
    }

    private Double coalesce(Double value, Double def) {
        return value == null ? def : value;
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    public void setWkk(String wkk) {
        this.wkk = wkk == null ? "" : wkk;
        this.fgskKartierabschnittKartierabschnitt1.setWkk(wkk);
        this.fgskKartierabschnittGewaesserumfeld1.setWkk(wkk);
        this.fgskKartierabschnittLaengsprofil1.setWkk(wkk);
        this.fgskKartierabschnittLaufentwicklung1.setWkk(wkk);
        this.fgskKartierabschnittQuerprofil1.setWkk(wkk);
        this.fgskKartierabschnittSohlenverbau1.setWkk(wkk);
        this.fgskKartierabschnittUferstruktur1.setWkk(wkk);
        this.fgskKartierabschnittErgebnisse1.setWkk(wkk);
    }

    public static void main(String[] args) throws Exception {
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost((String)"WRRL_DB_MV", (String)"Administratoren", (String)"admin", (String)"sb", (String)"fgsk_kartierabschnitt", (int)2821, (int)1280, (int)1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCalculations(Component leftC, Component enteredC) {
        block60: {
            if (this.readOnly || FgskKartierabschnittEditor.isException(this.cidsBean) || FgskKartierabschnittEditor.isPreFieldMapping(this.cidsBean)) {
                if (!this.readOnly && FgskKartierabschnittEditor.isException(this.cidsBean)) {
                    Calc.getInstance().removeAllRatings(this.cidsBean);
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("editor tab selection changed from old comp: " + leftC + "to new comp: " + enteredC));
            }
            String name = null;
            try {
                if (this.panErgebnisse.equals(enteredC)) {
                    block59: {
                        block58: {
                            block57: {
                                try {
                                    Calc.getInstance().calcWBEnvRating(this.cidsBean);
                                }
                                catch (ValidationException ex) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"cannot calculate wb env rating", (Throwable)ex);
                                    }
                                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.envRatingNotPossible.message"), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.envRatingNotPossible.title"), 1);
                                    this.selectedTabIndex = this.tpMain.getSelectedIndex();
                                    return;
                                }
                                try {
                                    Calc.getInstance().calcWBLongProfileRating(this.cidsBean);
                                }
                                catch (ValidationException ex) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"cannot calculate long profile rating", (Throwable)ex);
                                    }
                                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.longProfileRatingNotPossible.message"), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.longProfileRatingNotPossible.title"), 1);
                                    this.selectedTabIndex = this.tpMain.getSelectedIndex();
                                    return;
                                }
                                try {
                                    Calc.getInstance().calcCourseEvoRating(this.cidsBean);
                                }
                                catch (ValidationException ex) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"cannot calculate course evolution rating", (Throwable)ex);
                                    }
                                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.courseEvoRatingNotPossible.message"), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.courseEvoRatingNotPossible.title"), 1);
                                    this.selectedTabIndex = this.tpMain.getSelectedIndex();
                                    return;
                                }
                                try {
                                    Calc.getInstance().calcWBCrossProfileRating(this.cidsBean);
                                }
                                catch (ValidationException ex) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"cannot calculate cross profile rating", (Throwable)ex);
                                    }
                                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.crossProfileRatingNotPossible.message"), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.crossProfileRatingNotPossible.title"), 1);
                                    this.selectedTabIndex = this.tpMain.getSelectedIndex();
                                    return;
                                }
                                try {
                                    Calc.getInstance().calcBedStructureRating(this.cidsBean);
                                }
                                catch (ValidationException ex) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"cannot calculate bed structure rating", (Throwable)ex);
                                    }
                                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.bedStructureRatingNotPossible.message"), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.bedStructureRatingNotPossible.title"), 1);
                                    this.selectedTabIndex = this.tpMain.getSelectedIndex();
                                    return;
                                }
                                try {
                                    Calc.getInstance().calcBankStructureRating(this.cidsBean);
                                }
                                catch (ValidationException ex) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"cannot calculate bank structure rating", (Throwable)ex);
                                    }
                                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.bankStructureRatingNotPossible.message"), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.bankStructureRatingNotPossible.title"), 1);
                                    this.selectedTabIndex = this.tpMain.getSelectedIndex();
                                    return;
                                }
                                try {
                                    Calc.getInstance().calcBedRating(this.cidsBean);
                                }
                                catch (ValidationException e) {
                                    if (!LOG.isDebugEnabled()) break block57;
                                    LOG.debug((Object)"cannot calculate bed rating", (Throwable)e);
                                }
                            }
                            try {
                                Calc.getInstance().calcBankRating(this.cidsBean);
                            }
                            catch (ValidationException e) {
                                if (!LOG.isDebugEnabled()) break block58;
                                LOG.debug((Object)"cannot calculate bank rating", (Throwable)e);
                            }
                        }
                        try {
                            Calc.getInstance().calcEnvRating(this.cidsBean);
                        }
                        catch (ValidationException e) {
                            if (!LOG.isDebugEnabled()) break block59;
                            LOG.debug((Object)"cannot calculate env rating", (Throwable)e);
                        }
                    }
                    try {
                        Calc.getInstance().calcOverallRating(this.cidsBean);
                    }
                    catch (ValidationException ex) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"cannot calculate overall rating", (Throwable)ex);
                        }
                        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.overallRatingNotPossible.message"), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.overallRatingNotPossible.title"), 1);
                    }
                    break block60;
                }
                if (this.panGewaesserumfeld.equals(leftC)) {
                    name = NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.name.wbenv");
                    Calc.getInstance().calcWBEnvRating(this.cidsBean);
                    this.fgskKartierabschnittErgebnisse1.setCidsBean(this.cidsBean);
                } else if (this.panLaengsprofil.equals(leftC)) {
                    name = NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.name.longProfile");
                    Calc.getInstance().calcWBLongProfileRating(this.cidsBean);
                } else if (this.panLaufentwicklung.equals(leftC)) {
                    name = NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.name.courseEvo");
                    Calc.getInstance().calcCourseEvoRating(this.cidsBean);
                } else if (this.panQuerprofil.equals(leftC)) {
                    name = NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.name.crossProfile");
                    Calc.getInstance().calcWBCrossProfileRating(this.cidsBean);
                } else if (this.panSohlenstruktur.equals(leftC)) {
                    name = NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.name.bedStructure");
                    Calc.getInstance().calcBedStructureRating(this.cidsBean);
                } else if (this.panUferstruktur.equals(leftC)) {
                    name = NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.name.bankStructure");
                    Calc.getInstance().calcBankStructureRating(this.cidsBean);
                }
            }
            catch (ValidationException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("cannot calculate rating: " + name), (Throwable)ex);
                }
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.ratingNotPossible.message", name), NbBundle.getMessage(FgskKartierabschnittEditor.class, (String)"FgskKartierabschnittEditor.CalcListener.stateChanged.ratingNotPossible.title", (Object)name), 1);
            }
            catch (Exception ex) {
                LOG.error((Object)"unexpected exception during calculation", (Throwable)ex);
            }
            finally {
                this.selectedTabIndex = this.tpMain.getSelectedIndex();
            }
        }
        if (this.selectedTabIndex == 7) {
            this.fgskKartierabschnittErgebnisse1.refreshGueteklasse();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("linie")) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    FgskKartierabschnittEditor.this.refreshLabels();
                }
            }).start();
        }
    }

    public BeanInitializer getBeanInitializer() {
        return new KartierabschnittInitializer(this.cidsBean);
    }

    private final class CalcListener
    implements ChangeListener {
        private CalcListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Component leftC = FgskKartierabschnittEditor.this.tpMain.getComponentAt(FgskKartierabschnittEditor.this.selectedTabIndex);
            Component enteredC = FgskKartierabschnittEditor.this.tpMain.getSelectedComponent();
            FgskKartierabschnittEditor.this.performCalculations(leftC, enteredC);
        }
    }

    private final class ExceptionPropertyChangeListener
    implements PropertyChangeListener {
        private ExceptionPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt != null && "sonderfall_id".equals(evt.getPropertyName())) {
                FgskKartierabschnittEditor.this.handleException();
            }
        }
    }

    private class KartierabschnittInitializer
    extends DefaultBeanInitializer
    implements BeanInitializerForcePaste {
        public KartierabschnittInitializer(CidsBean cidsBean) {
            super(cidsBean);
        }

        public void initializeBean(CidsBean beanToInit) throws Exception {
            super.initializeBean(beanToInit);
            if (lastInstance != null) {
                lastInstance.setCidsBean(beanToInit);
            }
        }

        protected void processSimpleProperty(CidsBean beanToInit, String propertyName, Object simpleValueToProcess) throws Exception {
            if (propertyName.equalsIgnoreCase("av_user") || propertyName.equalsIgnoreCase("av_date") || propertyName.equalsIgnoreCase("gewaesser_abschnitt") || propertyName.equalsIgnoreCase("foto_nr")) {
                return;
            }
            super.processSimpleProperty(beanToInit, propertyName, simpleValueToProcess);
        }

        protected void processArrayProperty(CidsBean beanToInit, String propertyName, Collection<CidsBean> arrayValueToProcess) throws Exception {
            List<CidsBean> beans = CidsBeanSupport.getBeanCollectionFromProperty(beanToInit, propertyName);
            beans.clear();
            for (CidsBean tmp : arrayValueToProcess) {
                beans.add(tmp);
            }
        }

        protected void processComplexProperty(CidsBean beanToInit, String propertyName, CidsBean complexValueToProcess) throws Exception {
            if (propertyName.equals("linie") || propertyName.equals("fliessrichtung_id")) {
                return;
            }
            beanToInit.setProperty(propertyName, (Object)complexValueToProcess);
        }
    }
}

