/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.MassnahmenBand;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.jbands.JBand;
import de.cismet.tools.gui.jbands.SimpleBandModel;
import de.cismet.tools.gui.jbands.interfaces.Band;
import de.cismet.tools.gui.jbands.interfaces.BandModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class GupGewaesserPreview
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener {
    private static final Logger LOG = Logger.getLogger(GupGewaesserPreview.class);
    private static final MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_planungsabschnitt");
    private static final String GUP_MASSNAHME = "gup_unterhaltungsmassnahme";
    public static final int GUP_MASSNAHME_UFER_LINKS = 2;
    public static final int GUP_MASSNAHME_UFER_RECHTS = 1;
    public static final int GUP_MASSNAHME_UMFELD_RECHTS = 4;
    public static final int GUP_MASSNAHME_UMFELD_LINKS = 3;
    public static final int GUP_MASSNAHME_SOHLE = 5;
    private CidsBean cidsBean;
    private boolean readOnly = false;
    private String beanName = "";
    private final JBand band = new JBand(true);
    private final SimpleBandModel bandModel = new SimpleBandModel();
    private final MassnahmenBand rechtesUferBand = new MassnahmenBand("Ufer rechts", "gup_unterhaltungsmassnahme", Boolean.TRUE);
    private final MassnahmenBand sohleBand = new MassnahmenBand("Sohle", "gup_unterhaltungsmassnahme", null);
    private final MassnahmenBand linkesUferBand = new MassnahmenBand("Ufer links", "gup_unterhaltungsmassnahme", Boolean.FALSE);
    private RoundedPanel glassPanel;
    private JLabel lblGewName;
    private JPanel panBand;

    public GupGewaesserPreview() {
        this(false);
    }

    public GupGewaesserPreview(boolean readOnly) {
        this.readOnly = readOnly;
        this.initComponents();
        this.band.setModel((BandModel)this.bandModel);
        this.bandModel.addBand((Band)this.rechtesUferBand);
        this.bandModel.addBand((Band)this.sohleBand);
        this.bandModel.addBand((Band)this.linkesUferBand);
    }

    private void initComponents() {
        this.lblGewName = new JLabel();
        this.glassPanel = new RoundedPanel();
        this.panBand = new JPanel();
        this.setMinimumSize(new Dimension(775, 142));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(900, 142));
        this.setLayout(new GridBagLayout());
        this.lblGewName.setFont(new Font("DejaVu Sans", 1, 18));
        this.lblGewName.setMaximumSize(new Dimension(200, 50));
        this.lblGewName.setMinimumSize(new Dimension(200, 50));
        this.lblGewName.setPreferredSize(new Dimension(200, 50));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 15, 5, 50);
        this.add((Component)this.lblGewName, gridBagConstraints);
        this.glassPanel.setAlpha(0);
        this.glassPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GupGewaesserPreview.this.glassPanelMouseClicked(evt);
            }
        });
        this.glassPanel.setLayout((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.glassPanel, gridBagConstraints);
        this.panBand.setMaximumSize(new Dimension(610, 142));
        this.panBand.setMinimumSize(new Dimension(610, 142));
        this.panBand.setOpaque(false);
        this.panBand.setPreferredSize(new Dimension(610, 142));
        this.panBand.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GupGewaesserPreview.this.panBandMouseClicked(evt);
            }
        });
        this.panBand.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 0);
        this.add((Component)this.panBand, gridBagConstraints);
    }

    private void panBandMouseClicked(MouseEvent evt) {
        if (this.cidsBean != null) {
            ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObject(this.cidsBean.getMetaObject(), "");
        }
    }

    private void glassPanelMouseClicked(MouseEvent evt) {
        if (this.cidsBean != null && this.readOnly) {
            ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObject(this.cidsBean.getMetaObject(), "");
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            this.glassPanel.setCursor(Cursor.getPredefinedCursor(12));
            List all = cidsBean.getBeanCollectionProperty("massnahmen");
            ArrayList<CidsBean> rechtesUferList = new ArrayList<CidsBean>();
            ArrayList<CidsBean> sohleList = new ArrayList<CidsBean>();
            ArrayList<CidsBean> linkesUferList = new ArrayList<CidsBean>();
            for (CidsBean tmp : all) {
                Integer kind = (Integer)tmp.getProperty("wo.id");
                switch (kind) {
                    case 2: {
                        linkesUferList.add(tmp);
                        break;
                    }
                    case 1: {
                        rechtesUferList.add(tmp);
                        break;
                    }
                    case 5: {
                        sohleList.add(tmp);
                    }
                }
            }
            this.rechtesUferBand.setCidsBeans(rechtesUferList);
            this.sohleBand.setCidsBeans(sohleList);
            this.linkesUferBand.setCidsBeans(linkesUferList);
            this.panBand.add((Component)this.band, "Center");
            this.bandModel.fireBandModelValuesChanged();
            this.bandModel.fireBandModelChanged();
            this.band.updateUI();
            this.panBand.updateUI();
            this.band.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    GupGewaesserPreview.this.panBandMouseClicked(evt);
                }
            });
        }
    }

    public void loadCidsBean(final int id) {
        CismetThreadPool.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String query = "select " + MC.getID() + ", " + MC.getPrimaryKey() + " from " + MC.getTableName();
                    query = query + " WHERE id = " + id;
                    final MetaObject metaObject = SessionManager.getProxy().getMetaObject(id, MC.getId(), MC.getDomain());
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GupGewaesserPreview.this.setCidsBean(metaObject.getBean());
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while loading planungsabschnitt", (Throwable)e);
                }
            }
        });
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
        this.lblGewName.setText(beanName);
    }

    public void dispose() {
        this.band.dispose();
    }

    public String getTitle() {
        return "Gew\u00e4sser";
    }

    public void setTitle(String title) {
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        return true;
    }
}

