/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupWasserkoerper;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WkSearchByStations;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.GupHelper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.gui.RoundedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class GupGewaesserWrrl
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener {
    private static final Logger LOG = Logger.getLogger(GupGewaesserWrrl.class);
    private static final MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_fg");
    private CidsBean cidsBean;
    private boolean readOnly = false;
    private RoundedPanel glassPanel;
    private JPanel panGewaesserInner;
    private JScrollPane scrollGewaesser;

    public GupGewaesserWrrl() {
        this(false);
    }

    public GupGewaesserWrrl(boolean readOnly) {
        this.readOnly = readOnly;
        this.initComponents();
        this.scrollGewaesser.getViewport().setOpaque(false);
        this.setReadOnly(readOnly);
    }

    private void initComponents() {
        this.scrollGewaesser = new JScrollPane();
        this.panGewaesserInner = new JPanel();
        this.glassPanel = new RoundedPanel();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(994, 800));
        this.setLayout(new GridBagLayout());
        this.scrollGewaesser.setBorder(null);
        this.scrollGewaesser.setOpaque(false);
        this.panGewaesserInner.setBorder(null);
        this.panGewaesserInner.setMinimumSize(new Dimension(100, 100));
        this.panGewaesserInner.setOpaque(false);
        this.scrollGewaesser.setViewportView(this.panGewaesserInner);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.scrollGewaesser, gridBagConstraints);
        this.glassPanel.setAlpha(0);
        this.glassPanel.setLayout((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.glassPanel, gridBagConstraints);
    }

    public static void main(String[] args) {
        try {
            DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost((String)"WRRL_DB_MV", (String)"Administratoren", (String)"admin", (String)"sb", (String)"gup_gewaesserabschnitt", (int)1, (int)1280, (int)1024);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    GupGewaesserWrrl.this.refreshFields();
                }
            }).start();
        }
    }

    public void refreshFields() {
        try {
            CidsBean route;
            CidsBean statVon;
            final ArrayList<String> wkkList = new ArrayList<String>();
            CidsBean statLine = GupHelper.getStationLinie(this.cidsBean);
            if (statLine != null && (statVon = (CidsBean)statLine.getProperty("von")) != null && (route = (CidsBean)statVon.getProperty("route")) != null) {
                WkSearchByStations searchWK = new WkSearchByStations(GupHelper.getMinStart(this.cidsBean), GupHelper.getMaxEnd(this.cidsBean), String.valueOf(route.getProperty("gwk")));
                Collection resWK = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)searchWK);
                ArrayList resArray = (ArrayList)resWK;
                if (resArray != null && resArray.size() > 0 && ((ArrayList)resArray.get(0)).size() > 0) {
                    String wkkCond = null;
                    for (ArrayList tmp : resArray) {
                        Object o = tmp.get(0);
                        if (!(o instanceof String)) continue;
                        wkkList.add(o.toString());
                        if (wkkCond == null) {
                            wkkCond = "wk_k = '" + o.toString() + "'";
                            continue;
                        }
                        wkkCond = wkkCond + " OR wk_k = '" + o.toString() + "'";
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (wkkList != null && wkkList.size() > 0) {
                                GupGewaesserWrrl.this.panGewaesserInner.setLayout(new FlowLayout());
                                for (String mo : wkkList) {
                                    GupWasserkoerper tmp = new GupWasserkoerper();
                                    tmp.setBeanName(mo);
                                    GupGewaesserWrrl.this.panGewaesserInner.add(tmp);
                                }
                            }
                        }
                    });
                } else {
                    LOG.error((Object)"Server error in getWk_k(). Cids server search return null. See the server logs for further information");
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Problem beim Suchen der Wasserkoerper", (Throwable)e);
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.glassPanel.addMouseListener((MouseListener)new MouseAdapter(){});
        } else {
            for (MouseListener ml : this.glassPanel.getMouseListeners()) {
                this.glassPanel.removeMouseListener(ml);
            }
        }
    }

    public void dispose() {
    }

    public String getTitle() {
        return "WRRL";
    }

    public void setTitle(String title) {
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        return true;
    }
}

