/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.wrrl_db_mv.util.RendererTools;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.DocumentDropList;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.GupHelper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.gui.RoundedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.openide.util.NbBundle;

public class GupGewaesserabschnittAllgemein
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener {
    private static final Logger LOG = Logger.getLogger(GupGewaesserabschnittAllgemein.class);
    private CidsBean cidsBean;
    private boolean readOnly = false;
    private RoundedPanel glassPanel;
    private JButton jbAdd;
    private JButton jbDownload;
    private JList jlObjectList;
    private JPanel jpControl;
    private JButton jpDelete;
    private JScrollPane jsObjectList;
    private JLabel lblGewaessername;
    private JLabel lblGwk;
    private JLabel lblObjectList;
    private JTextField txtGewaessername;
    private JTextField txtGwk;
    private BindingGroup bindingGroup;

    public GupGewaesserabschnittAllgemein() {
        this(false);
    }

    public GupGewaesserabschnittAllgemein(boolean readOnly) {
        this.readOnly = readOnly;
        this.initComponents();
        if (readOnly) {
            RendererTools.makeReadOnly(this.txtGewaessername);
        }
        this.jpDelete.setEnabled(!readOnly);
        this.jbAdd.setEnabled(!readOnly);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.lblGewaessername = new JLabel();
        this.lblGwk = new JLabel();
        this.lblObjectList = new JLabel();
        this.txtGewaessername = new JTextField();
        this.txtGwk = new JTextField();
        this.jsObjectList = new JScrollPane();
        this.jlObjectList = new DocumentDropList(this.readOnly, "dokumente");
        this.jpControl = new JPanel();
        this.jbDownload = new JButton();
        this.jpDelete = new JButton();
        this.jbAdd = new JButton();
        this.glassPanel = new RoundedPanel();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(994, 300));
        this.setLayout(new GridBagLayout());
        this.lblGewaessername.setText(NbBundle.getMessage(GupGewaesserabschnittAllgemein.class, (String)"GupGewaesserabschnittAllgemein.lblGewaessername.text"));
        this.lblGewaessername.setMaximumSize(new Dimension(170, 17));
        this.lblGewaessername.setMinimumSize(new Dimension(170, 17));
        this.lblGewaessername.setPreferredSize(new Dimension(170, 17));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(25, 15, 5, 5);
        this.add((Component)this.lblGewaessername, gridBagConstraints);
        this.lblGwk.setText(NbBundle.getMessage(GupGewaesserabschnittAllgemein.class, (String)"GupGewaesserabschnittAllgemein.lblGwk.text"));
        this.lblGwk.setMaximumSize(new Dimension(170, 17));
        this.lblGwk.setMinimumSize(new Dimension(170, 17));
        this.lblGwk.setPreferredSize(new Dimension(170, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.add((Component)this.lblGwk, gridBagConstraints);
        this.lblObjectList.setText(NbBundle.getMessage(GupGewaesserabschnittAllgemein.class, (String)"GupGewaesserabschnittAllgemein.lblObjectList.text"));
        this.lblObjectList.setMaximumSize(new Dimension(170, 17));
        this.lblObjectList.setMinimumSize(new Dimension(170, 17));
        this.lblObjectList.setPreferredSize(new Dimension(170, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.add((Component)this.lblObjectList, gridBagConstraints);
        this.txtGewaessername.setMaximumSize(new Dimension(280, 20));
        this.txtGewaessername.setMinimumSize(new Dimension(280, 20));
        this.txtGewaessername.setPreferredSize(new Dimension(380, 20));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtGewaessername, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(25, 5, 5, 15);
        this.add((Component)this.txtGewaessername, gridBagConstraints);
        this.txtGwk.setEnabled(false);
        this.txtGwk.setMaximumSize(new Dimension(280, 20));
        this.txtGwk.setMinimumSize(new Dimension(280, 20));
        this.txtGwk.setPreferredSize(new Dimension(380, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.add((Component)this.txtGwk, gridBagConstraints);
        ELProperty eLProperty = ELProperty.create((String)"${cidsBean.dokumente}");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JList)this.jlObjectList);
        jListBinding.setSourceNullValue(null);
        jListBinding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.jsObjectList.setViewportView(this.jlObjectList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.add((Component)this.jsObjectList, gridBagConstraints);
        this.jpControl.setOpaque(false);
        this.jpControl.setLayout(new GridBagLayout());
        this.jbDownload.setText(NbBundle.getMessage(GupGewaesserabschnittAllgemein.class, (String)"GupGewaesserabschnittAllgemein.jbDownload.text"));
        this.jbDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupGewaesserabschnittAllgemein.this.jbDownloadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 15, 15);
        this.jpControl.add((Component)this.jbDownload, gridBagConstraints);
        this.jpDelete.setText(NbBundle.getMessage(GupGewaesserabschnittAllgemein.class, (String)"GupGewaesserabschnittAllgemein.jpDelete.text"));
        this.jpDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupGewaesserabschnittAllgemein.this.jpDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 15, 0);
        this.jpControl.add((Component)this.jpDelete, gridBagConstraints);
        this.jbAdd.setText(NbBundle.getMessage(GupGewaesserabschnittAllgemein.class, (String)"GupGewaesserabschnittAllgemein.jbAdd.text"));
        this.jbAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupGewaesserabschnittAllgemein.this.jbAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 15, 15);
        this.jpControl.add((Component)this.jbAdd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.add((Component)this.jpControl, gridBagConstraints);
        this.glassPanel.setAlpha(0);
        this.glassPanel.setLayout((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        this.add((Component)this.glassPanel, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void jpDeleteActionPerformed(ActionEvent evt) {
        if (this.readOnly) {
            return;
        }
        int[] selection = this.jlObjectList.getSelectedIndices();
        int count = 0;
        for (int index : selection) {
            ((DocumentDropList)this.jlObjectList).removeObject(index - count++);
        }
    }

    private void jbDownloadActionPerformed(ActionEvent evt) {
        ((DocumentDropList)this.jlObjectList).downloadSelectedDocs();
    }

    private void jbAddActionPerformed(ActionEvent evt) {
        if (!this.readOnly) {
            JFileChooser chooser = new JFileChooser();
            chooser.setMultiSelectionEnabled(true);
            chooser.showDialog(this, "Hinzuf\u00fcgen");
            File[] files = chooser.getSelectedFiles();
            ((DocumentDropList)this.jlObjectList).addFiles(Arrays.asList(files));
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            ((DocumentDropList)this.jlObjectList).setCidsBean(cidsBean);
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean);
            this.bindingGroup.bind();
            this.refreshLabels();
        }
    }

    public void refreshLabels() {
        String gwk = "";
        String gewName = "";
        try {
            CidsBean route;
            CidsBean statVon;
            CidsBean statLine = GupHelper.getStationLinie(this.cidsBean);
            if (statLine != null && (statVon = (CidsBean)statLine.getProperty("von")) != null && (route = (CidsBean)statVon.getProperty("route")) != null) {
                gwk = route.getProperty("gwk").toString();
                gewName = route.getProperty("routenname").toString();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while determining the water body", (Throwable)e);
        }
        final String gwkV = gwk;
        String gewNameV = gewName;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GupGewaesserabschnittAllgemein.this.txtGwk.setText(gwkV);
            }
        });
    }

    public void dispose() {
        this.bindingGroup.unbind();
    }

    public String getTitle() {
        return "Allgemeine Informationen";
    }

    public void setTitle(String title) {
    }

    public void editorClosed(EditorClosedEvent event) {
        ((DocumentDropList)this.jlObjectList).editorClosed(event);
    }

    public boolean prepareForSave() {
        return ((DocumentDropList)this.jlObjectList).prepareForSave();
    }

    public static void main(String[] args) {
        try {
            DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost((String)"WRRL_DB_MV", (String)"Administratoren", (String)"admin", (String)"x", (String)"gup_gewaesserabschnitt", (int)1, (int)1280, (int)1024);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

