/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.gui.RoundedPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URI;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class GupHydrologieEditor
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener,
MouseListener,
MouseMotionListener {
    private static final Logger LOG = Logger.getLogger(GupHydrologieEditor.class);
    private CidsBean cidsBean;
    private boolean readOnly = false;
    private HydroTableModel hydroModel = new HydroTableModel();
    private RoundedPanel glassPanel;
    private JScrollPane jScrollPane2;
    private JXTable jxPegel;

    public GupHydrologieEditor() {
        this(false);
    }

    public GupHydrologieEditor(boolean readOnly) {
        this.readOnly = readOnly;
        this.initComponents();
        this.setReadOnly(readOnly);
        this.jxPegel.setModel((TableModel)this.hydroModel);
        this.jxPegel.getColumn(11).setCellRenderer(new GanglinieRenderer());
        this.jxPegel.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/pegel.png"));
                JLabel lab = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                lab.setIcon(icon);
                return lab;
            }
        });
        this.jxPegel.setAutoResizeMode(3);
        this.jxPegel.getColumnModel().getColumn(0).setPreferredWidth(140);
        this.jxPegel.getColumnModel().getColumn(1).setPreferredWidth(140);
        this.jxPegel.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.jxPegel.getColumnModel().getColumn(3).setPreferredWidth(55);
        this.jxPegel.getColumnModel().getColumn(4).setPreferredWidth(55);
        this.jxPegel.getColumnModel().getColumn(5).setPreferredWidth(55);
        this.jxPegel.getColumnModel().getColumn(6).setPreferredWidth(55);
        this.jxPegel.getColumnModel().getColumn(7).setPreferredWidth(55);
        this.jxPegel.getColumnModel().getColumn(8).setPreferredWidth(55);
        this.jxPegel.getColumnModel().getColumn(9).setPreferredWidth(55);
        this.jxPegel.getColumnModel().getColumn(10).setPreferredWidth(55);
        this.jxPegel.getColumnModel().getColumn(11).setPreferredWidth(200);
        Highlighter alternateRowHighlighter = HighlighterFactory.createAlternateStriping((Color)new Color(208, 208, 208), (Color)new Color(144, 144, 144));
        this.jxPegel.setHighlighters(new Highlighter[]{alternateRowHighlighter, new LinkHighlighter()});
        this.jxPegel.addMouseListener((MouseListener)this);
        this.jxPegel.addMouseMotionListener((MouseMotionListener)this);
        this.jxPegel.setOpaque(false);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jxPegel = new JXTable();
        this.glassPanel = new RoundedPanel();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(994, 800));
        this.setLayout(new GridBagLayout());
        this.jScrollPane2.setViewportView((Component)this.jxPegel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 20, 15, 20);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.glassPanel.setAlpha(0);
        this.glassPanel.setLayout((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.glassPanel, gridBagConstraints);
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            // empty if block
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.glassPanel.addMouseListener((MouseListener)new MouseAdapter(){});
        } else {
            for (MouseListener ml : this.glassPanel.getMouseListeners()) {
                this.glassPanel.removeMouseListener(ml);
            }
        }
    }

    public void dispose() {
    }

    public String getTitle() {
        return "Hydrologische Kenngr\u00f6\u00dfen";
    }

    public void setTitle(String title) {
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int col = this.jxPegel.columnAtPoint(e.getPoint());
        if (col == 11) {
            try {
                Desktop.getDesktop().browse(URI.create("http://localhost/~thorsten/cids/web/gup/GWUTollense-Los1-5.pdf"));
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while starting download.", (Throwable)ex);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int col = this.jxPegel.columnAtPoint(e.getPoint());
        int row = this.jxPegel.rowAtPoint(e.getPoint());
        if (col == 11 && row != -1) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class GanglinieRenderer
    extends DefaultTableCellRenderer {
        private GanglinieRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/ganglinie.png"));
            JLabel lab = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            lab.setIcon(icon);
            return lab;
        }
    }

    private class LinkHighlighter
    implements Highlighter {
        private LinkHighlighter() {
        }

        public Component highlight(Component renderer, ComponentAdapter adapter) {
            if (renderer instanceof GanglinieRenderer) {
                GanglinieRenderer tmp = (GanglinieRenderer)renderer;
                tmp.setForeground(Color.BLUE);
            }
            return renderer;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public ChangeListener[] getChangeListeners() {
            return new ChangeListener[0];
        }
    }

    private class HydroTableModel
    extends AbstractTableModel {
        private String[] header = new String[]{"Bezeichnung Pegel", "Station", "Einz-Geb.", "NW", "MW", "HWx", "HHW", "NQ", "MQ", "HQx", "HHQ", "Ganglinie"};
        private String[][] data = new String[][]{{"Pegel A", "15700 m", "180 km\u00b2", "0.45", "0.51", "1.20", "1.82", "0.12", "2.25", "9.20", "14.40", "Ganglinie Pegel A"}, {"Pegel B", "38500 m", "180 km\u00b2", "0.20", "0.45", "0.83", "1.14", "0.00", "0.58", "3.94", "11.10", "Ganglinie Pegel B"}, {"Pegel C", "48500 m", "120 km\u00b2", "0.30", "0.55", "0.95", "1.24", "0.10", "0.55", "2.94", "9.10", "Ganglinie Pegel C"}, {"Pegel D", "53800 m", "150 km\u00b2", "0.28", "0.37", "0.77", "1.04", "0.00", "0.57", "3.83", "10.07", "Ganglinie Pegel D"}, {"Pegel E", "53800 m", "150 km\u00b2", "0.28", "0.37", "0.77", "1.04", "0.00", "0.57", "3.83", "10.07", "Ganglinie Pegel E"}, {"Pegel F", "57500 m", "50 km\u00b2", "0.38", "0.37", "0.87", "1.24", "0.10", "0.75", "2.64", "5.86", "Ganglinie Pegel F"}, {"Pegel G", "57500 m", "50 km\u00b2", "0.38", "0.37", "0.87", "1.24", "0.10", "0.75", "2.64", "5.86", "Ganglinie Pegel G"}, {"Pegel H", "53800 m", "150 km\u00b2", "0.28", "0.37", "0.77", "1.04", "0.00", "0.57", "3.83", "10.07", "Ganglinie Pegel H"}, {"Pegel I", "48500 m", "120 km\u00b2", "0.30", "0.55", "0.95", "1.24", "0.10", "0.55", "2.94", "9.10", "Ganglinie Pegel I"}, {"Pegel J", "38500 m", "180 km\u00b2", "0.20", "0.45", "0.83", "1.14", "0.00", "0.58", "3.94", "11.10", "Ganglinie Pegel J"}, {"Pegel K", "57500 m", "50 km\u00b2", "0.38", "0.37", "0.87", "1.24", "0.10", "0.75", "2.64", "5.86", "Ganglinie Pegel K"}, {"Pegel L", "57500 m", "50 km\u00b2", "0.38", "0.37", "0.87", "1.24", "0.10", "0.75", "2.64", "5.86", "Ganglinie Pegel L"}, {"Pegel M", "57500 m", "50 km\u00b2", "0.38", "0.37", "0.87", "1.24", "0.10", "0.75", "2.64", "5.86", "Ganglinie Pegel M"}, {"Pegel N", "53800 m", "150 km\u00b2", "0.28", "0.37", "0.77", "1.04", "0.00", "0.57", "3.83", "10.07", "Ganglinie Pegel N"}, {"Pegel O", "48500 m", "120 km\u00b2", "0.30", "0.55", "0.95", "1.24", "0.10", "0.55", "2.94", "9.10", "Ganglinie Pegel O"}, {"Pegel P", "48500 m", "120 km\u00b2", "0.30", "0.55", "0.95", "1.24", "0.10", "0.55", "2.94", "9.10", "Ganglinie Pegel P"}};

        private HydroTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.header.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex < this.header.length) {
                return this.header[columnIndex];
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < this.data.length && columnIndex < this.header.length) {
                return this.data[rowIndex][columnIndex];
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }
}

