/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.types.treenode.DefaultMetaTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.reports.LosReport;
import de.cismet.cids.custom.wrrl_db_mv.server.search.MassnahmenSearch;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.ExpressionEvaluator;
import de.cismet.cids.custom.wrrl_db_mv.util.RendererTools;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.GaebDownload;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.CalculationCache;
import de.cismet.tools.Calculator;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.TitleComponentProvider;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class GupLosEditor
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener,
TitleComponentProvider {
    private static final Logger LOG = Logger.getLogger(GupLosEditor.class);
    private static CalculationCache<List, ArrayList<ArrayList>> massnCache = new CalculationCache((Calculator)new MassnCalculator());
    private static final int UNUSED_ATTRIBUTE_FIELDS = 10;
    public static final int PLANUNGSABSCHNITT_VON = 0;
    public static final int PLANUNGSABSCHNITT_BIS = 1;
    public static final int GUP_NAME = 2;
    public static final int PLANUNGSABSCHNITT_NAME = 3;
    public static final int MASSNAHMENART_NAME = 4;
    public static final int MASSNAHMENBEZUG = 5;
    public static final int MASSNAHME_VON = 6;
    public static final int MASSNAHME_BIS = 7;
    public static final int RANDSTREIFENBREITE = 8;
    public static final int BOESCHUNGSNEIGUNG = 9;
    public static final int BOESCHUNGSLAENGE = 10;
    public static final int DEICHKRONENBREITE = 11;
    public static final int SOHLBREITE = 12;
    public static final int VORLANDBREITE = 13;
    public static final int CBMPROM = 14;
    public static final int STUECK = 15;
    public static final int STUNDEN = 16;
    public static final int SCHNITTTIEFE = 17;
    public static final int TEILLAENGE = 18;
    public static final int QM = 19;
    public static final int CBM = 20;
    public static final int ARBEITSBREITE = 21;
    public static final int MASSNAHMENART_ID = 22;
    public static final int LEISTUNGSTEXT = 23;
    public static final int AUFMASS_REGEL = 24;
    public static final int EINHEIT = 25;
    public static final int UM_ID = 26;
    public static final int PL_ID = 27;
    public static final int GUP_ID = 28;
    public static final int GWK = 29;
    public static final int MASSNAHMEN_ID = 30;
    public static final int BEAN = 31;
    public static final int GROUP_MASSN_TYP = 0;
    public static final int GROUP_TEILSTUECKE = 1;
    public static final int GROUP_LAENGE = 2;
    public static final int GROUP_AUFMASS = 3;
    public static final int GROUP_MASSEINHEIT = 4;
    public static final int GROUP_ID = 5;
    public static final int GROUP_LEISTUNGSTEXT = 6;
    public static final int GROUP_AUFMASSREGEL = 7;
    public static final int GROUP_EINHEIT = 8;
    public static final int GROUP_MASSN_ID = 9;
    public static final String[] ADDITIONAL_ATTRIBUTES = new String[]{"Randstreifenbreite", "B\u00f6schungsneigung", "B\u00f6schungsl\u00e4nge", "Deichkronenbreite", "Sohlbreite", "Vorlandbreite", "m\u00b3/m", "St\u00fcck", "Stunden", "Schnitttiefe", "teillaenge", "m\u00b2", "m\u00b3", "arbeitsbreite"};
    public static final String[] ADDITIONAL_ATTRIBUTE_MEASURES = new String[]{"m", "1/", "m", "m", "m", "m", "m\u00b3", "", "h", "m", "m", "m\u00b2", "m\u00b3", "m"};
    private static ExpressionEvaluator eval = new ExpressionEvaluator();
    boolean isNew;
    private List<String> gups;
    private List<String> planungsabschnitte;
    private CidsBean cidsBean;
    private boolean readOnly;
    private boolean initialised;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel6;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jsGupList;
    private JScrollPane jsMassnahmenabschnittList;
    private JLabel lblBemerkungen;
    private JLabel lblBezeichnung;
    private JLabel lblGups;
    private JLabel lblMassnahmen;
    private JLabel lblMassnahmenKum;
    private JLabel lblMassnahmenabschnitte;
    private JLabel lblTitle;
    private JList liGup;
    private JList liPlan;
    private JPanel panTitle;
    private JTable tabMassn;
    private JTable tabMassnKum;
    private JTextArea teBemerkungHinweise;
    private JTextField txtBezeichnung;
    private BindingGroup bindingGroup;

    public GupLosEditor() {
        this(false);
    }

    public GupLosEditor(boolean readOnly) {
        block4: {
            this.isNew = false;
            this.readOnly = false;
            this.initialised = false;
            this.readOnly = readOnly;
            this.initComponents();
            if (readOnly) {
                this.setReadOnly();
            } else {
                try {
                    new CidsBeanDropTarget((Component)this.tabMassn);
                    new DropTarget(this.liPlan, (DropTargetListener)((Object)this.liPlan));
                    new CidsBeanDropTarget((Component)this.jScrollPane2);
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)"Error while creating CidsBeanDropTarget", (Throwable)ex);
                }
            }
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel6 = new JLabel();
        this.lblMassnahmenabschnitte = new JLabel();
        this.jsMassnahmenabschnittList = new JScrollPane();
        this.liPlan = new PlanungsabschnittList();
        this.jsGupList = new JScrollPane();
        this.liGup = new JList();
        this.lblGups = new JLabel();
        this.jScrollPane2 = new TabScrollPane();
        this.tabMassn = new MassnahmenTable();
        this.lblMassnahmen = new JLabel();
        this.jPanel2 = new JPanel();
        this.lblBemerkungen = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.teBemerkungHinweise = new JTextArea();
        this.jPanel3 = new JPanel();
        this.lblBezeichnung = new JLabel();
        this.txtBezeichnung = new JTextField();
        this.jScrollPane3 = new TabScrollPane();
        this.tabMassnKum = new MassnahmenTable();
        this.lblMassnahmenKum = new JLabel();
        this.panTitle.setMinimumSize(new Dimension(1050, 48));
        this.panTitle.setOpaque(false);
        this.panTitle.setPreferredSize(new Dimension(1050, 44));
        this.panTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 24));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        this.lblTitle.setText(NbBundle.getMessage(GupLosEditor.class, (String)"GupLosEditor.lblTitle.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wrrl_db_mv/util/gup/export.png")));
        this.jButton1.setText(NbBundle.getMessage(GupLosEditor.class, (String)"GupLosEditor.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupLosEditor.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 7, 0, 7);
        this.panTitle.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wrrl_db_mv/util/gup/print.png")));
        this.jButton2.setText(NbBundle.getMessage(GupLosEditor.class, (String)"GupLosEditor.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupLosEditor.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this.panTitle.add((Component)this.jButton2, gridBagConstraints);
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wrrl_db_mv/util/gup/gaeb.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.panTitle.add((Component)this.jLabel6, gridBagConstraints);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(1294, 500));
        this.setLayout(new GridBagLayout());
        this.lblMassnahmenabschnitte.setText(NbBundle.getMessage(GupLosEditor.class, (String)"GupLosEditor.lblMassnahmenabschnitte.text"));
        this.lblMassnahmenabschnitte.setMaximumSize(new Dimension(230, 17));
        this.lblMassnahmenabschnitte.setMinimumSize(new Dimension(230, 17));
        this.lblMassnahmenabschnitte.setPreferredSize(new Dimension(230, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.add((Component)this.lblMassnahmenabschnitte, gridBagConstraints);
        this.jsMassnahmenabschnittList.setPreferredSize(new Dimension(300, 154));
        this.liPlan.setCellRenderer(new PlanungsabschnittListCellRenderer());
        this.liPlan.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GupLosEditor.this.liPlanKeyPressed(evt);
            }
        });
        this.jsMassnahmenabschnittList.setViewportView(this.liPlan);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 15, 15);
        this.add((Component)this.jsMassnahmenabschnittList, gridBagConstraints);
        this.jsGupList.setPreferredSize(new Dimension(300, 154));
        this.liGup.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GupLosEditor.this.liGupKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                GupLosEditor.this.liGupKeyTyped(evt);
            }
        });
        this.jsGupList.setViewportView(this.liGup);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 15, 15);
        this.add((Component)this.jsGupList, gridBagConstraints);
        this.lblGups.setText(NbBundle.getMessage(GupLosEditor.class, (String)"GupLosEditor.lblGups.text"));
        this.lblGups.setMaximumSize(new Dimension(230, 17));
        this.lblGups.setMinimumSize(new Dimension(230, 17));
        this.lblGups.setPreferredSize(new Dimension(230, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.add((Component)this.lblGups, gridBagConstraints);
        this.jScrollPane2.setOpaque(false);
        this.tabMassn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GupLosEditor.this.tabMassnMouseClicked(evt);
            }
        });
        this.tabMassn.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GupLosEditor.this.tabMassnKeyPressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.tabMassn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.lblMassnahmen.setText(NbBundle.getMessage(GupLosEditor.class, (String)"GupLosEditor.lblMassnahmen.text"));
        this.lblMassnahmen.setMaximumSize(new Dimension(230, 17));
        this.lblMassnahmen.setMinimumSize(new Dimension(230, 17));
        this.lblMassnahmen.setPreferredSize(new Dimension(230, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.add((Component)this.lblMassnahmen, gridBagConstraints);
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.lblBemerkungen.setText(NbBundle.getMessage(GupLosEditor.class, (String)"GupLosEditor.lblBemerkungen.text"));
        this.lblBemerkungen.setMaximumSize(new Dimension(230, 17));
        this.lblBemerkungen.setMinimumSize(new Dimension(230, 17));
        this.lblBemerkungen.setPreferredSize(new Dimension(230, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 5, 5, 15);
        this.jPanel2.add((Component)this.lblBemerkungen, gridBagConstraints);
        this.jScrollPane1.setMaximumSize(new Dimension(300, 50));
        this.jScrollPane1.setMinimumSize(new Dimension(300, 50));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 50));
        this.teBemerkungHinweise.setColumns(20);
        this.teBemerkungHinweise.setRows(2);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bemerkung}"), (Object)this.teBemerkungHinweise, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jScrollPane1.setViewportView(this.teBemerkungHinweise);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 15);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridBagLayout());
        this.lblBezeichnung.setText(NbBundle.getMessage(GupLosEditor.class, (String)"GupLosEditor.lblBezeichnung.text"));
        this.lblBezeichnung.setMaximumSize(new Dimension(150, 17));
        this.lblBezeichnung.setMinimumSize(new Dimension(150, 17));
        this.lblBezeichnung.setPreferredSize(new Dimension(150, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 5, 5, 15);
        this.jPanel3.add((Component)this.lblBezeichnung, gridBagConstraints);
        this.txtBezeichnung.setMaximumSize(new Dimension(180, 20));
        this.txtBezeichnung.setMinimumSize(new Dimension(180, 20));
        this.txtBezeichnung.setPreferredSize(new Dimension(180, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bezeichnung}"), (Object)this.txtBezeichnung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 15);
        this.jPanel3.add((Component)this.txtBezeichnung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jScrollPane3.setOpaque(false);
        this.tabMassnKum.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GupLosEditor.this.tabMassnKumMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.tabMassnKum);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.add((Component)this.jScrollPane3, gridBagConstraints);
        this.lblMassnahmenKum.setText(NbBundle.getMessage(GupLosEditor.class, (String)"GupLosEditor.lblMassnahmenKum.text"));
        this.lblMassnahmenKum.setMaximumSize(new Dimension(230, 17));
        this.lblMassnahmenKum.setMinimumSize(new Dimension(230, 17));
        this.lblMassnahmenKum.setPreferredSize(new Dimension(230, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.add((Component)this.lblMassnahmenKum, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void tabMassnMouseClicked(MouseEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)this)) {
                String jobname = DownloadManagerDialog.getInstance().getJobName();
                String extension = ".xls";
                String filename = this.cidsBean.toString();
                DownloadManager.instance().add((Download)new LosReport(this.createKumMassnList(false), ((MassnTableModel)this.tabMassn.getModel()).getBeans(), jobname, filename, filename, ".xls"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating report.", (Throwable)e);
        }
    }

    private void tabMassnKumMouseClicked(MouseEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)this)) {
                String jobname = DownloadManagerDialog.getInstance().getJobName();
                String extension = ".x81";
                String filename = this.cidsBean.toString();
                DownloadManager.instance().add((Download)new GaebDownload(this.createKumMassnList(false), this.cidsBean, jobname, "Leistungsverzeichnis - " + filename, filename, ".x81"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating gaeb file.", (Throwable)e);
        }
    }

    private void liPlanKeyPressed(KeyEvent evt) {
        if (evt.getKeyChar() == '\u007f') {
            evt.consume();
            if (!this.readOnly && this.liPlan.getModel() instanceof CidsBeanModel) {
                CidsBeanModel model = (CidsBeanModel)this.liPlan.getModel();
                int[] rows = this.liPlan.getSelectedIndices();
                MassnTableModel massnModel = (MassnTableModel)this.tabMassn.getModel();
                ArrayList<Integer> beanIds = new ArrayList<Integer>();
                for (int row : rows) {
                    Integer bean = model.getElementIdAt(row);
                    beanIds.add(bean);
                }
                Object object = beanIds.iterator();
                while (object.hasNext()) {
                    Integer id = (Integer)object.next();
                    massnModel.removePlanungsabschnitt(id);
                    model.removeElement(id);
                }
            }
        }
    }

    private void liGupKeyTyped(KeyEvent evt) {
    }

    private void liGupKeyPressed(KeyEvent evt) {
        if (evt.getKeyChar() == '\u007f') {
            evt.consume();
            if (!this.readOnly && this.liGup.getModel() instanceof CidsBeanModel) {
                CidsBeanModel model = (CidsBeanModel)this.liGup.getModel();
                int[] rows = this.liGup.getSelectedIndices();
                MassnTableModel massnModel = (MassnTableModel)this.tabMassn.getModel();
                ArrayList<Integer> beanIds = new ArrayList<Integer>();
                for (int row : rows) {
                    Integer bean = model.getElementIdAt(row);
                    beanIds.add(bean);
                }
                Object object = beanIds.iterator();
                while (object.hasNext()) {
                    Integer id = (Integer)object.next();
                    massnModel.removeGup(id);
                    model.removeElement(id);
                }
            }
        }
    }

    private void tabMassnKeyPressed(KeyEvent evt) {
        if (evt.getKeyChar() == '\u007f') {
            evt.consume();
            if (!this.readOnly && this.tabMassn.getModel() instanceof MassnTableModel) {
                int[] rows = this.tabMassn.getSelectedRows();
                MassnTableModel model = (MassnTableModel)this.tabMassn.getModel();
                model.removeRows(rows);
            }
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        this.cidsBean = cidsBean;
        this.jButton1.setEnabled(false);
        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean);
            this.bindingGroup.bind();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GupLosEditor.this.loadData();
                }
            });
        }
    }

    public static ArrayList convertToList(CidsBean massnBean) {
        String von = "";
        String bis = "";
        String gup = "";
        String name = "";
        Integer umId = (Integer)massnBean.getProperty("id");
        Integer plId = 0;
        Integer gupId = 0;
        String aufmassRegel = GupLosEditor.getAufmassRegel(massnBean);
        String einheit = GupLosEditor.getEinheit(massnBean);
        ArrayList<Object> newBean = new ArrayList<Object>();
        newBean.add("");
        newBean.add("");
        newBean.add("");
        newBean.add("");
        newBean.add(massnBean.getProperty("massnahme.name"));
        newBean.add(massnBean.getProperty("wo.ort"));
        newBean.add(massnBean.getProperty("linie.von.wert"));
        newBean.add(massnBean.getProperty("linie.bis.wert"));
        newBean.add(massnBean.getProperty("randstreifenbreite"));
        newBean.add(massnBean.getProperty("boeschungsbreite"));
        newBean.add(massnBean.getProperty("boeschungslaenge"));
        newBean.add(massnBean.getProperty("deichkronenbreite"));
        newBean.add(massnBean.getProperty("sohlbreite"));
        newBean.add(massnBean.getProperty("vorlandbreite"));
        newBean.add(massnBean.getProperty("cbmprom"));
        newBean.add(massnBean.getProperty("stueck"));
        newBean.add(massnBean.getProperty("stunden"));
        newBean.add(massnBean.getProperty("schnitttiefe"));
        newBean.add(massnBean.getProperty("teillaenge"));
        newBean.add(massnBean.getProperty("m_zwei"));
        newBean.add(massnBean.getProperty("m_drei"));
        newBean.add(massnBean.getProperty("arbeitsbreite"));
        newBean.add(massnBean.getProperty("massnahme.id"));
        newBean.add(massnBean.getProperty("massnahme.leistungstext"));
        newBean.add(aufmassRegel);
        newBean.add(einheit);
        newBean.add(umId);
        newBean.add(plId);
        newBean.add(gupId);
        newBean.add(massnBean);
        return newBean;
    }

    public static String getAufmassRegel(CidsBean bean) {
        String aufmassRegel = (String)bean.getProperty("massnahme.aufmass_regel");
        if (aufmassRegel == null || aufmassRegel.equals("")) {
            aufmassRegel = (String)bean.getProperty("massnahme.gewerk.aufmass_regel");
        }
        return aufmassRegel;
    }

    public static String getEinheit(CidsBean bean) {
        String einheit = (String)bean.getProperty("massnahme.einheit");
        if (einheit == null || einheit.equals("")) {
            einheit = (String)bean.getProperty("massnahme.gewerk.einheit");
        }
        return einheit;
    }

    private void loadData() {
        WaitingDialogThread<ArrayList<ArrayList>> t = new WaitingDialogThread<ArrayList<ArrayList>>(StaticSwingTools.getParentFrame((Component)this), true, "Lade betroffene Ma\u00dfnahmen", null, 200){

            protected ArrayList<ArrayList> doInBackground() throws Exception {
                List beans = GupLosEditor.this.cidsBean.getBeanCollectionProperty("massnahmen");
                if (beans != null && beans.size() > 0) {
                    ArrayList<String> in = new ArrayList<String>(1);
                    in.add(GupLosEditor.this.cidsBean.getProperty("id").toString());
                    return (ArrayList)massnCache.calcValue(in);
                }
                return new ArrayList<ArrayList>();
            }

            protected void done() {
                try {
                    ArrayList massnBeans = (ArrayList)this.get();
                    GupLosEditor.this.gups = new ArrayList();
                    GupLosEditor.this.planungsabschnitte = new ArrayList();
                    ArrayList<Integer> planungsabschnitteId = new ArrayList<Integer>();
                    ArrayList<Integer> gupId = new ArrayList<Integer>();
                    List beans = GupLosEditor.this.cidsBean.getBeanCollectionProperty("massnahmen");
                    for (ArrayList bean : massnBeans) {
                        String plan = GupLosEditor.toName(bean);
                        Integer id = (Integer)bean.get(26);
                        for (CidsBean tmp : beans) {
                            if (!tmp.getProperty("id").equals(id) || bean.size() != 31) continue;
                            bean.add(tmp);
                            break;
                        }
                        if (GupLosEditor.this.planungsabschnitte.contains(plan)) continue;
                        String gup = String.valueOf(bean.get(2));
                        GupLosEditor.this.planungsabschnitte.add(plan);
                        planungsabschnitteId.add((Integer)bean.get(27));
                        if (GupLosEditor.this.gups.contains(gup)) continue;
                        GupLosEditor.this.gups.add(gup);
                        gupId.add((Integer)bean.get(28));
                    }
                    GupLosEditor.this.liGup.setModel(new CidsBeanModel(GupLosEditor.this.gups, gupId));
                    GupLosEditor.this.liPlan.setModel(new CidsBeanModel(GupLosEditor.this.planungsabschnitte, planungsabschnitteId));
                    GupLosEditor.this.tabMassn.setModel(new MassnTableModel(massnBeans));
                    GupLosEditor.this.fillKumTable();
                    GupLosEditor.this.tabMassnKum.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            int[] row = GupLosEditor.this.tabMassnKum.getSelectedRows();
                            String[] filters = new String[row.length];
                            int index = 0;
                            for (int tmp : row) {
                                Object filter = ((MassnKumTableModel)GupLosEditor.this.tabMassnKum.getModel()).getValueAt(tmp, 0);
                                filters[index++] = (String)filter;
                            }
                            ((MassnTableModel)GupLosEditor.this.tabMassn.getModel()).setFilter(filters);
                        }
                    });
                    GupLosEditor.this.initialised = true;
                    GupLosEditor.this.jButton1.setEnabled(true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while trying to receive the underlying data.", (Throwable)e);
                }
            }
        };
        t.start();
    }

    private void fillKumTable() {
        this.tabMassnKum.setModel(new MassnKumTableModel(this.createKumMassnList(true)));
    }

    private ArrayList<ArrayList> createKumMassnList(boolean showError) {
        ArrayList<ArrayList> beans = ((MassnTableModel)this.tabMassn.getModel()).getBeans();
        ArrayList<ArrayList> groups = new ArrayList<ArrayList>();
        boolean error = false;
        for (ArrayList bean : beans) {
            ArrayList<Integer> group = null;
            for (ArrayList tmp : groups) {
                if (tmp.get(0) != bean.get(4) && (tmp.get(0) == null || !tmp.get(0).equals(bean.get(4)))) continue;
                group = tmp;
                break;
            }
            if (group == null) {
                Integer id = (Integer)bean.get(22);
                if (id == null) {
                    id = 1;
                }
                group = new ArrayList<Integer>();
                group.add((Integer)bean.get(4));
                group.add(0);
                group.add((Integer)0.0);
                group.add((Integer)0.0);
                group.add((Integer)bean.get(25));
                group.add(id);
                group.add((Integer)bean.get(23));
                group.add((Integer)bean.get(24));
                group.add((Integer)bean.get(25));
                group.add((Integer)bean.get(30));
                groups.add(group);
            }
            group.set(1, (Integer)group.get(1) + 1);
            group.set(2, (Integer)((Double)group.get(2) + this.calculateLength(bean)));
            String expression = (String)bean.get(24);
            try {
                Double a = GupLosEditor.calcMenge(bean, expression);
                if (a != null) {
                    group.set(3, (Integer)((Double)group.get(3) + a));
                    continue;
                }
                if (error || !showError) continue;
                error = true;
                if (bean.get(22) == null) {
                    JOptionPane.showMessageDialog(this, "Ma\u00dfnahme wurde nicht gesetzt. Die angezeigten Werte sind nicht korrekt", "Fehler!", 0);
                    continue;
                }
                JOptionPane.showMessageDialog(this, "Ung\u00fcltige Formel zur Berechnung des Aufma\u00dfes der Ma\u00dfnahme: " + bean.get(4) + " Formel: " + expression + ". Die angezeigten Werte sind nicht korrekt", "Fehler!", 0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Fehler!", 0);
            }
        }
        Collections.sort(groups, new Comparator<ArrayList>(){

            @Override
            public int compare(ArrayList o1, ArrayList o2) {
                if (o1 != null && o1.get(0) != null && o2 != null && o2.get(0) != null) {
                    return ((String)o1.get(0)).compareTo((String)o2.get(0));
                }
                if (!(o1 != null && o1.get(0) != null || o2 != null && o2.get(0) != null)) {
                    return 0;
                }
                if (o1 == null || o1.get(0) == null) {
                    return -1;
                }
                return 1;
            }
        });
        return groups;
    }

    public static Double calcMenge(ArrayList bean, String expression) throws Exception {
        if (expression != null) {
            if (!eval.isValidExpression(expression = GupLosEditor.replaceVariablesFromExpression(expression, bean))) {
                String text = "Ung\u00fcltige Formel zur Berechnung des Aufma\u00dfes der Ma\u00dfnahme: " + bean.get(4) + " Formel: " + bean.get(24) + ". Die angezeigten Werte sind nicht korrekt";
                throw new Exception(text);
            }
            return eval.eval(expression);
        }
        return null;
    }

    public static String replaceVariablesFromExpression(String ex, ArrayList valueList) {
        if (valueList == null) {
            valueList = new ArrayList<Integer>();
            for (int i = 0; i < 22; ++i) {
                valueList.add(2);
            }
            valueList.set(6, 1);
        }
        String expression = ex.toLowerCase();
        expression = expression.replace("b\u00f6schungsl\u00e4nge", GupLosEditor.replaceNull(valueList.get(10), 0.0).toString());
        expression = expression.replace("b\u00f6schungsneigung", GupLosEditor.replaceNull(valueList.get(9), 0.0).toString());
        expression = expression.replace("deichkronenbreite", GupLosEditor.replaceNull(valueList.get(11), 0.0).toString());
        expression = expression.replace("randstreifenbreite", GupLosEditor.replaceNull(valueList.get(8), 0.0).toString());
        expression = expression.replace("sohlbreite", GupLosEditor.replaceNull(valueList.get(12), 0.0).toString());
        expression = expression.replace("vorlandbreite", GupLosEditor.replaceNull(valueList.get(13), 0.0).toString());
        expression = expression.replace("cbmprom", GupLosEditor.replaceNull(valueList.get(14), 0.0).toString());
        expression = expression.replace("st\u00fcck", GupLosEditor.replaceNull(valueList.get(15), 0.0).toString());
        expression = expression.replace("stunden", GupLosEditor.replaceNull(valueList.get(16), 0.0).toString());
        expression = expression.replace("schnitttiefe", GupLosEditor.replaceNull(valueList.get(17), 0.0).toString());
        expression = expression.replace("teill\u00e4nge", GupLosEditor.replaceNull(valueList.get(18), 0.0).toString());
        expression = expression.replace("qm", GupLosEditor.replaceNull(valueList.get(19), 0.0).toString());
        expression = expression.replace("cbm", GupLosEditor.replaceNull(valueList.get(20), 0.0).toString());
        expression = expression.replace("arbeitsbreite", GupLosEditor.replaceNull(valueList.get(21), 0.0).toString());
        expression = expression.replace("von", GupLosEditor.replaceNull(valueList.get(6), 0.0).toString());
        expression = expression.replace("bis", GupLosEditor.replaceNull(valueList.get(7), 0.0).toString());
        return expression;
    }

    private static Object replaceNull(Object o, Object replacement) {
        return o == null ? replacement : o;
    }

    private double calculateLength(ArrayList bean) {
        double von = (Double)bean.get(6);
        double bis = (Double)bean.get(7);
        return bis - von;
    }

    private static String toName(ArrayList bean) {
        return String.valueOf(bean.get(3)) + " " + String.valueOf(bean.get(0)) + " - " + String.valueOf(bean.get(1));
    }

    private static String toName(CidsBean bean) {
        String routenname = String.valueOf(bean.getProperty("linie.von.route.routenname"));
        String von = String.valueOf(bean.getProperty("linie.von.wert"));
        String bis = String.valueOf(bean.getProperty("linie.bis.wert"));
        return routenname + " " + von + " - " + bis;
    }

    public void setReadOnly() {
        RendererTools.makeReadOnly(this.txtBezeichnung);
        RendererTools.makeReadOnly(this.teBemerkungHinweise);
    }

    public void dispose() {
        this.initialised = false;
        this.bindingGroup.unbind();
    }

    public String getTitle() {
        return "Los";
    }

    public void setTitle(String title) {
    }

    private void refreshPlanungsabschnitte() {
        CidsBeanModel model = (CidsBeanModel)this.liPlan.getModel();
        MassnTableModel massnModel = (MassnTableModel)this.tabMassn.getModel();
        ArrayList<Integer> obsoleteObjects = new ArrayList<Integer>();
        for (int i = 0; i < model.getSize(); ++i) {
            obsoleteObjects.add(model.getElementIdAt(i));
        }
        for (ArrayList bean : massnModel.getBeans()) {
            Integer id = (Integer)bean.get(27);
            obsoleteObjects.remove(id);
        }
        for (Integer id : obsoleteObjects) {
            model.removeElement(id);
        }
    }

    private void refreshGup() {
        CidsBeanModel model = (CidsBeanModel)this.liGup.getModel();
        MassnTableModel massnModel = (MassnTableModel)this.tabMassn.getModel();
        ArrayList<Integer> obsoleteObjects = new ArrayList<Integer>();
        for (int i = 0; i < model.getSize(); ++i) {
            obsoleteObjects.add(model.getElementIdAt(i));
        }
        for (ArrayList bean : massnModel.getBeans()) {
            Integer id = (Integer)bean.get(28);
            obsoleteObjects.remove(id);
        }
        for (Integer id : obsoleteObjects) {
            model.removeElement(id);
        }
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        return true;
    }

    private void addMassnahme(CidsBean bean) {
        if (bean.getClass().getName().equals("de.cismet.cids.dynamics.Gup_unterhaltungsmassnahme") && ((MassnTableModel)this.tabMassn.getModel()).add(bean)) {
            this.cidsBean.getBeanCollectionProperty("massnahmen").add(bean);
            String planName = GupLosEditor.toName((CidsBean)bean.getProperty("planungsabschnitt"));
            if (!this.planungsabschnitte.contains(planName)) {
                Integer planId = (Integer)bean.getProperty("planungsabschnitt.id");
                ((CidsBeanModel)this.liPlan.getModel()).add(planName, planId);
                Object gupName = bean.getProperty("planungsabschnitt.gup.name");
                if (!this.gups.contains(String.valueOf(gupName))) {
                    Integer gupId = (Integer)bean.getProperty("planungsabschnitt.gup.id");
                    ((CidsBeanModel)this.liGup.getModel()).add(String.valueOf(gupName), gupId);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost((String)"WRRL_DB_MV", (String)"Administratoren", (String)"admin", (String)"x", (String)"gup_los", (int)1, (int)1280, (int)1024);
    }

    public JComponent getTitleComponent() {
        return this.panTitle;
    }

    public static Object getAttribute(ArrayList bean, int number, FieldKind value) {
        int FIRST_ATTRIB = 8;
        int currentNumber = 0;
        for (int i = 8; i < bean.size() - 10; ++i) {
            Object tmpVal = bean.get(i);
            if (tmpVal == null || ++currentNumber != number) continue;
            switch (value) {
                case value: {
                    if (tmpVal instanceof Integer) {
                        Integer intVal = (Integer)tmpVal;
                        return intVal.doubleValue();
                    }
                    return tmpVal;
                }
                case name: {
                    return ADDITIONAL_ATTRIBUTES[i - 8];
                }
                case measure: {
                    return ADDITIONAL_ATTRIBUTE_MEASURES[i - 8];
                }
            }
        }
        return null;
    }

    private static class MassnCalculator
    implements Calculator<List, ArrayList<ArrayList>> {
        private MassnCalculator() {
        }

        public ArrayList<ArrayList> calculate(List input) throws Exception {
            MassnahmenSearch search = new MassnahmenSearch((String)input.get(0));
            Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
            return (ArrayList)res;
        }
    }

    private static class MassnKumTableModel
    implements TableModel {
        private static final String[] columns = new String[]{"Ma\u00dfn.Typ", "Teilst\u00fccke", "L\u00e4nge", "Aufma\u00df"};
        private ArrayList<ArrayList> beans;
        private List<TableModelListener> listener = new ArrayList<TableModelListener>();

        public MassnKumTableModel(ArrayList<ArrayList> beans) {
            this.beans = beans;
        }

        @Override
        public int getRowCount() {
            return this.beans.size();
        }

        @Override
        public int getColumnCount() {
            return columns.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columns[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ArrayList bean = this.beans.get(rowIndex);
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return String.valueOf(bean.get(columnIndex));
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listener.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listener.remove(l);
        }

        public void fireTableChanged() {
            TableModelEvent e = new TableModelEvent(this);
            for (TableModelListener tmp : this.listener) {
                tmp.tableChanged(e);
            }
        }
    }

    private class MassnTableModel
    implements TableModel {
        private final String[] columns = new String[]{"GUP", "Planungsabschnitt", "Ma\u00dfn.Typ", "Kompartiment", "von", "bis", "Attr.1", "Wert Attr.1", "Attr.2", "Wert Attr.2", "Attr.3", "Wert Attr.3"};
        private ArrayList<ArrayList> beans;
        private List<TableModelListener> listener = new ArrayList<TableModelListener>();
        private String[] filter = new String[0];

        public MassnTableModel(ArrayList<ArrayList> beans) {
            this.beans = beans;
        }

        @Override
        public int getRowCount() {
            int count = 0;
            for (ArrayList bean : this.beans) {
                String massn = String.valueOf(bean.get(4));
                if (!this.isContainedInFilter(massn)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columns[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ArrayList bean = this.getRow(rowIndex);
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return String.valueOf(bean.get(columnIndex + 2));
                }
                case 6: {
                    return GupLosEditor.getAttribute(bean, 1, FieldKind.name);
                }
                case 7: {
                    return GupLosEditor.getAttribute(bean, 1, FieldKind.value);
                }
                case 8: {
                    return GupLosEditor.getAttribute(bean, 2, FieldKind.name);
                }
                case 9: {
                    return GupLosEditor.getAttribute(bean, 2, FieldKind.value);
                }
                case 10: {
                    return GupLosEditor.getAttribute(bean, 3, FieldKind.name);
                }
                case 11: {
                    return GupLosEditor.getAttribute(bean, 3, FieldKind.value);
                }
            }
            return "";
        }

        private boolean isContainedInFilter(String cond) {
            for (String tmp : this.filter) {
                if (!tmp.equals(cond)) continue;
                return true;
            }
            return false;
        }

        private ArrayList getRow(int index) {
            int count = 0;
            for (ArrayList tmp : this.beans) {
                String massn = String.valueOf(tmp.get(4));
                if (!this.isContainedInFilter(massn)) continue;
                if (count == index) {
                    return tmp;
                }
                ++count;
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listener.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listener.remove(l);
        }

        public void setFilter(String[] filter) {
            this.filter = filter;
            this.fireTableChanged();
        }

        public void fireTableChanged() {
            TableModelEvent e = new TableModelEvent(this);
            for (TableModelListener tmp : this.listener) {
                tmp.tableChanged(e);
            }
        }

        private boolean add(CidsBean massnBean) {
            String von = String.valueOf(massnBean.getProperty("planungsabschnitt.linie.von.wert"));
            String bis = String.valueOf(massnBean.getProperty("planungsabschnitt.linie.bis.wert"));
            Long route = (Long)massnBean.getProperty("planungsabschnitt.linie.von.route.gwk");
            String gup = String.valueOf(massnBean.getProperty("planungsabschnitt.gup.name"));
            String name = String.valueOf(massnBean.getProperty("planungsabschnitt.name"));
            Integer umId = (Integer)massnBean.getProperty("id");
            Integer plId = (Integer)massnBean.getProperty("planungsabschnitt.id");
            Integer gupId = (Integer)massnBean.getProperty("planungsabschnitt.gup.id");
            return this.add(massnBean, name, gup, von, bis, plId, gupId, umId, route);
        }

        private boolean add(CidsBean massnBean, String name, String gup, String von, String bis, Integer plId, Integer gupId, Integer umId, Long route) {
            String aufmassRegel = GupLosEditor.getAufmassRegel(massnBean);
            String einheit = GupLosEditor.getEinheit(massnBean);
            ArrayList<Object> newBean = new ArrayList<Object>();
            newBean.add(von);
            newBean.add(bis);
            newBean.add(gup);
            newBean.add(name);
            newBean.add(massnBean.getProperty("massnahme.name"));
            newBean.add(massnBean.getProperty("wo.ort"));
            newBean.add(massnBean.getProperty("linie.von.wert"));
            newBean.add(massnBean.getProperty("linie.bis.wert"));
            newBean.add(massnBean.getProperty("randstreifenbreite"));
            newBean.add(massnBean.getProperty("boeschungsbreite"));
            newBean.add(massnBean.getProperty("boeschungslaenge"));
            newBean.add(massnBean.getProperty("deichkronenbreite"));
            newBean.add(massnBean.getProperty("sohlbreite"));
            newBean.add(massnBean.getProperty("vorlandbreite"));
            newBean.add(massnBean.getProperty("cbmprom"));
            newBean.add(massnBean.getProperty("stueck"));
            newBean.add(massnBean.getProperty("stunden"));
            newBean.add(massnBean.getProperty("schnitttiefe"));
            newBean.add(massnBean.getProperty("teillaenge"));
            newBean.add(massnBean.getProperty("m_zwei"));
            newBean.add(massnBean.getProperty("m_drei"));
            newBean.add(massnBean.getProperty("arbeitsbreite"));
            newBean.add(massnBean.getProperty("massnahme.id"));
            newBean.add(massnBean.getProperty("massnahme.leistungstext"));
            newBean.add(aufmassRegel);
            newBean.add(einheit);
            newBean.add(umId);
            newBean.add(plId);
            newBean.add(gupId);
            newBean.add(route);
            newBean.add(massnBean.getProperty("massnahme.massnahmen_id"));
            newBean.add(massnBean);
            if (!this.containsBean(this.beans, newBean)) {
                this.beans.add(newBean);
                return true;
            }
            return false;
        }

        private boolean containsBean(ArrayList<ArrayList> beans, ArrayList bean) {
            if (bean != null) {
                for (ArrayList tmp : beans) {
                    if (!tmp.get(26).equals(bean.get(26))) continue;
                    return true;
                }
            }
            return false;
        }

        public ArrayList<ArrayList> getBeans() {
            return this.beans;
        }

        public void removeRows(int[] rows) {
            int selectedRow = GupLosEditor.this.tabMassnKum.getSelectedRow();
            for (int tmp : rows) {
                GupLosEditor.this.cidsBean.getBeanCollectionProperty("massnahmen").remove((CidsBean)this.getRow(tmp).get(31));
            }
            Arrays.sort(rows);
            for (int index = rows.length - 1; index >= 0; --index) {
                this.beans.remove(this.getRow(index));
            }
            GupLosEditor.this.cidsBean.setArtificialChangeFlag(true);
            this.fireTableChanged();
            GupLosEditor.this.fillKumTable();
            GupLosEditor.this.refreshPlanungsabschnitte();
            GupLosEditor.this.refreshGup();
            if (selectedRow != -1 && selectedRow < GupLosEditor.this.tabMassnKum.getModel().getRowCount()) {
                GupLosEditor.this.tabMassnKum.setRowSelectionInterval(selectedRow, selectedRow);
            }
        }

        public void removePlanungsabschnitt(Integer planId) {
            ArrayList<ArrayList> tmpToRemove = new ArrayList<ArrayList>();
            for (ArrayList bean : this.beans) {
                if (bean.get(27) == null || !bean.get(27).equals(planId)) continue;
                Object beanToRemove = null;
                CidsBean cbean = (CidsBean)bean.get(31);
                GupLosEditor.this.cidsBean.getBeanCollectionProperty("massnahmen").remove(cbean);
                tmpToRemove.add(bean);
            }
            this.beans.removeAll(tmpToRemove);
            GupLosEditor.this.cidsBean.setArtificialChangeFlag(true);
            this.fireTableChanged();
            GupLosEditor.this.fillKumTable();
            GupLosEditor.this.refreshGup();
        }

        public void removeGup(Integer gupId) {
            ArrayList<ArrayList> tmpToRemove = new ArrayList<ArrayList>();
            for (ArrayList bean : this.beans) {
                if (bean.get(28) == null || !bean.get(28).equals(gupId)) continue;
                CidsBean cbean = (CidsBean)bean.get(31);
                GupLosEditor.this.cidsBean.getBeanCollectionProperty("massnahmen").remove(cbean);
                tmpToRemove.add(bean);
            }
            this.beans.removeAll(tmpToRemove);
            GupLosEditor.this.cidsBean.setArtificialChangeFlag(true);
            this.fireTableChanged();
            GupLosEditor.this.fillKumTable();
            GupLosEditor.this.refreshPlanungsabschnitte();
        }
    }

    private class CidsBeanModel
    implements ListModel {
        private List<String> titles;
        private List<Integer> ids;
        private List<ListDataListener> listener = new ArrayList<ListDataListener>();

        public CidsBeanModel(List<String> beans, List<Integer> ids) {
            this.titles = beans;
            this.ids = ids;
        }

        @Override
        public int getSize() {
            return this.titles.size();
        }

        public Object getElementAt(int index) {
            return this.titles.get(index);
        }

        public Integer getElementIdAt(int index) {
            return this.ids.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listener.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listener.remove(l);
        }

        private void fireContentsChanged() {
            ListDataEvent e = new ListDataEvent(this, 0, 0, 0);
            for (ListDataListener tmp : this.listener) {
                tmp.contentsChanged(e);
            }
        }

        public void add(String title, Integer id) {
            this.titles.add(title);
            this.ids.add(id);
            this.fireContentsChanged();
        }

        public void removeElement(Integer id) {
            int index = this.ids.indexOf(id);
            if (index >= 0) {
                this.ids.remove(index);
                this.titles.remove(index);
            }
            this.fireContentsChanged();
        }
    }

    private class PlanungsabschnittListCellRenderer
    extends DefaultListCellRenderer {
        private PlanungsabschnittListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (result instanceof JLabel && value instanceof CidsBean) {
                CidsBean bean = (CidsBean)value;
                String routenname = String.valueOf(bean.getProperty("linie.von.route.routenname"));
                String von = String.valueOf(bean.getProperty("linie.von.wert"));
                String bis = String.valueOf(bean.getProperty("linie.bis.wert"));
                String text = routenname + " " + von + " - " + bis;
                ((JLabel)result).setText(text);
            }
            return result;
        }
    }

    private class TabScrollPane
    extends JScrollPane
    implements CidsBeanDropListener {
        private TabScrollPane() {
        }

        public void beansDropped(ArrayList<CidsBean> beans) {
            if (GupLosEditor.this.readOnly || !GupLosEditor.this.initialised) {
                return;
            }
            for (CidsBean bean : beans) {
                GupLosEditor.this.addMassnahme(bean);
            }
            ((MassnTableModel)GupLosEditor.this.tabMassn.getModel()).fireTableChanged();
            try {
                GupLosEditor.this.fillKumTable();
            }
            catch (Exception e) {
                LOG.error((Object)"Error", (Throwable)e);
            }
        }
    }

    private class MassnahmenTable
    extends JTable
    implements CidsBeanDropListener {
        private MassnahmenTable() {
        }

        public void beansDropped(ArrayList<CidsBean> beans) {
            if (GupLosEditor.this.readOnly || !GupLosEditor.this.initialised) {
                return;
            }
            for (CidsBean bean : beans) {
                GupLosEditor.this.addMassnahme(bean);
            }
            ((MassnTableModel)GupLosEditor.this.tabMassn.getModel()).fireTableChanged();
            GupLosEditor.this.fillKumTable();
        }
    }

    private class PlanungsabschnittList
    extends JList
    implements DropTargetListener {
        DataFlavor fromNavigatorNode = new DataFlavor("application/x-java-jvm-local-objectref;class=" + DefaultMetaTreeNode.class.getName(), "a DefaultMetaTreeNode");
        DataFlavor fromNavigatorCollection = new DataFlavor("application/x-java-jvm-local-objectref;class=" + Collection.class.getName(), "a java.util.Collection of Sirius.navigator.types.treenode.DefaultMetaTreeNode objects");

        private PlanungsabschnittList() {
        }

        public void beansDropped(ArrayList<ObjectTreeNode> beans) {
            if (GupLosEditor.this.readOnly || !GupLosEditor.this.initialised) {
                return;
            }
            for (final ObjectTreeNode node : beans) {
                final CidsBean bean = node.getMetaObject().getBean();
                if (!bean.getClass().getName().equals("de.cismet.cids.dynamics.Gup_planungsabschnitt")) continue;
                WaitingDialogThread<Void> t = new WaitingDialogThread<Void>(StaticSwingTools.getParentFrame((Component)GupLosEditor.this), true, "F\u00fcge Planungsabschnitt hinzu", null, 200){

                    public Void doInBackground() throws Exception {
                        String beanName = GupLosEditor.toName(bean);
                        String von = String.valueOf(bean.getProperty("linie.von.wert"));
                        String bis = String.valueOf(bean.getProperty("linie.bis.wert"));
                        Long route = (Long)bean.getProperty("linie.von.route.gwk");
                        String gup = String.valueOf(bean.getProperty("gup.name"));
                        Integer gupId = (Integer)bean.getProperty("gup.id");
                        Integer plId = (Integer)bean.getProperty("id");
                        String name = String.valueOf(bean.getProperty("name"));
                        if (!GupLosEditor.this.planungsabschnitte.contains(beanName)) {
                            ((CidsBeanModel)GupLosEditor.this.liPlan.getModel()).add(beanName, plId);
                            if (!GupLosEditor.this.gups.contains(gup)) {
                                ((CidsBeanModel)GupLosEditor.this.liGup.getModel()).add(gup, gupId);
                            }
                        }
                        List<CidsBean> massnBeans = CidsBeanSupport.getBeanCollectionFromProperty(bean, "massnahmen");
                        ObjectTreeNode losNode = (ObjectTreeNode)node.getParent().getParent();
                        Integer losId = null;
                        List<CidsBean> massnCollection = null;
                        if (losNode != null && losNode.getMetaObject().getBean().getClass().getName().equals("de.cismet.cids.dynamics.Gup_los")) {
                            CidsBean losBean = losNode.getMetaObject().getBean();
                            losId = (Integer)losBean.getProperty("id");
                            massnCollection = CidsBeanSupport.getBeanCollectionFromProperty(losBean, "massnahmen");
                        }
                        if (massnBeans != null) {
                            for (CidsBean tmp : massnBeans) {
                                if (losId != null && (massnCollection == null || !massnCollection.contains(tmp)) || !((MassnTableModel)GupLosEditor.this.tabMassn.getModel()).add(tmp, name, gup, von, bis, plId, gupId, (Integer)tmp.getProperty("id"), route)) continue;
                                GupLosEditor.this.cidsBean.getBeanCollectionProperty("massnahmen").add(tmp);
                            }
                        }
                        return null;
                    }
                };
                t.start();
            }
            ((MassnTableModel)GupLosEditor.this.tabMassn.getModel()).fireTableChanged();
            GupLosEditor.this.fillKumTable();
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                beans = new ArrayList<ObjectTreeNode>();
                if (dtde.getTransferable().isDataFlavorSupported(this.fromNavigatorNode) && dtde.getTransferable().isDataFlavorSupported(this.fromNavigatorCollection)) {
                    try {
                        object = dtde.getTransferable().getTransferData(this.fromNavigatorCollection);
                        if (!(object instanceof Collection)) ** GOTO lbl18
                        c = (Collection)object;
                        for (E o : c) {
                            if (!(o instanceof ObjectTreeNode)) continue;
                            beans.add((ObjectTreeNode)o);
                        }
                    }
                    catch (Throwable t) {
                        GupLosEditor.access$2600().fatal((Object)"Drop Problems occurred", t);
                    }
                } else {
                    GupLosEditor.access$2600().fatal((Object)"Wrong transferable");
                }
lbl18:
                // 4 sources

                this.beansDropped(beans);
            }
            catch (Throwable ups) {
                GupLosEditor.access$2600().error((Object)"Problem during the DnD Opertaion", ups);
            }
        }
    }

    public static enum FieldKind {
        name,
        value,
        measure;

    }
}

