/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.method.MethodManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.middleware.types.Node;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.LinearReferencedLineEditor;
import de.cismet.cids.custom.objectrenderer.wrrl_db_mv.LinearReferencedLineRenderer;
import de.cismet.cids.custom.wrrl_db_mv.util.RendererTools;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.OperativeZieleComboBox;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.PflegezieleValidator;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class GupOperativesZielAbschnittEditor
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener,
PropertyChangeListener,
CidsBeanDropListener {
    public static final int OPERATIVES_ZIEL_UFER = 1;
    public static final int OPERATIVES_ZIEL_SOHLE = 2;
    public static final int OPERATIVES_ZIEL_UMFELD = 3;
    private static final Logger LOG = Logger.getLogger(GupOperativesZielAbschnittEditor.class);
    private static final MetaClass PFLEGEZIEL_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_operatives_ziel");
    private static final String ENTWICKLUNGSZIEL_TEMPLATE = "exists (select 1 from GUP_OPERATIVES_ZIEL_GUP_ENTWICKLUNGSZIEL_NAME ent where gup_operatives_ziel_reference = p.id and ent.entwicklungsziel = %s)";
    private static final String SITUATIONSTYP_TEMPLATE = "exists (select 1 from GUP_OPERATIVES_ZIEL_GUP_UNTERHALTUNGSERFORDERNIS_NAME ue where gup_operatives_ziel_reference = p.id and ue.unterhaltungserfordernis = %s)";
    private CidsBean cidsBean;
    private List<CidsBean> others;
    private PflegezieleValidator validator;
    private boolean readOnly;
    private DefaultBindableReferenceCombo cbName;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jscEval;
    private JButton lblSearch;
    private JLabel lblValid;
    private JLabel lblValidLab;
    private JLabel lblZiel;
    private LinearReferencedLineEditor linearReferencedLineEditor;
    private JTextArea textEval;
    private BindingGroup bindingGroup;

    public GupOperativesZielAbschnittEditor() {
        this(false);
    }

    public GupOperativesZielAbschnittEditor(boolean readOnly) {
        this.readOnly = readOnly;
        this.linearReferencedLineEditor = readOnly ? new LinearReferencedLineRenderer(true) : new LinearReferencedLineEditor();
        this.linearReferencedLineEditor.setLineField("linie");
        this.initComponents();
        if (!readOnly) {
            block4: {
                try {
                    new CidsBeanDropTarget((Component)this);
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)"Error while creating CidsBeanDropTarget", (Throwable)ex);
                }
            }
            this.linearReferencedLineEditor.setOtherLinesEnabled(true);
            this.linearReferencedLineEditor.setOtherLinesQueryAddition("gup_operatives_ziel_abschnitt", "gup_operatives_ziel_abschnitt.linie = ");
            this.linearReferencedLineEditor.setShowOtherInDialog(true);
        } else {
            RendererTools.makeReadOnly((JComboBox)this.cbName);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.lblZiel = new JLabel();
        this.cbName = new OperativeZieleComboBox();
        this.lblSearch = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.linearReferencedLineEditor = this.linearReferencedLineEditor;
        this.jPanel3 = new JPanel();
        this.lblValidLab = new JLabel();
        this.lblValid = new JLabel();
        this.jscEval = new JScrollPane();
        this.textEval = new JTextArea();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(994, 400));
        this.setLayout(new GridBagLayout());
        this.lblZiel.setText(NbBundle.getMessage(GupOperativesZielAbschnittEditor.class, (String)"GupOperativesZielAbschnittEditor.lblZiel.text"));
        this.lblZiel.setMaximumSize(new Dimension(170, 17));
        this.lblZiel.setMinimumSize(new Dimension(170, 17));
        this.lblZiel.setPreferredSize(new Dimension(120, 17));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 35, 5, 5);
        this.add((Component)this.lblZiel, gridBagConstraints);
        this.cbName.setMaximumSize(new Dimension(420, 20));
        this.cbName.setMinimumSize(new Dimension(420, 20));
        this.cbName.setPreferredSize(new Dimension(520, 20));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.operatives_ziel}"), (Object)this.cbName, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.insets = new Insets(15, 5, 5, 15);
        this.add((Component)this.cbName, gridBagConstraints);
        this.lblSearch.setText(NbBundle.getMessage(GupOperativesZielAbschnittEditor.class, (String)"GupOperativesZielAbschnittEditor.lblSearch.text", (Object[])new Object[0]));
        this.lblSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupOperativesZielAbschnittEditor.this.lblSearchActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(15, 5, 5, 35);
        this.add((Component)this.lblSearch, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 35, 10, 10);
        this.jPanel2.add((Component)this.linearReferencedLineEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridBagLayout());
        this.lblValidLab.setFont(new Font("Ubuntu", 1, 15));
        this.lblValidLab.setHorizontalAlignment(0);
        this.lblValidLab.setText(NbBundle.getMessage(GupOperativesZielAbschnittEditor.class, (String)"GupOperativesZielAbschnittEditor.lblValidLab.text"));
        this.lblValidLab.setPreferredSize(new Dimension(210, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.jPanel3.add((Component)this.lblValidLab, gridBagConstraints);
        this.lblValid.setHorizontalAlignment(0);
        this.lblValid.setMaximumSize(new Dimension(128, 128));
        this.lblValid.setMinimumSize(new Dimension(64, 64));
        this.lblValid.setPreferredSize(new Dimension(64, 64));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel3.add((Component)this.lblValid, gridBagConstraints);
        this.jscEval.setMaximumSize(new Dimension(235, 100));
        this.jscEval.setMinimumSize(new Dimension(235, 100));
        this.jscEval.setPreferredSize(new Dimension(235, 100));
        this.textEval.setColumns(18);
        this.textEval.setRows(3);
        this.jscEval.setViewportView(this.textEval);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.jPanel3.add((Component)this.jscEval, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 10, 35);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void lblSearchActionPerformed(ActionEvent evt) {
        this.searchValidPflegeziele();
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(final CidsBean cidsBean) {
        this.bindingGroup.unbind();
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean);
            this.bindingGroup.bind();
            if (this.others != null) {
                ArrayList<CidsBean> lineBeans = new ArrayList<CidsBean>();
                Object id = cidsBean.getProperty("linie.id");
                for (CidsBean b : this.others) {
                    CidsBean tmp = (CidsBean)b.getProperty("linie");
                    if (tmp == null || tmp.getProperty("id").equals(id)) continue;
                    lineBeans.add(tmp);
                }
                this.linearReferencedLineEditor.setOtherLines(lineBeans);
            }
            this.linearReferencedLineEditor.setCidsBean(cidsBean);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Object item = cidsBean.getProperty("operatives_ziel");
                    if (item != null) {
                        GupOperativesZielAbschnittEditor.this.cbName.setSelectedItem(item);
                    }
                }
            }).start();
            CidsBean line = (CidsBean)cidsBean.getProperty("linie");
            if (line != null) {
                line.addPropertyChangeListener((PropertyChangeListener)this);
                CidsBean von = (CidsBean)line.getProperty("von");
                CidsBean bis = (CidsBean)line.getProperty("bis");
                if (von != null) {
                    von.addPropertyChangeListener((PropertyChangeListener)this);
                }
                if (bis != null) {
                    bis.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
            cidsBean.addPropertyChangeListener((PropertyChangeListener)this);
            this.validatePflegeziel();
        }
    }

    public void setKompartiment(int kompartiment) {
        ((OperativeZieleComboBox)this.cbName).setKompartiment(kompartiment);
        this.cbName.setSelectedItem(null);
    }

    public void unbind() {
        this.bindingGroup.unbind();
    }

    public void setOthers(List<CidsBean> others) {
        this.others = others;
    }

    public void dispose() {
        if (this.cidsBean != null) {
            this.cidsBean.removePropertyChangeListener((PropertyChangeListener)this);
            CidsBean line = (CidsBean)this.cidsBean.getProperty("linie");
            if (line != null) {
                line.removePropertyChangeListener((PropertyChangeListener)this);
                CidsBean von = (CidsBean)line.getProperty("von");
                CidsBean bis = (CidsBean)line.getProperty("bis");
                if (von != null) {
                    von.removePropertyChangeListener((PropertyChangeListener)this);
                }
                if (bis != null) {
                    bis.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
        this.bindingGroup.unbind();
        this.linearReferencedLineEditor.dispose();
    }

    public String getTitle() {
        return NbBundle.getMessage(GupOperativesZielAbschnittEditor.class, (String)"GupOperativesZielAbschnittEditor.getTitle");
    }

    public void setTitle(String title) {
    }

    public void editorClosed(EditorClosedEvent event) {
        this.linearReferencedLineEditor.editorClosed(event);
    }

    private void validatePflegeziel() {
        this.lblValid.setVisible(false);
        CismetThreadPool.execute((Runnable)new SwingWorker<PflegezieleValidator.ValidationResult, Void>(){
            List<String> errors = new ArrayList<String>();

            @Override
            protected PflegezieleValidator.ValidationResult doInBackground() throws Exception {
                if (GupOperativesZielAbschnittEditor.this.validator == null) {
                    return null;
                }
                return GupOperativesZielAbschnittEditor.this.validator.validate(GupOperativesZielAbschnittEditor.this.cidsBean, this.errors);
            }

            @Override
            protected void done() {
                try {
                    PflegezieleValidator.ValidationResult res = (PflegezieleValidator.ValidationResult)((Object)this.get());
                    if (res != null) {
                        GupOperativesZielAbschnittEditor.this.lblValid.setVisible(true);
                    }
                    if (res == PflegezieleValidator.ValidationResult.ok) {
                        GupOperativesZielAbschnittEditor.this.lblValid.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/ok_64.png")));
                        GupOperativesZielAbschnittEditor.this.lblValid.setToolTipText("OK");
                        GupOperativesZielAbschnittEditor.this.textEval.setText("");
                        GupOperativesZielAbschnittEditor.this.jscEval.setVisible(false);
                    } else if (res == PflegezieleValidator.ValidationResult.warning) {
                        GupOperativesZielAbschnittEditor.this.lblValid.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/ok_auflagen_64.png")));
                        GupOperativesZielAbschnittEditor.this.lblValid.setToolTipText("");
                        GupOperativesZielAbschnittEditor.this.textEval.setText("");
                        GupOperativesZielAbschnittEditor.this.jscEval.setVisible(false);
                    } else if (res == PflegezieleValidator.ValidationResult.error) {
                        GupOperativesZielAbschnittEditor.this.lblValid.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/stop_64.png")));
                        StringBuilder errorText = new StringBuilder("<html>");
                        StringBuilder errorT = new StringBuilder("");
                        for (String tmp : this.errors) {
                            errorText.append(tmp).append("<br />");
                            errorT.append(tmp).append("\n");
                        }
                        errorText.append("</html>");
                        GupOperativesZielAbschnittEditor.this.lblValid.setToolTipText(errorText.toString());
                        GupOperativesZielAbschnittEditor.this.textEval.setText(errorT.toString());
                        GupOperativesZielAbschnittEditor.this.jscEval.setVisible(true);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception while validating.", (Throwable)e);
                }
            }
        });
    }

    public void searchValidPflegeziele() {
        WaitingDialogThread<List<Node>> t = new WaitingDialogThread<List<Node>>(StaticSwingTools.getParentFrame((Component)this), true, "Lade g\u00fcltige Pflegeziele", null, 100){

            protected List<Node> doInBackground() throws Exception {
                MetaObject[] mo = GupOperativesZielAbschnittEditor.this.getValidPflegezielObjects();
                ArrayList<Node> validPflegezielList = new ArrayList<Node>();
                for (MetaObject tmp : mo) {
                    if (!OperativeZieleComboBox.isRelevantBean(((OperativeZieleComboBox)GupOperativesZielAbschnittEditor.this.cbName).getKompartiment(), tmp.getBean())) continue;
                    validPflegezielList.add((Node)new MetaObjectNode(tmp.getBean()));
                }
                return validPflegezielList;
            }

            protected void done() {
                try {
                    List validPflegezielList = (List)this.get();
                    if (validPflegezielList.isEmpty()) {
                        JOptionPane.showMessageDialog(GupOperativesZielAbschnittEditor.this, "Es wurden keine validen Pflegeziele gefunden", "Keine validen Pflegeziele gefunden", 1);
                    }
                    MethodManager.getManager().showSearchResults(null, validPflegezielList.toArray(new Node[validPflegezielList.size()]), false);
                    MethodManager.getManager().showSearchResults();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while retrieving Pflegeziel objects.", (Throwable)e);
                }
            }
        };
        t.start();
    }

    private MetaObject[] getValidPflegezielObjects() throws ConnectionException {
        StringBuilder newQuery = new StringBuilder("select distinct " + PFLEGEZIEL_MC.getID() + "," + PFLEGEZIEL_MC.getPrimaryKey() + " from " + PFLEGEZIEL_MC.getTableName() + " p ");
        List<CidsBean> entwicklungszielList = this.validator.getEntwicklungszielIntersectingPflegezielAbschnitt(this.cidsBean);
        List<CidsBean> situationstypList = this.validator.getSituationstypIntersectingPflegezielAbschnitt(this.cidsBean);
        boolean firstCondition = true;
        if (entwicklungszielList != null && !entwicklungszielList.isEmpty()) {
            for (CidsBean entBean : entwicklungszielList) {
                if (firstCondition) {
                    newQuery.append(" WHERE ");
                    firstCondition = false;
                } else {
                    newQuery.append(" AND ");
                }
                newQuery.append(String.format(ENTWICKLUNGSZIEL_TEMPLATE, String.valueOf(entBean.getProperty("id"))));
            }
        }
        if (situationstypList != null && !situationstypList.isEmpty()) {
            for (CidsBean sitBean : situationstypList) {
                if (firstCondition) {
                    newQuery.append(" WHERE ");
                    firstCondition = false;
                } else {
                    newQuery.append(" AND ");
                }
                newQuery.append(String.format(SITUATIONSTYP_TEMPLATE, String.valueOf(sitBean.getProperty("id"))));
            }
        }
        return SessionManager.getProxy().getMetaObjectByQuery(SessionManager.getSession().getUser(), newQuery.toString());
    }

    public boolean prepareForSave() {
        return this.linearReferencedLineEditor.prepareForSave();
    }

    public static void main(String[] args) throws Exception {
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost((String)"WRRL_DB_MV", (String)"Administratoren", (String)"admin", (String)"x", (String)"gup_operatives_ziel", (int)1, (int)1280, (int)1024);
    }

    public PflegezieleValidator getValidator() {
        return this.validator;
    }

    public void setValidator(PflegezieleValidator validator) {
        this.validator = validator;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("massnahme")) {
            this.validatePflegeziel();
        }
    }

    public void beansDropped(ArrayList<CidsBean> beans) {
        if (this.readOnly) {
            return;
        }
        if (this.cidsBean != null) {
            for (CidsBean bean : beans) {
                if (!bean.getClass().getName().equals("de.cismet.cids.dynamics.Gup_operatives_ziel")) continue;
                try {
                    this.cidsBean.setProperty("operatives_ziel", (Object)bean.getMetaObject());
                    this.validatePflegeziel();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while setting new operatives ziel.", (Throwable)ex);
                }
            }
        }
    }
}

