/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.tools.MetaObjectCache;
import Sirius.navigator.types.treenode.DefaultMetaTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GeschuetzteArtAbschnittEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupEntwicklungszielEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupGewaesserabschnittAllgemein;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupGupEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupHydrologEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupOperativesZielAbschnittEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupPoiEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupUmlandnutzungEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupUnterhaltungserfordernisEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupUnterhaltungsmassnahmeEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.LinearReferencedLineEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.SchutzgebietEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.UmlandnutzerEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.VermessungBandElementEditor;
import de.cismet.cids.custom.reports.GeppReport;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WkSearchByStations;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.CheckAssistent;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.CheckAssistentListener;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.ColoredReadOnlyBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.ColoredReadOnlyBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.ColoredReadOnlySnappingBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.GupHelper;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.LineBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.LineBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.MassnBezugListListener;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.MassnahmenBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.MassnahmenBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.QuerbauwerksBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.ReadOnlyTextBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.ReadOnlyTextBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.RulerBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.RulerLabelBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.StationLineBackup;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.UnterhaltungserfordernisBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.UnterhaltungserfordernisBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.UnterhaltungsmassnahmeValidator;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.VermeidungsgruppeMitGeom;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.VermeidungsgruppeRBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.VermeidungsgruppeReadOnlyBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.VermessungsbandHelper;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.VermessungsbandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.WKBand;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingHelper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.TitleComponentProvider;
import de.cismet.tools.gui.jbands.BandModelEvent;
import de.cismet.tools.gui.jbands.EmptyAbsoluteHeightedBand;
import de.cismet.tools.gui.jbands.JBand;
import de.cismet.tools.gui.jbands.SimpleBandModel;
import de.cismet.tools.gui.jbands.interfaces.Band;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandMemberSelectable;
import de.cismet.tools.gui.jbands.interfaces.BandModel;
import de.cismet.tools.gui.jbands.interfaces.BandModelListener;
import edu.umd.cs.piccolo.PNode;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.observablecollections.ObservableList;
import org.jdesktop.observablecollections.ObservableListListener;
import org.openide.util.NbBundle;

public class GupPlanungsabschnittEditor
extends JPanel
implements CidsBeanRenderer,
TitleComponentProvider,
EditorSaveListener,
CheckAssistentListener {
    private static final Logger LOG = Logger.getLogger(GupPlanungsabschnittEditor.class);
    private static final String GUP_MASSNAHME = "gup_unterhaltungsmassnahme";
    private static final String VERMESSUNG = "vermessung_band_element";
    public static final int GUP_UFER_LINKS = 2;
    public static final int GUP_UFER_RECHTS = 1;
    public static final int GUP_UMFELD_RECHTS = 4;
    public static final int GUP_UMFELD_LINKS = 3;
    public static final int GUP_SOHLE = 5;
    private static CidsBean lastGup = null;
    private static UnterhaltungsmassnahmeValidator searchValidator;
    private static CidsBean lastActiveMassnBean;
    private static final ExecutorService executor;
    private static final ExecutorService executorReadOnly;
    private List<CidsBean> rechtesUferList = new ArrayList<CidsBean>();
    private List<CidsBean> sohleList = new ArrayList<CidsBean>();
    private List<CidsBean> linkesUferList = new ArrayList<CidsBean>();
    private List<CidsBean> rechtesUmfeldList = new ArrayList<CidsBean>();
    private List<CidsBean> linkesUmfeldList = new ArrayList<CidsBean>();
    private VermessungsbandHelper vermessungsband;
    private final MassnahmenBand rechtesUferBand = new MassnahmenBand("Ufer rechts", "gup_unterhaltungsmassnahme", Boolean.TRUE);
    private final MassnahmenBand sohleBand = new MassnahmenBand("Sohle", "gup_unterhaltungsmassnahme", null);
    private final MassnahmenBand linkesUferBand = new MassnahmenBand("Ufer links", "gup_unterhaltungsmassnahme", Boolean.FALSE);
    private final MassnahmenBand rechtesUmfeldBand = new MassnahmenBand("Umfeld rechts", "gup_unterhaltungsmassnahme", Boolean.TRUE);
    private final MassnahmenBand linkesUmfeldBand = new MassnahmenBand("Umfeld links", "gup_unterhaltungsmassnahme", Boolean.FALSE);
    private boolean isNew = false;
    private final ColoredReadOnlyBand nutzungLinksBand = new ColoredReadOnlyBand("Umlandnutzung links", "art", "art.name");
    private final ColoredReadOnlyBand nutzungRechtsBand = new ColoredReadOnlyBand("Umlandnutzung rechts", "art", "art.name");
    private final ColoredReadOnlySnappingBand schutzgebietLinksBand = new ColoredReadOnlySnappingBand("Schutzgebiet links", "art", "art.name");
    private final ColoredReadOnlySnappingBand schutzgebietRechtsBand = new ColoredReadOnlySnappingBand("Schutzgebiet rechts", "art", "art.name");
    private final ColoredReadOnlySnappingBand schutzgebietSohleBand = new ColoredReadOnlySnappingBand("Schutzgebiet Sohle", "art", "art.name");
    private final VermeidungsgruppeRBand verbreitungsraumLinksBand = new VermeidungsgruppeRBand("Verbreitungsraum links");
    private final VermeidungsgruppeRBand verbreitungsraumRechtsBand = new VermeidungsgruppeRBand("Verbreitungsraum rechts");
    private final VermeidungsgruppeRBand verbreitungsraumUmfeldLinksBand = new VermeidungsgruppeRBand("Verbreitungsraum Umfeld links");
    private final VermeidungsgruppeRBand verbreitungsraumUmfeldRechtsBand = new VermeidungsgruppeRBand("Verbreitungsraum Umfeld rechts");
    private final VermeidungsgruppeRBand verbreitungsraumSohleBand = new VermeidungsgruppeRBand("Verbreitungsraum Sohle");
    private final ColoredReadOnlyBand operativeZieleLinksBand = new ColoredReadOnlyBand("Pflegeziele links", "operatives_ziel", "operatives_ziel.name");
    private final ColoredReadOnlyBand operativeZieleRechtsBand = new ColoredReadOnlyBand("Pflegeziele rechts", "operatives_ziel", "operatives_ziel.name");
    private final ColoredReadOnlyBand operativeZieleSohleBand = new ColoredReadOnlyBand("Pflegeziele Sohle", "operatives_ziel", "operatives_ziel.name");
    private final ColoredReadOnlyBand operativeZieleUmfeldLinksBand = new ColoredReadOnlyBand("Pflegeziele Umfeld links", "operatives_ziel", "operatives_ziel.name");
    private final ColoredReadOnlyBand operativeZieleUmfeldRechtsBand = new ColoredReadOnlyBand("Pflegeziele Umfeld rechts", "operatives_ziel", "operatives_ziel.name");
    private final ColoredReadOnlyBand entwicklungszielBand = new ColoredReadOnlyBand("WRRL-Ma\u00dfnahme bis 27", "name_bezeichnung", "name_bezeichnung.name");
    private final ColoredReadOnlyBand entwicklungszielBand33 = new ColoredReadOnlyBand("WRRL-Ma\u00dfnahme nach 27", "name_bezeichnung", "name_bezeichnung.name");
    private final ReadOnlyTextBand unterhaltungshinweisLinks = new ReadOnlyTextBand("Unterhaltungshinweise links", "art.name", "art.name");
    private final ReadOnlyTextBand unterhaltungshinweisRechts = new ReadOnlyTextBand("Unterhaltungshinweise rechts", "art.name", "art.name");
    private final ReadOnlyTextBand unterhaltungshinweisSohle = new ReadOnlyTextBand("Unterhaltungshinweise Sohle", "art.name", "art.name");
    private final ReadOnlyTextBand umlandnutzerLinks = new ReadOnlyTextBand("Umlandnutzer links", null, null);
    private final ReadOnlyTextBand umlandnutzerRechts = new ReadOnlyTextBand("Umlandnutzer rechts", null, null);
    private final ColoredReadOnlyBand hydrologieBand = new ColoredReadOnlyBand("Hydraulik", null, null);
    private final RulerBand ruler = new RulerBand(0.0, 5000.0);
    private final RulerLabelBand rulerLabel = new RulerLabelBand(0.0, 5000.0);
    private final UnterhaltungserfordernisBand unterhaltungserfordernisBand = new UnterhaltungserfordernisBand();
    private WKBand wkband;
    private final QuerbauwerksBand querbauwerksband = new QuerbauwerksBand();
    private final EmptyAbsoluteHeightedBand operativeZieleFiller = new EmptyAbsoluteHeightedBand(5);
    private final EmptyAbsoluteHeightedBand unterhaltungshinweisFiller = new EmptyAbsoluteHeightedBand(5);
    private final EmptyAbsoluteHeightedBand schutzgebieteFiller = new EmptyAbsoluteHeightedBand(5);
    private final EmptyAbsoluteHeightedBand hydrologieFiller = new EmptyAbsoluteHeightedBand(5);
    private final EmptyAbsoluteHeightedBand verbreitungsraumFiller = new EmptyAbsoluteHeightedBand(5);
    private final EmptyAbsoluteHeightedBand wkBandFiller = new EmptyAbsoluteHeightedBand(5);
    private JBand jband;
    private final BandModelListener modelListener = new GupGewaesserabschnittBandModelListener();
    private final SimpleBandModel sbm = new SimpleBandModel();
    private final String gwk;
    private CidsBean cidsBean;
    private final VermessungBandElementEditor vermessungsEditor = new VermessungBandElementEditor();
    private final GupEntwicklungszielEditor entwicklungszielEditor = new GupEntwicklungszielEditor(true);
    private final GupPoiEditor unterhaltungshinweisEditor = new GupPoiEditor(true);
    private final UmlandnutzerEditor umlandnutzerEditor = new UmlandnutzerEditor(true);
    private final GupUnterhaltungserfordernisEditor unterhaltungserfordernisEditor = new GupUnterhaltungserfordernisEditor(true);
    private GupUnterhaltungsmassnahmeEditor massnahmeEditor;
    private final GupUmlandnutzungEditor umlandnutzungEditor = new GupUmlandnutzungEditor(true);
    private final SchutzgebietEditor schutzgebietEditor = new SchutzgebietEditor(true);
    private final GupOperativesZielAbschnittEditor operativesZielEditor = new GupOperativesZielAbschnittEditor(true);
    private final GeschuetzteArtAbschnittEditor verbreitungsraumEditor = new GeschuetzteArtAbschnittEditor(true, true);
    private GupGewaesserabschnittAllgemein allgemeinEditor;
    private final GupHydrologEditor hydroEditor = new GupHydrologEditor(true);
    private boolean readOnly = false;
    private boolean initialReadOnly = false;
    private final StationLineBackup stationBackup = new StationLineBackup("linie");
    private UnterhaltungsmassnahmeValidator validator;
    private ButtonGroup bgrpDetails;
    private JButton btnReport;
    private JToggleButton butStationierung;
    private JCheckBox chkEntwicklungsziel;
    private JCheckBox chkEntwicklungsziel33;
    private JCheckBox chkHydrologie;
    private JCheckBox chkMassnahmen;
    private JCheckBox chkNaturschutz;
    private JCheckBox chkOperativeZiele;
    private JCheckBox chkQuerbauwerke;
    private JCheckBox chkSonstigeMassnahmen;
    private JCheckBox chkUmlandnutzer;
    private JCheckBox chkUmlandnutzung;
    private JCheckBox chkUnterhaltungserfordernis;
    private JCheckBox chkUnterhaltungshinweise;
    private JCheckBox chkVerbreitungsraum;
    private JCheckBox chkWasserkoerper;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JButton jbApply;
    private JButton jbApply1;
    private JLabel lblFiller;
    private JLabel lblFiller2;
    private JLabel lblFiller3;
    private JLabel lblFiller4;
    private JLabel lblFiller5;
    private JLabel lblFoot;
    private JLabel lblGup;
    private JLabel lblHeading;
    private JLabel lblLos;
    private JLabel lblLosVal;
    private JLabel lblStatus;
    private JLabel lblSubTitle;
    private JLabel lblTitle;
    private LinearReferencedLineEditor linearReferencedLineEditor;
    private JPanel panAllgemein;
    private JPanel panApply;
    private JPanel panApplyBand;
    private JPanel panBand;
    private JPanel panBandControl;
    private JPanel panEmpty;
    private JPanel panEntwicklungsziel;
    private JPanel panFooter;
    private SemiRoundedPanel panHeadInfo;
    private JPanel panHeader;
    private JPanel panHeaderInfo;
    private JPanel panHydro;
    private RoundedPanel panInfo;
    private JPanel panInfoContent;
    private JPanel panMassnahme;
    private JPanel panMassnahmeSonstige;
    private JPanel panNew;
    private JPanel panOperativeZiele;
    private JPanel panSchutzgebiet;
    private JPanel panTitle;
    private JPanel panUmlandnutzer;
    private JPanel panUmlandnutzung;
    private JPanel panUnterhaltungserfordernis;
    private JPanel panUnterhaltungshinweis;
    private JPanel panVerbreitungsraum;
    private JPanel panVermessung;
    private JSlider sldZoom;
    private JScrollPane spBand;
    private JToggleButton togAllgemeinInfo;
    private JToggleButton togApplyStats;
    private BindingGroup bindingGroup;

    public GupPlanungsabschnittEditor() {
        this(false);
    }

    public GupPlanungsabschnittEditor(boolean readOnly) {
        this.gwk = null;
        this.initialReadOnly = readOnly;
        this.jband = new JBand(readOnly);
        this.initComponents();
        this.butStationierung.setVisible(!readOnly);
        this.spBand.getViewport().setOpaque(false);
        this.massnahmeEditor = new GupUnterhaltungsmassnahmeEditor(readOnly);
        this.allgemeinEditor = new GupGewaesserabschnittAllgemein(readOnly);
        this.rechtesUferBand.setReadOnly(readOnly);
        this.linkesUferBand.setReadOnly(readOnly);
        this.rechtesUmfeldBand.setReadOnly(readOnly);
        this.linkesUmfeldBand.setReadOnly(readOnly);
        this.sohleBand.setReadOnly(readOnly);
        this.unterhaltungserfordernisBand.setEnabled(false);
        this.entwicklungszielBand.setEnabled(false);
        this.entwicklungszielBand33.setEnabled(false);
        this.unterhaltungshinweisLinks.setEnabled(false);
        this.unterhaltungshinweisRechts.setEnabled(false);
        this.unterhaltungshinweisSohle.setEnabled(false);
        this.umlandnutzerLinks.setEnabled(false);
        this.umlandnutzerRechts.setEnabled(false);
        this.hydrologieBand.setEnabled(false);
        this.hydrologieBand.setUseBorder(true);
        this.querbauwerksband.setEnabled(false);
        this.rechtesUmfeldBand.setEnabled(false);
        this.linkesUmfeldBand.setEnabled(false);
        this.nutzungLinksBand.setEnabled(false);
        this.nutzungRechtsBand.setEnabled(false);
        this.schutzgebietRechtsBand.setEnabled(false);
        this.schutzgebietSohleBand.setEnabled(false);
        this.schutzgebietLinksBand.setEnabled(false);
        this.verbreitungsraumRechtsBand.setEnabled(false);
        this.verbreitungsraumLinksBand.setEnabled(false);
        this.verbreitungsraumUmfeldRechtsBand.setEnabled(false);
        this.verbreitungsraumUmfeldLinksBand.setEnabled(false);
        this.verbreitungsraumSohleBand.setEnabled(false);
        this.operativeZieleRechtsBand.setEnabled(false);
        this.operativeZieleLinksBand.setEnabled(false);
        this.operativeZieleSohleBand.setEnabled(false);
        this.operativeZieleUmfeldLinksBand.setEnabled(false);
        this.operativeZieleUmfeldRechtsBand.setEnabled(false);
        this.operativeZieleFiller.setEnabled(false);
        this.unterhaltungshinweisFiller.setEnabled(false);
        this.schutzgebieteFiller.setEnabled(false);
        this.hydrologieFiller.setEnabled(false);
        this.verbreitungsraumFiller.setEnabled(false);
        this.wkBandFiller.setEnabled(false);
        this.sohleBand.setMeasureType(5);
        this.rechtesUferBand.setMeasureType(1);
        this.linkesUferBand.setMeasureType(2);
        this.rechtesUmfeldBand.setMeasureType(4);
        this.linkesUmfeldBand.setMeasureType(3);
        this.wkband = new WKBand(this.sbm.getMin(), this.sbm.getMax());
        this.sbm.addBand((Band)this.wkband);
        this.sbm.addBand((Band)this.wkBandFiller);
        this.sbm.addBand((Band)this.entwicklungszielBand);
        this.sbm.addBand((Band)this.entwicklungszielBand33);
        this.sbm.addBand((Band)this.unterhaltungserfordernisBand);
        this.sbm.addBand((Band)new EmptyAbsoluteHeightedBand(5));
        this.sbm.addBand((Band)this.unterhaltungshinweisRechts);
        this.sbm.addBand((Band)this.unterhaltungshinweisSohle);
        this.sbm.addBand((Band)this.unterhaltungshinweisLinks);
        this.sbm.addBand((Band)this.unterhaltungshinweisFiller);
        this.sbm.addBand((Band)this.verbreitungsraumUmfeldRechtsBand);
        this.sbm.addBand((Band)this.verbreitungsraumRechtsBand);
        this.sbm.addBand((Band)this.verbreitungsraumSohleBand);
        this.sbm.addBand((Band)this.verbreitungsraumLinksBand);
        this.sbm.addBand((Band)this.verbreitungsraumUmfeldLinksBand);
        this.sbm.addBand((Band)this.verbreitungsraumFiller);
        this.sbm.addBand((Band)this.schutzgebietRechtsBand);
        this.sbm.addBand((Band)this.schutzgebietSohleBand);
        this.sbm.addBand((Band)this.schutzgebietLinksBand);
        this.sbm.addBand((Band)this.schutzgebieteFiller);
        this.sbm.addBand((Band)this.operativeZieleUmfeldRechtsBand);
        this.sbm.addBand((Band)this.operativeZieleRechtsBand);
        this.sbm.addBand((Band)this.operativeZieleSohleBand);
        this.sbm.addBand((Band)this.operativeZieleLinksBand);
        this.sbm.addBand((Band)this.operativeZieleUmfeldLinksBand);
        this.sbm.addBand((Band)this.operativeZieleFiller);
        this.sbm.addBand((Band)this.umlandnutzerRechts);
        this.sbm.addBand((Band)this.nutzungRechtsBand);
        this.sbm.addBand((Band)this.rechtesUmfeldBand);
        this.sbm.addBand((Band)this.rechtesUferBand);
        this.sbm.addBand((Band)this.sohleBand);
        this.sbm.addBand((Band)this.linkesUferBand);
        this.sbm.addBand((Band)this.linkesUmfeldBand);
        this.sbm.addBand((Band)this.nutzungLinksBand);
        this.sbm.addBand((Band)this.umlandnutzerLinks);
        this.sbm.addBand((Band)new EmptyAbsoluteHeightedBand(5));
        this.sbm.addBand((Band)this.hydrologieBand);
        this.sbm.addBand((Band)this.hydrologieFiller);
        this.sbm.addBand((Band)this.querbauwerksband);
        this.sbm.addBand((Band)new EmptyAbsoluteHeightedBand(5));
        this.jband.setModel((BandModel)this.sbm);
        this.panBand.add((Component)this.jband, "Center");
        this.jband.setHorizontalScrollBarPolicy(32);
        this.switchToForm("allgemein");
        this.lblHeading.setText("Allgemeine Informationen");
        this.panEntwicklungsziel.add((Component)this.entwicklungszielEditor, "Center");
        this.panUnterhaltungshinweis.add((Component)this.unterhaltungshinweisEditor, "Center");
        this.panUmlandnutzer.add((Component)this.umlandnutzerEditor, "Center");
        this.panUnterhaltungserfordernis.add((Component)this.unterhaltungserfordernisEditor, "Center");
        this.panVermessung.add((Component)this.vermessungsEditor, "Center");
        this.panMassnahme.add((Component)this.massnahmeEditor, "Center");
        this.panUmlandnutzung.add((Component)this.umlandnutzungEditor, "Center");
        this.panSchutzgebiet.add((Component)this.schutzgebietEditor, "Center");
        this.panOperativeZiele.add((Component)this.operativesZielEditor, "Center");
        this.panVerbreitungsraum.add((Component)this.verbreitungsraumEditor, "Center");
        this.panAllgemein.add((Component)this.allgemeinEditor, "Center");
        this.panHydro.add((Component)this.hydroEditor, "Center");
        this.sbm.addBandModelListener(this.modelListener);
        this.sldZoom.setPaintTrack(false);
        if (!readOnly) {
            this.vermessungsband = new VermessungsbandHelper(this.jband, this.modelListener, this.panBand, this.panApplyBand, this.panApply, this.togApplyStats);
        } else {
            this.togApplyStats.setVisible(false);
        }
    }

    private ExecutorService getExecutor() {
        return this.initialReadOnly ? executorReadOnly : executor;
    }

    private void normalizeDimensions(JComponent c) {
        c.setMinimumSize(new Dimension(1, 1));
        c.setPreferredSize(new Dimension(1, 1));
    }

    private void switchToForm(final String id) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ((CardLayout)GupPlanungsabschnittEditor.this.panInfoContent.getLayout()).show(GupPlanungsabschnittEditor.this.panInfoContent, id);
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        this.cidsBean = cidsBean;
        this.switchToForm("empty");
        this.lblHeading.setText("");
        if (cidsBean != null) {
            this.setReadOnly(this.isReadOnly());
            this.bindingGroup.bind();
            if (!this.readOnly) {
                this.vermessungsband.setCidsBean(cidsBean);
            }
            boolean bl = this.isNew = cidsBean.getProperty("linie") == null;
            if (cidsBean.getProperty("linie") == null) {
                this.panBand.removeAll();
                CidsBean gupBean = null;
                if (lastGup != null) {
                    gupBean = lastGup;
                    lastGup = null;
                } else {
                    DefaultMetaTreeNode dmtn = ComponentRegistry.getRegistry().getCatalogueTree().getSelectedNode();
                    ObjectTreeNode node = (ObjectTreeNode)dmtn.getParent();
                    gupBean = node.getMetaObject().getBean();
                }
                try {
                    if (!this.readOnly && cidsBean.getProperty("gup") == null) {
                        cidsBean.setProperty("gup", (Object)gupBean);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while setting the gup id.", (Throwable)e);
                }
                this.panBand.add((Component)this.panNew, "Center");
                this.linearReferencedLineEditor.setLineField("linie");
                this.linearReferencedLineEditor.setCidsBean(cidsBean);
            } else {
                this.setNamesAndBands();
            }
            String status = GupGupEditor.determineStatusNameByGupBean((CidsBean)cidsBean.getProperty("gup"));
            this.lblStatus.setText("Status: " + status);
        }
    }

    private void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.jband.setReadOnly(readOnly);
        this.massnahmeEditor = new GupUnterhaltungsmassnahmeEditor(readOnly);
        this.allgemeinEditor = new GupGewaesserabschnittAllgemein(readOnly);
        this.panMassnahme.removeAll();
        this.panAllgemein.removeAll();
        this.panMassnahme.add(this.massnahmeEditor);
        this.panAllgemein.add((Component)this.allgemeinEditor, "Center");
        this.butStationierung.setVisible(!readOnly);
        this.rechtesUferBand.setReadOnly(readOnly);
        this.linkesUferBand.setReadOnly(readOnly);
        this.rechtesUmfeldBand.setReadOnly(readOnly);
        this.linkesUmfeldBand.setReadOnly(readOnly);
        this.sohleBand.setReadOnly(readOnly);
        if (!readOnly) {
            this.vermessungsband = new VermessungsbandHelper(this.jband, this.modelListener, this.panBand, this.panApplyBand, this.panApply, this.togApplyStats);
            this.togApplyStats.setVisible(true);
        } else {
            this.vermessungsband = null;
            this.togApplyStats.setVisible(false);
        }
    }

    private boolean isReadOnly() {
        if (this.initialReadOnly) {
            return true;
        }
        Boolean isClosed = (Boolean)this.cidsBean.getProperty("gup.geschlossen");
        if (isClosed != null && isClosed.booleanValue()) {
            return true;
        }
        Integer statId = GupGupEditor.determineStatusByGupBean((CidsBean)this.cidsBean.getProperty("gup"));
        if (statId == null) {
            statId = 0;
        }
        return !GupGupEditor.hasActionSachbearbeiter() || statId != 0;
    }

    private void setNamesAndBands() {
        searchValidator = this.validator = new UnterhaltungsmassnahmeValidator();
        if (!this.initialReadOnly) {
            CheckAssistent.getInstance().dispose();
            CheckAssistent.getInstance().setForceReadOnly(false);
            CheckAssistent.getInstance().addListener(this);
            CheckAssistent.getInstance().setCidsBean(this.cidsBean);
        } else if (CheckAssistent.getInstance().getCidsBean() == null || CheckAssistent.getInstance().isForceReadOnly()) {
            CheckAssistent.getInstance().dispose();
            CheckAssistent.getInstance().setForceReadOnly(true);
            CheckAssistent.getInstance().addListener(this);
            CheckAssistent.getInstance().setCidsBean(this.cidsBean);
        }
        this.massnahmeEditor.setValidator(this.validator);
        this.rechtesUferBand.setUnterhaltungsmassnahmeValidator(this.validator);
        this.sohleBand.setUnterhaltungsmassnahmeValidator(this.validator);
        this.linkesUferBand.setUnterhaltungsmassnahmeValidator(this.validator);
        this.rechtesUmfeldBand.setUnterhaltungsmassnahmeValidator(this.validator);
        this.linkesUmfeldBand.setUnterhaltungsmassnahmeValidator(this.validator);
        CidsBean route = LinearReferencingHelper.getRouteBeanFromStationBean((CidsBean)this.cidsBean.getProperty("linie.von"));
        double from = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty("linie.von"));
        double till = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty("linie.bis"));
        this.sbm.setMin(from);
        this.sbm.setMax(till);
        this.wkband.setMinMax(from, till);
        this.ruler.setMinMax(from, till);
        this.rulerLabel.setMinMax(from, till);
        if (!this.readOnly) {
            this.vermessungsband.setVwkBand(new WKBand(this.sbm.getMin(), this.sbm.getMax()));
        }
        this.jband.setMinValue(from);
        this.jband.setMaxValue(till);
        this.rechtesUferBand.setRoute(route);
        this.sohleBand.setRoute(route);
        this.linkesUferBand.setRoute(route);
        this.rechtesUmfeldBand.setRoute(route);
        this.linkesUmfeldBand.setRoute(route);
        List all = this.cidsBean.getBeanCollectionProperty("massnahmen");
        this.rechtesUferList = new ArrayList<CidsBean>();
        this.sohleList = new ArrayList<CidsBean>();
        this.linkesUferList = new ArrayList<CidsBean>();
        this.rechtesUmfeldList = new ArrayList<CidsBean>();
        this.linkesUmfeldList = new ArrayList<CidsBean>();
        for (CidsBean tmp : all) {
            Integer kind = (Integer)tmp.getProperty("wo.id");
            switch (kind) {
                case 2: {
                    this.linkesUferList.add(tmp);
                    break;
                }
                case 1: {
                    this.rechtesUferList.add(tmp);
                    break;
                }
                case 3: {
                    this.linkesUmfeldList.add(tmp);
                    break;
                }
                case 4: {
                    this.rechtesUmfeldList.add(tmp);
                    break;
                }
                case 5: {
                    this.sohleList.add(tmp);
                }
            }
        }
        this.rechtesUferList = ObservableCollections.observableList(this.rechtesUferList);
        this.linkesUferList = ObservableCollections.observableList(this.linkesUferList);
        this.sohleList = ObservableCollections.observableList(this.sohleList);
        this.rechtesUmfeldList = ObservableCollections.observableList(this.rechtesUmfeldList);
        this.linkesUmfeldList = ObservableCollections.observableList(this.linkesUmfeldList);
        ((ObservableList)this.rechtesUferList).addObservableListListener((ObservableListListener)new MassnahmenListListener(1, this.cidsBean, "massnahmen"));
        ((ObservableList)this.linkesUferList).addObservableListListener((ObservableListListener)new MassnahmenListListener(2, this.cidsBean, "massnahmen"));
        ((ObservableList)this.rechtesUmfeldList).addObservableListListener((ObservableListListener)new MassnahmenListListener(4, this.cidsBean, "massnahmen"));
        ((ObservableList)this.linkesUmfeldList).addObservableListListener((ObservableListListener)new MassnahmenListListener(3, this.cidsBean, "massnahmen"));
        ((ObservableList)this.sohleList).addObservableListListener((ObservableListListener)new MassnahmenListListener(5, this.cidsBean, "massnahmen"));
        this.rechtesUferBand.setCidsBeans(this.rechtesUferList);
        this.sohleBand.setCidsBeans(this.sohleList);
        this.linkesUferBand.setCidsBeans(this.linkesUferList);
        this.rechtesUmfeldBand.setCidsBeans(this.rechtesUmfeldList);
        this.linkesUmfeldBand.setCidsBeans(this.linkesUmfeldList);
        this.allgemeinEditor.setCidsBean(this.cidsBean);
        String rname = String.valueOf(route.getProperty("routenname"));
        this.lblSubTitle.setText(rname + " [" + (int)this.sbm.getMin() + "," + (int)this.sbm.getMax() + "]");
        this.loadExternalData(route);
    }

    private void loadExternalData(final CidsBean route) {
        final Boolean freezed = (Boolean)this.cidsBean.getProperty("gup.eingefroren");
        Timestamp freezeTime = (Timestamp)this.cidsBean.getProperty("gup.eingefroren_zeit");
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        final String freezedTimeString = freezed != null && freezed != false && freezeTime != null ? "Stand: " + formatter.format(freezeTime) : "";
        this.getExecutor().execute(new SwingWorker<ArrayList<ArrayList>, Void>(){

            @Override
            protected ArrayList<ArrayList> doInBackground() throws Exception {
                WkSearchByStations searchWK = new WkSearchByStations(GupPlanungsabschnittEditor.this.sbm.getMin(), GupPlanungsabschnittEditor.this.sbm.getMax(), String.valueOf(route.getProperty("gwk")));
                Collection resWK = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)searchWK);
                return (ArrayList)resWK;
            }

            @Override
            protected void done() {
                try {
                    ArrayList res = (ArrayList)this.get();
                    GupPlanungsabschnittEditor.this.wkband.setWK(res);
                    if (!GupPlanungsabschnittEditor.this.readOnly) {
                        GupPlanungsabschnittEditor.this.vermessungsband.setWk(res);
                    }
                    ((SimpleBandModel)GupPlanungsabschnittEditor.this.jband.getModel()).fireBandModelChanged();
                    GupPlanungsabschnittEditor.this.updateUI();
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem beim Suchen der Wasserk\u00f6rper", (Throwable)e);
                }
            }
        });
        this.getExecutor().execute(new SwingWorker<ArrayList<ArrayList>, Void>(){

            @Override
            protected ArrayList<ArrayList> doInBackground() throws Exception {
                ArrayList<Object> in = new ArrayList<Object>(3);
                in.add(GupPlanungsabschnittEditor.this.sbm.getMin());
                in.add(GupPlanungsabschnittEditor.this.sbm.getMax());
                in.add(route.getProperty("gwk"));
                return (ArrayList)GupHelper.querbauwerkCache.calcValue(in);
            }

            @Override
            protected void done() {
                try {
                    GupPlanungsabschnittEditor.this.chkQuerbauwerke.setEnabled(true);
                    GupPlanungsabschnittEditor.this.querbauwerksband.addQuerbauwerkeFromQueryResult((ArrayList)this.get());
                    ((SimpleBandModel)GupPlanungsabschnittEditor.this.jband.getModel()).fireBandModelChanged();
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem beim Suchen der Querbauwerke", (Throwable)e);
                }
            }
        });
        this.getExecutor().execute(new SwingWorker<Collection<CidsBean>, Void>(){

            @Override
            protected Collection<CidsBean> doInBackground() throws Exception {
                if (freezed != null && freezed.booleanValue()) {
                    String schutzgebiete = (String)GupPlanungsabschnittEditor.this.cidsBean.getProperty("eingefrorene_schutzgebiete");
                    GupPlanungsabschnittEditor.this.chkNaturschutz.setToolTipText(freezedTimeString);
                    if (schutzgebiete == null) {
                        return new ArrayList<CidsBean>();
                    }
                    CidsBean bean = CidsBean.createNewCidsBeanFromJSON((boolean)true, (String)schutzgebiete);
                    if (bean != null && bean.getBeanCollectionProperty("schutzgebiete") != null) {
                        return bean.getBeanCollectionProperty("schutzgebiete");
                    }
                    return new ArrayList<CidsBean>();
                }
                ArrayList<Object> in = new ArrayList<Object>(3);
                in.add(GupPlanungsabschnittEditor.this.sbm.getMin());
                in.add(GupPlanungsabschnittEditor.this.sbm.getMax());
                in.add(route.getProperty("gwk"));
                MetaObject[] metaObjects = (MetaObject[])GupHelper.schutzgebietCache.calcValue(in);
                ArrayList<CidsBean> beanList = new ArrayList<CidsBean>();
                if (metaObjects != null) {
                    for (MetaObject mo : metaObjects) {
                        beanList.add(mo.getBean());
                    }
                }
                return beanList;
            }

            @Override
            protected void done() {
                try {
                    Collection result = (Collection)this.get();
                    ArrayList<CidsBean> beansLeft = new ArrayList<CidsBean>();
                    ArrayList<CidsBean> beansRight = new ArrayList<CidsBean>();
                    ArrayList<CidsBean> beansSohle = new ArrayList<CidsBean>();
                    GupPlanungsabschnittEditor.this.validator.setSchutzgebiete(result);
                    for (CidsBean tmp : result) {
                        CidsBean side = (CidsBean)tmp.getProperty("wo");
                        if (side == null) continue;
                        if ((Integer)side.getProperty("id") == 1) {
                            beansRight.add(tmp);
                            continue;
                        }
                        if ((Integer)side.getProperty("id") == 2) {
                            beansLeft.add(tmp);
                            continue;
                        }
                        if ((Integer)side.getProperty("id") != 5) continue;
                        beansSohle.add(tmp);
                    }
                    GupPlanungsabschnittEditor.this.schutzgebietLinksBand.setCidsBeans(beansLeft);
                    GupPlanungsabschnittEditor.this.schutzgebietRechtsBand.setCidsBeans(beansRight);
                    GupPlanungsabschnittEditor.this.schutzgebietSohleBand.setCidsBeans(beansSohle);
                    GupPlanungsabschnittEditor.this.chkNaturschutz.setEnabled(true);
                    ((SimpleBandModel)GupPlanungsabschnittEditor.this.jband.getModel()).fireBandModelChanged();
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem beim Suchen der Schutzgebiete", (Throwable)e);
                }
            }
        });
        this.getExecutor().execute(new SwingWorker<VermeidungsgruppeReadOnlyBandMember[], Void>(){
            private final MetaClass VERMEIDUNGSGRUPPE = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"VERMEIDUNGSGRUPPE");
            private final String query = "select " + this.VERMEIDUNGSGRUPPE.getID() + ", v." + this.VERMEIDUNGSGRUPPE.getPrimaryKey() + " from " + this.VERMEIDUNGSGRUPPE.getTableName() + " v join VERMEIDUNGSGRUPPE_GESCHUETZTE_ART vga on v.arten = vga.vermeidungsgruppe_reference join geschuetzte_art ga on vga.art = ga.id where ga.id = ";

            @Override
            protected VermeidungsgruppeReadOnlyBandMember[] doInBackground() throws Exception {
                Collection beans;
                if (freezed != null && freezed.booleanValue()) {
                    String verbreitungsraeume = (String)GupPlanungsabschnittEditor.this.cidsBean.getProperty("eingefrorene_verbreitungsraeume");
                    GupPlanungsabschnittEditor.this.chkVerbreitungsraum.setToolTipText(freezedTimeString);
                    beans = verbreitungsraeume == null ? new ArrayList() : CidsBean.createNewCidsBeansFromJSONCollection((boolean)true, (String)verbreitungsraeume);
                } else {
                    ArrayList<Object> in = new ArrayList<Object>(3);
                    in.add(GupPlanungsabschnittEditor.this.sbm.getMin());
                    in.add(GupPlanungsabschnittEditor.this.sbm.getMax());
                    in.add(route.getProperty("gwk"));
                    ArrayList<CidsBean> beanList = new ArrayList<CidsBean>();
                    MetaObject[] metaObjects = (MetaObject[])GupHelper.verbreitungsraumCache.calcValue(in);
                    if (metaObjects != null) {
                        for (MetaObject tmp : metaObjects) {
                            boolean umfeld;
                            CidsBean abschnitt = tmp.getBean();
                            Integer woId = (Integer)abschnitt.getProperty("wo.id");
                            boolean sohle = woId == 5;
                            boolean ufer = woId == 2 || woId == 1;
                            boolean bl = umfeld = woId == 3 || woId == 4;
                            String woQuery = sohle ? " AND v.sohle IS TRUE " : (ufer ? " AND v.ufer IS TRUE " : (umfeld ? " AND v.umfeld IS TRUE " : ""));
                            MetaObject[] vermeidungsgruppen = MetaObjectCache.getInstance().getMetaObjectsByQuery(this.query + tmp.getBean().getProperty("art.id") + woQuery, "WRRL_DB_MV");
                            if (vermeidungsgruppen == null) continue;
                            for (MetaObject vermeidungsgruppe : vermeidungsgruppen) {
                                CidsBean newBean = CidsBean.createNewCidsBeanFromTableName((String)"WRRL_DB_MV", (String)"gup_vermeidungsgruppe_art");
                                newBean.setProperty("art", (Object)abschnitt);
                                newBean.setProperty("vermeidungsgruppe", (Object)vermeidungsgruppe.getBean());
                                beanList.add(newBean);
                            }
                        }
                    }
                    beans = beanList;
                }
                ArrayList<VermeidungsgruppeReadOnlyBandMember> res = new ArrayList<VermeidungsgruppeReadOnlyBandMember>();
                if (beans != null) {
                    for (CidsBean tmp : beans) {
                        VermeidungsgruppeReadOnlyBandMember bandMember = new VermeidungsgruppeReadOnlyBandMember();
                        bandMember.setCidsBean((CidsBean)tmp.getProperty("art"), (CidsBean)tmp.getProperty("vermeidungsgruppe"));
                        res.add(bandMember);
                    }
                }
                return res.toArray(new VermeidungsgruppeReadOnlyBandMember[res.size()]);
            }

            @Override
            protected void done() {
                try {
                    VermeidungsgruppeReadOnlyBandMember[] result = (VermeidungsgruppeReadOnlyBandMember[])this.get();
                    ArrayList<VermeidungsgruppeReadOnlyBandMember> beansLeft = new ArrayList<VermeidungsgruppeReadOnlyBandMember>();
                    ArrayList<VermeidungsgruppeReadOnlyBandMember> beansRight = new ArrayList<VermeidungsgruppeReadOnlyBandMember>();
                    ArrayList<VermeidungsgruppeReadOnlyBandMember> beansMiddle = new ArrayList<VermeidungsgruppeReadOnlyBandMember>();
                    ArrayList<VermeidungsgruppeReadOnlyBandMember> beansUmfeldLeft = new ArrayList<VermeidungsgruppeReadOnlyBandMember>();
                    ArrayList<VermeidungsgruppeReadOnlyBandMember> beansUmfeldRight = new ArrayList<VermeidungsgruppeReadOnlyBandMember>();
                    ArrayList<VermeidungsgruppeMitGeom> verbreitungsraeume = new ArrayList<VermeidungsgruppeMitGeom>();
                    for (VermeidungsgruppeReadOnlyBandMember tmp : result) {
                        verbreitungsraeume.add(new VermeidungsgruppeMitGeom(tmp.getVermeidungsgruppe(), tmp.getArt()));
                    }
                    GupPlanungsabschnittEditor.this.validator.setVerbreitungsraum(verbreitungsraeume.toArray(new VermeidungsgruppeMitGeom[verbreitungsraeume.size()]));
                    for (VermeidungsgruppeReadOnlyBandMember tmp : result) {
                        CidsBean side = (CidsBean)tmp.getCidsBean().getProperty("wo");
                        if (side == null) continue;
                        int sideId = (Integer)side.getProperty("id");
                        if (sideId == 1) {
                            beansRight.add(tmp);
                            continue;
                        }
                        if (sideId == 3) {
                            beansUmfeldLeft.add(tmp);
                            continue;
                        }
                        if (sideId == 4) {
                            beansUmfeldRight.add(tmp);
                            continue;
                        }
                        if (sideId == 2) {
                            beansLeft.add(tmp);
                            continue;
                        }
                        if (sideId != 5) continue;
                        beansMiddle.add(tmp);
                    }
                    GupPlanungsabschnittEditor.this.verbreitungsraumLinksBand.addMember(beansLeft);
                    GupPlanungsabschnittEditor.this.verbreitungsraumRechtsBand.addMember(beansRight);
                    GupPlanungsabschnittEditor.this.verbreitungsraumUmfeldLinksBand.addMember(beansUmfeldLeft);
                    GupPlanungsabschnittEditor.this.verbreitungsraumUmfeldRechtsBand.addMember(beansUmfeldRight);
                    GupPlanungsabschnittEditor.this.verbreitungsraumSohleBand.addMember(beansMiddle);
                    GupPlanungsabschnittEditor.this.chkVerbreitungsraum.setEnabled(true);
                    ((SimpleBandModel)GupPlanungsabschnittEditor.this.jband.getModel()).fireBandModelChanged();
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem beim Suchen der Verbreitungsr\u00e4ume", (Throwable)e);
                }
            }
        });
        this.getExecutor().execute(new SwingWorker<Collection<CidsBean>, Void>(){

            @Override
            protected Collection<CidsBean> doInBackground() throws Exception {
                if (freezed != null && freezed.booleanValue()) {
                    String operativeZiele = (String)GupPlanungsabschnittEditor.this.cidsBean.getProperty("eingefrorene_operative_ziele");
                    GupPlanungsabschnittEditor.this.chkOperativeZiele.setToolTipText(freezedTimeString);
                    if (operativeZiele == null) {
                        return new ArrayList<CidsBean>();
                    }
                    CidsBean bean = CidsBean.createNewCidsBeanFromJSON((boolean)true, (String)operativeZiele);
                    if (bean != null && bean.getBeanCollectionProperty("ziele") != null) {
                        return bean.getBeanCollectionProperty("ziele");
                    }
                    return new ArrayList<CidsBean>();
                }
                ArrayList<Object> in = new ArrayList<Object>(3);
                in.add(GupPlanungsabschnittEditor.this.sbm.getMin());
                in.add(GupPlanungsabschnittEditor.this.sbm.getMax());
                in.add(route.getProperty("gwk"));
                MetaObject[] metaObjects = (MetaObject[])GupHelper.operativeZieleCache.calcValue(in);
                ArrayList<CidsBean> beanList = new ArrayList<CidsBean>();
                if (metaObjects != null) {
                    for (MetaObject mo : metaObjects) {
                        beanList.add(mo.getBean());
                    }
                }
                return beanList;
            }

            @Override
            protected void done() {
                try {
                    Collection result = (Collection)this.get();
                    ArrayList<CidsBean> beansLeft = new ArrayList<CidsBean>();
                    ArrayList<CidsBean> beansRight = new ArrayList<CidsBean>();
                    ArrayList<CidsBean> beansMiddle = new ArrayList<CidsBean>();
                    ArrayList<CidsBean> beansUmLeft = new ArrayList<CidsBean>();
                    ArrayList<CidsBean> beansUmRight = new ArrayList<CidsBean>();
                    GupPlanungsabschnittEditor.this.validator.setOperativeZiele(result);
                    for (CidsBean tmp : result) {
                        CidsBean side = (CidsBean)tmp.getProperty("wo");
                        if (side == null) continue;
                        if ((Integer)side.getProperty("id") == 1) {
                            beansRight.add(tmp);
                            continue;
                        }
                        if ((Integer)side.getProperty("id") == 2) {
                            beansLeft.add(tmp);
                            continue;
                        }
                        if ((Integer)side.getProperty("id") == 5) {
                            beansMiddle.add(tmp);
                            continue;
                        }
                        if ((Integer)side.getProperty("id") == 3) {
                            beansUmLeft.add(tmp);
                            continue;
                        }
                        if ((Integer)side.getProperty("id") != 4) continue;
                        beansUmRight.add(tmp);
                    }
                    GupPlanungsabschnittEditor.this.operativeZieleLinksBand.setCidsBeans(beansLeft);
                    GupPlanungsabschnittEditor.this.operativeZieleRechtsBand.setCidsBeans(beansRight);
                    GupPlanungsabschnittEditor.this.operativeZieleSohleBand.setCidsBeans(beansMiddle);
                    GupPlanungsabschnittEditor.this.operativeZieleUmfeldLinksBand.setCidsBeans(beansUmLeft);
                    GupPlanungsabschnittEditor.this.operativeZieleUmfeldRechtsBand.setCidsBeans(beansUmRight);
                    GupPlanungsabschnittEditor.this.chkOperativeZiele.setEnabled(true);
                    ((SimpleBandModel)GupPlanungsabschnittEditor.this.jband.getModel()).fireBandModelChanged();
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem beim Suchen der Operativen Ziele", (Throwable)e);
                }
            }
        });
        this.getExecutor().execute(new SwingWorker<Collection<CidsBean>, Void>(){

            @Override
            protected Collection<CidsBean> doInBackground() throws Exception {
                if (freezed != null && freezed.booleanValue()) {
                    String umlandnutzung = (String)GupPlanungsabschnittEditor.this.cidsBean.getProperty("eingefrorene_umlandnutzung");
                    GupPlanungsabschnittEditor.this.chkUmlandnutzung.setToolTipText(freezedTimeString);
                    if (umlandnutzung == null) {
                        return new ArrayList<CidsBean>();
                    }
                    CidsBean bean = CidsBean.createNewCidsBeanFromJSON((boolean)true, (String)umlandnutzung);
                    if (bean != null && bean.getBeanCollectionProperty("umlandnutzung") != null) {
                        return bean.getBeanCollectionProperty("umlandnutzung");
                    }
                    return new ArrayList<CidsBean>();
                }
                ArrayList<Object> in = new ArrayList<Object>(3);
                in.add(GupPlanungsabschnittEditor.this.sbm.getMin());
                in.add(GupPlanungsabschnittEditor.this.sbm.getMax());
                in.add(route.getProperty("gwk"));
                MetaObject[] metaObjects = (MetaObject[])GupHelper.umlandCache.calcValue(in);
                ArrayList<CidsBean> beanList = new ArrayList<CidsBean>();
                if (metaObjects != null) {
                    for (MetaObject mo : metaObjects) {
                        beanList.add(mo.getBean());
                    }
                }
                return beanList;
            }

            @Override
            protected void done() {
                try {
                    Collection result = (Collection)this.get();
                    ArrayList<CidsBean> beansLeft = new ArrayList<CidsBean>();
                    ArrayList<CidsBean> beansRight = new ArrayList<CidsBean>();
                    for (CidsBean tmp : result) {
                        CidsBean side = (CidsBean)tmp.getProperty("wo");
                        if (side == null) continue;
                        if ((Integer)side.getProperty("id") == 1) {
                            beansRight.add(tmp);
                            continue;
                        }
                        if ((Integer)side.getProperty("id") != 2) continue;
                        beansLeft.add(tmp);
                    }
                    GupPlanungsabschnittEditor.this.nutzungLinksBand.setCidsBeans(beansLeft);
                    GupPlanungsabschnittEditor.this.nutzungRechtsBand.setCidsBeans(beansRight);
                    GupPlanungsabschnittEditor.this.chkUmlandnutzung.setEnabled(true);
                    ((SimpleBandModel)GupPlanungsabschnittEditor.this.jband.getModel()).fireBandModelChanged();
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem beim Suchen der Umlandnutzung", (Throwable)e);
                }
            }
        });
        this.getExecutor().execute(new SwingWorker<Collection<CidsBean>, Void>(){

            @Override
            protected Collection<CidsBean> doInBackground() throws Exception {
                if (freezed != null && freezed.booleanValue()) {
                    String entwicklungsziel = (String)GupPlanungsabschnittEditor.this.cidsBean.getProperty("eingefrorene_entwicklungsziele");
                    GupPlanungsabschnittEditor.this.chkEntwicklungsziel.setToolTipText(freezedTimeString);
                    if (entwicklungsziel == null) {
                        return new ArrayList<CidsBean>();
                    }
                    CidsBean bean = CidsBean.createNewCidsBeanFromJSON((boolean)true, (String)entwicklungsziel);
                    if (bean != null && bean.getBeanCollectionProperty("entwicklungsziele") != null) {
                        ArrayList<CidsBean> beanList = new ArrayList<CidsBean>();
                        for (CidsBean massn : bean.getBeanCollectionProperty("entwicklungsziele")) {
                            Object firstBand = massn.getProperty("first_gepp_band");
                            if (firstBand != null && !((Boolean)firstBand).booleanValue()) continue;
                            beanList.add(massn);
                        }
                        return beanList;
                    }
                    return new ArrayList<CidsBean>();
                }
                ArrayList<Object> in = new ArrayList<Object>(3);
                in.add(GupPlanungsabschnittEditor.this.sbm.getMin());
                in.add(GupPlanungsabschnittEditor.this.sbm.getMax());
                in.add(route.getProperty("gwk"));
                MetaObject[] metaObjects = (MetaObject[])GupHelper.entwicklungszielCache.calcValue(in);
                ArrayList<CidsBean> beanList = new ArrayList<CidsBean>();
                if (metaObjects != null) {
                    for (MetaObject mo : metaObjects) {
                        beanList.add(mo.getBean());
                    }
                }
                return beanList;
            }

            @Override
            protected void done() {
                try {
                    Collection beans = (Collection)this.get();
                    GupPlanungsabschnittEditor.this.entwicklungszielBand.setCidsBeans(beans);
                    GupPlanungsabschnittEditor.this.chkEntwicklungsziel.setEnabled(true);
                    ((SimpleBandModel)GupPlanungsabschnittEditor.this.jband.getModel()).fireBandModelChanged();
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem beim Suchen der WRRL-Ma\u00dfnahmen", (Throwable)e);
                }
            }
        });
        this.getExecutor().execute(new SwingWorker<Collection<CidsBean>, Void>(){

            @Override
            protected Collection<CidsBean> doInBackground() throws Exception {
                if (freezed != null && freezed.booleanValue()) {
                    String entwicklungsziel = (String)GupPlanungsabschnittEditor.this.cidsBean.getProperty("eingefrorene_entwicklungsziele");
                    GupPlanungsabschnittEditor.this.chkEntwicklungsziel.setToolTipText(freezedTimeString);
                    if (entwicklungsziel == null) {
                        return new ArrayList<CidsBean>();
                    }
                    CidsBean bean = CidsBean.createNewCidsBeanFromJSON((boolean)true, (String)entwicklungsziel);
                    if (bean != null && bean.getBeanCollectionProperty("entwicklungsziele") != null) {
                        ArrayList<CidsBean> beanList = new ArrayList<CidsBean>();
                        for (CidsBean massn : bean.getBeanCollectionProperty("entwicklungsziele")) {
                            Object firstBand = massn.getProperty("first_gepp_band");
                            if (firstBand == null || ((Boolean)firstBand).booleanValue()) continue;
                            beanList.add(massn);
                        }
                        return beanList.isEmpty() ? null : beanList;
                    }
                    return new ArrayList<CidsBean>();
                }
                ArrayList<Object> in = new ArrayList<Object>(3);
                in.add(GupPlanungsabschnittEditor.this.sbm.getMin());
                in.add(GupPlanungsabschnittEditor.this.sbm.getMax());
                in.add(route.getProperty("gwk"));
                MetaObject[] metaObjects = (MetaObject[])GupHelper.entwicklungsziel33Cache.calcValue(in);
                ArrayList<CidsBean> beanList = new ArrayList<CidsBean>();
                if (metaObjects != null) {
                    for (MetaObject mo : metaObjects) {
                        beanList.add(mo.getBean());
                    }
                }
                return beanList;
            }

            @Override
            protected void done() {
                try {
                    Collection beans = (Collection)this.get();
                    if (beans == null) {
                        GupPlanungsabschnittEditor.this.chkEntwicklungsziel33.setVisible(false);
                    } else {
                        GupPlanungsabschnittEditor.this.entwicklungszielBand33.setCidsBeans(beans);
                        GupPlanungsabschnittEditor.this.chkEntwicklungsziel33.setEnabled(true);
                        ((SimpleBandModel)GupPlanungsabschnittEditor.this.jband.getModel()).fireBandModelChanged();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem beim Suchen der WRRL-Ma\u00dfnahmen", (Throwable)e);
                }
            }
        });
        this.getExecutor().execute(new SwingWorker<MetaObject[], Void>(){

            @Override
            protected MetaObject[] doInBackground() throws Exception {
                ArrayList<Object> in = new ArrayList<Object>(3);
                in.add(GupPlanungsabschnittEditor.this.sbm.getMin());
                in.add(GupPlanungsabschnittEditor.this.sbm.getMax());
                in.add(route.getProperty("gwk"));
                return (MetaObject[])GupHelper.unterhaltungshinweiseCache.calcValue(in);
            }

            @Override
            protected void done() {
                try {
                    MetaObject[] result = (MetaObject[])this.get();
                    ArrayList<CidsBean> beansLeft = new ArrayList<CidsBean>();
                    ArrayList<CidsBean> beansRight = new ArrayList<CidsBean>();
                    ArrayList<CidsBean> beansMiddle = new ArrayList<CidsBean>();
                    for (MetaObject tmp : result) {
                        CidsBean side = (CidsBean)tmp.getBean().getProperty("wo");
                        if (side == null) continue;
                        if ((Integer)side.getProperty("id") == 1) {
                            beansRight.add(tmp.getBean());
                            continue;
                        }
                        if ((Integer)side.getProperty("id") == 2) {
                            beansLeft.add(tmp.getBean());
                            continue;
                        }
                        if ((Integer)side.getProperty("id") != 5) continue;
                        beansMiddle.add(tmp.getBean());
                    }
                    GupPlanungsabschnittEditor.this.unterhaltungshinweisLinks.setCidsBeans(beansLeft);
                    GupPlanungsabschnittEditor.this.unterhaltungshinweisRechts.setCidsBeans(beansRight);
                    GupPlanungsabschnittEditor.this.unterhaltungshinweisSohle.setCidsBeans(beansMiddle);
                    GupPlanungsabschnittEditor.this.chkUnterhaltungshinweise.setEnabled(true);
                    ((SimpleBandModel)GupPlanungsabschnittEditor.this.jband.getModel()).fireBandModelChanged();
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem beim Suchen der Unterhaltungshinweise", (Throwable)e);
                }
            }
        });
        this.getExecutor().execute(new SwingWorker<MetaObject[], Void>(){

            @Override
            protected MetaObject[] doInBackground() throws Exception {
                ArrayList<Object> in = new ArrayList<Object>(3);
                in.add(GupPlanungsabschnittEditor.this.sbm.getMin());
                in.add(GupPlanungsabschnittEditor.this.sbm.getMax());
                in.add(route.getProperty("gwk"));
                return (MetaObject[])GupHelper.umlandnutzerCache.calcValue(in);
            }

            @Override
            protected void done() {
                try {
                    MetaObject[] result = (MetaObject[])this.get();
                    ArrayList<CidsBean> beansLeft = new ArrayList<CidsBean>();
                    ArrayList<CidsBean> beansRight = new ArrayList<CidsBean>();
                    for (MetaObject tmp : result) {
                        CidsBean side = (CidsBean)tmp.getBean().getProperty("wo");
                        if (side == null) continue;
                        if ((Integer)side.getProperty("id") == 1) {
                            beansRight.add(tmp.getBean());
                            continue;
                        }
                        if ((Integer)side.getProperty("id") != 2) continue;
                        beansLeft.add(tmp.getBean());
                    }
                    GupPlanungsabschnittEditor.this.umlandnutzerLinks.setCidsBeans(beansLeft);
                    GupPlanungsabschnittEditor.this.umlandnutzerRechts.setCidsBeans(beansRight);
                    GupPlanungsabschnittEditor.this.chkUmlandnutzer.setEnabled(true);
                    ((SimpleBandModel)GupPlanungsabschnittEditor.this.jband.getModel()).fireBandModelChanged();
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem beim Suchen der Umlandnutzer", (Throwable)e);
                }
            }
        });
        this.getExecutor().execute(new SwingWorker<MetaObject[], Void>(){

            @Override
            protected MetaObject[] doInBackground() throws Exception {
                ArrayList<Object> in = new ArrayList<Object>(3);
                in.add(GupPlanungsabschnittEditor.this.sbm.getMin());
                in.add(GupPlanungsabschnittEditor.this.sbm.getMax());
                in.add(route.getProperty("gwk"));
                return (MetaObject[])GupHelper.unterhaltungserfordernisCache.calcValue(in);
            }

            @Override
            protected void done() {
                try {
                    MetaObject[] result = (MetaObject[])this.get();
                    ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
                    for (MetaObject tmp : result) {
                        beans.add(tmp.getBean());
                    }
                    GupPlanungsabschnittEditor.this.unterhaltungserfordernisBand.setCidsBeans(beans);
                    GupPlanungsabschnittEditor.this.chkUnterhaltungserfordernis.setEnabled(true);
                    ((SimpleBandModel)GupPlanungsabschnittEditor.this.jband.getModel()).fireBandModelChanged();
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem beim Suchen der Situationstypen", (Throwable)e);
                }
            }
        });
        this.getExecutor().execute(new SwingWorker<MetaObject[], Void>(){

            @Override
            protected MetaObject[] doInBackground() throws Exception {
                ArrayList<Object> in = new ArrayList<Object>(3);
                in.add(GupPlanungsabschnittEditor.this.sbm.getMin());
                in.add(GupPlanungsabschnittEditor.this.sbm.getMax());
                in.add(route.getProperty("gwk"));
                return (MetaObject[])GupHelper.hydrologieCache.calcValue(in);
            }

            @Override
            protected void done() {
                try {
                    MetaObject[] result = (MetaObject[])this.get();
                    ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
                    for (MetaObject tmp : result) {
                        beans.add(tmp.getBean());
                    }
                    GupPlanungsabschnittEditor.this.hydrologieBand.setCidsBeans(beans);
                    GupPlanungsabschnittEditor.this.chkHydrologie.setEnabled(true);
                    ((SimpleBandModel)GupPlanungsabschnittEditor.this.jband.getModel()).fireBandModelChanged();
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem beim Suchen der Hydrologiedaten", (Throwable)e);
                }
            }
        });
    }

    public static void setLastGup(CidsBean gup) {
        lastGup = gup;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public JComponent getTitleComponent() {
        return this.panTitle;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFooter = new JPanel();
        this.lblFoot = new JLabel();
        this.bgrpDetails = new ButtonGroup();
        this.panTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.lblStatus = new JLabel();
        this.togAllgemeinInfo = new JToggleButton();
        this.togApplyStats = new JToggleButton();
        this.butStationierung = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.btnReport = new JButton();
        this.panNew = new JPanel();
        this.linearReferencedLineEditor = new LinearReferencedLineEditor();
        this.jbApply = new JButton();
        this.panApply = new JPanel();
        this.jbApply1 = new JButton();
        this.panApplyBand = new JPanel();
        this.panInfo = new RoundedPanel();
        this.panHeadInfo = new SemiRoundedPanel();
        this.lblHeading = new JLabel();
        this.panInfoContent = new JPanel();
        this.panEntwicklungsziel = new JPanel();
        this.panUnterhaltungserfordernis = new JPanel();
        this.panMassnahmeSonstige = new JPanel();
        this.panEmpty = new JPanel();
        this.panHydro = new JPanel();
        this.panAllgemein = new JPanel();
        this.panUmlandnutzung = new JPanel();
        this.panMassnahme = new JPanel();
        this.panVermessung = new JPanel();
        this.panSchutzgebiet = new JPanel();
        this.panVerbreitungsraum = new JPanel();
        this.panOperativeZiele = new JPanel();
        this.panUnterhaltungshinweis = new JPanel();
        this.panUmlandnutzer = new JPanel();
        this.panHeader = new JPanel();
        this.panHeaderInfo = new JPanel();
        this.jLabel1 = new JLabel();
        this.lblGup = new JLabel();
        this.jLabel3 = new JLabel();
        this.lblSubTitle = new JLabel();
        this.jLabel5 = new JLabel();
        this.sldZoom = new JSlider();
        this.lblLos = new JLabel();
        this.lblLosVal = new JLabel();
        this.panBand = new JPanel();
        this.spBand = new JScrollPane();
        this.panBandControl = new RoundedPanel();
        this.chkMassnahmen = new JCheckBox();
        this.chkSonstigeMassnahmen = new JCheckBox();
        this.chkWasserkoerper = new JCheckBox();
        this.chkUmlandnutzung = new JCheckBox();
        this.chkQuerbauwerke = new JCheckBox();
        this.chkNaturschutz = new JCheckBox();
        this.chkUnterhaltungserfordernis = new JCheckBox();
        this.chkEntwicklungsziel = new JCheckBox();
        this.chkEntwicklungsziel33 = new JCheckBox();
        this.chkVerbreitungsraum = new JCheckBox();
        this.chkOperativeZiele = new JCheckBox();
        this.chkUnterhaltungshinweise = new JCheckBox();
        this.chkUmlandnutzer = new JCheckBox();
        this.chkHydrologie = new JCheckBox();
        this.lblFiller = new JLabel();
        this.lblFiller2 = new JLabel();
        this.lblFiller3 = new JLabel();
        this.lblFiller4 = new JLabel();
        this.lblFiller5 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.panFooter.setMinimumSize(new Dimension(1050, 48));
        this.panFooter.setOpaque(false);
        this.panFooter.setPreferredSize(new Dimension(1050, 48));
        this.panFooter.setLayout(new GridBagLayout());
        this.lblFoot.setFont(new Font("Tahoma", 1, 12));
        this.lblFoot.setForeground(new Color(255, 255, 255));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 25, 7, 25);
        this.panFooter.add((Component)this.lblFoot, gridBagConstraints);
        this.panTitle.setMinimumSize(new Dimension(1050, 36));
        this.panTitle.setOpaque(false);
        this.panTitle.setPreferredSize(new Dimension(1050, 36));
        this.panTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 24));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        this.lblTitle.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.lblTitle.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.lblStatus.setFont(new Font("Tahoma", 1, 14));
        this.lblStatus.setForeground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panTitle.add((Component)this.lblStatus, gridBagConstraints);
        this.bgrpDetails.add(this.togAllgemeinInfo);
        this.togAllgemeinInfo.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.togAllgemeinInfo.text", (Object[])new Object[0]));
        this.togAllgemeinInfo.setPreferredSize(new Dimension(117, 44));
        this.togAllgemeinInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.togAllgemeinInfoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 7);
        this.panTitle.add((Component)this.togAllgemeinInfo, gridBagConstraints);
        this.togApplyStats.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.togApplyStats.text", (Object[])new Object[0]));
        this.togApplyStats.setPreferredSize(new Dimension(117, 44));
        this.togApplyStats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.togApplyStatsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 7);
        this.panTitle.add((Component)this.togApplyStats, gridBagConstraints);
        this.butStationierung.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.butStationierung.text", (Object[])new Object[0]));
        this.butStationierung.setPreferredSize(new Dimension(117, 44));
        this.butStationierung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.butStationierungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 7);
        this.panTitle.add((Component)this.butStationierung, gridBagConstraints);
        this.jPanel1.setMaximumSize(new Dimension(1, 1));
        this.jPanel1.setMinimumSize(new Dimension(1, 1));
        this.jPanel1.setOpaque(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.panTitle.add((Component)this.jPanel1, gridBagConstraints);
        this.btnReport.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wrrl_db_mv/printer.png")));
        this.btnReport.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"FotodokumentationRenderer.btnReport.text"));
        this.btnReport.setBorder(null);
        this.btnReport.setBorderPainted(false);
        this.btnReport.setContentAreaFilled(false);
        this.btnReport.setFocusPainted(false);
        this.btnReport.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wrrl_db_mv/printer_pressed.png")));
        this.btnReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.btnReportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.panTitle.add((Component)this.btnReport, gridBagConstraints);
        this.panNew.setOpaque(false);
        this.panNew.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panNew.add((Component)this.linearReferencedLineEditor, gridBagConstraints);
        this.jbApply.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupGewaesserabschnittEditor.jbApply.text"));
        this.jbApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.jbApplyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panNew.add((Component)this.jbApply, gridBagConstraints);
        this.panApply.setOpaque(false);
        this.panApply.setLayout(new GridBagLayout());
        this.jbApply1.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupGewaesserabschnittEditor.jbApply1.text"));
        this.jbApply1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.jbApply1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(25, 5, 5, 5);
        this.panApply.add((Component)this.jbApply1, gridBagConstraints);
        this.panApplyBand.setOpaque(false);
        this.panApplyBand.setPreferredSize(new Dimension(300, 100));
        this.panApplyBand.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.panApply.add((Component)this.panApplyBand, gridBagConstraints);
        this.setMinimumSize(new Dimension(1050, 850));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(1050, 850));
        this.setLayout(new GridBagLayout());
        this.panInfo.setMinimumSize(new Dimension(740, 460));
        this.panInfo.setPreferredSize(new Dimension(740, 460));
        this.panHeadInfo.setBackground(new Color(51, 51, 51));
        this.panHeadInfo.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading.setForeground(new Color(255, 255, 255));
        this.lblHeading.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.lblHeading.text", (Object[])new Object[0]));
        this.panHeadInfo.add((Component)this.lblHeading);
        this.panInfo.add((Component)this.panHeadInfo, (Object)"North");
        this.panInfoContent.setOpaque(false);
        this.panInfoContent.setLayout(new CardLayout());
        this.panEntwicklungsziel.setOpaque(false);
        this.panEntwicklungsziel.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panEntwicklungsziel, "entwicklungsziel");
        this.panUnterhaltungserfordernis.setOpaque(false);
        this.panUnterhaltungserfordernis.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panUnterhaltungserfordernis, "unterhaltungserfordernis");
        this.panMassnahmeSonstige.setOpaque(false);
        this.panMassnahmeSonstige.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panMassnahmeSonstige, "massnahmesonstige");
        this.panEmpty.setOpaque(false);
        this.panEmpty.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panEmpty, "empty");
        this.panHydro.setOpaque(false);
        this.panHydro.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panHydro, "hydro");
        this.panAllgemein.setOpaque(false);
        this.panAllgemein.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panAllgemein, "allgemein");
        this.panUmlandnutzung.setOpaque(false);
        this.panUmlandnutzung.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panUmlandnutzung, "umlandnutzung");
        this.panMassnahme.setOpaque(false);
        this.panMassnahme.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panMassnahme, "massnahme");
        this.panVermessung.setOpaque(false);
        this.panVermessung.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panVermessung, "vermessung");
        this.panSchutzgebiet.setOpaque(false);
        this.panSchutzgebiet.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panSchutzgebiet, "schutzgebiet");
        this.panVerbreitungsraum.setOpaque(false);
        this.panVerbreitungsraum.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panVerbreitungsraum, "verbreitungsraum");
        this.panOperativeZiele.setOpaque(false);
        this.panOperativeZiele.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panOperativeZiele, "operativeZiele");
        this.panUnterhaltungshinweis.setOpaque(false);
        this.panUnterhaltungshinweis.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panUnterhaltungshinweis, "unterhaltungshinweis");
        this.panUmlandnutzer.setOpaque(false);
        this.panUmlandnutzer.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panUmlandnutzer, "umlandnutzer");
        this.panInfo.add((Component)this.panInfoContent, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.add((Component)this.panInfo, gridBagConstraints);
        this.panHeader.setOpaque(false);
        this.panHeader.setLayout(new GridBagLayout());
        this.panHeaderInfo.setMinimumSize(new Dimension(400, 102));
        this.panHeaderInfo.setOpaque(false);
        this.panHeaderInfo.setPreferredSize(new Dimension(420, 102));
        this.panHeaderInfo.setLayout(null);
        this.jLabel1.setFont(new Font("Lucida Grande", 1, 14));
        this.jLabel1.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.jLabel1.text", (Object[])new Object[0]));
        this.jLabel1.setMinimumSize(new Dimension(91, 22));
        this.panHeaderInfo.add(this.jLabel1);
        this.jLabel1.setBounds(12, 23, 50, 17);
        this.lblGup.setFont(new Font("Lucida Grande", 1, 14));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gup.name}"), (Object)this.lblGup, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.panHeaderInfo.add(this.lblGup);
        this.lblGup.setBounds(110, 23, 290, 20);
        this.jLabel3.setFont(new Font("Lucida Grande", 1, 14));
        this.jLabel3.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.jLabel3.text", (Object[])new Object[0]));
        this.jLabel3.setMinimumSize(new Dimension(91, 22));
        this.panHeaderInfo.add(this.jLabel3);
        this.jLabel3.setBounds(12, 46, 86, 17);
        this.lblSubTitle.setFont(new Font("Lucida Grande", 1, 14));
        this.panHeaderInfo.add(this.lblSubTitle);
        this.lblSubTitle.setBounds(110, 46, 290, 20);
        this.jLabel5.setFont(new Font("Lucida Sans", 1, 14));
        this.jLabel5.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.jLabel5.text", (Object[])new Object[0]));
        this.jLabel5.setMaximumSize(new Dimension(92, 22));
        this.jLabel5.setMinimumSize(new Dimension(92, 22));
        this.jLabel5.setPreferredSize(new Dimension(92, 22));
        this.panHeaderInfo.add(this.jLabel5);
        this.jLabel5.setBounds(12, 68, 80, 20);
        this.sldZoom.setMaximum(200);
        this.sldZoom.setValue(0);
        this.sldZoom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GupPlanungsabschnittEditor.this.sldZoomStateChanged(evt);
            }
        });
        this.panHeaderInfo.add(this.sldZoom);
        this.sldZoom.setBounds(110, 72, 290, 16);
        this.lblLos.setFont(new Font("Lucida Grande", 1, 14));
        this.lblLos.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.lblLos.text", (Object[])new Object[0]));
        this.lblLos.setMinimumSize(new Dimension(91, 22));
        this.panHeaderInfo.add(this.lblLos);
        this.lblLos.setBounds(12, 0, 37, 17);
        this.lblLosVal.setFont(new Font("Lucida Grande", 1, 14));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.los.bezeichnung}"), (Object)this.lblLosVal, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.panHeaderInfo.add(this.lblLosVal);
        this.lblLosVal.setBounds(110, 0, 290, 20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        this.panHeader.add((Component)this.panHeaderInfo, gridBagConstraints);
        this.panBand.setOpaque(false);
        this.panBand.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panHeader.add((Component)this.panBand, gridBagConstraints);
        this.spBand.setBorder(null);
        this.spBand.setHorizontalScrollBarPolicy(31);
        this.spBand.setVerticalScrollBarPolicy(21);
        this.spBand.setViewportBorder(null);
        this.spBand.setMinimumSize(new Dimension(500, 100));
        this.spBand.setOpaque(false);
        this.spBand.setPreferredSize(new Dimension(500, 100));
        this.panBandControl.setPreferredSize(new Dimension(490, 95));
        this.panBandControl.setLayout(new FlowLayout(1, 5, 2));
        this.chkMassnahmen.setSelected(true);
        this.chkMassnahmen.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkMassnahmen.text", (Object[])new Object[0]));
        this.chkMassnahmen.setContentAreaFilled(false);
        this.chkMassnahmen.setPreferredSize(new Dimension(180, 18));
        this.chkMassnahmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkMassnahmenActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkMassnahmen);
        this.chkSonstigeMassnahmen.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkSonstigeMassnahmen.text", (Object[])new Object[0]));
        this.chkSonstigeMassnahmen.setContentAreaFilled(false);
        this.chkSonstigeMassnahmen.setPreferredSize(new Dimension(180, 18));
        this.chkSonstigeMassnahmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkSonstigeMassnahmenActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkSonstigeMassnahmen);
        this.chkWasserkoerper.setSelected(true);
        this.chkWasserkoerper.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkWasserkoerper.text", (Object[])new Object[0]));
        this.chkWasserkoerper.setContentAreaFilled(false);
        this.chkWasserkoerper.setPreferredSize(new Dimension(180, 18));
        this.chkWasserkoerper.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkWasserkoerperActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkWasserkoerper);
        this.chkUmlandnutzung.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkUmlandnutzung.text", (Object[])new Object[0]));
        this.chkUmlandnutzung.setContentAreaFilled(false);
        this.chkUmlandnutzung.setEnabled(false);
        this.chkUmlandnutzung.setPreferredSize(new Dimension(180, 18));
        this.chkUmlandnutzung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkUmlandnutzungActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkUmlandnutzung);
        this.chkQuerbauwerke.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkQuerbauwerke.text", (Object[])new Object[0]));
        this.chkQuerbauwerke.setContentAreaFilled(false);
        this.chkQuerbauwerke.setEnabled(false);
        this.chkQuerbauwerke.setPreferredSize(new Dimension(180, 18));
        this.chkQuerbauwerke.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkQuerbauwerkeActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkQuerbauwerke);
        this.chkNaturschutz.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkNaturschutz.text", (Object[])new Object[0]));
        this.chkNaturschutz.setContentAreaFilled(false);
        this.chkNaturschutz.setEnabled(false);
        this.chkNaturschutz.setPreferredSize(new Dimension(180, 18));
        this.chkNaturschutz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkNaturschutzActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkNaturschutz);
        this.chkUnterhaltungserfordernis.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkUnterhaltungserfordernis.text", (Object[])new Object[0]));
        this.chkUnterhaltungserfordernis.setContentAreaFilled(false);
        this.chkUnterhaltungserfordernis.setEnabled(false);
        this.chkUnterhaltungserfordernis.setPreferredSize(new Dimension(180, 18));
        this.chkUnterhaltungserfordernis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkUnterhaltungserfordernisActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkUnterhaltungserfordernis);
        this.chkEntwicklungsziel.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkEntwicklungsziel.text", (Object[])new Object[0]));
        this.chkEntwicklungsziel.setContentAreaFilled(false);
        this.chkEntwicklungsziel.setEnabled(false);
        this.chkEntwicklungsziel.setPreferredSize(new Dimension(180, 18));
        this.chkEntwicklungsziel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkEntwicklungszielActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkEntwicklungsziel);
        this.chkEntwicklungsziel33.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkEntwicklungsziel33.text", (Object[])new Object[0]));
        this.chkEntwicklungsziel33.setContentAreaFilled(false);
        this.chkEntwicklungsziel33.setEnabled(false);
        this.chkEntwicklungsziel33.setPreferredSize(new Dimension(180, 18));
        this.chkEntwicklungsziel33.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkEntwicklungsziel33ActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkEntwicklungsziel33);
        this.chkVerbreitungsraum.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkVerbreitungsraum.text", (Object[])new Object[0]));
        this.chkVerbreitungsraum.setContentAreaFilled(false);
        this.chkVerbreitungsraum.setEnabled(false);
        this.chkVerbreitungsraum.setPreferredSize(new Dimension(180, 18));
        this.chkVerbreitungsraum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkVerbreitungsraumActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkVerbreitungsraum);
        this.chkOperativeZiele.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkOperativeZiele.text", (Object[])new Object[0]));
        this.chkOperativeZiele.setContentAreaFilled(false);
        this.chkOperativeZiele.setEnabled(false);
        this.chkOperativeZiele.setPreferredSize(new Dimension(180, 18));
        this.chkOperativeZiele.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkOperativeZieleActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkOperativeZiele);
        this.chkUnterhaltungshinweise.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkUnterhaltungshinweise.text", (Object[])new Object[0]));
        this.chkUnterhaltungshinweise.setContentAreaFilled(false);
        this.chkUnterhaltungshinweise.setEnabled(false);
        this.chkUnterhaltungshinweise.setPreferredSize(new Dimension(180, 18));
        this.chkUnterhaltungshinweise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkUnterhaltungshinweiseActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkUnterhaltungshinweise);
        this.chkUmlandnutzer.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkUmlandnutzer.text", (Object[])new Object[0]));
        this.chkUmlandnutzer.setContentAreaFilled(false);
        this.chkUmlandnutzer.setEnabled(false);
        this.chkUmlandnutzer.setPreferredSize(new Dimension(180, 18));
        this.chkUmlandnutzer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkUmlandnutzerActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkUmlandnutzer);
        this.chkHydrologie.setText(NbBundle.getMessage(GupPlanungsabschnittEditor.class, (String)"GupPlanungsabschnittEditor.chkHydrologie.text", (Object[])new Object[0]));
        this.chkHydrologie.setContentAreaFilled(false);
        this.chkHydrologie.setEnabled(false);
        this.chkHydrologie.setPreferredSize(new Dimension(180, 18));
        this.chkHydrologie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GupPlanungsabschnittEditor.this.chkHydrologieActionPerformed(evt);
            }
        });
        this.panBandControl.add(this.chkHydrologie);
        this.lblFiller.setPreferredSize(new Dimension(180, 18));
        this.panBandControl.add(this.lblFiller);
        this.lblFiller2.setPreferredSize(new Dimension(180, 18));
        this.panBandControl.add(this.lblFiller2);
        this.lblFiller3.setPreferredSize(new Dimension(180, 18));
        this.panBandControl.add(this.lblFiller3);
        this.lblFiller4.setPreferredSize(new Dimension(180, 18));
        this.panBandControl.add(this.lblFiller4);
        this.lblFiller5.setPreferredSize(new Dimension(180, 18));
        this.panBandControl.add(this.lblFiller5);
        this.spBand.setViewportView(this.panBandControl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panHeader.add((Component)this.spBand, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panHeader, gridBagConstraints);
        this.jPanel3.setMinimumSize(new Dimension(1050, 1));
        this.jPanel3.setOpaque(false);
        this.jPanel3.setPreferredSize(new Dimension(1050, 1));
        this.jLabel4.setMaximumSize(new Dimension(1050, 1));
        this.jLabel4.setMinimumSize(new Dimension(1050, 1));
        this.jLabel4.setPreferredSize(new Dimension(1050, 1));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1050, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 5, Short.MAX_VALUE).addComponent(this.jLabel4, -2, 1040, -2).addGap(0, 5, Short.MAX_VALUE))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel4, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void sldZoomStateChanged(ChangeEvent evt) {
        double zoom = (double)this.sldZoom.getValue() / 10.0;
        this.jband.setZoomFactor(zoom);
        if (this.vermessungsband != null) {
            this.vermessungsband.setZoomFactor(zoom);
        }
    }

    private void togAllgemeinInfoActionPerformed(ActionEvent evt) {
        this.switchToForm("allgemein");
        this.lblHeading.setText("Allgemeine Informationen");
        this.zoomToAbschnitt();
    }

    private void chkQuerbauwerkeActionPerformed(ActionEvent evt) {
        this.querbauwerksband.setEnabled(this.chkQuerbauwerke.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void chkMassnahmenActionPerformed(ActionEvent evt) {
        this.linkesUferBand.setEnabled(this.chkMassnahmen.isSelected());
        this.rechtesUferBand.setEnabled(this.chkMassnahmen.isSelected());
        this.sohleBand.setEnabled(this.chkMassnahmen.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void chkSonstigeMassnahmenActionPerformed(ActionEvent evt) {
        this.rechtesUmfeldBand.setEnabled(this.chkSonstigeMassnahmen.isSelected());
        this.linkesUmfeldBand.setEnabled(this.chkSonstigeMassnahmen.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void chkWasserkoerperActionPerformed(ActionEvent evt) {
        this.wkband.setEnabled(this.chkWasserkoerper.isSelected());
        this.wkBandFiller.setEnabled(this.chkWasserkoerper.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void chkUmlandnutzungActionPerformed(ActionEvent evt) {
        this.nutzungLinksBand.setEnabled(this.chkUmlandnutzung.isSelected());
        this.nutzungRechtsBand.setEnabled(this.chkUmlandnutzung.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void chkNaturschutzActionPerformed(ActionEvent evt) {
        this.schutzgebietLinksBand.setEnabled(this.chkNaturschutz.isSelected());
        this.schutzgebietRechtsBand.setEnabled(this.chkNaturschutz.isSelected());
        this.schutzgebietSohleBand.setEnabled(this.chkNaturschutz.isSelected());
        this.schutzgebieteFiller.setEnabled(this.chkNaturschutz.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void chkUnterhaltungserfordernisActionPerformed(ActionEvent evt) {
        this.unterhaltungserfordernisBand.setEnabled(this.chkUnterhaltungserfordernis.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void chkEntwicklungszielActionPerformed(ActionEvent evt) {
        this.entwicklungszielBand.setEnabled(this.chkEntwicklungsziel.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void adjustHeight() {
        int SIZE_OTHERS = 610;
        int DEFAULT_SIZE = 850;
        int recommendetHeight = 30;
        if (this.chkMassnahmen.isSelected()) {
            recommendetHeight += 75;
        }
        if (this.chkEntwicklungsziel.isSelected()) {
            recommendetHeight += 25;
        }
        if (this.chkHydrologie.isSelected()) {
            recommendetHeight += 25;
        }
        if (this.chkNaturschutz.isSelected()) {
            recommendetHeight += 75;
        }
        if (this.chkOperativeZiele.isSelected()) {
            recommendetHeight += 125;
        }
        if (this.chkQuerbauwerke.isSelected()) {
            recommendetHeight += 25;
        }
        if (this.chkSonstigeMassnahmen.isSelected()) {
            recommendetHeight += 50;
        }
        if (this.chkUmlandnutzer.isSelected()) {
            recommendetHeight += 50;
        }
        if (this.chkUmlandnutzung.isSelected()) {
            recommendetHeight += 50;
        }
        if (this.chkUnterhaltungserfordernis.isSelected()) {
            recommendetHeight += 25;
        }
        if (this.chkUnterhaltungshinweise.isSelected()) {
            recommendetHeight += 75;
        }
        if (this.chkVerbreitungsraum.isSelected()) {
            recommendetHeight += 170;
        }
        if (this.chkWasserkoerper.isSelected()) {
            recommendetHeight += 25;
        }
        if (recommendetHeight + 610 > 850) {
            this.setMinimumSize(new Dimension((int)this.getMinimumSize().getWidth(), recommendetHeight + 610));
            this.setPreferredSize(new Dimension((int)this.getMinimumSize().getWidth(), recommendetHeight + 610));
        } else {
            this.setMinimumSize(new Dimension((int)this.getMinimumSize().getWidth(), 850));
            this.setPreferredSize(new Dimension((int)this.getMinimumSize().getWidth(), 850));
        }
        this.revalidate();
    }

    private void zoomToAbschnitt() {
        Geometry g = (Geometry)this.cidsBean.getProperty("linie.geom.geo_field");
        final MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
        XBoundingBox xbb = new XBoundingBox(g);
        mc.gotoBoundingBoxWithHistory((BoundingBox)xbb);
        DefaultStyledFeature dsf = new DefaultStyledFeature();
        dsf.setGeometry(g);
        dsf.setCanBeSelected(false);
        dsf.setLinePaint((Paint)Color.YELLOW);
        dsf.setLineWidth(6);
        final PFeature highlighter = new PFeature((Feature)dsf, mc);
        mc.getHighlightingLayer().addChild((PNode)highlighter);
        highlighter.animateToTransparency(0.1f, 2000L);
        CismetThreadPool.execute((Runnable)new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Thread.currentThread();
                Thread.sleep(2500L);
                return null;
            }

            @Override
            protected void done() {
                try {
                    mc.getHighlightingLayer().removeChild((PNode)highlighter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void jbApplyActionPerformed(ActionEvent evt) {
        if (this.isNew) {
            this.panBand.removeAll();
            this.panBand.add((Component)this.jband, "Center");
            this.setNamesAndBands();
            this.linearReferencedLineEditor.dispose();
            if (!this.readOnly) {
                this.vermessungsband.showRoute();
                this.togApplyStats.setEnabled(true);
            }
            this.isNew = false;
        } else {
            int resp = JOptionPane.showConfirmDialog(this, "Ma\u00dfnahmen, die nicht mehr innerhalb des Planungsabschnitts liegen, werden entfernt.", "Achtung", 2);
            if (resp == 0) {
                Integer routeId = (Integer)LinearReferencingHelper.getRouteBeanFromStationBean((CidsBean)this.cidsBean.getProperty("linie.von")).getProperty("id");
                double from = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty("linie.von"));
                double till = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty("linie.bis"));
                List all = this.cidsBean.getBeanCollectionProperty("massnahmen");
                this.stationBackup.cutSubobjects(all, from, till, routeId);
                this.panBand.removeAll();
                this.panBand.add((Component)this.jband, "Center");
                this.repaint();
                this.resetBands();
                this.vermessungsband.reset();
                this.butStationierung.setSelected(!this.butStationierung.isSelected());
                this.setNamesAndBands();
                this.linearReferencedLineEditor.dispose();
                if (!this.readOnly) {
                    this.vermessungsband.showRoute();
                    this.togApplyStats.setEnabled(true);
                }
            }
        }
    }

    private void togApplyStatsActionPerformed(ActionEvent evt) {
        if (this.togApplyStats.isSelected()) {
            if (this.isNew) {
                this.vermessungsband.savePositions();
                this.jbApplyActionPerformed(null);
                this.vermessungsband.showVermessungsbandFromSavedPositions();
                if (this.butStationierung.isSelected()) {
                    this.butStationierung.setSelected(false);
                }
            } else {
                this.vermessungsband.showVermessungsband();
                if (this.butStationierung.isSelected()) {
                    this.butStationierung.setSelected(false);
                    this.stationBackup.restoreStationValues(this.cidsBean);
                }
            }
        } else {
            this.vermessungsband.hideVermessungsband();
        }
        this.updateUI();
        this.repaint();
    }

    private void jbApply1ActionPerformed(ActionEvent evt) {
        LineBand[] bands = new MassnahmenBand[]{this.rechtesUferBand, this.linkesUferBand, this.sohleBand};
        this.vermessungsband.applyStats(this, bands, GUP_MASSNAHME);
        this.updateUI();
        this.repaint();
    }

    private void chkVerbreitungsraumActionPerformed(ActionEvent evt) {
        this.verbreitungsraumLinksBand.setEnabled(this.chkVerbreitungsraum.isSelected());
        this.verbreitungsraumUmfeldLinksBand.setEnabled(this.chkVerbreitungsraum.isSelected());
        this.verbreitungsraumUmfeldRechtsBand.setEnabled(this.chkVerbreitungsraum.isSelected());
        this.verbreitungsraumRechtsBand.setEnabled(this.chkVerbreitungsraum.isSelected());
        this.verbreitungsraumSohleBand.setEnabled(this.chkVerbreitungsraum.isSelected());
        this.verbreitungsraumFiller.setEnabled(this.chkVerbreitungsraum.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void chkOperativeZieleActionPerformed(ActionEvent evt) {
        this.operativeZieleLinksBand.setEnabled(this.chkOperativeZiele.isSelected());
        this.operativeZieleRechtsBand.setEnabled(this.chkOperativeZiele.isSelected());
        this.operativeZieleSohleBand.setEnabled(this.chkOperativeZiele.isSelected());
        this.operativeZieleUmfeldLinksBand.setEnabled(this.chkOperativeZiele.isSelected());
        this.operativeZieleUmfeldRechtsBand.setEnabled(this.chkOperativeZiele.isSelected());
        this.operativeZieleFiller.setEnabled(this.chkOperativeZiele.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void chkUnterhaltungshinweiseActionPerformed(ActionEvent evt) {
        this.unterhaltungshinweisLinks.setEnabled(this.chkUnterhaltungshinweise.isSelected());
        this.unterhaltungshinweisRechts.setEnabled(this.chkUnterhaltungshinweise.isSelected());
        this.unterhaltungshinweisSohle.setEnabled(this.chkUnterhaltungshinweise.isSelected());
        this.unterhaltungshinweisFiller.setEnabled(this.chkUnterhaltungshinweise.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void chkUmlandnutzerActionPerformed(ActionEvent evt) {
        this.umlandnutzerLinks.setEnabled(this.chkUmlandnutzer.isSelected());
        this.umlandnutzerRechts.setEnabled(this.chkUmlandnutzer.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void chkHydrologieActionPerformed(ActionEvent evt) {
        this.hydrologieBand.setEnabled(this.chkHydrologie.isSelected());
        this.hydrologieFiller.setEnabled(this.chkHydrologie.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void butStationierungActionPerformed(ActionEvent evt) {
        if (this.butStationierung.isSelected()) {
            this.panBand.removeAll();
            this.panBand.add((Component)this.panNew, "Center");
            if (this.togApplyStats.isSelected()) {
                this.togApplyStats.setSelected(false);
            }
            this.stationBackup.save(this.cidsBean);
            this.linearReferencedLineEditor.setLineField("linie");
            this.linearReferencedLineEditor.setOtherLinesEnabled(false);
            this.linearReferencedLineEditor.setCidsBean(this.cidsBean);
            this.repaint();
        } else {
            this.stationBackup.restoreStationValues(this.cidsBean);
            this.panBand.removeAll();
            this.panBand.add((Component)this.jband, "Center");
            this.repaint();
        }
    }

    private void btnReportActionPerformed(ActionEvent evt) {
        MassnahmenBand[] mBandArray = new MassnahmenBand[]{this.rechtesUferBand, this.linkesUferBand, this.sohleBand, this.rechtesUmfeldBand, this.linkesUmfeldBand};
        GeppReport report = new GeppReport((JFrame)StaticSwingTools.getParentFrame((Component)this), this.cidsBean, this.jband, mBandArray);
        report.print();
    }

    private void chkEntwicklungsziel33ActionPerformed(ActionEvent evt) {
        this.entwicklungszielBand33.setEnabled(this.chkEntwicklungsziel33.isSelected());
        this.adjustHeight();
        this.sbm.fireBandModelValuesChanged();
    }

    private void resetBands() {
        this.wkband.removeAllMember();
        this.entwicklungszielBand.removeAllMember();
        this.entwicklungszielBand33.removeAllMember();
        this.unterhaltungserfordernisBand.removeAllMember();
        this.unterhaltungshinweisRechts.removeAllMember();
        this.unterhaltungshinweisSohle.removeAllMember();
        this.unterhaltungshinweisLinks.removeAllMember();
        this.verbreitungsraumRechtsBand.removeAllMember();
        this.verbreitungsraumSohleBand.removeAllMember();
        this.verbreitungsraumLinksBand.removeAllMember();
        this.verbreitungsraumUmfeldLinksBand.removeAllMember();
        this.verbreitungsraumUmfeldRechtsBand.removeAllMember();
        this.schutzgebietRechtsBand.removeAllMember();
        this.schutzgebietSohleBand.removeAllMember();
        this.schutzgebietLinksBand.removeAllMember();
        this.operativeZieleUmfeldRechtsBand.removeAllMember();
        this.operativeZieleRechtsBand.removeAllMember();
        this.operativeZieleSohleBand.removeAllMember();
        this.operativeZieleLinksBand.removeAllMember();
        this.operativeZieleUmfeldLinksBand.removeAllMember();
        this.umlandnutzerRechts.removeAllMember();
        this.nutzungRechtsBand.removeAllMember();
        this.nutzungLinksBand.removeAllMember();
        this.umlandnutzerLinks.removeAllMember();
        this.hydrologieBand.removeAllMember();
        this.querbauwerksband.removeAllMember();
        this.chkEntwicklungsziel.setEnabled(false);
        this.chkHydrologie.setEnabled(false);
        this.chkNaturschutz.setEnabled(false);
        this.chkOperativeZiele.setEnabled(false);
        this.chkQuerbauwerke.setEnabled(false);
        this.chkUmlandnutzer.setEnabled(false);
        this.chkUmlandnutzung.setEnabled(false);
        this.chkUnterhaltungserfordernis.setEnabled(false);
        this.chkUnterhaltungshinweise.setEnabled(false);
        this.chkVerbreitungsraum.setEnabled(false);
    }

    public void dispose() {
        this.disposeEditors();
        if (!this.readOnly) {
            this.vermessungsband.dispose();
        }
        this.linearReferencedLineEditor.dispose();
        this.sbm.removeBandModelListener(this.modelListener);
        this.jband.dispose();
        this.jband = null;
        if (CheckAssistent.getInstance().containsListener(this)) {
            CheckAssistent.getInstance().removeListener(this);
            CheckAssistent.getInstance().dispose();
        }
        this.bindingGroup.unbind();
    }

    private void disposeEditors() {
        this.massnahmeEditor.dispose();
        this.umlandnutzungEditor.dispose();
        this.schutzgebietEditor.dispose();
        this.verbreitungsraumEditor.dispose();
        this.operativesZielEditor.dispose();
        this.allgemeinEditor.dispose();
        this.hydroEditor.dispose();
        this.entwicklungszielEditor.dispose();
        this.unterhaltungserfordernisEditor.dispose();
        this.vermessungsEditor.dispose();
        this.unterhaltungshinweisEditor.dispose();
        this.umlandnutzerEditor.dispose();
    }

    public String getTitle() {
        return this.cidsBean.toString();
    }

    public void setTitle(String title) {
    }

    public static void main(String[] args) throws Exception {
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost((String)"WRRL_DB_MV", (String)"Administratoren", (String)"admin", (String)"kif", (String)"gup_planungsabschnitt", (int)19, (int)1280, (int)1024);
    }

    public void editorClosed(EditorClosedEvent event) {
        this.linearReferencedLineEditor.editorClosed(event);
        this.allgemeinEditor.editorClosed(event);
        this.massnahmeEditor.editorClosed(event);
        this.umlandnutzungEditor.editorClosed(event);
        this.schutzgebietEditor.editorClosed(event);
        this.verbreitungsraumEditor.editorClosed(event);
        this.operativesZielEditor.editorClosed(event);
        this.hydroEditor.editorClosed(event);
        this.entwicklungszielEditor.editorClosed(event);
        this.unterhaltungserfordernisEditor.editorClosed(event);
        this.vermessungsEditor.editorClosed(event);
        this.unterhaltungshinweisEditor.editorClosed(event);
        this.umlandnutzerEditor.editorClosed(event);
        if (this.vermessungsband != null) {
            this.vermessungsband.editorClosed(event);
        }
    }

    public boolean prepareForSave() {
        if (this.isDeclinedWithoutReason()) {
            JOptionPane.showMessageDialog(this, "Es existieren Ma\u00dfnahmen, die ohne Begr\u00fcndung abgelehnt wurden.", "Ung\u00fcltige Entscheidung", 2);
            return false;
        }
        try {
            CidsBean route;
            CidsBean statVon;
            CidsBean statLine = (CidsBean)this.cidsBean.getProperty("linie");
            if (this.cidsBean.getProperty("name") == null && statLine != null && (statVon = (CidsBean)statLine.getProperty("von")) != null && (route = (CidsBean)statVon.getProperty("route")) != null) {
                String gewName = route.getProperty("routenname").toString();
                this.cidsBean.setProperty("name", (Object)gewName);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while determining the water body", (Throwable)e);
        }
        return this.allgemeinEditor.prepareForSave() && this.linearReferencedLineEditor.prepareForSave();
    }

    private boolean isDeclinedWithoutReason() {
        List maBeans = this.cidsBean.getBeanCollectionProperty("massnahmen");
        for (CidsBean tmp : maBeans) {
            Boolean appNb = (Boolean)tmp.getProperty("abgelehnt_nb");
            String conditionsNb = (String)tmp.getProperty("auflagen_nb");
            Boolean appWb = (Boolean)tmp.getProperty("abgelehnt_wb");
            String conditionsWb = (String)tmp.getProperty("auflagen_wb");
            appNb = appNb == null ? false : appNb;
            appWb = appWb == null ? false : appWb;
            conditionsNb = conditionsNb == null || conditionsNb.equals("") ? null : conditionsNb;
            String string = conditionsWb = conditionsWb == null || conditionsWb.equals("") ? null : conditionsWb;
            if ((!appNb.booleanValue() || conditionsNb != null) && (!appWb.booleanValue() || conditionsWb != null)) continue;
            return true;
        }
        return false;
    }

    public static UnterhaltungsmassnahmeValidator getSearchValidator() {
        return searchValidator;
    }

    public static CidsBean getLastActiveMassnBean() {
        return lastActiveMassnBean;
    }

    @Override
    public void onSelectionChange(CidsBean massnBean) {
        CidsBean bean;
        Integer wo = (Integer)massnBean.getProperty("wo.id");
        MassnahmenBand band = null;
        switch (wo) {
            case 5: {
                band = this.sohleBand;
                break;
            }
            case 2: {
                band = this.linkesUferBand;
                break;
            }
            case 1: {
                band = this.rechtesUferBand;
                break;
            }
            case 3: {
                band = this.linkesUmfeldBand;
                break;
            }
            case 4: {
                band = this.rechtesUmfeldBand;
            }
        }
        Integer id = (Integer)massnBean.getProperty("id");
        LineBandMember member = null;
        for (int i = 0; i < band.getNumberOfMembers() && !(bean = (member = (MassnahmenBandMember)band.getMember(i)).getCidsBean()).getProperty("id").equals(id); ++i) {
        }
        if (!member.isSelected()) {
            this.jband.setSelectedMember((BandMemberSelectable)member);
            this.jband.scrollToBandMember((BandMember)member);
        }
    }

    static {
        CismetThreadPool.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                MetaClass year = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"GUP_JAHR");
                MetaClass interval = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_massnahmenintervall");
                try {
                    DefaultBindableReferenceCombo.getModelByMetaClass((MetaClass)year, (boolean)true);
                    DefaultBindableReferenceCombo.getModelByMetaClass((MetaClass)interval, (boolean)true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        CismetThreadPool.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                MetaClass time = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_unterhaltungsmassnahme_ausfuehrungszeitpunkt");
                MetaClass material = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_material_verbleib");
                try {
                    DefaultBindableReferenceCombo.getModelByMetaClass((MetaClass)time, (boolean)true);
                    DefaultBindableReferenceCombo.getModelByMetaClass((MetaClass)material, (boolean)true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while loading all object of the type gup_massnahmenart.", (Throwable)e);
                }
            }
        });
        CismetThreadPool.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                MetaClass geraet = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_geraet");
                MetaClass einsatzvariante = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_einsatzvariante");
                try {
                    DefaultBindableReferenceCombo.getModelByMetaClass((MetaClass)geraet, (boolean)true);
                    DefaultBindableReferenceCombo.getModelByMetaClass((MetaClass)einsatzvariante, (boolean)true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        executor = CismetExecutors.newFixedThreadPool((int)10);
        executorReadOnly = CismetExecutors.newFixedThreadPool((int)10);
    }

    private class MassnahmenListListener
    extends MassnBezugListListener {
        public MassnahmenListListener(int kindId, CidsBean cidsBean, String collectionPropertyName) {
            super(kindId, cidsBean, collectionPropertyName);
        }

        @Override
        public void listElementsAdded(ObservableList list, int index, int length) {
            super.listElementsAdded(list, index, length);
            if (length == 1) {
                CidsBean los = (CidsBean)this.cidsBean.getProperty("los");
                if (los != null) {
                    CidsBean bean = (CidsBean)list.get(index);
                    try {
                        bean.setProperty("los", (Object)los);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while assigning the los object", (Throwable)e);
                    }
                }
            } else {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
    }

    class GupGewaesserabschnittBandModelListener
    implements BandModelListener {
        GupGewaesserabschnittBandModelListener() {
        }

        public void bandModelChanged(BandModelEvent e) {
        }

        public void bandModelSelectionChanged(BandModelEvent e) {
            BandMember bm;
            Cursor currentCursor = GupPlanungsabschnittEditor.this.getCursor();
            GupPlanungsabschnittEditor.this.setCursor(Cursor.getPredefinedCursor(3));
            GupPlanungsabschnittEditor.this.togAllgemeinInfo.setSelected(false);
            GupPlanungsabschnittEditor.this.disposeEditors();
            if (GupPlanungsabschnittEditor.this.togApplyStats.isSelected()) {
                bm = GupPlanungsabschnittEditor.this.vermessungsband.getSelectedMember();
                GupPlanungsabschnittEditor.this.vermessungsband.setRefreshAvoided(true);
            } else {
                bm = GupPlanungsabschnittEditor.this.jband.getSelectedBandMember();
                GupPlanungsabschnittEditor.this.jband.setRefreshAvoided(true);
            }
            if (bm != null) {
                GupPlanungsabschnittEditor.this.bgrpDetails.clearSelection();
                GupPlanungsabschnittEditor.this.switchToForm("empty");
                GupPlanungsabschnittEditor.this.lblHeading.setText("");
                if (bm instanceof MassnahmenBandMember) {
                    CidsBean bean = ((MassnahmenBandMember)bm).getCidsBean();
                    MassnahmenBand mb = (MassnahmenBand)((MassnahmenBandMember)bm).getParentBand();
                    if (mb.getMeasureType() == 5) {
                        GupPlanungsabschnittEditor.this.switchToForm("massnahme");
                        GupPlanungsabschnittEditor.this.lblHeading.setText("Ma\u00dfnahmen Sohle");
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setMassnahmen(GupPlanungsabschnittEditor.this.sohleList);
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setKompartiment(1);
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setCidsBean(bean);
                    } else if (mb.getMeasureType() == 4) {
                        GupPlanungsabschnittEditor.this.switchToForm("massnahme");
                        GupPlanungsabschnittEditor.this.lblHeading.setText("Umfeld rechts");
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setKompartiment(3);
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setMassnahmen(GupPlanungsabschnittEditor.this.rechtesUmfeldList);
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setCidsBean(bean);
                    } else if (mb.getMeasureType() == 3) {
                        GupPlanungsabschnittEditor.this.switchToForm("massnahme");
                        GupPlanungsabschnittEditor.this.lblHeading.setText("Umfeld links");
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setKompartiment(3);
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setMassnahmen(GupPlanungsabschnittEditor.this.linkesUmfeldList);
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setCidsBean(bean);
                    } else if (mb.getMeasureType() == 1) {
                        GupPlanungsabschnittEditor.this.switchToForm("massnahme");
                        GupPlanungsabschnittEditor.this.lblHeading.setText("Ma\u00dfnahmen Ufer");
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setKompartiment(2);
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setMassnahmen(GupPlanungsabschnittEditor.this.rechtesUferList);
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setCidsBean(bean);
                    } else if (mb.getMeasureType() == 2) {
                        GupPlanungsabschnittEditor.this.switchToForm("massnahme");
                        GupPlanungsabschnittEditor.this.lblHeading.setText("Ma\u00dfnahmen Ufer");
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setKompartiment(2);
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setMassnahmen(GupPlanungsabschnittEditor.this.linkesUferList);
                        GupPlanungsabschnittEditor.this.massnahmeEditor.setCidsBean(bean);
                    }
                    if (!GupPlanungsabschnittEditor.this.readOnly) {
                        lastActiveMassnBean = bean;
                    }
                    ComponentRegistry.getRegistry().getSearchResultsTree().repaint();
                    if (CheckAssistent.getInstance().containsListener(GupPlanungsabschnittEditor.this)) {
                        CheckAssistent.getInstance().setSelection(bean);
                    }
                } else if (bm instanceof VermeidungsgruppeReadOnlyBandMember) {
                    GupPlanungsabschnittEditor.this.switchToForm("verbreitungsraum");
                    GupPlanungsabschnittEditor.this.lblHeading.setText("Verbreitungsraum");
                    GupPlanungsabschnittEditor.this.verbreitungsraumEditor.setVerbreitungsraum(((VermeidungsgruppeReadOnlyBandMember)bm).getVermeidungsgruppe());
                    GupPlanungsabschnittEditor.this.verbreitungsraumEditor.setCidsBean(((VermeidungsgruppeReadOnlyBandMember)bm).getCidsBean());
                } else if (bm instanceof ColoredReadOnlyBandMember) {
                    String colorProp = ((ColoredReadOnlyBandMember)bm).getColorProperty();
                    if (colorProp != null && colorProp.equals("operatives_ziel")) {
                        GupPlanungsabschnittEditor.this.switchToForm("operativeZiele");
                        GupPlanungsabschnittEditor.this.lblHeading.setText("Pflegeziel");
                        int kompartiment = -1;
                        GupPlanungsabschnittEditor.this.operativesZielEditor.setKompartiment(-1);
                        GupPlanungsabschnittEditor.this.operativesZielEditor.setCidsBean(((ColoredReadOnlyBandMember)bm).getCidsBean());
                    } else if (((ColoredReadOnlyBandMember)bm).getCidsBean().getClass().getName().endsWith("Gup_umlandnutzung")) {
                        GupPlanungsabschnittEditor.this.switchToForm("umlandnutzung");
                        GupPlanungsabschnittEditor.this.lblHeading.setText("Umlandnutzung");
                        GupPlanungsabschnittEditor.this.umlandnutzungEditor.setCidsBean(((ColoredReadOnlyBandMember)bm).getCidsBean());
                    } else if (((ColoredReadOnlyBandMember)bm).getCidsBean().getClass().getName().endsWith("hydrolog")) {
                        GupPlanungsabschnittEditor.this.switchToForm("hydro");
                        GupPlanungsabschnittEditor.this.lblHeading.setText("Hydraulik");
                        GupPlanungsabschnittEditor.this.hydroEditor.setCidsBean(((ColoredReadOnlyBandMember)bm).getCidsBean());
                    } else if (colorProp != null && colorProp.equals("name_bezeichnung")) {
                        GupPlanungsabschnittEditor.this.switchToForm("entwicklungsziel");
                        GupPlanungsabschnittEditor.this.lblHeading.setText("WRRL-Ma\u00dfnahme");
                        GupPlanungsabschnittEditor.this.entwicklungszielEditor.setCidsBean(((ColoredReadOnlyBandMember)bm).getCidsBean());
                    } else {
                        GupPlanungsabschnittEditor.this.switchToForm("schutzgebiet");
                        GupPlanungsabschnittEditor.this.lblHeading.setText("Schutzgebiet");
                        GupPlanungsabschnittEditor.this.schutzgebietEditor.setCidsBean(((ColoredReadOnlyBandMember)bm).getCidsBean());
                    }
                } else if (bm instanceof UnterhaltungserfordernisBandMember) {
                    GupPlanungsabschnittEditor.this.switchToForm("unterhaltungserfordernis");
                    GupPlanungsabschnittEditor.this.lblHeading.setText("Situationstyp");
                    GupPlanungsabschnittEditor.this.unterhaltungserfordernisEditor.setCidsBean(((UnterhaltungserfordernisBandMember)bm).getCidsBean());
                } else if (bm instanceof ReadOnlyTextBandMember) {
                    String textProperty = ((ReadOnlyTextBandMember)bm).getTextProperty();
                    if (textProperty != null && textProperty.equals("art.name")) {
                        GupPlanungsabschnittEditor.this.switchToForm("unterhaltungshinweis");
                        GupPlanungsabschnittEditor.this.lblHeading.setText("Unterhaltungshinweis");
                        GupPlanungsabschnittEditor.this.unterhaltungshinweisEditor.setCidsBean(((ReadOnlyTextBandMember)bm).getCidsBean());
                    } else {
                        GupPlanungsabschnittEditor.this.switchToForm("umlandnutzer");
                        GupPlanungsabschnittEditor.this.lblHeading.setText("Umlandnutzer");
                        GupPlanungsabschnittEditor.this.umlandnutzerEditor.setCidsBean(((ReadOnlyTextBandMember)bm).getCidsBean());
                    }
                } else if (bm instanceof VermessungsbandMember) {
                    GupPlanungsabschnittEditor.this.switchToForm("vermessung");
                    GupPlanungsabschnittEditor.this.lblHeading.setText("Vermessungselement");
                    List<CidsBean> others = GupPlanungsabschnittEditor.this.vermessungsband.getAllMembers();
                    GupPlanungsabschnittEditor.this.vermessungsEditor.setOthers(others);
                    GupPlanungsabschnittEditor.this.vermessungsEditor.setCidsBean(((VermessungsbandMember)bm).getCidsBean());
                }
            } else {
                GupPlanungsabschnittEditor.this.switchToForm("empty");
                GupPlanungsabschnittEditor.this.lblHeading.setText("");
            }
            if (GupPlanungsabschnittEditor.this.togApplyStats.isSelected()) {
                GupPlanungsabschnittEditor.this.vermessungsband.setRefreshAvoided(false);
                GupPlanungsabschnittEditor.this.vermessungsband.bandModelChanged();
            } else {
                GupPlanungsabschnittEditor.this.jband.setRefreshAvoided(false);
                GupPlanungsabschnittEditor.this.jband.bandModelChanged(null);
            }
            GupPlanungsabschnittEditor.this.setCursor(currentCursor);
        }

        public void bandModelValuesChanged(BandModelEvent e) {
        }
    }
}

