/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.featurerenderer.wrrl_db_mv.LawaFeatureRenderer;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.LinearReferencedLineEditor;
import de.cismet.cids.custom.objectrenderer.wrrl_db_mv.LinearReferencedLineRenderer;
import de.cismet.cids.custom.wrrl_db_mv.server.search.LawaTypeNeighbourSearch;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WkkSearch;
import de.cismet.cids.custom.wrrl_db_mv.util.MapUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.UIUtil;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.features.FeatureGroup;
import de.cismet.cismap.commons.features.FeatureGroups;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class LawaEditor
extends JPanel
implements CidsBeanRenderer,
PropertyChangeListener,
EditorSaveListener,
FooterComponentProvider,
CidsBeanDropListener {
    private static final Logger LOG = Logger.getLogger(LawaEditor.class);
    private static final String ROUTE_FEATURE_CLASS_NAME = "de.cismet.cids.custom.util.StationToMapRegistry$RouteFeature";
    private static final int NO_NEIGHBOUR_FOUND = -1;
    private static final MappingComponent MAPPING_COMPONENT = CismapBroker.getInstance().getMappingComponent();
    private boolean readOnly;
    private CidsBean cidsBean;
    private CidsBean realGeom;
    private JLabel blbSpace;
    private DefaultBindableReferenceCombo cbLawa_nr;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblFoot;
    private JLabel lblHeading;
    private JLabel lblHeading1;
    private JLabel lblLawa_nr;
    private JLabel lblTypOberhalb;
    private JLabel lblTypUnterhalb;
    private JLabel lblValLawa_nr;
    private JLabel lblValTypOberhalb;
    private JLabel lblValTypUnterhalb;
    private JLabel lblValWk_k;
    private JLabel lblWk_k;
    private LinearReferencedLineEditor linearReferencedLineEditor;
    private JPanel panFooter;
    private SemiRoundedPanel panHeadInfo;
    private SemiRoundedPanel panHeadInfo1;
    private RoundedPanel panInfo;
    private RoundedPanel panInfo1;
    private JPanel panInfoContent;
    private JPanel panInfoContent1;
    private JPanel panLineOberhalb;
    private JPanel panLineUnterhalb;
    private BindingGroup bindingGroup;

    public LawaEditor() {
        this(false);
    }

    public LawaEditor(boolean readOnly) {
        block4: {
            this.readOnly = false;
            this.readOnly = readOnly;
            this.linearReferencedLineEditor = readOnly ? new LinearReferencedLineRenderer() : new LinearReferencedLineEditor();
            this.linearReferencedLineEditor.setLineField("linie");
            this.initComponents();
            if (!readOnly) {
                this.lblValLawa_nr.setVisible(false);
                this.panLineOberhalb.setVisible(false);
                this.panLineUnterhalb.setVisible(false);
                this.linearReferencedLineEditor.setOtherLinesQueryAddition("lawa", "lawa.linie = ");
            } else {
                this.cbLawa_nr.setVisible(false);
            }
            try {
                new CidsBeanDropTarget((Component)this);
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)"Error while creating CidsBeanDropTarget", (Throwable)ex);
            }
        }
    }

    public void setCidsBean(CidsBean cidsBean) {
        if (!this.readOnly) {
            CidsFeature cidsFeature = new CidsFeature(cidsBean.getMetaObject());
            ArrayList features = new ArrayList();
            features.addAll(FeatureGroups.expandAll((FeatureGroup)cidsFeature));
            MAPPING_COMPONENT.getFeatureCollection().removeFeatures(features);
        }
        this.bindingGroup.unbind();
        this.removeListener();
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean);
            this.bindingGroup.bind();
            this.linearReferencedLineEditor.setCidsBean(cidsBean);
            Object lawa_nr = cidsBean.getProperty("lawa_nr");
            if (lawa_nr != null) {
                this.lblValLawa_nr.setText(lawa_nr.toString());
            } else {
                this.lblValLawa_nr.setText("");
            }
            cidsBean.addPropertyChangeListener((PropertyChangeListener)this);
            if (cidsBean.getProperty("linie.geom") != null) {
                this.realGeom = (CidsBean)cidsBean.getProperty("linie.geom");
                this.realGeom.addPropertyChangeListener((PropertyChangeListener)this);
            }
            UIUtil.setLastModifier(cidsBean, this.lblFoot);
            if (!this.readOnly) {
                this.zoomToFeatures();
            }
        } else {
            this.lblValLawa_nr.setText("");
            this.lblFoot.setText("");
        }
        this.setNeighbours();
    }

    private void setNeighbours() {
        if (this.cidsBean != null) {
            Color color;
            int predecessorType = this.getNeighbourType(String.valueOf(this.cidsBean.getProperty("id")), true);
            int sucessorType = this.getNeighbourType(String.valueOf(this.cidsBean.getProperty("id")), false);
            if (predecessorType != -1) {
                this.lblValTypUnterhalb.setText(String.valueOf(predecessorType));
                color = LawaFeatureRenderer.getPaintForLawaType(predecessorType);
                this.panLineUnterhalb.setBackground(color);
            } else {
                this.lblValTypUnterhalb.setText("<nicht gesetzt>");
            }
            if (sucessorType != -1) {
                this.lblValTypOberhalb.setText(String.valueOf(sucessorType));
                color = LawaFeatureRenderer.getPaintForLawaType(sucessorType);
                this.panLineOberhalb.setBackground(color);
            } else {
                this.lblValTypOberhalb.setText("<nicht gesetzt>");
            }
            this.panLineUnterhalb.setVisible(predecessorType != -1);
            this.panLineOberhalb.setVisible(sucessorType != -1);
        } else {
            this.lblValTypUnterhalb.setText("<nicht gesetzt>");
            this.lblValTypOberhalb.setText("<nicht gesetzt>");
            this.panLineUnterhalb.setVisible(false);
            this.panLineOberhalb.setVisible(false);
        }
    }

    private int getNeighbourType(String lawaId, boolean predecessor) {
        int result = -1;
        try {
            LawaTypeNeighbourSearch search = new LawaTypeNeighbourSearch(lawaId, predecessor);
            Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
            ArrayList resArray = (ArrayList)res;
            if (resArray != null && resArray.size() > 0 && ((ArrayList)resArray.get(0)).size() > 0) {
                Object o = ((ArrayList)resArray.get(0)).get(0);
                if (o instanceof Integer) {
                    result = (Integer)o;
                }
            } else {
                LOG.error((Object)"Server error in getNeighbourType(). Cids server search return null. See the server logs for further information");
            }
        }
        catch (ConnectionException e) {
            LOG.error((Object)"Exception during a cids server search.", (Throwable)e);
        }
        return result;
    }

    private String getWk_k(Geometry realGeom) {
        String result = null;
        if (realGeom == null) {
            return null;
        }
        try {
            String geom = realGeom.toText();
            CidsBean route = (CidsBean)this.cidsBean.getProperty("linie.von.route");
            if (route == null) {
                LOG.error((Object)"Route not found");
                return null;
            }
            Object routeId = route.getProperty("id");
            if (routeId == null) {
                LOG.error((Object)"Route id not found");
                return null;
            }
            WkkSearch search = new WkkSearch(geom, routeId.toString());
            Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
            ArrayList resArray = (ArrayList)res;
            if (resArray != null && resArray.size() > 0 && ((ArrayList)resArray.get(0)).size() > 0) {
                Object o = ((ArrayList)resArray.get(0)).get(0);
                if (o instanceof String) {
                    result = o.toString();
                }
            } else {
                LOG.error((Object)"Server error in getWk_k(). Cids server search return null. See the server logs for further information");
            }
        }
        catch (ConnectionException e) {
            LOG.error((Object)"Exception during a cids server search.", (Throwable)e);
        }
        return result;
    }

    private void zoomToFeatures() {
        MapUtil.zoomToFeatureCollection(this.linearReferencedLineEditor.getZoomFeatures());
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFooter = new JPanel();
        this.lblFoot = new JLabel();
        this.panInfo = new RoundedPanel();
        this.panHeadInfo = new SemiRoundedPanel();
        this.lblHeading = new JLabel();
        this.panInfoContent = new JPanel();
        this.lblWk_k = new JLabel();
        this.blbSpace = new JLabel();
        this.jPanel1 = new JPanel();
        this.lblLawa_nr = new JLabel();
        this.cbLawa_nr = new DefaultBindableReferenceCombo();
        this.lblValWk_k = new JLabel();
        this.lblValLawa_nr = new JLabel();
        this.jPanel2 = new JPanel();
        this.panInfo1 = new RoundedPanel();
        this.panHeadInfo1 = new SemiRoundedPanel();
        this.lblHeading1 = new JLabel();
        this.panInfoContent1 = new JPanel();
        this.linearReferencedLineEditor = this.linearReferencedLineEditor;
        this.lblTypUnterhalb = new JLabel();
        this.lblTypOberhalb = new JLabel();
        this.lblValTypUnterhalb = new JLabel();
        this.lblValTypOberhalb = new JLabel();
        this.panLineUnterhalb = new JPanel();
        this.panLineOberhalb = new JPanel();
        this.jPanel3 = new JPanel();
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new GridBagLayout());
        this.lblFoot.setFont(new Font("Tahoma", 1, 12));
        this.lblFoot.setForeground(new Color(255, 255, 255));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 25, 7, 25);
        this.panFooter.add((Component)this.lblFoot, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        this.panInfo.setMinimumSize(new Dimension(640, 100));
        this.panInfo.setPreferredSize(new Dimension(680, 100));
        this.panHeadInfo.setBackground(new Color(51, 51, 51));
        this.panHeadInfo.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading.setForeground(new Color(255, 255, 255));
        this.lblHeading.setText("LAWA-Detailtyp");
        this.panHeadInfo.add((Component)this.lblHeading);
        this.panInfo.add((Component)this.panHeadInfo, (Object)"North");
        this.panInfoContent.setOpaque(false);
        this.panInfoContent.setLayout(new GridBagLayout());
        this.lblWk_k.setText("Wasserk\u00f6rper-K\u00fcrzel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 5, 5);
        this.panInfoContent.add((Component)this.lblWk_k, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weighty = 1.0;
        this.panInfoContent.add((Component)this.blbSpace, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panInfoContent.add((Component)this.jPanel1, gridBagConstraints);
        this.lblLawa_nr.setText("LAWA-Typ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panInfoContent.add((Component)this.lblLawa_nr, gridBagConstraints);
        this.cbLawa_nr.setMinimumSize(new Dimension(415, 20));
        this.cbLawa_nr.setPreferredSize(new Dimension(415, 20));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.lawa_nr}"), (Object)this.cbLawa_nr, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panInfoContent.add((Component)this.cbLawa_nr, gridBagConstraints);
        this.lblValWk_k.setMaximumSize(new Dimension(415, 20));
        this.lblValWk_k.setPreferredSize(new Dimension(415, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.wk_k}"), (Object)this.lblValWk_k, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.panInfoContent.add((Component)this.lblValWk_k, gridBagConstraints);
        this.lblValLawa_nr.setMinimumSize(new Dimension(415, 20));
        this.lblValLawa_nr.setPreferredSize(new Dimension(415, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panInfoContent.add((Component)this.lblValLawa_nr, gridBagConstraints);
        this.panInfo.add((Component)this.panInfoContent, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.add((Component)this.panInfo, gridBagConstraints);
        this.jPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.panInfo1.setMinimumSize(new Dimension(640, 140));
        this.panHeadInfo1.setBackground(new Color(51, 51, 51));
        this.panHeadInfo1.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo1.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo1.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading1.setForeground(new Color(255, 255, 255));
        this.lblHeading1.setText("Geometrie");
        this.panHeadInfo1.add((Component)this.lblHeading1);
        this.panInfo1.add((Component)this.panHeadInfo1, (Object)"North");
        this.panInfoContent1.setOpaque(false);
        this.panInfoContent1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panInfoContent1.add((Component)this.linearReferencedLineEditor, gridBagConstraints);
        this.lblTypUnterhalb.setText("Typ unterhalb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(30, 10, 5, 10);
        this.panInfoContent1.add((Component)this.lblTypUnterhalb, gridBagConstraints);
        this.lblTypOberhalb.setText("Typ oberhalb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(30, 10, 5, 10);
        this.panInfoContent1.add((Component)this.lblTypOberhalb, gridBagConstraints);
        this.lblValTypUnterhalb.setText("<nicht gesetzt>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.panInfoContent1.add((Component)this.lblValTypUnterhalb, gridBagConstraints);
        this.lblValTypOberhalb.setText("<nicht gesetzt>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.panInfoContent1.add((Component)this.lblValTypOberhalb, gridBagConstraints);
        this.panLineUnterhalb.setBackground(new Color(255, 91, 0));
        this.panLineUnterhalb.setMinimumSize(new Dimension(10, 4));
        this.panLineUnterhalb.setPreferredSize(new Dimension(100, 4));
        this.panLineUnterhalb.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panInfoContent1.add((Component)this.panLineUnterhalb, gridBagConstraints);
        this.panLineOberhalb.setBackground(new Color(255, 91, 0));
        this.panLineOberhalb.setMinimumSize(new Dimension(10, 4));
        this.panLineOberhalb.setPreferredSize(new Dimension(100, 4));
        this.panLineOberhalb.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panInfoContent1.add((Component)this.panLineOberhalb, gridBagConstraints);
        this.panInfo1.add((Component)this.panInfoContent1, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.add((Component)this.panInfo1, gridBagConstraints);
        this.jPanel3.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public void dispose() {
        this.linearReferencedLineEditor.dispose();
        this.removeListener();
        this.bindingGroup.unbind();
    }

    private void removeListener() {
        if (this.realGeom != null) {
            this.realGeom.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.cidsBean != null) {
            this.cidsBean.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public String getTitle() {
        return this.cidsBean.getProperty("wk_k") + " " + String.valueOf(this.cidsBean);
    }

    public void setTitle(String title) {
    }

    public void editorClosed(EditorClosedEvent event) {
        this.linearReferencedLineEditor.editorClosed(event);
    }

    public boolean prepareForSave() {
        boolean save = true;
        if (this.cidsBean != null) {
            try {
                this.cidsBean.setProperty("av_user", (Object)SessionManager.getSession().getUser().toString());
                this.cidsBean.setProperty("av_time", (Object)new Timestamp(System.currentTimeMillis()));
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return save &= this.linearReferencedLineEditor.prepareForSave();
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if (!this.readOnly) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("propertyChange " + evt.getPropertyName()));
                    }
                    if (evt.getPropertyName().equals("geom")) {
                        if (evt.getNewValue() != null) {
                            ((CidsBean)evt.getNewValue()).addPropertyChangeListener((PropertyChangeListener)LawaEditor.this);
                        } else if (LawaEditor.this.realGeom != null) {
                            LawaEditor.this.realGeom.removePropertyChangeListener((PropertyChangeListener)LawaEditor.this);
                        }
                    } else if (evt.getPropertyName().equals("geo_field") && evt.getNewValue() != null) {
                        String wkk = LawaEditor.this.getWk_k((Geometry)evt.getNewValue());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("change wk_k to " + wkk));
                        }
                        if (wkk != null) {
                            LawaEditor.this.lblValWk_k.setText(wkk);
                            try {
                                Object o = LawaEditor.this.cidsBean.getProperty("wk_k");
                                if (o instanceof String) {
                                    Logger logger = LOG;
                                    synchronized (logger) {
                                        if (!wkk.equals((String)o)) {
                                            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)LawaEditor.this), "Durch die \u00c4nderung der Stationierung hat sich der Wasserk\u00f6rper ge\u00e4ndert.", "\u00c4nderung am Wasserk\u00f6rper", 1);
                                            LawaEditor.this.cidsBean.setProperty("wk_k", (Object)wkk);
                                        }
                                    }
                                } else {
                                    LawaEditor.this.cidsBean.setProperty("wk_k", (Object)wkk);
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"wk_k updated");
                                }
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Cannot assign the new wk_k to the cids bean", (Throwable)e);
                            }
                        }
                    }
                }
            }).start();
        }
    }

    public void beansDropped(ArrayList<CidsBean> beans) {
        if (this.cidsBean != null && !this.readOnly) {
            for (CidsBean bean : beans) {
                if (!bean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_fg")) continue;
                try {
                    this.cidsBean.setProperty("wk_k", bean.getProperty("wk_k"));
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while setting a new wk_k", (Throwable)e);
                }
            }
        }
    }
}

