/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.LinearReferencedLineArrayEditorListener;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.LinearReferencedLineEditor;
import de.cismet.cids.custom.wrrl_db_mv.commons.linearreferencing.LinearReferencingConstants;
import de.cismet.cids.custom.wrrl_db_mv.util.MapUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingSingletonInstances;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openide.util.NbBundle;

public class LinearReferencedLineArrayEditor
extends JPanel
implements DisposableCidsBeanStore,
EditorSaveListener,
LinearReferencingConstants,
LinearReferencingSingletonInstances {
    HashMap<CidsBean, LinearReferencedLineEditor> editorMap = new HashMap();
    private HashMap<JButton, LinearReferencedLineEditor> editorButtonMap = new HashMap();
    private Collection<LinearReferencedLineArrayEditorListener> listeners = new ArrayList<LinearReferencedLineArrayEditorListener>();
    private CidsBean cidsBean;
    private String arrayField;
    private String metaClassName;
    private String lineField;
    private String otherLinesFromQueryPart;
    private String otherLinesWhereQueryPart;
    private boolean isOtherLinesEnabled = true;
    private boolean drawingFeaturesEnabled = true;
    private boolean readOnly = false;
    private JLabel jLabel3;
    private JLabel lblTitle;
    private JPanel panDrop;
    private JPanel panLines;
    private RoundedPanel panRounded;
    private SemiRoundedPanel panSemiRounded;

    public LinearReferencedLineArrayEditor() {
        this(false);
    }

    public LinearReferencedLineArrayEditor(boolean readOnly) {
        this.readOnly = readOnly;
        this.initComponents();
        if (!readOnly) {
            try {
                new CidsBeanDropTarget((Component)this.panDrop);
            }
            catch (Exception ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"error while creating CidsBeanDropTarget");
                }
            }
        } else {
            this.jLabel3.setText("");
        }
    }

    public void setOtherLinesEnabled(boolean isOtherLinesEnabled) {
        this.isOtherLinesEnabled = isOtherLinesEnabled;
    }

    private boolean isOtherLinesEnabled() {
        return this.isOtherLinesEnabled;
    }

    public void setOtherLinesQueryAddition(String otherLinesFromQueryPart, String otherLinesWhereQueryPart) {
        this.otherLinesFromQueryPart = otherLinesFromQueryPart;
        this.otherLinesWhereQueryPart = otherLinesWhereQueryPart;
    }

    private String getMetaClassName() {
        return this.metaClassName;
    }

    private void setMetaClassName(String metaClassName) {
        this.metaClassName = metaClassName;
    }

    public final void setFields(String metaClassName, String arrayField, String lineField) {
        this.setMetaClassName(metaClassName);
        this.setArrayField(arrayField);
        this.setLineField(lineField);
    }

    private void setArrayField(String arrayField) {
        this.arrayField = arrayField;
    }

    private String getLineField() {
        return this.lineField;
    }

    private void setLineField(String lineField) {
        this.lineField = lineField;
    }

    public void setTitle(String title) {
        this.lblTitle.setText(title);
    }

    protected LinearReferencedLineEditor createEditor() {
        return new LinearReferencedLineEditor(!this.readOnly);
    }

    public boolean addListener(LinearReferencedLineArrayEditorListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(LinearReferencedLineArrayEditorListener listener) {
        return this.listeners.remove(listener);
    }

    private void fireEditorAdded(LinearReferencedLineEditor source) {
        for (LinearReferencedLineArrayEditorListener listener : this.listeners) {
            listener.editorAdded(source);
        }
    }

    private void fireEditorRemoved(LinearReferencedLineEditor source) {
        for (LinearReferencedLineArrayEditorListener listener : this.listeners) {
            listener.editorRemoved(source);
        }
    }

    private Collection<CidsBean> getCidsBeans() {
        if (this.getCidsBean() == null) {
            return new ArrayList<CidsBean>();
        }
        return (Collection)this.getCidsBean().getProperty(this.arrayField);
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        CIDSBEAN_CACHE.clear();
        this.cidsBean = cidsBean;
        for (CidsBean childBean : this.getCidsBeans()) {
            LinearReferencedLineEditor editor = this.createEditor();
            editor.setDrawingFeaturesEnabled(this.drawingFeaturesEnabled);
            editor.setOtherLinesEnabled(this.isOtherLinesEnabled());
            editor.setOtherLinesQueryAddition(this.otherLinesFromQueryPart, this.otherLinesWhereQueryPart);
            editor.setLineField(this.getLineField());
            editor.setCidsBean(childBean);
            this.addEditor(editor);
        }
    }

    private void addEditor(LinearReferencedLineEditor editor) {
        this.editorMap.put(editor.getCidsBean(), editor);
        JPanel panItem = new JPanel(new BorderLayout(5, 5));
        panItem.setOpaque(false);
        if (!this.readOnly) {
            JButton btnRemove = new JButton();
            btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_remove_mini.png")));
            btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JButton button = (JButton)evt.getSource();
                    LinearReferencedLineEditor editor = (LinearReferencedLineEditor)LinearReferencedLineArrayEditor.this.editorButtonMap.get(button);
                    LinearReferencedLineArrayEditor.this.removeEditor(editor);
                }
            });
            JPanel panEast = new JPanel(new FlowLayout(1, 5, 5));
            panEast.add(btnRemove);
            panEast.setOpaque(false);
            panItem.add((Component)panEast, "East");
            this.editorButtonMap.put(btnRemove, editor);
        }
        JPanel panEditor = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        panEditor.setOpaque(false);
        panEditor.add((Component)editor, gridBagConstraints);
        panItem.add((Component)panEditor, "Center");
        panItem.add((Component)new JSeparator(), "South");
        this.panLines.add(panItem);
        this.revalidate();
        this.fireEditorAdded(editor);
    }

    protected CidsBean createBeanFromRoute(CidsBean routeBean) {
        MetaClass parentMC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)this.getMetaClassName());
        CidsBean newBean = parentMC.getEmptyInstance().getBean();
        LinearReferencedLineEditor.fillFromRoute(routeBean, newBean, this.getLineField());
        return newBean;
    }

    private void removeEditor(LinearReferencedLineEditor editor) {
        Collection<CidsBean> cidsBeans = this.getCidsBeans();
        cidsBeans.remove(editor.getCidsBean());
        this.panLines.remove(editor.getParent().getParent());
        editor.dispose();
        this.editorMap.remove(editor.getCidsBean());
        this.revalidate();
        this.fireEditorRemoved(editor);
    }

    public void dispose() {
        for (LinearReferencedLineEditor editor : this.editorMap.values()) {
            editor.dispose();
        }
    }

    private void initComponents() {
        this.panRounded = new RoundedPanel();
        this.panSemiRounded = new SemiRoundedPanel();
        this.lblTitle = new JLabel();
        this.panLines = new JPanel();
        this.panDrop = new DropPanel();
        this.jLabel3 = new JLabel();
        this.setMinimumSize(new Dimension(200, 100));
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 2));
        this.panRounded.setLayout((LayoutManager)new GridBagLayout());
        this.panSemiRounded.setBackground(new Color(51, 51, 51));
        this.panSemiRounded.setMinimumSize(new Dimension(55, 24));
        this.panSemiRounded.setPreferredSize(new Dimension(0, 24));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        this.lblTitle.setHorizontalAlignment(0);
        this.lblTitle.setText(NbBundle.getMessage(LinearReferencedLineArrayEditor.class, (String)"LinearReferencedLineArrayEditor.lblTitle.text_1"));
        this.panSemiRounded.add((Component)this.lblTitle, (Object)"Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.panRounded.add((Component)this.panSemiRounded, (Object)gridBagConstraints);
        this.panLines.setMinimumSize(new Dimension(100, 48));
        this.panLines.setOpaque(false);
        this.panLines.setLayout(new BoxLayout(this.panLines, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panRounded.add((Component)this.panLines, (Object)gridBagConstraints);
        this.panDrop.setMinimumSize(new Dimension(10, 24));
        this.panDrop.setOpaque(false);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText(NbBundle.getMessage(LinearReferencedLineArrayEditor.class, (String)"LinearReferencedLineArrayEditor.jLabel3.text"));
        this.panDrop.add(this.jLabel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.panRounded.add((Component)this.panDrop, (Object)gridBagConstraints);
        this.add((Component)this.panRounded);
    }

    public void editorClosed(EditorClosedEvent event) {
        CidsBean savedBean = event.getSavedBean();
        if (savedBean != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SavedBean: " + event.getSavedBean().getMOString()), (Throwable)new CurrentStackTrace());
            }
            for (CidsBean savedChildBean : (Collection)savedBean.getProperty(this.arrayField)) {
                LinearReferencedLineEditor editor = this.editorMap.get(savedChildBean);
                if (editor == null) continue;
                editor.editorClosed(new EditorClosedEvent(event.getStatus(), savedChildBean));
            }
        }
    }

    public boolean prepareForSave() {
        boolean save = true;
        for (LinearReferencedLineEditor editor : this.editorMap.values()) {
            save &= editor.prepareForSave();
        }
        return save;
    }

    public Collection<Feature> getZoomFeatures() {
        ArrayList<Feature> zoomFeatures = new ArrayList<Feature>();
        this.addZoomFeaturesToCollection(zoomFeatures);
        return zoomFeatures;
    }

    public void addZoomFeaturesToCollection(Collection<Feature> collection) {
        for (LinearReferencedLineEditor editor : this.editorMap.values()) {
            editor.addZoomFeaturesToCollection(collection);
        }
    }

    public boolean isDrawingFeaturesEnabled() {
        return this.drawingFeaturesEnabled;
    }

    public void setDrawingFeaturesEnabled(boolean drawingFeaturesEnabled) {
        this.drawingFeaturesEnabled = drawingFeaturesEnabled;
    }

    private class DropPanel
    extends JPanel
    implements CidsBeanDropListener {
        private DropPanel() {
        }

        public void beansDropped(ArrayList<CidsBean> beans) {
            for (CidsBean bean : beans) {
                if (bean.getMetaObject().getMetaClass().getName().equals("route")) {
                    LinearReferencedLineEditor editor = LinearReferencedLineArrayEditor.this.createEditor();
                    editor.setLineField(LinearReferencedLineArrayEditor.this.getLineField());
                    CidsBean lineBean = LinearReferencedLineArrayEditor.this.createBeanFromRoute(bean);
                    editor.setOtherLinesQueryAddition(LinearReferencedLineArrayEditor.this.otherLinesFromQueryPart, LinearReferencedLineArrayEditor.this.otherLinesWhereQueryPart);
                    editor.setDrawingFeaturesEnabled(LinearReferencedLineArrayEditor.this.drawingFeaturesEnabled);
                    editor.setCidsBean(lineBean);
                    editor.updateRealGeoms();
                    LinearReferencedLineArrayEditor.this.addEditor(editor);
                    LinearReferencedLineArrayEditor.this.getCidsBeans().add(editor.getCidsBean());
                    if (LinearReferencedLineArrayEditor.this.getCidsBeans().size() == 1) {
                        LinearReferencedLineArrayEditor.this.getCidsBean().getMetaObject().setAllClasses();
                    }
                    MapUtil.zoomToFeatureCollection(editor.getZoomFeatures());
                    continue;
                }
                return;
            }
        }
    }
}

