/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import de.cismet.cids.custom.objecteditors.wrrl_db_mv.LinearReferencedLineEditor;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.MapUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.MassnahmenUmsetzungCache;
import de.cismet.cids.custom.wrrl_db_mv.util.RouteWBDropBehavior;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class MassnahmenUmsetzungEditor
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener,
CidsBeanDropListener {
    private static final Logger LOG = Logger.getLogger(MassnahmenUmsetzungEditor.class);
    public static final String[] WB_PROPERTIES = new String[]{"wk_fg", "wk_sg", "wk_kg", "wk_gw"};
    private static final String MASSN_STARTED_PROPERTY = "massn_started";
    private boolean readOnly = false;
    private boolean isStandaloneEditor = true;
    private CidsBean cidsBean;
    private ArrayList<CidsBean> beansToDelete = new ArrayList();
    private ArrayList<CidsBean> beansToSave = new ArrayList();
    private JList referencedList;
    private RouteWBDropBehavior dropBehaviorListener;
    private Thread actionRetrievalThread = null;
    private MassnahmenUmsetzungCache cache;
    private JComboBox cbGeom;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JLabel lblBeschrDerMa;
    private JLabel lblGeom;
    private JLabel lblHeading1;
    private JLabel lblMassnahme_nr;
    private JLabel lblValMassnahme_nr;
    private JLabel lblValWk_k;
    private JLabel lblWk_k;
    private LinearReferencedLineEditor linearReferencedLineEditor;
    private RoundedPanel panGeo;
    private SemiRoundedPanel panHeadInfo1;
    private JPanel panInfoContent1;
    private BindingGroup bindingGroup;

    public MassnahmenUmsetzungEditor() {
        this(true, false);
    }

    public MassnahmenUmsetzungEditor(boolean isStandaloneEditor, boolean readOnly) {
        this.isStandaloneEditor = isStandaloneEditor;
        this.readOnly = readOnly;
        if (!isStandaloneEditor) {
            this.initComponents();
            this.dropBehaviorListener = new RouteWBDropBehavior(this);
            this.linearReferencedLineEditor.setLineField("linie");
            this.linearReferencedLineEditor.setDropBehavior(this.dropBehaviorListener);
            this.linearReferencedLineEditor.setOtherLinesEnabled(false);
            this.deActivateGUIElements(false);
            this.jPanel1.setVisible(!readOnly);
            try {
                new CidsBeanDropTarget((Component)this);
            }
            catch (Exception ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error while creating CidsBeanDropTarget", (Throwable)ex);
                }
            }
        } else {
            JLabel hintLabel = new JLabel();
            hintLabel.setText(NbBundle.getMessage(MassnahmenUmsetzungEditor.class, (String)"MassnahmenUmsetzungEditor.hintLabel.text"));
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0);
            this.add((Component)hintLabel, constraints);
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame("Test");
        f.setDefaultCloseOperation(3);
        MassnahmenUmsetzungEditor s = new MassnahmenUmsetzungEditor();
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)s, "Center");
        f.pack();
        f.setVisible(true);
    }

    private void zoomToFeatures() {
        MapUtil.zoomToFeatureCollection(this.linearReferencedLineEditor.getZoomFeatures());
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.lblBeschrDerMa = new JLabel();
        this.lblWk_k = new JLabel();
        this.lblValWk_k = new JLabel();
        this.lblMassnahme_nr = new JLabel();
        this.lblValMassnahme_nr = new JLabel();
        this.panGeo = new RoundedPanel();
        this.panHeadInfo1 = new SemiRoundedPanel();
        this.lblHeading1 = new JLabel();
        this.panInfoContent1 = new JPanel();
        this.linearReferencedLineEditor = new LinearReferencedLineEditor();
        this.jPanel1 = new JPanel();
        this.cbGeom = new DefaultCismapGeometryComboBoxEditor();
        this.lblGeom = new JLabel();
        this.setMinimumSize(new Dimension(440, 675));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(440, 675));
        this.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(550, 480));
        this.jPanel2.setOpaque(false);
        this.jPanel2.setPreferredSize(new Dimension(550, 480));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(422, 75));
        this.jScrollPane1.setPreferredSize(new Dimension(422, 75));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(3);
        this.jTextArea1.setDisabledTextColor(new Color(26, 26, 26));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.mass_beschreibung}"), (Object)this.jTextArea1, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblBeschrDerMa.setText(NbBundle.getMessage(MassnahmenUmsetzungEditor.class, (String)"MassnahmenUmsetzungEditor.lblBeschrDerMa.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel2.add((Component)this.lblBeschrDerMa, gridBagConstraints);
        this.lblWk_k.setText(NbBundle.getMessage(MassnahmenUmsetzungEditor.class, (String)"MassnahmenUmsetzungEditor.lblWk_k.text"));
        this.lblWk_k.setMinimumSize(new Dimension(182, 20));
        this.lblWk_k.setPreferredSize(new Dimension(182, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel2.add((Component)this.lblWk_k, gridBagConstraints);
        this.lblValWk_k.setMinimumSize(new Dimension(250, 20));
        this.lblValWk_k.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.jPanel2.add((Component)this.lblValWk_k, gridBagConstraints);
        this.lblMassnahme_nr.setText(NbBundle.getMessage(MassnahmenUmsetzungEditor.class, (String)"MassnahmenUmsetzungEditor.lblMassnahme_nr.text"));
        this.lblMassnahme_nr.setMinimumSize(new Dimension(182, 20));
        this.lblMassnahme_nr.setPreferredSize(new Dimension(182, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel2.add((Component)this.lblMassnahme_nr, gridBagConstraints);
        this.lblValMassnahme_nr.setMinimumSize(new Dimension(250, 20));
        this.lblValMassnahme_nr.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.jPanel2.add((Component)this.lblValMassnahme_nr, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 20);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.panHeadInfo1.setBackground(new Color(51, 51, 51));
        this.panHeadInfo1.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo1.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo1.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading1.setForeground(new Color(255, 255, 255));
        this.lblHeading1.setText(NbBundle.getMessage(MassnahmenUmsetzungEditor.class, (String)"MassnahmenUmsetzungEditor.lblHeading1.text"));
        this.panHeadInfo1.add((Component)this.lblHeading1);
        this.panGeo.add((Component)this.panHeadInfo1, (Object)"North");
        this.panInfoContent1.setOpaque(false);
        this.panInfoContent1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panInfoContent1.add((Component)this.linearReferencedLineEditor, gridBagConstraints);
        this.panGeo.add((Component)this.panInfoContent1, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 10, 20);
        this.add((Component)this.panGeo, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        if (!this.readOnly) {
            this.cbGeom.setMinimumSize(new Dimension(300, 20));
            this.cbGeom.setPreferredSize(new Dimension(300, 20));
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.additional_geom}"), (Object)this.cbGeom, (Property)BeanProperty.create((String)"selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)this.cbGeom).getConverter());
            this.bindingGroup.addBinding((Binding)binding);
        }
        if (!this.readOnly) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            this.jPanel1.add((Component)this.cbGeom, gridBagConstraints);
        }
        this.lblGeom.setText(NbBundle.getMessage(MassnahmenUmsetzungEditor.class, (String)"MassnahmenUmsetzungEditor.lblGeom.text"));
        this.lblGeom.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel1.add((Component)this.lblGeom, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(final CidsBean cidsBean) {
        int ans;
        CidsBean action = null;
        CidsBean wb = null;
        if (this.isStandaloneEditor) {
            return;
        }
        if (this.dropBehaviorListener.isRouteChanged() && !this.linearReferencedLineEditor.hasChangedSinceDrop() && (ans = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Sie haben die Stationen nicht ge\u00e4ndert, nachdem Sie eine neue Route ausgew\u00e4hlt haben. M\u00f6chten Sie die Stationen \u00e4ndern?", "Keine \u00c4nderung der Stationen", 0, 2)) == 0) {
            return;
        }
        this.dispose();
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            if (this.cache != null) {
                action = this.cache.getAction(cidsBean);
                wb = this.cache.getWB(cidsBean);
            }
            ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).setCidsMetaObject(cidsBean.getMetaObject());
            ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).initForNewBinding();
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean);
            if (wb == null && cidsBean != null && MassnahmenUmsetzungCache.getWk_kId(cidsBean) != null) {
                CidsBean wkObject = MassnahmenUmsetzungCache.bindWkkField(this.lblValWk_k, cidsBean);
                this.dropBehaviorListener.setWkFg(wkObject);
            } else if (wb != null) {
                this.dropBehaviorListener.setWkFg(wb);
                this.lblValWk_k.setText(String.valueOf(wb.getProperty(MassnahmenUmsetzungCache.getWk_kProperty(cidsBean))));
            } else if (cidsBean != null && MassnahmenUmsetzungCache.getWk_kId(cidsBean) == null) {
                this.lblValWk_k.setText("<nicht gesetzt>");
            }
            this.bindingGroup.bind();
            this.deActivateGUIElements(true);
            this.zoomToFeatures();
        } else {
            this.dropBehaviorListener.setWkFg(null);
            this.deActivateGUIElements(false);
            this.lblValWk_k.setText("");
        }
        this.linearReferencedLineEditor.setCidsBean(cidsBean);
        this.waitForRunningThreads();
        if (action == null && cidsBean != null && cidsBean.getProperty("massnahme") != null) {
            this.lblValMassnahme_nr.setText("");
            this.actionRetrievalThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    MassnahmenUmsetzungCache.bindActionField(MassnahmenUmsetzungEditor.this.lblValMassnahme_nr, cidsBean);
                }
            });
            this.actionRetrievalThread.start();
        } else if (action != null) {
            this.lblValMassnahme_nr.setText(String.valueOf(action.getProperty("massn_id")));
        } else if (cidsBean != null && cidsBean.getProperty("massnahme") == null) {
            this.lblValMassnahme_nr.setText("<nicht gesetzt>");
        } else {
            this.lblValMassnahme_nr.setText("");
        }
    }

    private void waitForRunningThreads() {
        if (this.actionRetrievalThread != null && this.actionRetrievalThread.isAlive()) {
            this.actionRetrievalThread.interrupt();
        }
        while (this.actionRetrievalThread != null && this.actionRetrievalThread.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void dispose() {
        if (!this.isStandaloneEditor) {
            ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).dispose();
            this.linearReferencedLineEditor.dispose();
            this.bindingGroup.unbind();
        }
    }

    public String getTitle() {
        return "";
    }

    public void setTitle(String title) {
    }

    public void setList(JList referencedList) {
        this.referencedList = referencedList;
    }

    private void deActivateGUIElements(boolean enable) {
        if (this.readOnly) {
            enable = false;
        }
        this.jTextArea1.setEnabled(enable);
        this.cbGeom.setEnabled(enable);
        this.linearReferencedLineEditor.setEnabled(enable);
    }

    public void beansDropped(ArrayList<CidsBean> beans) {
        if (this.isStandaloneEditor || this.readOnly) {
            return;
        }
        if (this.cidsBean != null) {
            for (CidsBean bean : beans) {
                int conf;
                if (bean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_fg")) {
                    this.bindToWb(WB_PROPERTIES[0], bean);
                    this.dropBehaviorListener.setWkFg(bean);
                    continue;
                }
                if (bean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_sg")) {
                    this.bindToWb(WB_PROPERTIES[1], bean);
                    continue;
                }
                if (bean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_kg")) {
                    this.bindToWb(WB_PROPERTIES[2], bean);
                    continue;
                }
                if (bean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_gw")) {
                    this.bindToWb(WB_PROPERTIES[3], bean);
                    continue;
                }
                if (!bean.getClass().getName().equals("de.cismet.cids.dynamics.Massnahmen") || (conf = JOptionPane.showConfirmDialog(this, "Soll die Ma\u00dfnahme " + bean.toString() + " wirklich als Template f\u00fcr die ausgew\u00e4hlte Umsetzung dienen?", "Ma\u00dfnahme als Template nutzen", 1)) != 0) continue;
                this.copyActionToImplementation(bean);
                if (this.referencedList == null) continue;
                this.referencedList.repaint();
            }
            CidsBean action = MassnahmenUmsetzungCache.bindActionField(this.lblValMassnahme_nr, this.cidsBean);
            CidsBean wb = MassnahmenUmsetzungCache.bindWkkField(this.lblValWk_k, this.cidsBean);
            if (this.getCache() != null) {
                this.getCache().addAction(this.cidsBean, action);
                this.getCache().addWB(this.cidsBean, wb);
            }
        }
    }

    private void bindToWb(String propertyName, CidsBean propertyEntry) {
        try {
            this.cidsBean.setProperty(propertyName, propertyEntry.getProperty("id"));
            for (String propName : WB_PROPERTIES) {
                if (propName.equals(propertyName)) continue;
                this.cidsBean.setProperty(propName, null);
            }
            this.showOrHideGeometryEditors();
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while binding a water body", (Throwable)ex);
        }
    }

    public void copyActionToImplementation(CidsBean act) {
        block17: {
            try {
                Object started;
                CidsBean linBean;
                CidsBean additionalGeom = (CidsBean)act.getProperty("additional_geom");
                CidsBeanSupport.deletePropertyIfExists(this.cidsBean, "additional_geom", this.beansToDelete);
                this.cidsBean.setProperty("massnahme", act.getProperty("id"));
                this.cidsBean.setProperty("additional_geom", (Object)CidsBeanSupport.cloneCidsBean(additionalGeom));
                this.cidsBean.setProperty("mass_beschreibung", act.getProperty("massn_id"));
                if (act.getProperty("wk_fg") != null) {
                    this.cidsBean.setProperty("wk_fg", ((CidsBean)act.getProperty("wk_fg")).getProperty("id"));
                } else {
                    this.cidsBean.setProperty("wk_fg", null);
                }
                if (act.getProperty("wk_sg") != null) {
                    this.cidsBean.setProperty("wk_sg", ((CidsBean)act.getProperty("wk_sg")).getProperty("id"));
                } else {
                    this.cidsBean.setProperty("wk_sg", null);
                }
                if (act.getProperty("wk_kg") != null) {
                    this.cidsBean.setProperty("wk_kg", ((CidsBean)act.getProperty("wk_kg")).getProperty("id"));
                } else {
                    this.cidsBean.setProperty("wk_kg", null);
                }
                if (act.getProperty("wk_gw") != null) {
                    this.cidsBean.setProperty("wk_gw", ((CidsBean)act.getProperty("wk_gw")).getProperty("id"));
                } else {
                    this.cidsBean.setProperty("wk_gw", null);
                }
                List<CidsBean> meas = CidsBeanSupport.getBeanCollectionFromProperty(act, "de_meas_cd");
                if (meas != null && meas.size() > 0) {
                    this.cidsBean.setProperty("measure_type_code", (Object)meas.get(0));
                }
                if ((linBean = (CidsBean)act.getProperty("linie")) != null) {
                    CidsBean statFrom = (CidsBean)linBean.getProperty("von");
                    CidsBean statTo = (CidsBean)linBean.getProperty("bis");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("statFrom " + statFrom.getProperty("wert")));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("statTo " + statTo.getProperty("wert")));
                    }
                    CidsBeanSupport.deleteStationlineIfExists(this.cidsBean, "linie", this.beansToDelete);
                    this.cidsBean.setProperty("linie", (Object)CidsBeanSupport.cloneStationline(linBean));
                    this.linearReferencedLineEditor.setCidsBean(this.cidsBean);
                }
                if (act == null || (started = act.getProperty(MASSN_STARTED_PROPERTY)) != null && (!(started instanceof Boolean) || ((Boolean)started).booleanValue())) break block17;
                try {
                    act.setProperty(MASSN_STARTED_PROPERTY, (Object)Boolean.TRUE);
                    if (!this.beansToSave.contains(act)) {
                        this.beansToSave.add(act);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while set action to fin.", (Throwable)e);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error during the creation of a new bean of type massnahmen", (Throwable)e);
            }
        }
    }

    public void editorClosed(EditorClosedEvent event) {
        if (!this.isStandaloneEditor) {
            this.linearReferencedLineEditor.editorClosed(event);
        }
    }

    public boolean prepareForSave() {
        int ans;
        if (this.isStandaloneEditor) {
            return true;
        }
        if (this.dropBehaviorListener.isRouteChanged() && !this.linearReferencedLineEditor.hasChangedSinceDrop() && (ans = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Sie haben die Stationen nicht ge\u00e4ndert, nachdem Sie eine neue Route ausgew\u00e4hlt haben. M\u00f6chten Sie die Stationen \u00e4ndern?", "Keine \u00c4nderung der Stationen", 0, 2)) == 0) {
            return false;
        }
        for (CidsBean bean : this.beansToDelete) {
            try {
                bean.persist();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while deleting bean", (Throwable)e);
            }
        }
        for (CidsBean bean : this.beansToSave) {
            try {
                bean.persist();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while deleting bean", (Throwable)e);
            }
        }
        boolean save = true;
        return save &= this.linearReferencedLineEditor.prepareForSave();
    }

    private void showOrHideGeometryEditors() {
        if (this.cidsBean != null && this.cidsBean.getProperty(WB_PROPERTIES[1]) != null) {
            this.panGeo.setVisible(false);
        } else {
            this.panGeo.setVisible(true);
        }
    }

    public MassnahmenUmsetzungCache getCache() {
        return this.cache;
    }

    public void setCache(MassnahmenUmsetzungCache cache) {
        this.cache = cache;
    }

    private class CustomElementComparator
    implements Comparator<CidsBean> {
        private int integerIndex = 0;

        public CustomElementComparator() {
        }

        public CustomElementComparator(int integerIndex) {
            this.integerIndex = integerIndex;
        }

        @Override
        public int compare(CidsBean o1, CidsBean o2) {
            if (o1 != null && o2 != null) {
                String strValue1 = (String)o1.getProperty("value");
                String strValue2 = (String)o2.getProperty("value");
                if (strValue1 != null && strValue2 != null) {
                    try {
                        Integer value1 = Integer.parseInt(strValue1.substring(this.integerIndex));
                        Integer value2 = Integer.parseInt(strValue2.substring(this.integerIndex));
                        return value1 - value2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return strValue1.compareTo(strValue2);
                    }
                }
                if (strValue1 == null && strValue2 == null) {
                    return 0;
                }
                return strValue1 == null ? -1 : 1;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            return o1 == null ? -1 : 1;
        }
    }
}

