/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.method.MethodManager;
import Sirius.navigator.ui.DescriptionPaneCalpa;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.middleware.types.Node;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.LinearReferencedPointEditorListener;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.QuerbauwerkePanFive;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.QuerbauwerkePanFour;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.QuerbauwerkePanOne;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.QuerbauwerkePanSeven;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.QuerbauwerkePanSix;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.QuerbauwerkePanThree;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.QuerbauwerkePanTwo;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.MapUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.TabbedPaneUITransparent;
import de.cismet.cids.custom.wrrl_db_mv.util.UIUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.WrrlEditorTester;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.BeanInitializer;
import de.cismet.cids.editors.BeanInitializerProvider;
import de.cismet.cids.editors.DefaultBeanInitializer;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.BindingGroup;
import org.openide.util.NbBundle;

public class QuerbauwerkeEditor
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener,
FooterComponentProvider,
BeanInitializerProvider,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(QuerbauwerkeEditor.class);
    private CidsBean cidsBean;
    private boolean readOnly = false;
    private final BindingGroup bindingGroup;
    private final PropertyChangeListener bauwerkPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getPropertyName().equals("bauwerk")) {
                int bauwerk_value = 0;
                try {
                    bauwerk_value = Integer.parseInt((String)((CidsBean)QuerbauwerkeEditor.this.cidsBean.getProperty("bauwerk")).getProperty("value"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                QuerbauwerkeEditor.this.querbauwerkePanFour.setWehrVisible(bauwerk_value == 1);
                QuerbauwerkeEditor.this.querbauwerkePanFour.setStarrVisible(bauwerk_value == 3);
            }
        }
    };
    private ConnectionContext cc = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.EDITOR, (String)"Querbauwerke");
    private JButton butLoadObjects;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JLabel lblFoot;
    private JLabel lblHeading;
    private JPanel panAllgemeines;
    private JPanel panBeschreibung;
    private JPanel panFische;
    private JPanel panFooter;
    private SemiRoundedPanel panHeadInfo;
    private RoundedPanel panInfo;
    private JPanel panInfoContent;
    private JPanel panSearchTool;
    private QuerbauwerkePanFive querbauwerkePanFive;
    private QuerbauwerkePanFour querbauwerkePanFour;
    private QuerbauwerkePanOne querbauwerkePanOne;
    private QuerbauwerkePanSeven querbauwerkePanSeven1;
    private QuerbauwerkePanSix querbauwerkePanSix;
    private QuerbauwerkePanThree querbauwerkePanThree;
    private QuerbauwerkePanTwo querbauwerkePanTwo;
    private JTabbedPane tpMain;

    public QuerbauwerkeEditor() {
        this(false);
    }

    public QuerbauwerkeEditor(boolean readOnly) {
        this.readOnly = readOnly;
        this.bindingGroup = new BindingGroup();
        this.initComponents();
        Boolean hasPerm = false;
        try {
            hasPerm = SessionManager.getProxy().hasConfigAttr(SessionManager.getSession().getUser(), "qb_all_infos", ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.EDITOR, (String)"has qb permission"));
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot check permission", (Throwable)e);
        }
        if (!hasPerm.booleanValue()) {
            this.tpMain.setEnabledAt(2, false);
        }
        try {
            boolean showSearch = SessionManager.getProxy().hasConfigAttr(SessionManager.getSession().getUser(), "qbw.search", this.cc);
            if (!showSearch) {
                this.tpMain.remove(this.tpMain.getTabCount() - 1);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot check configuration attribute qbw.search", (Throwable)e);
            this.tpMain.remove(this.tpMain.getTabCount() - 1);
        }
        if (!readOnly) {
            this.querbauwerkePanSix.getStat09Editor().addListener(new LinearReferencedPointEditorListener(){

                @Override
                public void pointCreated() {
                    block2: {
                        try {
                            QuerbauwerkeEditor.this.cidsBean.setProperty("stat09", (Object)QuerbauwerkeEditor.this.querbauwerkePanSix.getStat09Editor().getCidsBean());
                        }
                        catch (Exception ex) {
                            if (!LOG.isDebugEnabled()) break block2;
                            LOG.debug((Object)"error while assigning stat09 cidsbean to cidsbean", (Throwable)ex);
                        }
                    }
                }
            });
            this.querbauwerkePanSix.getStat09BisEditor().addListener(new LinearReferencedPointEditorListener(){

                @Override
                public void pointCreated() {
                    block2: {
                        try {
                            QuerbauwerkeEditor.this.cidsBean.setProperty("stat09_bis", (Object)QuerbauwerkeEditor.this.querbauwerkePanSix.getStat09BisEditor().getCidsBean());
                        }
                        catch (Exception ex) {
                            if (!LOG.isDebugEnabled()) break block2;
                            LOG.debug((Object)"error while assigning stat09_bis cidsbean to cidsbean", (Throwable)ex);
                        }
                    }
                }
            });
        }
        final DescriptionPaneCalpa browserPanel = new DescriptionPaneCalpa();
        browserPanel.setOpaque(false);
        this.jPanel1.add((Component)browserPanel, "Center");
        SwingWorker<String, Void> sw = new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() throws Exception {
                return SessionManager.getProxy().getConfigAttr(SessionManager.getSession().getUser(), "qbw.text", QuerbauwerkeEditor.this.cc);
            }

            @Override
            protected void done() {
                try {
                    String r = (String)this.get();
                    if (r != null) {
                        browserPanel.setPageFromContent(r);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while reatuing qbw.text configuration attribute", (Throwable)ex);
                }
            }
        };
        sw.execute();
        this.tpMain.setUI(new TabbedPaneUITransparent());
    }

    private void zoomToFeatures() {
        ArrayList<Feature> zoomFeatures = new ArrayList<Feature>();
        this.querbauwerkePanSix.getStat09Editor().addZoomFeaturesToCollection(zoomFeatures);
        this.querbauwerkePanSix.getStat09BisEditor().addZoomFeaturesToCollection(zoomFeatures);
        MapUtil.zoomToFeatureCollection(zoomFeatures);
    }

    private void initComponents() {
        this.panFooter = new JPanel();
        this.lblFoot = new JLabel();
        this.tpMain = new JTabbedPane();
        this.panBeschreibung = new JPanel();
        this.querbauwerkePanTwo = new QuerbauwerkePanTwo(this.readOnly);
        this.jPanel3 = new JPanel();
        this.querbauwerkePanThree = new QuerbauwerkePanThree(this.readOnly);
        this.querbauwerkePanFive = new QuerbauwerkePanFive(this.readOnly);
        if (!this.readOnly) {
            this.querbauwerkePanSix = new QuerbauwerkePanSix();
        }
        this.panAllgemeines = new JPanel();
        this.jPanel2 = new JPanel();
        this.querbauwerkePanOne = new QuerbauwerkePanOne(this.readOnly);
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.querbauwerkePanFour = new QuerbauwerkePanFour(this.readOnly);
        this.panFische = new JPanel();
        this.querbauwerkePanSeven1 = new QuerbauwerkePanSeven(this.readOnly);
        this.panSearchTool = new JPanel();
        this.panInfo = new RoundedPanel();
        this.panHeadInfo = new SemiRoundedPanel();
        this.lblHeading = new JLabel();
        this.panInfoContent = new JPanel();
        this.jPanel1 = new JPanel();
        this.butLoadObjects = new JButton();
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new GridBagLayout());
        this.lblFoot.setFont(new Font("Tahoma", 1, 12));
        this.lblFoot.setForeground(new Color(255, 255, 255));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 25, 7, 25);
        this.panFooter.add((Component)this.lblFoot, gridBagConstraints);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.panBeschreibung.setOpaque(false);
        this.panBeschreibung.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.panBeschreibung.add((Component)this.querbauwerkePanTwo, gridBagConstraints);
        this.jPanel3.setOpaque(false);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panBeschreibung.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.panBeschreibung.add((Component)this.querbauwerkePanThree, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.panBeschreibung.add((Component)this.querbauwerkePanFive, gridBagConstraints);
        if (!this.readOnly) {
            // empty if block
        }
        if (!this.readOnly) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(10, 0, 10, 0);
            this.panBeschreibung.add((Component)this.querbauwerkePanSix, gridBagConstraints);
        }
        this.tpMain.addTab(NbBundle.getMessage(QuerbauwerkeEditor.class, (String)"QuerbauwerkeEditor.panBeschreibung.TabConstraints.tabTitle"), this.panBeschreibung);
        this.panAllgemeines.setOpaque(false);
        this.panAllgemeines.setLayout(new GridBagLayout());
        this.jPanel2.setOpaque(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1316, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 464, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panAllgemeines.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.panAllgemeines.add((Component)this.querbauwerkePanOne, gridBagConstraints);
        this.tpMain.addTab(NbBundle.getMessage(QuerbauwerkeEditor.class, (String)"QuerbauwerkeEditor.panAllgemeines.TabConstraints.tabTitle"), this.panAllgemeines);
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel5.setOpaque(false);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1316, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 888, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel4.add((Component)this.querbauwerkePanFour, gridBagConstraints);
        this.tpMain.addTab(NbBundle.getMessage(QuerbauwerkeEditor.class, (String)"QuerbauwerkeEditor.jPanel4.TabConstraints.tabTitle"), this.jPanel4);
        this.panFische.setOpaque(false);
        this.panFische.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.panFische.add((Component)this.querbauwerkePanSeven1, gridBagConstraints);
        this.tpMain.addTab(NbBundle.getMessage(QuerbauwerkeEditor.class, (String)"QuerbauwerkeEditor.panFische.TabConstraints.tabTitle"), this.panFische);
        this.panSearchTool.setOpaque(false);
        this.panSearchTool.setLayout(new GridBagLayout());
        this.panHeadInfo.setBackground(new Color(51, 51, 51));
        this.panHeadInfo.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading.setForeground(new Color(255, 255, 255));
        this.lblHeading.setText(NbBundle.getMessage(QuerbauwerkeEditor.class, (String)"QuerbauwerkeEditor.lblHeading.text"));
        this.panHeadInfo.add((Component)this.lblHeading);
        this.panInfo.add((Component)this.panHeadInfo, (Object)"North");
        this.panInfoContent.setOpaque(false);
        this.panInfoContent.setLayout(new GridBagLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panInfoContent.add((Component)this.jPanel1, gridBagConstraints);
        this.butLoadObjects.setText(NbBundle.getMessage(QuerbauwerkeEditor.class, (String)"QuerbauwerkeEditor.butLoadObjects.text", (Object[])new Object[0]));
        this.butLoadObjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuerbauwerkeEditor.this.butLoadObjectsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.panInfoContent.add((Component)this.butLoadObjects, gridBagConstraints);
        this.panInfo.add((Component)this.panInfoContent, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panSearchTool.add((Component)this.panInfo, gridBagConstraints);
        this.tpMain.addTab(NbBundle.getMessage(QuerbauwerkeEditor.class, (String)"QuerbauwerkeEditor.panSearchTool.TabConstraints.tabTitle", (Object[])new Object[0]), this.panSearchTool);
        this.add((Component)this.tpMain, "Center");
    }

    private void butLoadObjectsActionPerformed(ActionEvent evt) {
        this.loadRelatedQbw(this.cidsBean);
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        if (this.cidsBean != null) {
            this.cidsBean.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            block7: {
                cidsBean.addPropertyChangeListener((PropertyChangeListener)this);
                try {
                    cidsBean.addPropertyChangeListener(this.bauwerkPropertyChangeListener);
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)"error while autosetting properties", (Throwable)ex);
                }
            }
            if (this.tpMain.getTabCount() == 5 && cidsBean.getProperty("up_agg_id") == null) {
                this.tpMain.remove(this.tpMain.getTabCount() - 1);
            }
            this.refreshReadOnlyFields();
            this.querbauwerkePanOne.setCidsBean(cidsBean);
            this.querbauwerkePanTwo.setCidsBean(cidsBean);
            this.querbauwerkePanThree.setCidsBean(cidsBean);
            this.querbauwerkePanFour.setCidsBean(cidsBean);
            this.querbauwerkePanFive.setCidsBean(cidsBean);
            if (this.querbauwerkePanSix != null) {
                this.querbauwerkePanSix.setCidsBean(cidsBean);
            }
            this.querbauwerkePanSeven1.setCidsBean(cidsBean);
            this.bindingGroup.bind();
            UIUtil.setLastModifier(cidsBean, this.lblFoot);
            this.tpMain.setEnabledAt(3, QuerbauwerkeEditor.showFishPanel(cidsBean));
            if (!this.readOnly) {
                this.zoomToFeatures();
            }
        }
    }

    private void refreshReadOnlyFields() {
        this.updateQbwId();
        CismetThreadPool.execute((Runnable)new Thread(new Runnable(){

            @Override
            public void run() {
                QuerbauwerkeEditor.this.updateWaKoerper();
            }
        }));
    }

    public static boolean showFishPanel(CidsBean cidsBean) {
        return true;
    }

    private synchronized void updateWaKoerper() {
        block12: {
            MetaClass mcWkFg = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_fg");
            MetaClass mcWkFgTeile = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_fg_teile");
            MetaClass mcWkTeil = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_teil");
            MetaClass mcLine = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"station_linie");
            MetaClass mcStation = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"station");
            MetaClass mcRoute = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"route");
            MetaClass mcWkSg = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_sg");
            MetaClass mcQuerbauwerke = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"querbauwerke");
            MetaClass mcGeom = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"geom");
            String queryWkFg = "";
            String queryWkSg = "";
            int id = (Integer)this.cidsBean.getProperty("id");
            CidsBean stat09 = (CidsBean)this.cidsBean.getProperty("stat09");
            if (stat09 != null) {
                double wert = (Double)stat09.getProperty("wert");
                CidsBean route = (CidsBean)stat09.getProperty("route");
                long gwk = (Long)route.getProperty("gwk");
                queryWkFg = "SELECT    " + mcWkFg.getID() + ",    wk_fg." + mcWkFg.getPrimaryKey() + " FROM    " + mcWkFg.getTableName() + " AS wk_fg,    " + mcWkFgTeile.getTableName() + " AS wk_fg_teile,    " + mcWkTeil.getTableName() + " AS wk_teil,    " + mcLine.getTableName() + " AS linie,    " + mcStation.getTableName() + " AS von,    " + mcStation.getTableName() + " AS bis,    " + mcRoute.getTableName() + " AS route WHERE not (wk_fg.wk_k ilike 'gel\u00f6scht%') and   wk_fg.teile = wk_fg_teile.wk_fg_reference AND    wk_fg_teile.teil = wk_teil.id AND    wk_teil.linie = linie." + "id" + " AND    linie." + "von" + " = von." + "id" + " AND    linie." + "bis" + " = bis." + "id" + " AND    von.route = route." + "id" + " AND    route." + "gwk" + " = " + Long.toString(gwk) + " AND (       (von." + "wert" + " <= " + Double.toString(wert) + " AND bis." + "wert" + " >= " + Double.toString(wert) + ") OR       (bis." + "wert" + " <= " + Double.toString(wert) + " AND von." + "wert" + " >= " + Double.toString(wert) + ")    ) ;";
            }
            try {
                MetaObject[] mosWkFg;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("queryWkFg  => " + queryWkFg));
                }
                if ((mosWkFg = SessionManager.getProxy().getMetaObjectByQuery(queryWkFg, 0)) != null && mosWkFg.length > 0) {
                    MetaObject moWkFg = mosWkFg[0];
                    String wkK = (String)moWkFg.getAttributeByFieldName("wk_k").getValue();
                    this.querbauwerkePanTwo.setWaKoerper(wkK);
                    this.querbauwerkePanTwo.setMoWk(moWkFg);
                    this.querbauwerkePanTwo.setKategorie(QuerbauwerkePanTwo.Kategorie.Fliessgewaesser);
                } else if (stat09 != null) {
                    MetaObject[] mosWkSg;
                    queryWkSg = "SELECT    " + mcWkSg.getID() + ",    wk_sg." + mcWkSg.getPrimaryKey() + " FROM    " + mcWkSg.getTableName() + " AS wk_sg,    " + mcGeom.getTableName() + " AS geom_sg,    (       SELECT          querbauwerke.id AS id,          station_von.wert AS wert,          route.gwk AS gwk,          st_linesubstring(             geom_route.geo_field,             (case when station_von.wert < station_bis.wert then station_von.wert else station_bis.wert end ) / st_length(geom_route.geo_field),             (case when station_von.wert < station_bis.wert then station_bis.wert else station_von.wert end ) / st_length(geom_route.geo_field)          ) AS geom       FROM          " + mcQuerbauwerke.getTableName() + " AS querbauwerke,          " + mcStation.getTableName() + " AS station_von,          " + mcStation.getTableName() + " AS station_bis,          " + mcRoute.getTableName() + " AS route,          " + mcGeom.getTableName() + " AS geom_route       WHERE          querbauwerke.stat09 = station_von.id AND          querbauwerke.stat09_bis = station_bis.id AND          station_von.route = route.id AND          route.geom = geom_route.id    ) AS qbw,    (       SELECT          querbauwerke.id AS id,          ST_Extent(geom_route.geo_field) AS geom       FROM          " + mcQuerbauwerke.getTableName() + " AS querbauwerke,          " + mcStation.getTableName() + " AS station_von,          " + mcRoute.getTableName() + " AS route,          " + mcGeom.getTableName() + " AS geom_route       WHERE          querbauwerke.stat09 = station_von.id AND          station_von.route = route.id AND          route.geom = geom_route.id       GROUP BY querbauwerke.id    ) AS qbw_ext WHERE    qbw.id = " + id + " AND    wk_sg.geom = geom_sg.id AND    qbw.id = qbw_ext.id AND    geom_sg.geo_field && qbw_ext.geom AND    ST_Intersects(       geom_sg.geo_field,       qbw.geom    ) ;";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("queryWkSg  => " + queryWkSg));
                    }
                    if ((mosWkSg = SessionManager.getProxy().getMetaObjectByQuery(queryWkSg, 0)) != null && mosWkSg.length > 0) {
                        MetaObject moWkSg = mosWkSg[0];
                        String wkK = (String)moWkSg.getAttributeByFieldName("wk_k").getValue();
                        this.querbauwerkePanTwo.setWaKoerper(wkK);
                        this.querbauwerkePanTwo.setMoWk(moWkSg);
                        this.querbauwerkePanTwo.setKategorie(QuerbauwerkePanTwo.Kategorie.Standgewaesser);
                    } else {
                        this.querbauwerkePanTwo.setWaKoerper(null);
                        this.querbauwerkePanTwo.setMoWk(null);
                        this.querbauwerkePanTwo.setKategorie(null);
                    }
                }
            }
            catch (ConnectionException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"error while fetching metaobject", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block12;
                LOG.debug((Object)"error while autosetting wa_koerper", (Throwable)ex);
            }
        }
    }

    private void updateQbwId() {
        block4: {
            try {
                CidsBean stat09 = (CidsBean)this.cidsBean.getProperty("stat09");
                if (stat09 != null) {
                    String wert = new DecimalFormat("#.#").format((Double)stat09.getProperty("wert"));
                    CidsBean route = (CidsBean)stat09.getProperty("route");
                    String gwk = String.valueOf(route.getProperty("gwk"));
                    this.querbauwerkePanOne.setQbwLage(gwk + "@" + wert);
                } else {
                    this.querbauwerkePanOne.setQbwLage("");
                }
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.error((Object)"error while auto-setting qbw_id", (Throwable)ex);
            }
        }
    }

    public void dispose() {
        this.querbauwerkePanOne.dispose();
        this.querbauwerkePanTwo.dispose();
        this.querbauwerkePanThree.dispose();
        this.querbauwerkePanFour.dispose();
        this.querbauwerkePanFive.dispose();
        if (this.querbauwerkePanSix != null) {
            this.querbauwerkePanSix.dispose();
        }
        this.querbauwerkePanSeven1.dispose();
        if (this.cidsBean != null) {
            this.cidsBean.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public String getTitle() {
        return String.valueOf(this.cidsBean);
    }

    public void setTitle(String title) {
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        if (this.cidsBean != null) {
            try {
                this.cidsBean.setProperty("av_user", (Object)SessionManager.getSession().getUser().toString());
                this.cidsBean.setProperty("av_time", (Object)new Timestamp(System.currentTimeMillis()));
                String zweck = (String)this.cidsBean.getProperty("zweck.value");
                if (zweck != null && zweck.equals("9")) {
                    if (this.cidsBean.getProperty("baujahr") == null) {
                        JOptionPane.showMessageDialog(this, NbBundle.getMessage(QuerbauwerkeEditor.class, (String)"QuerbauwerkeEditor.prepareForSave.baujahr.message"), NbBundle.getMessage(QuerbauwerkeEditor.class, (String)"QuerbauwerkeEditor.prepareForSave.baujahr.title"), 0);
                        return false;
                    }
                    if (this.cidsBean.getProperty("opt_jahr") == null) {
                        JOptionPane.showMessageDialog(this, NbBundle.getMessage(QuerbauwerkeEditor.class, (String)"QuerbauwerkeEditor.prepareForSave.opt_jahr.message"), NbBundle.getMessage(QuerbauwerkeEditor.class, (String)"QuerbauwerkeEditor.prepareForSave.opt_jahr.title"), 0);
                        return false;
                    }
                    if (this.cidsBean.getProperty("faa_typ") == null) {
                        JOptionPane.showMessageDialog(this, NbBundle.getMessage(QuerbauwerkeEditor.class, (String)"QuerbauwerkeEditor.prepareForSave.faa_typ.message"), NbBundle.getMessage(QuerbauwerkeEditor.class, (String)"QuerbauwerkeEditor.prepareForSave.faa_typ.title"), 0);
                        return false;
                    }
                }
                return CidsBeanSupport.checkOptionalAttribute(this.cidsBean, this, null);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        new WrrlEditorTester("Querbauwerke", QuerbauwerkeEditor.class, "WRRL_DB_MV").run();
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    public BeanInitializer getBeanInitializer() {
        return new DefaultBeanInitializer(this.cidsBean){
            private final String[] IGNORED_SIMPLE_TYPES;
            {
                this.IGNORED_SIMPLE_TYPES = new String[]{"av_user", "av_date", "anlagename", "massn_id", "zurueckgebaut", "foto", "starr_ander", "wehr_andere", "info_quel", "sqa_id", "bemerk_alt", "hb", "b_index1", "b_unio", "b_rhithral", "vorrang", "qbw_anz3a", "up_bem", "endkontr", "unz_oberh", "b_aal", "b_stoer", "b_fna", "b_lachs", "b_mai", "b_mf", "b_mna", "b_schnaep", "b_stint_w", "b_bf", "b_bna", "b_elritze", "b_groppe", "b_quappe", "b_rapfen", "b_stint_b", "b_wels", "b_zaehrte", "b_zope", "zuord_faa"};
                Arrays.sort(this.IGNORED_SIMPLE_TYPES);
            }

            protected void processSimpleProperty(CidsBean beanToInit, String propertyName, Object simpleValueToProcess) throws Exception {
                if (Arrays.binarySearch(this.IGNORED_SIMPLE_TYPES, propertyName) >= 0) {
                    return;
                }
                super.processSimpleProperty(beanToInit, propertyName, simpleValueToProcess);
            }

            protected void processArrayProperty(CidsBean beanToInit, String propertyName, Collection<CidsBean> arrayValueToProcess) throws Exception {
                List<CidsBean> beans = CidsBeanSupport.getBeanCollectionFromProperty(beanToInit, propertyName);
                beans.clear();
                for (CidsBean tmp : arrayValueToProcess) {
                    beans.add(tmp);
                }
            }

            protected void processComplexProperty(CidsBean beanToInit, String propertyName, CidsBean complexValueToProcess) throws Exception {
                if (propertyName.equals("stat09") || propertyName.equals("stat09_bis") || propertyName.equals("massn_ref") || propertyName.equals("massn1") || propertyName.equals("massn2") || propertyName.equals("massn3") || propertyName.equalsIgnoreCase("foto_richtung") || propertyName.equals("starr") || propertyName.equalsIgnoreCase("wehr_1") || propertyName.equalsIgnoreCase("wehr_2") || propertyName.equalsIgnoreCase("oeko_dgk") || propertyName.equalsIgnoreCase("dgk_warum")) {
                    return;
                }
                beanToInit.setProperty(propertyName, (Object)complexValueToProcess);
            }
        };
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("stat09")) {
            this.refreshReadOnlyFields();
        }
    }

    private void loadRelatedQbw(CidsBean qbwBean) {
        String up_agg_id = (String)qbwBean.getProperty("up_agg_id");
        if (up_agg_id != null) {
            try {
                MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"querbauwerke");
                String query = "select " + MC.getID() + ", q." + MC.getPrimaryKey() + " from " + MC.getTableName();
                query = query + " q WHERE q.qbw_id_u = '" + up_agg_id + "'";
                MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
                ArrayList<MetaObjectNode> qbwNodeList = new ArrayList<MetaObjectNode>();
                if (metaObjects != null) {
                    for (MetaObject qbwMetaObject : metaObjects) {
                        qbwNodeList.add(new MetaObjectNode(qbwMetaObject.getBean()));
                    }
                    MethodManager.getManager().showSearchResults(null, qbwNodeList.toArray(new Node[qbwNodeList.size()]), false);
                    MethodManager.getManager().showSearchResults();
                }
            }
            catch (ConnectionException e) {
                LOG.error((Object)"Error while trying to receive qbws.", (Throwable)e);
            }
        }
    }

    private class DropPanel
    extends JPanel
    implements CidsBeanDropListener {
        private DropPanel() {
        }

        public void beansDropped(ArrayList<CidsBean> al) {
            if (al.size() == 1) {
                CidsBean qbwBean = al.get(0);
                QuerbauwerkeEditor.this.loadRelatedQbw(qbwBean);
            }
        }
    }
}

