/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.wrrl_db_mv.fgsksimulation.FgskSimCalc;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.RendererTools;
import de.cismet.cids.custom.wrrl_db_mv.util.ScrollableComboBox;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.VerticalTextIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.openide.util.NbBundle;

public class SimMassnahmeEditor
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener {
    private static final Logger LOG = Logger.getLogger(SimMassnahmeEditor.class);
    private static final String[] columnNames = new String[]{"Typ", "Wirkungsklasse", "Kostenklasse", "Wirkung FGSK", "Wirkung Biologie", "Fische", "Makrozoobenthos", "Makrophyten", "Laufkr\u00fcmmung", "Anzahl L\u00e4ngsb\u00e4nke", "Anzahl Laufstrukturen", "Kr\u00fcmmungserosion", "Anzahl Querb\u00e4nke", "Str\u00f6mungsdiversit\u00e4t", "Tiefenvarianz", "Substratdiversit\u00e4t", "Sohlverbau", "Anzahl Sohlstrukturen", "Sohltiefe", "Breitenerosion", "Breitenvarianz", "Profiltyp", "Uferverbau", "Anzahl Uferstrukturen", "Uferbewuchs", "Gew\u00e4sserrandstreifen", "Fl\u00e4chennutzung", "so. Umfeldstrukturen"};
    private static final Map<String, String> tooltips = new HashMap<String, String>();
    private static final MetaClass LAWA_TYPE = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"la_lawa_nr");
    private static final MetaClass WIRKUNG = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"sim_wirkungsklasse");
    private static final MetaClass KOSTEN = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"sim_kostenklasse");
    private String title;
    private CidsBean cidsBean;
    private boolean readOnly;
    private JComboBox lawaCombo = new ScrollableComboBox(LAWA_TYPE);
    private JComboBox wirkungCombo = new ScrollableComboBox(WIRKUNG);
    private JComboBox kostenCombo = new ScrollableComboBox(KOSTEN);
    private CustomTableModel model;
    private JCheckBox cbFl;
    private DefaultBindableReferenceCombo cbRestriktion;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane3;
    private JButton jbAdd;
    private JButton jbRemove;
    private JScrollPane jsTable;
    private JLabel lblBemerkung;
    private JLabel lblBerechnung;
    private JLabel lblHeading;
    private JLabel lblHeading1;
    private JLabel lblHilfe;
    private JLabel lblKurzbez;
    private JLabel lblMNT;
    private JLabel lblMNT1;
    private JLabel lblMNT2;
    private JLabel lblName;
    private JLabel lblOrt;
    private JLabel lblPreis;
    private RoundedPanel panAuswirkungen;
    private JPanel panButtons;
    private SemiRoundedPanel panHeadInfo;
    private SemiRoundedPanel panHeadInfo1;
    private JPanel panInfoContent;
    private JPanel panInfoContent1;
    private RoundedPanel panKosten;
    private JTextArea taBemerkung;
    private JTextArea taBerechnung;
    private JTextArea taHilfe;
    private JTextArea taPreis;
    private JTable tabWirkung;
    private JTextField txtKurzbez;
    private JTextField txtMnt;
    private JTextField txtMnt1;
    private JTextField txtName;
    private BindingGroup bindingGroup;

    public SimMassnahmeEditor() {
        this(false);
    }

    public SimMassnahmeEditor(boolean readOnly) {
        this.initComponents();
        RendererTools.makeReadOnly(this.taHilfe);
        this.jSplitPane1.setOpaque(false);
        this.jSplitPane2.setOpaque(false);
        this.jSplitPane3.setOpaque(false);
        this.jSplitPane1.setBorder(null);
        this.jSplitPane2.setBorder(null);
        this.jSplitPane3.setBorder(null);
        if (readOnly) {
            RendererTools.makeReadOnly((JComboBox)this.cbRestriktion);
            RendererTools.makeReadOnly(this.taBemerkung);
            RendererTools.makeReadOnly(this.taPreis);
            RendererTools.makeReadOnly(this.taBerechnung);
            RendererTools.makeReadOnly(this.txtKurzbez);
            RendererTools.makeReadOnly(this.txtMnt);
            RendererTools.makeReadOnly(this.txtName);
            RendererTools.makeReadOnly(this.cbFl);
            this.panButtons.setVisible(false);
        }
        for (int i = 0; i < columnNames.length; ++i) {
            if (i == 3) {
                tooltips.put(columnNames[i], "Summe Wirkung FGSK");
                continue;
            }
            if (i == 4) {
                tooltips.put(columnNames[i], "Summe Wirkung Biologie");
                continue;
            }
            if (i == 9) {
                tooltips.put(columnNames[i], "Anzahl der L\u00e4ngsb\u00e4nke mit vorherrschenden Substraten");
                continue;
            }
            if (i == 10) {
                tooltips.put(columnNames[i], "Anzahl besonderer Laufstrukturen");
                continue;
            }
            if (i == 12) {
                tooltips.put(columnNames[i], "Anzahl der Querb\u00e4nke mit den vorherrschenden Substraten");
                continue;
            }
            if (i == 18) {
                tooltips.put(columnNames[i], "Anzahl besonderer Sohlstrukturen");
                continue;
            }
            if (i == 19) {
                tooltips.put(columnNames[i], "Sohltiefe / obere Profilbreite");
                continue;
            }
            if (i == 24) {
                tooltips.put(columnNames[i], "Anzahl besonderer Uferstrukturen");
                continue;
            }
            if (i == 27) {
                tooltips.put(columnNames[i], "sonstige Umfeldstrukturen");
                continue;
            }
            tooltips.put(columnNames[i], columnNames[i]);
        }
        this.tabWirkung.getTableHeader().setDefaultRenderer(new CustomTableHeaderCellRenderer(this.tabWirkung.getTableHeader().getDefaultRenderer()));
        this.tabWirkung.getTableHeader().setPreferredSize(new Dimension(25, 150));
        this.lawaCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text = "";
                if (value != null) {
                    text = "Typ " + ((CidsBean)value).getProperty("code");
                }
                return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
            }
        });
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jPanel1 = new JPanel();
        this.lblKurzbez = new JLabel();
        this.lblName = new JLabel();
        this.txtKurzbez = new JTextField();
        this.txtName = new JTextField();
        this.txtMnt = new JTextField();
        this.lblOrt = new JLabel();
        this.lblBemerkung = new JLabel();
        this.cbRestriktion = new ScrollableComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.taBemerkung = new JTextArea();
        this.lblMNT = new JLabel();
        this.lblMNT1 = new JLabel();
        this.cbFl = new JCheckBox();
        this.lblMNT2 = new JLabel();
        this.txtMnt1 = new JTextField();
        this.jSplitPane3 = new JSplitPane();
        this.panKosten = new RoundedPanel();
        this.panHeadInfo = new SemiRoundedPanel();
        this.lblHeading = new JLabel();
        this.panInfoContent = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.lblPreis = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.taPreis = new JTextArea();
        this.jPanel3 = new JPanel();
        this.lblBerechnung = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.taBerechnung = new JTextArea();
        this.jPanel4 = new JPanel();
        this.lblHilfe = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.taHilfe = new JTextArea();
        this.panAuswirkungen = new RoundedPanel();
        this.panHeadInfo1 = new SemiRoundedPanel();
        this.lblHeading1 = new JLabel();
        this.panInfoContent1 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jsTable = new JScrollPane();
        this.tabWirkung = new JTable();
        this.panButtons = new JPanel();
        this.jbAdd = new JButton();
        this.jbRemove = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblKurzbez.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.lblKurzbez.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 10, 5, 5);
        this.jPanel1.add((Component)this.lblKurzbez, gridBagConstraints);
        this.lblName.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.lblName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.jPanel1.add((Component)this.lblName, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.key}"), (Object)this.txtKurzbez, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 5);
        this.jPanel1.add((Component)this.txtKurzbez, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtName, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.jPanel1.add((Component)this.txtName, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.mnt}"), (Object)this.txtMnt, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.jPanel1.add((Component)this.txtMnt, gridBagConstraints);
        this.lblOrt.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.lblOrt.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 20, 5, 5);
        this.jPanel1.add((Component)this.lblOrt, gridBagConstraints);
        this.lblBemerkung.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.lblBemerkung.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.jPanel1.add((Component)this.lblBemerkung, gridBagConstraints);
        this.cbRestriktion.setMinimumSize(new Dimension(120, 20));
        this.cbRestriktion.setPreferredSize(new Dimension(80, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.ort}"), (Object)this.cbRestriktion, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 5);
        this.jPanel1.add((Component)this.cbRestriktion, gridBagConstraints);
        this.taBemerkung.setColumns(20);
        this.taBemerkung.setRows(3);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bemerkung}"), (Object)this.taBemerkung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jScrollPane1.setViewportView(this.taBemerkung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblMNT.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.lblMNT.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.jPanel1.add((Component)this.lblMNT, gridBagConstraints);
        this.lblMNT1.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.lblMNT1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.jPanel1.add((Component)this.lblMNT1, gridBagConstraints);
        this.cbFl.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.cbFl.text", (Object[])new Object[0]));
        this.cbFl.setContentAreaFilled(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.flaechenbedarf}"), (Object)this.cbFl, (Property)BeanProperty.create((String)"selected"));
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        this.cbFl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimMassnahmeEditor.this.cbFlActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.jPanel1.add((Component)this.cbFl, gridBagConstraints);
        this.lblMNT2.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.lblMNT2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.jPanel1.add((Component)this.lblMNT2, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fix_gk}"), (Object)this.txtMnt1, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue(null);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.jPanel1.add((Component)this.txtMnt1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jSplitPane3.setOrientation(0);
        this.panKosten.setMinimumSize(new Dimension(880, 200));
        this.panKosten.setPreferredSize(new Dimension(880, 300));
        this.panHeadInfo.setBackground(new Color(51, 51, 51));
        this.panHeadInfo.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading.setForeground(new Color(255, 255, 255));
        this.lblHeading.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.lblHeading.text"));
        this.panHeadInfo.add((Component)this.lblHeading);
        this.panKosten.add((Component)this.panHeadInfo, (Object)"North");
        this.panInfoContent.setOpaque(false);
        this.panInfoContent.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(600);
        this.jSplitPane2.setDividerLocation(297);
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.lblPreis.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.lblPreis.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblPreis, gridBagConstraints);
        this.taPreis.setColumns(10);
        this.taPreis.setRows(5);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.kosten}"), (Object)this.taPreis, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jScrollPane2.setViewportView(this.taPreis);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jSplitPane2.setLeftComponent(this.jPanel2);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridBagLayout());
        this.lblBerechnung.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.lblBerechnung.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.lblBerechnung, gridBagConstraints);
        this.taBerechnung.setColumns(10);
        this.taBerechnung.setRows(5);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.kostenformel}"), (Object)this.taBerechnung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jScrollPane3.setViewportView(this.taBerechnung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel3.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jSplitPane2.setRightComponent(this.jPanel3);
        this.jSplitPane1.setLeftComponent(this.jSplitPane2);
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new GridBagLayout());
        this.lblHilfe.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.lblHilfe.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.lblHilfe, gridBagConstraints);
        this.taHilfe.setEditable(false);
        this.taHilfe.setColumns(10);
        this.taHilfe.setRows(5);
        this.taHilfe.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.taHilfe.text"));
        this.jScrollPane4.setViewportView(this.taHilfe);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panInfoContent.add((Component)this.jSplitPane1, gridBagConstraints);
        this.panKosten.add((Component)this.panInfoContent, (Object)"Center");
        this.jSplitPane3.setLeftComponent((Component)this.panKosten);
        this.panAuswirkungen.setMinimumSize(new Dimension(880, 200));
        this.panAuswirkungen.setPreferredSize(new Dimension(880, 300));
        this.panHeadInfo1.setBackground(new Color(51, 51, 51));
        this.panHeadInfo1.setMinimumSize(new Dimension(209, 24));
        this.panHeadInfo1.setPreferredSize(new Dimension(209, 24));
        this.panHeadInfo1.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading1.setForeground(new Color(255, 255, 255));
        this.lblHeading1.setText(NbBundle.getMessage(SimMassnahmeEditor.class, (String)"SimMassnahmeEditor.lblHeading1.text"));
        this.panHeadInfo1.add((Component)this.lblHeading1);
        this.panAuswirkungen.add((Component)this.panHeadInfo1, (Object)"North");
        this.panInfoContent1.setOpaque(false);
        this.panInfoContent1.setLayout(new GridBagLayout());
        this.jPanel8.setOpaque(false);
        this.jPanel8.setLayout(new GridBagLayout());
        this.jsTable.setViewportView(this.tabWirkung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 15, 10, 15);
        this.jPanel8.add((Component)this.jsTable, gridBagConstraints);
        this.panButtons.setOpaque(false);
        this.panButtons.setLayout(new GridBagLayout());
        this.jbAdd.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_add_16.png")));
        this.jbAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimMassnahmeEditor.this.jbAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 0, 15, 10);
        this.panButtons.add((Component)this.jbAdd, gridBagConstraints);
        this.jbRemove.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_remove_16.png")));
        this.jbRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimMassnahmeEditor.this.jbRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(15, 0, 15, 10);
        this.panButtons.add((Component)this.jbRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel8.add((Component)this.panButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panInfoContent1.add((Component)this.jPanel8, gridBagConstraints);
        this.panAuswirkungen.add((Component)this.panInfoContent1, (Object)"Center");
        this.jSplitPane3.setRightComponent((Component)this.panAuswirkungen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.add((Component)this.jSplitPane3, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void jbAddActionPerformed(ActionEvent evt) {
        try {
            CidsBean bean = CidsBeanSupport.createNewCidsBeanFromTableName("sim_massnahmen_wirkung");
            this.model.addBean(bean);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating a new bean of type sim_massnahmen_wirkung", (Throwable)e);
        }
    }

    private void jbRemoveActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.tabWirkung.getSelectedRows();
        Arrays.sort(selectedRows);
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.model.removeRow(selectedRows[i]);
        }
    }

    private void cbFlActionPerformed(ActionEvent evt) {
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cidsBean = cidsBean;
        this.bindingGroup.unbind();
        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean);
            this.bindingGroup.bind();
            this.model = new CustomTableModel(cidsBean.getBeanCollectionProperty("wirkungen"));
            this.tabWirkung.setModel(this.model);
            this.tabWirkung.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)new ComboBoxCellEditor(this.lawaCombo));
            this.tabWirkung.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)new ComboBoxCellEditor(this.wirkungCombo));
            this.tabWirkung.getColumnModel().getColumn(2).setCellEditor((TableCellEditor)new ComboBoxCellEditor(this.kostenCombo));
            this.tabWirkung.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    String text = "";
                    if (value != null) {
                        text = "Typ " + ((CidsBean)value).getProperty("code");
                    }
                    return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
                }
            });
            this.setTableSize();
        }
    }

    private void setTableSize() {
        TableColumnModel columnModel = this.tabWirkung.getColumnModel();
        FontMetrics fmetrics = this.tabWirkung.getFontMetrics(this.tabWirkung.getFont());
        TableModel model = this.tabWirkung.getModel();
        int columnCount = model.getColumnCount();
        boolean totalSize = false;
        for (int i = 2; i < columnCount; ++i) {
            int size = 25;
            columnModel.getColumn(i).setMinWidth(25);
            columnModel.getColumn(i).setWidth(25);
            columnModel.getColumn(i).setPreferredWidth(25);
        }
        this.tabWirkung.setMinimumSize(new Dimension(20, 50));
    }

    public void dispose() {
    }

    public String getTitle() {
        if (this.cidsBean != null) {
            return this.cidsBean.toString() == null || this.cidsBean.toString().equals("") || this.cidsBean.toString().equals("null") ? "unbenannt" : this.cidsBean.toString();
        }
        return "unbenannt";
    }

    public void setTitle(String title) {
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        return true;
    }

    public static void main(String[] args) throws Exception {
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost((String)"WRRL_DB_MV", (String)"Administratoren", (String)"admin", (String)"kif", (String)"sim_massnahme", (int)241, (int)1280, (int)1024);
    }

    private class CustomTableHeaderCellRenderer
    extends JLabel
    implements TableCellRenderer {
        TableCellRenderer renderer = new DefaultTableCellRenderer();

        public CustomTableHeaderCellRenderer(TableCellRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            VerticalTextIcon icon = new VerticalTextIcon(String.valueOf(value), false);
            Component c = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setText(null);
            this.setIcon((Icon)icon);
            this.setHorizontalAlignment(0);
            this.setToolTipText((String)tooltips.get((String)value));
            this.setBorder(MetalBorders.getTextBorder());
            return this;
        }
    }

    private class CustomTableModel
    implements TableModel {
        List<CidsBean> beans;
        List<TableModelListener> listener = new ArrayList<TableModelListener>();
        private final String[] columnProperties = new String[]{"gewaessertyp", "wirkungsklasse", "kostenklasse", "summe_wirkung_fgsk", "summe_wirkung_biologie", "fische", "makrozoobenthos", "makrophyten", "laufkruemmung", "anzahl_laengsbaenken_mvs", "anzahl_besonderer_laufstrukturen", "kruemmungserosion", "anzahl_querbaenke_mvs", "stroemungsdiversitaet", "tiefenvarianz", "substratdiversitaet", "sohlverbau", "anzahl_besonderer_sohlstrukturen", "sohltiefe_obere_profilbreite", "breitenerosion", "breitenvarianz", "profiltyp", "uferverbau", "anzahl_besonderer_uferstrukturen", "uferbewuchs", "gewaesserrandstreifen", "flaechennutzung", "sonstige_umfeldstrukturen"};

        public CustomTableModel(List<CidsBean> beans) {
            this.beans = beans;
        }

        @Override
        public int getRowCount() {
            return this.beans.size();
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnNames[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex <= 2) {
                return CidsBean.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (SimMassnahmeEditor.this.readOnly) {
                return false;
            }
            if (columnIndex == 3 || columnIndex == 4) {
                return false;
            }
            return !SimMassnahmeEditor.this.readOnly;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.beans.get(rowIndex).getProperty("gewaessertyp");
            }
            if (columnIndex == 3) {
                return FgskSimCalc.getInstance().calcFgskSum(this.beans.get(rowIndex));
            }
            if (columnIndex == 4) {
                return FgskSimCalc.getInstance().calcBioSum(this.beans.get(rowIndex));
            }
            return this.beans.get(rowIndex).getProperty(this.columnProperties[columnIndex]);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (SimMassnahmeEditor.this.readOnly) {
                return;
            }
            if (columnIndex <= 2) {
                try {
                    this.beans.get(rowIndex).setProperty(this.columnProperties[columnIndex], aValue);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while set value.", (Throwable)e);
                }
            } else {
                try {
                    this.beans.get(rowIndex).setProperty(this.columnProperties[columnIndex], (Object)Integer.parseInt((String)aValue));
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(SimMassnahmeEditor.this, "Es sind nur ganze Zahlen zul\u00e4ssig.", "Ung\u00fcltige Eingabe", 0);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while set value.", (Throwable)e);
                }
            }
        }

        public void addBean(CidsBean bean) {
            this.beans.add(bean);
            this.fireTableChangedEvent();
        }

        public void removeBean(CidsBean bean) {
            try {
                this.beans.remove(bean);
                bean.delete();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while deleting bean of type sim_massnahmen_wirkung", (Throwable)e);
            }
            this.fireTableChangedEvent();
        }

        public void removeRow(int row) {
            this.removeBean(this.beans.get(row));
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listener.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listener.remove(l);
        }

        public void fireTableChangedEvent() {
            TableModelEvent e = new TableModelEvent(this);
            for (TableModelListener l : this.listener) {
                l.tableChanged(e);
            }
        }
    }
}

