/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.Navigator;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.plugin.PluginDescriptor;
import Sirius.navigator.plugin.PluginRegistry;
import Sirius.navigator.plugin.PluginUIDescriptor;
import Sirius.navigator.types.treenode.DefaultMetaTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.LayoutedContainer;
import Sirius.navigator.ui.MutableConstraints;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.SimSimulationsabschnittEditor;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.Calc;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.FgskSimulationHelper;
import de.cismet.cids.custom.wrrl_db_mv.fgsksimulation.FgskSimCalc;
import de.cismet.cids.custom.wrrl_db_mv.server.search.AllObjectsSearch;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.ComparableCidsBean;
import de.cismet.cids.custom.wrrl_db_mv.util.ReadOnlyFgskBand;
import de.cismet.cids.custom.wrrl_db_mv.util.ReadOnlyFgskBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.RendererTools;
import de.cismet.cids.custom.wrrl_db_mv.util.WrrlMapOptionsPanel;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.WKBand;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingHelper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CismapPlugin;
import de.cismet.commons.concurrency.CismetConcurrency;
import de.cismet.tools.CalculationCache;
import de.cismet.tools.Calculator;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.TitleComponentProvider;
import de.cismet.tools.gui.jbands.BandModelEvent;
import de.cismet.tools.gui.jbands.JBand;
import de.cismet.tools.gui.jbands.SimpleBandModel;
import de.cismet.tools.gui.jbands.interfaces.Band;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandMemberSelectable;
import de.cismet.tools.gui.jbands.interfaces.BandModel;
import de.cismet.tools.gui.jbands.interfaces.BandModelListener;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SimulationEditor
extends JPanel
implements CidsBeanRenderer,
FooterComponentProvider,
TitleComponentProvider,
EditorSaveListener,
SimSimulationsabschnittEditor.SimulationResultChangedListener {
    private static final String WK_FG_CLASS_NAME = "de.cismet.cids.dynamics.Wk_fg";
    private static final Logger LOG = Logger.getLogger(SimulationEditor.class);
    private static final MetaClass MC_WK_FG = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_fg");
    private static final MetaClass MC_MASSNAHMEN = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"massnahmen");
    private static final MetaClass MC_FGSK = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"fgsk_kartierabschnitt");
    private static final MetaClass MC_SIM_FLAECEHNERWERBSPREIS = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"sim_flaechenerwerbspreis");
    private static final CalculationCache<List, MetaObject[]> FGSK_CACHE = new CalculationCache((Calculator)new FgskCalculator());
    private static final CalculationCache<List, MetaObject[]> WK_FG_CACHE = new CalculationCache((Calculator)new WkfgCalculator());
    private static final CalculationCache<List, MetaObject[]> MASSNAHMEN_CACHE = new CalculationCache((Calculator)new MassnBvpCalculator());
    public static final CalculationCache<String, List<MetaObject>> FL_COSTS_CACHE = new CalculationCache((Calculator)new FlCostsCalculator());
    private static final String HOME = System.getProperty("user.home");
    private static final String FS = System.getProperty("file.separator");
    private static final String CISMAP_BACKUP_LAYOUT = HOME + FS + ".cismap" + FS + "backup.layout";
    private static final String NAVIGATOR_BACKUP_LAYOUT = Navigator.NAVIGATOR_HOME + "navigatorBackup.layout";
    private static boolean layoutRestored = true;
    private boolean warningAlreadyShown = false;
    private ReadOnlyFgskBand[] fgskBands;
    private WKBand wkband;
    private JBand[] jband;
    private BandModelListener[] modelListener;
    private SimpleBandModel[] sbm;
    private CidsBean cidsBean;
    private SimSimulationsabschnittEditor simulationsEditor;
    private boolean initialReadOnly = false;
    private boolean readOnly = false;
    private boolean isNew = false;
    private CidsBean wkFg;
    private MetaObject[] fgsks;
    private boolean cancel = false;
    private boolean namePrompt = false;
    private boolean selectionChangedHandlingInProgress = false;
    private boolean wkMassnListChangedByUser = false;
    private ButtonGroup bgZiel;
    private ButtonGroup bgrpDetails;
    private JButton butCancel;
    private JButton butOK;
    private JCheckBox cbKostenFix;
    private JDialog diaName;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JMenu jMenu1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane5;
    private JButton jbRem;
    private JList jlMultiSimList;
    private JList jlWKMassnList;
    private JLabel labInfo;
    private JLabel labMassnProp;
    private JLabel labMultiSim;
    private JLabel lblBemerkungen;
    private JLabel lblBemerkungen1;
    private JLabel lblCosts4;
    private JLabel lblFlCosts;
    private JLabel lblFlKosten;
    private JLabel lblFoot;
    private JLabel lblHeading;
    private JLabel lblHeading1;
    private JLabel lblKostenGes4;
    private JLabel lblMaCosts;
    private JLabel lblMaKosten;
    private JLabel lblMarker1;
    private JLabel lblMarker2;
    private JLabel lblMarker3;
    private JLabel lblMarker4;
    private JLabel lblMarker5;
    private JLabel lblName;
    private JLabel lblNeCosts;
    private JLabel lblNeKosten;
    private JLabel lblNeu;
    private JLabel lblSoCosts;
    private JLabel lblSoKosten;
    private JLabel lblSubTitle1;
    private JLabel lblTitle;
    private JLabel lblTitleName;
    private JPanel panAllgemein;
    private JPanel panBand;
    private JPanel panClass1;
    private JPanel panClass2;
    private JPanel panClass3;
    private JPanel panClass4;
    private JPanel panClass5;
    private JPanel panClass6;
    private JPanel panEditorPanel;
    private JPanel panEmpty;
    private JPanel panFgsk;
    private JPanel panFooter;
    private SemiRoundedPanel panHeadInfo;
    private SemiRoundedPanel panHeadInfo1;
    private JPanel panHeader;
    private JPanel panHeaderInfo;
    private RoundedPanel panInfo;
    private JPanel panInfoContent;
    private JPanel panInfoContent1;
    private JPanel panLoading;
    private JPanel panMain;
    private JPanel panMorphometer;
    private JPanel panMultiSim;
    private JPanel panNew;
    private JPanel panSim;
    private JPanel panSimCard;
    private JPanel panTitle;
    private JPanel panTotal1;
    private JPanel panVermessung;
    private RoundedPanel panWkInfo;
    private JRadioButton rbOekPot;
    private JRadioButton rbZust;
    private JSlider sldZoom;
    private JTextArea taBemerkungen;
    private JToggleButton togZoomToParts;
    private JTextField txtName;

    public SimulationEditor() {
        this(false);
    }

    public SimulationEditor(boolean readOnly) {
        this.initialReadOnly = readOnly;
        this.readOnly = readOnly;
        this.initComponents();
        this.panHeaderInfo.setVisible(false);
        this.jPanel1.setVisible(false);
        if (!readOnly) {
            new CidsBeanDropTarget((Component)this.panNew);
            new CidsBeanDropTarget((Component)this.jlMultiSimList);
        }
        this.simulationsEditor = new SimSimulationsabschnittEditor(readOnly);
        this.simulationsEditor.hideProposalButton();
        this.simulationsEditor.addSimulationResultChangedListener(this);
        this.switchToForm("empty");
        this.lblHeading.setText("FGSK Abschnitt");
        this.panSim.add((Component)this.simulationsEditor, "Center");
        this.jlMultiSimList.setCellRenderer(new MultiMassnahmenConainerCellRenderer());
        this.sldZoom.setPaintTrack(false);
    }

    private void setReadOnly(boolean readOnly) {
        if (this.readOnly != readOnly) {
            this.readOnly = readOnly;
            this.simulationsEditor.setReadOnly(readOnly);
            if (readOnly) {
                RendererTools.makeReadOnly(this.txtName);
                RendererTools.makeReadOnly(this.taBemerkungen);
                RendererTools.makeReadOnly(this.cbKostenFix);
            } else {
                RendererTools.makeWritable(this.txtName);
                RendererTools.makeWritable(this.taBemerkungen);
                RendererTools.makeWritable(this.cbKostenFix);
            }
        }
    }

    private void addBands() {
        List teile = this.wkFg.getBeanCollectionProperty("teile");
        int teileLength = 0;
        for (CidsBean tmpTeil : teile) {
            if (!this.hasFgsk((Integer)tmpTeil.getProperty("linie.von.route.id"), (Double)tmpTeil.getProperty("linie.von.wert"), (Double)tmpTeil.getProperty("linie.bis.wert"))) continue;
            ++teileLength;
        }
        this.jband = new JBand[teileLength];
        this.sbm = new SimpleBandModel[teileLength];
        this.fgskBands = new ReadOnlyFgskBand[teileLength];
        this.modelListener = new RestriktionBandModelListener[teileLength];
        this.panBand.setLayout(new GridLayout(teileLength, 1));
        int internIndex = 0;
        for (int index = 0; index < teile.size(); ++index) {
            if (!this.hasFgsk((Integer)((CidsBean)teile.get(index)).getProperty("linie.von.route.id"), (Double)((CidsBean)teile.get(index)).getProperty("linie.von.wert"), (Double)((CidsBean)teile.get(index)).getProperty("linie.bis.wert"))) continue;
            this.sbm[internIndex] = new SimpleBandModel();
            String gwk = String.valueOf(((CidsBean)teile.get(index)).getProperty("linie.von.route.gwk"));
            this.fgskBands[internIndex] = new ReadOnlyFgskBand(gwk);
            this.jband[internIndex] = new JBand(true);
            this.jband[internIndex].setSelectionMode(JBand.SelectionMode.MULTIPLE_INTERVAL_SELECTION);
            this.modelListener[internIndex] = new RestriktionBandModelListener(this.jband[internIndex]);
            this.sbm[internIndex].addBand((Band)this.fgskBands[internIndex]);
            this.jband[internIndex].setModel((BandModel)this.sbm[internIndex]);
            this.panBand.add((Component)this.jband[internIndex], "Center");
            this.jband[internIndex].setHorizontalScrollBarPolicy(32);
            this.sbm[internIndex].addBandModelListener(this.modelListener[internIndex]);
            ++internIndex;
        }
    }

    private void switchToForm(final String id) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                StringTokenizer st = new StringTokenizer(id, ">");
                if (st.hasMoreTokens()) {
                    ((CardLayout)SimulationEditor.this.panEditorPanel.getLayout()).show(SimulationEditor.this.panEditorPanel, st.nextToken());
                }
                String secondToken = null;
                if (st.hasMoreTokens()) {
                    secondToken = st.nextToken();
                    ((CardLayout)SimulationEditor.this.panSimCard.getLayout()).show(SimulationEditor.this.panSimCard, secondToken);
                }
                SimulationEditor.this.labMassnProp.setVisible(secondToken != null && secondToken.equals("sim") && !SimulationEditor.this.readOnly);
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cidsBean = cidsBean;
        this.wkFg = null;
        this.switchToForm("empty");
        this.lblHeading.setText("");
        if (cidsBean != null) {
            this.isNew = cidsBean.getProperty("wk_key") == null;
            this.warningAlreadyShown = false;
            if (this.initialReadOnly || cidsBean.getProperty("read_only") != null && ((Boolean)cidsBean.getProperty("read_only")).booleanValue()) {
                this.setReadOnly(true);
            } else {
                this.setReadOnly(false);
            }
            if (this.isNew) {
                ObjectTreeNode node;
                CidsBean tmpBean;
                TreeNode nodeTmp;
                ((CardLayout)this.panMain.getLayout()).show(this.panMain, "band");
                this.panBand.add((Component)this.panNew, "Center");
                this.namePrompt = true;
                try {
                    cidsBean.setProperty("name", (Object)"Variante");
                    this.fillDialog();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while setting the name", (Throwable)e);
                }
                DefaultMetaTreeNode dmtn = ComponentRegistry.getRegistry().getCatalogueTree().getSelectedNode();
                if (dmtn == null) {
                    dmtn = ComponentRegistry.getRegistry().getSearchResultsTree().getSelectedNode();
                }
                if (dmtn != null && (nodeTmp = dmtn.getParent()) != null && nodeTmp instanceof ObjectTreeNode && (tmpBean = (node = (ObjectTreeNode)nodeTmp).getMetaObject().getBean()).getClass().getName().equals(WK_FG_CLASS_NAME)) {
                    this.wkFg = tmpBean;
                    ((CardLayout)this.panMain.getLayout()).show(this.panMain, "band");
                    try {
                        cidsBean.setProperty("wk_key", this.wkFg.getProperty("wk_k"));
                        this.fillDialog();
                        this.setNamesAndBands();
                        this.isNew = false;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"error while setting the wk_key property", (Throwable)e);
                    }
                }
            } else {
                this.lblTitle.setText(this.getTitle());
                this.setName();
                this.fillDialog();
                this.setNamesAndBands();
                this.refreshWkFgMassnList();
            }
        }
        if (!this.initialReadOnly && WrrlMapOptionsPanel.isChangeMapWindowActive()) {
            this.changeLayout();
        }
    }

    private void changeLayout() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (layoutRestored) {
                    try {
                        CismapPlugin cismap = (CismapPlugin)PluginRegistry.getRegistry().getPlugin("cismap");
                        LayoutedContainer container = (LayoutedContainer)ComponentRegistry.getRegistry().getGUIContainer();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("cismap backup file: " + CISMAP_BACKUP_LAYOUT));
                        }
                        cismap.saveLayout(CISMAP_BACKUP_LAYOUT);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("navigator backup file: " + NAVIGATOR_BACKUP_LAYOUT));
                        }
                        container.saveLayout(NAVIGATOR_BACKUP_LAYOUT, (Component)ComponentRegistry.getRegistry().getMainWindow());
                        layoutRestored = false;
                        InputStream is = this.getClass().getClassLoader().getResourceAsStream("de/cismet/cids/custom/objecteditors/wrrl_db_mv/fullscreenmap.layout");
                        cismap.loadLayout(is, false);
                        PluginDescriptor cismapDescriptor = PluginRegistry.getRegistry().getPluginDescriptor("cismap");
                        PluginUIDescriptor uiDescriptor = cismapDescriptor.getUIDescriptor("cismap");
                        container.remove("cismap");
                        uiDescriptor.setPosition("P2");
                        container.add((MutableConstraints)uiDescriptor);
                        ComponentRegistry.getRegistry().showComponent(ComponentRegistry.ATTRIBUTE_EDITOR);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot cahnge the layout.", (Throwable)e);
                    }
                }
            }
        });
    }

    private void restoreLayout() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (new File(CISMAP_BACKUP_LAYOUT).exists()) {
                        CismapPlugin cismap = (CismapPlugin)PluginRegistry.getRegistry().getPlugin("cismap");
                        cismap.loadLayout(CISMAP_BACKUP_LAYOUT, false);
                    }
                    if (new File(NAVIGATOR_BACKUP_LAYOUT).exists()) {
                        LayoutedContainer container = (LayoutedContainer)ComponentRegistry.getRegistry().getGUIContainer();
                        container.loadLayout(NAVIGATOR_BACKUP_LAYOUT, false, (Component)ComponentRegistry.getRegistry().getMainWindow());
                    }
                    layoutRestored = true;
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot cahnge the layout.", (Throwable)e);
                }
            }
        });
    }

    private void refreshWkFgMassnList() {
        TreeSet<ComparableCidsBean> massnSet = new TreeSet<ComparableCidsBean>();
        List massnAnwendungen = this.cidsBean.getBeanCollectionProperty("angewendete_simulationsmassnahmen");
        if (massnAnwendungen != null) {
            for (CidsBean massnAnwendung : massnAnwendungen) {
                CidsBean massnGruppe = FgskSimulationHelper.getSimMassnahmeGruppeById((Integer)massnAnwendung.getProperty("massnahme"));
                CidsBean einzelMassn = FgskSimulationHelper.getSimMassnahmeById((Integer)massnAnwendung.getProperty("einzel_massnahme"));
                if (massnGruppe != null) {
                    List massnList = massnGruppe.getBeanCollectionProperty("massnahmen");
                    if (massnList == null) continue;
                    for (CidsBean massn : massnList) {
                        massnSet.add(new ComparableCidsBean(massn));
                    }
                    continue;
                }
                if (einzelMassn == null) continue;
                massnSet.add(new ComparableCidsBean(einzelMassn));
            }
        }
        DefaultListModel<CidsBean> listModel = new DefaultListModel<CidsBean>();
        for (ComparableCidsBean massn : massnSet) {
            listModel.addElement(massn.getBean());
        }
        this.jlWKMassnList.setModel(listModel);
        this.jlWKMassnList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = String.valueOf(value);
                if (value != null && value.getClass().getName().equals("de.cismet.cids.dynamics.Sim_massnahme")) {
                    CidsBean bean = (CidsBean)value;
                    name = bean.getProperty("key") + " - " + bean.toString();
                }
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
    }

    private void fillDialog() {
        String name = (String)this.cidsBean.getProperty("name");
        String beschreibung = (String)this.cidsBean.getProperty("beschreibung");
        Boolean fixCosts = (Boolean)this.cidsBean.getProperty("kosten_fix");
        if (name == null) {
            name = "";
        }
        if (beschreibung == null) {
            beschreibung = "";
        }
        if (fixCosts == null) {
            fixCosts = false;
        }
        this.txtName.setText(name);
        this.taBemerkungen.setText(beschreibung);
        this.cbKostenFix.setSelected(fixCosts);
    }

    private void setName() {
        String name = (String)this.cidsBean.getProperty("name");
        if (name != null) {
            this.lblTitleName.setText("Name: " + this.cidsBean.getProperty("name"));
            this.lblTitleName.setToolTipText("Beschreibung: " + this.cidsBean.getProperty("beschreibung"));
        } else {
            this.lblTitleName.setText("Name: ");
        }
    }

    private void setNamesAndBands() {
        final boolean checkForMassnahmen = this.isNew;
        ((CardLayout)this.panMain.getLayout()).show(this.panMain, "loading");
        final SwingWorker<MetaObject[], Void> waitingDialog = new SwingWorker<MetaObject[], Void>(){

            @Override
            protected MetaObject[] doInBackground() throws Exception {
                ArrayList<Object> wkfgIn = new ArrayList<Object>(1);
                wkfgIn.add(SimulationEditor.this.cidsBean.getProperty("wk_key"));
                MetaObject[] mosWkFg = (MetaObject[])WK_FG_CACHE.calcValue(wkfgIn);
                if (mosWkFg != null && mosWkFg.length == 1) {
                    SimulationEditor.this.wkFg = mosWkFg[0].getBean();
                    ArrayList<Object> in = new ArrayList<Object>(1);
                    in.add(SimulationEditor.this.cidsBean.getProperty("wk_key"));
                    return (MetaObject[])FGSK_CACHE.calcValue(in);
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    SimulationEditor.access$1402(SimulationEditor.this, (MetaObject[])this.get());
                    SimulationEditor.this.panBand.removeAll();
                    if (SimulationEditor.this.wkFg != null) {
                        SimulationEditor.this.addBands();
                        SimulationEditor.this.lblSubTitle1.setText(String.valueOf(SimulationEditor.this.wkFg.getProperty("wk_k")));
                        SimulationEditor.this.lblTitle.setText(SimulationEditor.this.getTitle());
                        List teile = SimulationEditor.this.wkFg.getBeanCollectionProperty("teile");
                        int index = 0;
                        boolean firstBand = true;
                        for (CidsBean teil : teile) {
                            if (!SimulationEditor.this.hasFgsk((Integer)teil.getProperty("linie.von.route.id"), (Double)teil.getProperty("linie.von.wert"), (Double)teil.getProperty("linie.bis.wert"))) continue;
                            CidsBean route = LinearReferencingHelper.getRouteBeanFromStationBean((CidsBean)teil.getProperty("linie.von"));
                            double from = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)teil.getProperty("linie.von"));
                            double till = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)teil.getProperty("linie.bis"));
                            SimulationEditor.this.sbm[index].setMin(from);
                            SimulationEditor.this.sbm[index].setMax(till);
                            SimulationEditor.this.fgskBands[index].setMin(from);
                            SimulationEditor.this.fgskBands[index].setMax(till);
                            SimulationEditor.this.jband[index].setMinValue(from);
                            SimulationEditor.this.jband[index].setMaxValue(till);
                            Integer rid = (Integer)route.getProperty("id");
                            if (firstBand) {
                                SimulationEditor.this.wkband = new WKBand(from, till);
                                SimulationEditor.this.wkband.fillAndInsertBand(SimulationEditor.this.sbm[index], String.valueOf(route.getProperty("gwk")), SimulationEditor.this.jband[index], null);
                                firstBand = false;
                            }
                            if (SimulationEditor.this.fgsks != null) {
                                ArrayList<CidsBean> fgskList = new ArrayList<CidsBean>();
                                HashMap<CidsBean, List<CidsBean>> massnahmenMap = new HashMap<CidsBean, List<CidsBean>>();
                                HashMap<CidsBean, Boolean> massnahmenCompleteMap = new HashMap<CidsBean, Boolean>();
                                for (MetaObject fgsk : SimulationEditor.this.fgsks) {
                                    Double bis = (Double)fgsk.getBean().getProperty("linie.bis.wert");
                                    Double von = (Double)fgsk.getBean().getProperty("linie.von.wert");
                                    if (von > bis) {
                                        Double tmp = von;
                                        von = bis;
                                        bis = tmp;
                                    }
                                    if (!fgsk.getBean().getProperty("linie.von.route.id").equals(rid) || !(bis - 1.0 >= from) || !(von + 1.0 <= till)) continue;
                                    CidsBean fgskBean = fgsk.getBean();
                                    fgskList.add(fgskBean);
                                    massnahmenMap.put(fgskBean, SimulationEditor.this.getMassnahmenForFgsk(fgskBean));
                                    massnahmenCompleteMap.put(fgskBean, SimulationEditor.this.getMassnahmenFragmentForFgsk(fgskBean).isEmpty());
                                }
                                SimulationEditor.this.fgskBands[index].setCidsBeans(fgskList, massnahmenMap, massnahmenCompleteMap);
                                SimulationEditor.this.sbm[index].fireBandModelChanged();
                            }
                            ++index;
                        }
                        SimulationEditor.this.setGewTyp();
                        if (SimulationEditor.this.fgsks != null && SimulationEditor.this.fgsks.length > 100) {
                            int zoomValue = SimulationEditor.this.fgsks.length < 150 ? 30 : 60;
                            SimulationEditor.this.sldZoom.setValue(zoomValue);
                            double zoom = (double)SimulationEditor.this.sldZoom.getValue() / 10.0;
                            for (JBand tmpBand : SimulationEditor.this.jband) {
                                tmpBand.setZoomFactor(zoom);
                            }
                        }
                        if (checkForMassnahmen) {
                            SimulationEditor.this.checkForMassnahmenBvp();
                        } else {
                            SimulationEditor.this.refreshMorphometer();
                            ((CardLayout)SimulationEditor.this.panMain.getLayout()).show(SimulationEditor.this.panMain, "band");
                            SimulationEditor.this.panHeaderInfo.setVisible(true);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while retrieving fgsk objects.", (Throwable)e);
                }
            }
        };
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismetConcurrency.getInstance((String)"Fgsk_sim").getDefaultExecutor().submit(waitingDialog);
            }
        });
    }

    private void checkForMassnahmenBvp() {
        SwingWorker<MetaObject[], Void> waitingDialog = new SwingWorker<MetaObject[], Void>(){

            @Override
            protected MetaObject[] doInBackground() throws Exception {
                ArrayList<Object> in = new ArrayList<Object>(1);
                in.add(SimulationEditor.this.cidsBean.getProperty("wk_key"));
                return (MetaObject[])MASSNAHMEN_CACHE.calcValue(in);
            }

            @Override
            protected void done() {
                try {
                    int userAnswer;
                    MetaObject[] mos = (MetaObject[])this.get();
                    if (mos != null && mos.length > 0 && (userAnswer = JOptionPane.showConfirmDialog(SimulationEditor.this, NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.checkForMassnahmenBvp().message"), NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.checkForMassnahmenBvp().title"), 0, 3)) == 0) {
                        for (MetaObject mo : mos) {
                            CidsBean maBean = mo.getBean();
                            List<CidsBean> MassnBeans = FgskSimulationHelper.getSimMassnBeanFromMassnBvp(maBean);
                            if (MassnBeans == null || MassnBeans.isEmpty()) continue;
                            CidsBean stationLine = (CidsBean)maBean.getProperty("linie");
                            double from = Math.min((Double)stationLine.getProperty("von.wert"), (Double)stationLine.getProperty("bis.wert"));
                            double to = Math.max((Double)stationLine.getProperty("von.wert"), (Double)stationLine.getProperty("bis.wert"));
                            Long gwk = (Long)stationLine.getProperty("von.route.gwk");
                            List<CidsBean> fgskList = FgskSimulationHelper.getAllCorrespondingFgsk(from, to, gwk, SimulationEditor.this.fgsks);
                            for (CidsBean fgsk : fgskList) {
                                for (CidsBean massn : MassnBeans) {
                                    ReadOnlyFgskBandMember member;
                                    double percentage = FgskSimulationHelper.determineFgskIntersectionPercentage(fgsk, from, to, gwk);
                                    boolean complete = percentage == 100.0;
                                    SimulationEditor.this.addMassnahme(fgsk, massn, complete);
                                    if (complete || (member = SimulationEditor.this.getBandMemberForFgsk(fgsk)) == null) continue;
                                    member.setComplete(false);
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while retrieving massnahmen BVP objects", (Throwable)e);
                }
                SimulationEditor.this.refreshMorphometer();
                SimulationEditor.this.refreshWkFgMassnList();
                ((CardLayout)SimulationEditor.this.panMain.getLayout()).show(SimulationEditor.this.panMain, "band");
                SimulationEditor.this.panHeaderInfo.setVisible(true);
            }
        };
        CismetConcurrency.getInstance((String)"Fgsk_sim").getDefaultExecutor().submit(waitingDialog);
    }

    private ReadOnlyFgskBandMember getBandMemberForFgsk(CidsBean fgsk) {
        for (ReadOnlyFgskBand band : this.fgskBands) {
            for (int i = 0; i < band.getNumberOfMembers(); ++i) {
                ReadOnlyFgskBandMember member = (ReadOnlyFgskBandMember)band.getMember(i);
                if (!member.getCidsBean().equals((Object)fgsk)) continue;
                return member;
            }
        }
        return null;
    }

    private void addMassnahme(CidsBean fgsk, CidsBean massn) {
        this.addMassnahme(fgsk, massn, null);
    }

    private void addMassnahme(CidsBean fgsk, CidsBean massn, Boolean complete) {
        if (FgskSimulationHelper.isMassnGroupContained(massn, this.cidsBean, fgsk)) {
            return;
        }
        try {
            CidsBean newBean = CidsBeanSupport.createNewCidsBeanFromTableName("sim_massnahmen_anwendungen");
            newBean.setProperty("fgsk_ka", fgsk.getProperty("id"));
            if (massn.getClass().getName().equals("de.cismet.cids.dynamics.Sim_massnahmen_gruppe")) {
                newBean.setProperty("massnahme", massn.getProperty("id"));
            } else if (massn.getClass().getName().equals("de.cismet.cids.dynamics.Sim_massnahme")) {
                newBean.setProperty("einzel_massnahme", massn.getProperty("id"));
            }
            if (complete != null && complete.booleanValue()) {
                newBean.setProperty("complete", (Object)true);
            } else {
                newBean.setProperty("complete", (Object)false);
            }
            this.cidsBean.getBeanCollectionProperty("angewendete_simulationsmassnahmen").add(newBean);
            SimSimulationsabschnittEditor.SimulationResultChangedEvent e = new SimSimulationsabschnittEditor.SimulationResultChangedEvent(this, fgsk, this.getMassnahmenForFgsk(fgsk));
            this.simulationResultChanged(e);
        }
        catch (Exception e) {
            LOG.error((Object)"error adding new object of type sim_massnahmen_anwendung", (Throwable)e);
        }
    }

    private void removeMassnahme(CidsBean fgsk, CidsBean massn) {
        try {
            List simMassnList = this.cidsBean.getBeanCollectionProperty("angewendete_simulationsmassnahmen");
            CidsBean massnToRemove = null;
            Integer targetId = (Integer)massn.getProperty("id");
            Integer fgskId = (Integer)fgsk.getProperty("id");
            for (CidsBean simMassn : simMassnList) {
                Integer massnId;
                if (!simMassn.getProperty("fgsk_ka").equals(fgskId) || (massnId = (Integer)simMassn.getProperty("einzel_massnahme")) == null || !massnId.equals(targetId)) continue;
                massnToRemove = simMassn;
                break;
            }
            if (massnToRemove != null) {
                simMassnList.remove(massnToRemove);
                SimSimulationsabschnittEditor.SimulationResultChangedEvent e = new SimSimulationsabschnittEditor.SimulationResultChangedEvent(this, fgsk, this.getMassnahmenForFgsk(fgsk));
                this.simulationResultChanged(e);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error adding new object of type sim_massnahmen_anwendung", (Throwable)e);
        }
    }

    private void refreshMorphometer() {
        this.jPanel1.setVisible(true);
        double[] classInMeter = new double[6];
        int HEIGHT = 28;
        int maxWidth = this.panMorphometer.getWidth() - 2;
        int[] lengthClass = new int[6];
        double totalLength = this.getWBLength();
        double lengthFgsk = 0.0;
        for (MetaObject fgsk : this.fgsks) {
            double length = 0.0;
            int cl = 0;
            try {
                length = Calc.getStationLength(fgsk.getBean());
                Double p = SimSimulationsabschnittEditor.calc(fgsk.getBean(), this.getMassnahmenForFgsk(fgsk.getBean()), false, null);
                cl = SimSimulationsabschnittEditor.getGueteklasse(fgsk.getBean(), p);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while calculating class", (Throwable)e);
                lengthFgsk += length;
                classInMeter[5] = classInMeter[5] + length;
                continue;
            }
            lengthFgsk += length;
            if (cl > 0) {
                int n = cl - 1;
                classInMeter[n] = classInMeter[n] + length;
                continue;
            }
            classInMeter[5] = classInMeter[5] + length;
        }
        if (lengthFgsk > totalLength && !this.warningAlreadyShown && !this.readOnly) {
            JOptionPane.showMessageDialog(this, "Die einzelnen Kartierabschnitte sind gr\u00f6\u00dfer als der gesamte Wasserk\u00f6rper.", "Fehler", 2);
            this.warningAlreadyShown = true;
        }
        lengthClass[0] = (int)(classInMeter[0] * (double)maxWidth / totalLength);
        lengthClass[1] = (int)(classInMeter[1] * (double)maxWidth / totalLength);
        lengthClass[2] = (int)(classInMeter[2] * (double)maxWidth / totalLength);
        lengthClass[3] = (int)(classInMeter[3] * (double)maxWidth / totalLength);
        lengthClass[4] = (int)(classInMeter[4] * (double)maxWidth / totalLength);
        lengthClass[5] = (int)(classInMeter[5] * (double)maxWidth / totalLength);
        int total = 0;
        for (int i : lengthClass) {
            total += i;
        }
        int lostPrecionTotal = maxWidth - (int)((double)(total * maxWidth) / totalLength);
        int i = 0;
        while (lostPrecionTotal != 0) {
            if (lengthClass[i] > 0) {
                int change = lostPrecionTotal / Math.abs(lostPrecionTotal);
                int n = i;
                lengthClass[n] = lengthClass[n] + change;
                lostPrecionTotal += change;
            }
            if (++i != lengthClass.length) continue;
        }
        this.panClass1.setSize(lengthClass[0], 28);
        this.panClass2.setBounds((int)(this.panClass1.getBounds().getX() + this.panClass1.getBounds().getWidth()), 1, lengthClass[1], 28);
        this.panClass3.setBounds((int)(this.panClass2.getBounds().getX() + this.panClass2.getBounds().getWidth()), 1, lengthClass[2], 28);
        this.panClass4.setBounds((int)(this.panClass3.getBounds().getX() + this.panClass3.getBounds().getWidth()), 1, lengthClass[3], 28);
        this.panClass5.setBounds((int)(this.panClass4.getBounds().getX() + this.panClass4.getBounds().getWidth()), 1, lengthClass[4], 28);
        this.panClass6.setBounds((int)(this.panClass5.getBounds().getX() + this.panClass5.getBounds().getWidth()), 1, lengthClass[5], 28);
        this.panClass1.setBackground(SimSimulationsabschnittEditor.getColor(1));
        this.panClass2.setBackground(SimSimulationsabschnittEditor.getColor(2));
        this.panClass3.setBackground(SimSimulationsabschnittEditor.getColor(3));
        this.panClass4.setBackground(SimSimulationsabschnittEditor.getColor(4));
        this.panClass5.setBackground(SimSimulationsabschnittEditor.getColor(5));
        this.panClass6.setBackground(SimSimulationsabschnittEditor.getColor(0));
        this.refreshKosten();
    }

    private void refreshKosten() {
        List angMassn = this.cidsBean.getBeanCollectionProperty("angewendete_simulationsmassnahmen");
        double costs = 0.0;
        double flaechenerwerb = 0.0;
        double customCosts = 0.0;
        for (CidsBean massn : angMassn) {
            try {
                CidsBean fgsk = this.getFgskById((Integer)massn.getProperty("fgsk_ka"));
                CidsBean mass = FgskSimulationHelper.getSimMassnahmeGruppeById((Integer)massn.getProperty("massnahme"));
                CidsBean einzelMass = FgskSimulationHelper.getSimMassnahmeById((Integer)massn.getProperty("einzel_massnahme"));
                if (fgsk == null) continue;
                if (mass != null) {
                    for (CidsBean m : mass.getBeanCollectionProperty("massnahmen")) {
                        String ort = (String)m.getProperty("ort.name");
                        if (ort.equalsIgnoreCase("Fl\u00e4chenbedarf")) {
                            flaechenerwerb += FgskSimCalc.getInstance().calcCosts(fgsk, m, (List)FL_COSTS_CACHE.calcValue((Object)"1"));
                            continue;
                        }
                        costs += FgskSimCalc.getInstance().calcCosts(fgsk, m, (List)FL_COSTS_CACHE.calcValue((Object)"1"));
                    }
                    continue;
                }
                if (einzelMass != null) {
                    String ort = (String)einzelMass.getProperty("ort.name");
                    if (ort.equalsIgnoreCase("Fl\u00e4chenbedarf")) {
                        flaechenerwerb += FgskSimCalc.getInstance().calcCosts(fgsk, einzelMass, (List)FL_COSTS_CACHE.calcValue((Object)"1"));
                        continue;
                    }
                    costs += FgskSimCalc.getInstance().calcCosts(fgsk, einzelMass, (List)FL_COSTS_CACHE.calcValue((Object)"1"));
                    continue;
                }
                if (massn.getProperty("sonstige_kosten") == null) continue;
                customCosts += ((Double)massn.getProperty("sonstige_kosten")).doubleValue();
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot calculate the costs", (Throwable)e);
            }
        }
        double p = (costs + flaechenerwerb + customCosts) * 0.15;
        DecimalFormat format = new DecimalFormat();
        this.lblMaKosten.setText(format.format(costs) + " \u20ac");
        this.lblFlKosten.setText(format.format(flaechenerwerb) + " \u20ac");
        this.lblSoKosten.setText(format.format(customCosts) + " \u20ac");
        this.lblNeKosten.setText(format.format(p) + " \u20ac");
        this.lblKostenGes4.setText(format.format(costs + flaechenerwerb + p + customCosts) + " \u20ac");
    }

    private CidsBean getFgskById(int id) {
        for (MetaObject mo : this.fgsks) {
            if (mo.getID() != id) continue;
            return mo.getBean();
        }
        return null;
    }

    private double getWBLength() {
        double length = 0.0;
        if (this.wkFg != null) {
            List parts = this.wkFg.getBeanCollectionProperty("teile");
            for (CidsBean p : parts) {
                length += SimulationEditor.getWbStationLength(p);
            }
        }
        return length;
    }

    public static double getWbStationLength(CidsBean bean) {
        try {
            Double toValue = (Double)bean.getProperty("linie.bis.wert");
            Double fromValue = (Double)bean.getProperty("linie.von.wert");
            return Math.abs(toValue - fromValue);
        }
        catch (Exception e) {
            String message = "illegal station settings in WK-FG-Teil";
            LOG.error((Object)"illegal station settings in WK-FG-Teil", (Throwable)e);
            return 0.0;
        }
    }

    private List<CidsBean> getMassnahmenForFgsk(CidsBean fgsk) {
        ArrayList<CidsBean> massnahmen = new ArrayList<CidsBean>();
        Integer fgskId = (Integer)fgsk.getProperty("id");
        List angMassn = this.cidsBean.getBeanCollectionProperty("angewendete_simulationsmassnahmen");
        for (CidsBean massn : angMassn) {
            CidsBean simMassBean;
            Integer massnId;
            if (!massn.getProperty("fgsk_ka").equals(fgskId)) continue;
            if (massn.getProperty("massnahme") != null) {
                massnId = (Integer)massn.getProperty("massnahme");
                simMassBean = FgskSimulationHelper.getSimMassnahmeGruppeById(massnId);
                massnahmen.add(simMassBean);
                continue;
            }
            if (massn.getProperty("einzel_massnahme") == null) continue;
            massnId = (Integer)massn.getProperty("einzel_massnahme");
            simMassBean = FgskSimulationHelper.getSimMassnahmeById(massnId);
            massnahmen.add(simMassBean);
        }
        return massnahmen;
    }

    private Double getCustomCostsForFgsk(CidsBean fgsk) {
        CidsBean costsBean = FgskSimulationHelper.getCustomCostsBeanForFgsk(this.cidsBean, fgsk);
        if (costsBean != null) {
            return (Double)costsBean.getProperty("sonstige_kosten");
        }
        return null;
    }

    private List<CidsBean> getMassnahmenFragmentForFgsk(CidsBean fgsk) {
        ArrayList<CidsBean> massnahmen = new ArrayList<CidsBean>();
        Integer fgskId = (Integer)fgsk.getProperty("id");
        List angMassn = this.cidsBean.getBeanCollectionProperty("angewendete_simulationsmassnahmen");
        for (CidsBean massn : angMassn) {
            CidsBean simMassBean;
            Integer massnId;
            if (!massn.getProperty("fgsk_ka").equals(fgskId) || massn.getProperty("complete") == null || ((Boolean)massn.getProperty("complete")).booleanValue()) continue;
            if (massn.getProperty("massnahme") != null) {
                massnId = (Integer)massn.getProperty("massnahme");
                simMassBean = FgskSimulationHelper.getSimMassnahmeGruppeById(massnId);
                massnahmen.add(simMassBean);
                continue;
            }
            if (massn.getProperty("einzel_massnahme") == null) continue;
            massnId = (Integer)massn.getProperty("einzel_massnahme");
            simMassBean = FgskSimulationHelper.getSimMassnahmeById(massnId);
            massnahmen.add(simMassBean);
        }
        return massnahmen;
    }

    private boolean hasFgsk(Integer rid, Double from, Double till) {
        for (MetaObject fgsk : this.fgsks) {
            if (!fgsk.getBean().getProperty("linie.von.route.id").equals(rid) || !((Double)fgsk.getBean().getProperty("linie.von.wert") >= from) || !((Double)fgsk.getBean().getProperty("linie.bis.wert") <= till)) continue;
            return true;
        }
        return false;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void initComponents() {
        this.panFooter = new JPanel();
        this.lblFoot = new JLabel();
        this.bgrpDetails = new ButtonGroup();
        this.panNew = new CidsBeanDropPanel();
        this.lblNeu = new JLabel();
        this.bgZiel = new ButtonGroup();
        this.panTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.jPanel1 = new JPanel();
        this.panMorphometer = new JPanel();
        this.panClass1 = new JPanel();
        this.panClass2 = new JPanel();
        this.panClass3 = new JPanel();
        this.panClass4 = new JPanel();
        this.panClass5 = new JPanel();
        this.panClass6 = new JPanel();
        this.lblMarker1 = new JLabel();
        this.lblMarker2 = new JLabel();
        this.lblMarker3 = new JLabel();
        this.lblMarker4 = new JLabel();
        this.lblMarker5 = new JLabel();
        this.lblTitleName = new JLabel();
        this.labInfo = new JLabel();
        this.jPanel2 = new JPanel();
        this.lblMaCosts = new JLabel();
        this.lblMaKosten = new JLabel();
        this.lblFlCosts = new JLabel();
        this.lblFlKosten = new JLabel();
        this.lblSoCosts = new JLabel();
        this.lblSoKosten = new JLabel();
        this.lblNeCosts = new JLabel();
        this.lblNeKosten = new JLabel();
        this.lblCosts4 = new JLabel();
        this.lblKostenGes4 = new JLabel();
        this.diaName = new JDialog();
        this.panAllgemein = new JPanel();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblBemerkungen = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taBemerkungen = new JTextArea();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.lblBemerkungen1 = new JLabel();
        this.cbKostenFix = new JCheckBox();
        this.jMenu1 = new JMenu();
        this.panInfo = new RoundedPanel();
        this.panHeadInfo = new SemiRoundedPanel();
        this.lblHeading = new JLabel();
        this.labMassnProp = new JLabel();
        this.panInfoContent = new JPanel();
        this.panEditorPanel = new JPanel();
        this.panFgsk = new JPanel();
        this.panSimCard = new JPanel();
        this.panSim = new JPanel();
        this.panMultiSim = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jlMultiSimList = new MultiFgskCidsBeanDropList();
        this.labMultiSim = new JLabel();
        this.jbRem = new JButton();
        this.panEmpty = new JPanel();
        this.panVermessung = new JPanel();
        this.panWkInfo = new RoundedPanel();
        this.panHeadInfo1 = new SemiRoundedPanel();
        this.lblHeading1 = new JLabel();
        this.panInfoContent1 = new JPanel();
        this.panTotal1 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.jlWKMassnList = new JList();
        this.panHeader = new JPanel();
        this.panHeaderInfo = new JPanel();
        this.jLabel5 = new JLabel();
        this.sldZoom = new JSlider();
        this.jLabel6 = new JLabel();
        this.lblSubTitle1 = new JLabel();
        this.rbOekPot = new JRadioButton();
        this.rbZust = new JRadioButton();
        this.togZoomToParts = new JToggleButton();
        this.panMain = new JPanel();
        this.panLoading = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.panBand = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.panFooter.setMinimumSize(new Dimension(1050, 16));
        this.panFooter.setOpaque(false);
        this.panFooter.setPreferredSize(new Dimension(1050, 16));
        this.panFooter.setLayout(new GridBagLayout());
        this.lblFoot.setFont(new Font("Tahoma", 1, 12));
        this.lblFoot.setForeground(new Color(255, 255, 255));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 25, 7, 25);
        this.panFooter.add((Component)this.lblFoot, gridBagConstraints);
        this.panNew.setOpaque(false);
        this.panNew.setLayout(new GridBagLayout());
        this.lblNeu.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblNeu.text", (Object[])new Object[0]));
        this.panNew.add((Component)this.lblNeu, new GridBagConstraints());
        this.panTitle.setOpaque(false);
        this.panTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(640, 30));
        this.jPanel1.setLayout(null);
        this.panMorphometer.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.panMorphometer.setOpaque(false);
        this.panMorphometer.setPreferredSize(new Dimension(200, 30));
        this.panMorphometer.setLayout(null);
        this.panClass1.setMinimumSize(new Dimension(0, 28));
        this.panClass1.setPreferredSize(new Dimension(0, 28));
        GroupLayout panClass1Layout = new GroupLayout(this.panClass1);
        this.panClass1.setLayout(panClass1Layout);
        panClass1Layout.setHorizontalGroup(panClass1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panClass1Layout.setVerticalGroup(panClass1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 28, Short.MAX_VALUE));
        this.panMorphometer.add(this.panClass1);
        this.panClass1.setBounds(1, 1, 0, 28);
        this.panClass2.setMinimumSize(new Dimension(0, 26));
        this.panClass2.setPreferredSize(new Dimension(0, 26));
        GroupLayout panClass2Layout = new GroupLayout(this.panClass2);
        this.panClass2.setLayout(panClass2Layout);
        panClass2Layout.setHorizontalGroup(panClass2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panClass2Layout.setVerticalGroup(panClass2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE));
        this.panMorphometer.add(this.panClass2);
        this.panClass2.setBounds(12, 1, 0, 26);
        this.panClass3.setMinimumSize(new Dimension(0, 26));
        this.panClass3.setPreferredSize(new Dimension(0, 26));
        GroupLayout panClass3Layout = new GroupLayout(this.panClass3);
        this.panClass3.setLayout(panClass3Layout);
        panClass3Layout.setHorizontalGroup(panClass3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panClass3Layout.setVerticalGroup(panClass3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE));
        this.panMorphometer.add(this.panClass3);
        this.panClass3.setBounds(12, 1, 0, 26);
        this.panClass4.setMinimumSize(new Dimension(0, 26));
        this.panClass4.setPreferredSize(new Dimension(0, 26));
        GroupLayout panClass4Layout = new GroupLayout(this.panClass4);
        this.panClass4.setLayout(panClass4Layout);
        panClass4Layout.setHorizontalGroup(panClass4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panClass4Layout.setVerticalGroup(panClass4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE));
        this.panMorphometer.add(this.panClass4);
        this.panClass4.setBounds(12, 1, 0, 26);
        this.panClass5.setMinimumSize(new Dimension(0, 26));
        this.panClass5.setPreferredSize(new Dimension(0, 26));
        GroupLayout panClass5Layout = new GroupLayout(this.panClass5);
        this.panClass5.setLayout(panClass5Layout);
        panClass5Layout.setHorizontalGroup(panClass5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panClass5Layout.setVerticalGroup(panClass5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE));
        this.panMorphometer.add(this.panClass5);
        this.panClass5.setBounds(12, 1, 0, 26);
        this.panClass6.setMinimumSize(new Dimension(0, 26));
        GroupLayout panClass6Layout = new GroupLayout(this.panClass6);
        this.panClass6.setLayout(panClass6Layout);
        panClass6Layout.setHorizontalGroup(panClass6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panClass6Layout.setVerticalGroup(panClass6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE));
        this.panMorphometer.add(this.panClass6);
        this.panClass6.setBounds(12, 1, 0, 26);
        this.jPanel1.add(this.panMorphometer);
        this.panMorphometer.setBounds(5, 0, 625, 30);
        this.lblMarker1.setForeground(Color.white);
        this.lblMarker1.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblMarker1.text", (Object[])new Object[0]));
        this.jPanel1.add(this.lblMarker1);
        this.lblMarker1.setBounds(2, 30, 10, 17);
        this.lblMarker2.setForeground(Color.white);
        this.lblMarker2.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblMarker2.text", (Object[])new Object[0]));
        this.jPanel1.add(this.lblMarker2);
        this.lblMarker2.setBounds(158, 30, 20, 17);
        this.lblMarker3.setForeground(Color.white);
        this.lblMarker3.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblMarker3.text", (Object[])new Object[0]));
        this.jPanel1.add(this.lblMarker3);
        this.lblMarker3.setBounds(315, 30, 20, 17);
        this.lblMarker4.setForeground(Color.white);
        this.lblMarker4.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblMarker4.text", (Object[])new Object[0]));
        this.jPanel1.add(this.lblMarker4);
        this.lblMarker4.setBounds(471, 30, 20, 17);
        this.lblMarker5.setForeground(Color.white);
        this.lblMarker5.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblMarker5.text", (Object[])new Object[0]));
        this.jPanel1.add(this.lblMarker5);
        this.lblMarker5.setBounds(615, 30, 25, 17);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipady = 23;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panTitle.add((Component)this.jPanel1, gridBagConstraints);
        this.lblTitleName.setFont(new Font("Tahoma", 1, 18));
        this.lblTitleName.setForeground(new Color(255, 255, 255));
        this.lblTitleName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimulationEditor.this.lblTitleNameMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panTitle.add((Component)this.lblTitleName, gridBagConstraints);
        this.labInfo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/icon-info-sign-white.png")));
        this.labInfo.setToolTipText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.labInfo.toolTipText", (Object[])new Object[0]));
        this.labInfo.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.labInfo.setCursor(new Cursor(12));
        this.labInfo.setRequestFocusEnabled(false);
        this.labInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimulationEditor.this.labInfoMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.panTitle.add((Component)this.labInfo, gridBagConstraints);
        this.jPanel2.setOpaque(false);
        this.jPanel2.setPreferredSize(new Dimension(640, 30));
        this.jPanel2.setLayout(new GridBagLayout());
        this.lblMaCosts.setFont(new Font("Tahoma", 1, 14));
        this.lblMaCosts.setForeground(new Color(255, 255, 255));
        this.lblMaCosts.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblMaCosts.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.lblMaCosts, gridBagConstraints);
        this.lblMaKosten.setFont(new Font("Tahoma", 1, 14));
        this.lblMaKosten.setForeground(new Color(255, 255, 255));
        this.lblMaKosten.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblMaKosten.text", (Object[])new Object[0]));
        this.lblMaKosten.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimulationEditor.this.lblMaKostenMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.lblMaKosten, gridBagConstraints);
        this.lblFlCosts.setFont(new Font("Tahoma", 1, 14));
        this.lblFlCosts.setForeground(new Color(255, 255, 255));
        this.lblFlCosts.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblFlCosts.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.lblFlCosts, gridBagConstraints);
        this.lblFlKosten.setFont(new Font("Tahoma", 1, 14));
        this.lblFlKosten.setForeground(new Color(255, 255, 255));
        this.lblFlKosten.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblFlKosten.text", (Object[])new Object[0]));
        this.lblFlKosten.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimulationEditor.this.lblFlKostenMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.lblFlKosten, gridBagConstraints);
        this.lblSoCosts.setFont(new Font("Tahoma", 1, 14));
        this.lblSoCosts.setForeground(new Color(255, 255, 255));
        this.lblSoCosts.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblSoCosts.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.lblSoCosts, gridBagConstraints);
        this.lblSoKosten.setFont(new Font("Tahoma", 1, 14));
        this.lblSoKosten.setForeground(new Color(255, 255, 255));
        this.lblSoKosten.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblSoKosten.text", (Object[])new Object[0]));
        this.lblSoKosten.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimulationEditor.this.lblSoKostenMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.lblSoKosten, gridBagConstraints);
        this.lblNeCosts.setFont(new Font("Tahoma", 1, 14));
        this.lblNeCosts.setForeground(new Color(255, 255, 255));
        this.lblNeCosts.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblNeCosts.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.lblNeCosts, gridBagConstraints);
        this.lblNeKosten.setFont(new Font("Tahoma", 1, 14));
        this.lblNeKosten.setForeground(new Color(255, 255, 255));
        this.lblNeKosten.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblNeKosten.text", (Object[])new Object[0]));
        this.lblNeKosten.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimulationEditor.this.lblNeKostenMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.lblNeKosten, gridBagConstraints);
        this.lblCosts4.setFont(new Font("Tahoma", 1, 14));
        this.lblCosts4.setForeground(new Color(255, 255, 255));
        this.lblCosts4.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblCosts4.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.lblCosts4, gridBagConstraints);
        this.lblKostenGes4.setFont(new Font("Tahoma", 1, 14));
        this.lblKostenGes4.setForeground(new Color(255, 255, 255));
        this.lblKostenGes4.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblKostenGes4.text", (Object[])new Object[0]));
        this.lblKostenGes4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimulationEditor.this.lblKostenGes4MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.lblKostenGes4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panTitle.add((Component)this.jPanel2, gridBagConstraints);
        this.diaName.setTitle(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.diaName.title", (Object[])new Object[0]));
        this.diaName.setMinimumSize(new Dimension(590, 206));
        this.diaName.setModal(true);
        this.diaName.setResizable(false);
        this.diaName.getContentPane().setLayout(new GridBagLayout());
        this.panAllgemein.setOpaque(false);
        this.panAllgemein.setLayout(new GridBagLayout());
        this.lblName.setText(NbBundle.getMessage(SimulationEditor.class, (String)"GupGewaesserabschnittAllgemein.lblGewaessername.text"));
        this.lblName.setMaximumSize(new Dimension(170, 17));
        this.lblName.setMinimumSize(new Dimension(170, 17));
        this.lblName.setPreferredSize(new Dimension(170, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(25, 15, 5, 5);
        this.panAllgemein.add((Component)this.lblName, gridBagConstraints);
        this.txtName.setMaximumSize(new Dimension(280, 20));
        this.txtName.setMinimumSize(new Dimension(280, 20));
        this.txtName.setPreferredSize(new Dimension(380, 20));
        this.txtName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulationEditor.this.txtNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(25, 5, 5, 15);
        this.panAllgemein.add((Component)this.txtName, gridBagConstraints);
        this.lblBemerkungen.setText(NbBundle.getMessage(SimulationEditor.class, (String)"GupGewaesserabschnittAllgemein.lblGwk.text"));
        this.lblBemerkungen.setMaximumSize(new Dimension(170, 17));
        this.lblBemerkungen.setMinimumSize(new Dimension(170, 17));
        this.lblBemerkungen.setPreferredSize(new Dimension(170, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.panAllgemein.add((Component)this.lblBemerkungen, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(262, 87));
        this.taBemerkungen.setColumns(20);
        this.taBemerkungen.setRows(5);
        this.jScrollPane1.setViewportView(this.taBemerkungen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.panAllgemein.add((Component)this.jScrollPane1, gridBagConstraints);
        this.butOK.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.butOK.text", (Object[])new Object[0]));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulationEditor.this.butOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.panAllgemein.add((Component)this.butOK, gridBagConstraints);
        this.butCancel.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.butCancel.text", (Object[])new Object[0]));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulationEditor.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.panAllgemein.add((Component)this.butCancel, gridBagConstraints);
        this.lblBemerkungen1.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblBemerkungen1.text"));
        this.lblBemerkungen1.setMaximumSize(new Dimension(170, 17));
        this.lblBemerkungen1.setMinimumSize(new Dimension(170, 17));
        this.lblBemerkungen1.setPreferredSize(new Dimension(170, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.panAllgemein.add((Component)this.lblBemerkungen1, gridBagConstraints);
        this.cbKostenFix.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.cbKostenFix.text", (Object[])new Object[0]));
        this.cbKostenFix.setContentAreaFilled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panAllgemein.add((Component)this.cbKostenFix, gridBagConstraints);
        this.diaName.getContentPane().add((Component)this.panAllgemein, new GridBagConstraints());
        this.jMenu1.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.jMenu1.text", (Object[])new Object[0]));
        this.setMinimumSize(new Dimension(1150, 750));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(1150, 750));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SimulationEditor.this.formKeyPressed(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.panInfo.setMinimumSize(new Dimension(830, 436));
        this.panInfo.setPreferredSize(new Dimension(830, 436));
        this.panHeadInfo.setBackground(new Color(51, 51, 51));
        this.panHeadInfo.setMinimumSize(new Dimension(109, 50));
        this.panHeadInfo.setPreferredSize(new Dimension(109, 40));
        this.panHeadInfo.setLayout((LayoutManager)new GridBagLayout());
        this.lblHeading.setForeground(new Color(255, 255, 255));
        this.lblHeading.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblHeading.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.panHeadInfo.add((Component)this.lblHeading, (Object)gridBagConstraints);
        this.labMassnProp.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/icon-searchfolder_w.png")));
        this.labMassnProp.setToolTipText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.labMassnProp.toolTipText", (Object[])new Object[0]));
        this.labMassnProp.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.labMassnProp.setCursor(new Cursor(12));
        this.labMassnProp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimulationEditor.this.labMassnPropMouseClicked(evt);
            }
        });
        this.panHeadInfo.add((Component)this.labMassnProp, (Object)new GridBagConstraints());
        this.panInfo.add((Component)this.panHeadInfo, (Object)"North");
        this.panInfoContent.setOpaque(false);
        this.panInfoContent.setLayout(new GridBagLayout());
        this.panEditorPanel.setLayout(new CardLayout());
        this.panFgsk.setOpaque(false);
        this.panFgsk.setLayout(new GridBagLayout());
        this.panSimCard.setLayout(new CardLayout());
        this.panSim.setLayout(new BorderLayout());
        this.panSimCard.add((Component)this.panSim, "sim");
        this.panMultiSim.setLayout(new GridBagLayout());
        this.jScrollPane3.setPreferredSize(new Dimension(280, 130));
        this.jScrollPane3.setViewportView(this.jlMultiSimList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 15, 15, 10);
        this.panMultiSim.add((Component)this.jScrollPane3, gridBagConstraints);
        this.labMultiSim.setHorizontalAlignment(0);
        this.labMultiSim.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.labMultiSim.text", (Object[])new Object[0]));
        this.labMultiSim.setPreferredSize(new Dimension(480, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 15, 0, 15);
        this.panMultiSim.add((Component)this.labMultiSim, gridBagConstraints);
        this.jbRem.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_remove_16.png")));
        this.jbRem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulationEditor.this.jbRemActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.panMultiSim.add((Component)this.jbRem, gridBagConstraints);
        this.panSimCard.add((Component)this.panMultiSim, "multiSim");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panFgsk.add((Component)this.panSimCard, gridBagConstraints);
        this.panEditorPanel.add((Component)this.panFgsk, "fgsk");
        this.panEmpty.setOpaque(false);
        this.panEmpty.setLayout(new BorderLayout());
        this.panEditorPanel.add((Component)this.panEmpty, "empty");
        this.panVermessung.setOpaque(false);
        this.panVermessung.setLayout(new BorderLayout());
        this.panEditorPanel.add((Component)this.panVermessung, "vermessung");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panInfoContent.add((Component)this.panEditorPanel, gridBagConstraints);
        this.panInfo.add((Component)this.panInfoContent, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.add((Component)this.panInfo, gridBagConstraints);
        this.panWkInfo.setMinimumSize(new Dimension(640, 436));
        this.panWkInfo.setPreferredSize(new Dimension(270, 436));
        this.panHeadInfo1.setBackground(new Color(51, 51, 51));
        this.panHeadInfo1.setMinimumSize(new Dimension(109, 40));
        this.panHeadInfo1.setPreferredSize(new Dimension(109, 40));
        this.panHeadInfo1.setLayout((LayoutManager)new GridBagLayout());
        this.lblHeading1.setForeground(new Color(255, 255, 255));
        this.lblHeading1.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.lblHeading1.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.panHeadInfo1.add((Component)this.lblHeading1, (Object)gridBagConstraints);
        this.panWkInfo.add((Component)this.panHeadInfo1, (Object)"North");
        this.panInfoContent1.setOpaque(false);
        this.panInfoContent1.setLayout(new GridBagLayout());
        this.panTotal1.setPreferredSize(new Dimension(315, 200));
        this.panTotal1.setLayout(new GridBagLayout());
        this.jlWKMassnList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SimulationEditor.this.jlWKMassnListValueChanged(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.jlWKMassnList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 15, 5, 15);
        this.panTotal1.add((Component)this.jScrollPane5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panInfoContent1.add((Component)this.panTotal1, gridBagConstraints);
        this.panWkInfo.add((Component)this.panInfoContent1, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.add((Component)this.panWkInfo, gridBagConstraints);
        this.panHeader.setOpaque(false);
        this.panHeader.setLayout(new GridBagLayout());
        this.panHeaderInfo.setMinimumSize(new Dimension(531, 52));
        this.panHeaderInfo.setOpaque(false);
        this.panHeaderInfo.setPreferredSize(new Dimension(531, 52));
        this.panHeaderInfo.setLayout(null);
        this.jLabel5.setFont(new Font("Lucida Sans", 0, 18));
        this.jLabel5.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.jLabel5.text", (Object[])new Object[0]));
        this.jLabel5.setMaximumSize(new Dimension(92, 22));
        this.jLabel5.setMinimumSize(new Dimension(92, 22));
        this.jLabel5.setPreferredSize(new Dimension(92, 22));
        this.panHeaderInfo.add(this.jLabel5);
        this.jLabel5.setBounds(330, 0, 60, 20);
        this.sldZoom.setMaximum(200);
        this.sldZoom.setValue(0);
        this.sldZoom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SimulationEditor.this.sldZoomStateChanged(evt);
            }
        });
        this.panHeaderInfo.add(this.sldZoom);
        this.sldZoom.setBounds(390, 4, 350, 16);
        this.jLabel6.setFont(new Font("Lucida Grande", 0, 18));
        this.jLabel6.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.jLabel6.text", (Object[])new Object[0]));
        this.jLabel6.setMinimumSize(new Dimension(91, 22));
        this.panHeaderInfo.add(this.jLabel6);
        this.jLabel6.setBounds(12, 0, 92, 22);
        this.lblSubTitle1.setFont(new Font("Lucida Grande", 0, 18));
        this.panHeaderInfo.add(this.lblSubTitle1);
        this.lblSubTitle1.setBounds(110, 0, 220, 20);
        this.bgZiel.add(this.rbOekPot);
        this.rbOekPot.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.rbOekPot.text", (Object[])new Object[0]));
        this.rbOekPot.setContentAreaFilled(false);
        this.rbOekPot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulationEditor.this.rbOekPotActionPerformed(evt);
            }
        });
        this.panHeaderInfo.add(this.rbOekPot);
        this.rbOekPot.setBounds(810, 0, 240, 24);
        this.bgZiel.add(this.rbZust);
        this.rbZust.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.rbZust.text", (Object[])new Object[0]));
        this.rbZust.setContentAreaFilled(false);
        this.rbZust.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulationEditor.this.rbZustActionPerformed(evt);
            }
        });
        this.panHeaderInfo.add(this.rbZust);
        this.rbZust.setBounds(810, 20, 230, 24);
        this.togZoomToParts.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/icon-zoom-in.png")));
        this.togZoomToParts.setToolTipText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.togZoomToParts.toolTipText", (Object[])new Object[0]));
        this.panHeaderInfo.add(this.togZoomToParts);
        this.togZoomToParts.setBounds(760, 4, 30, 28);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.panHeader.add((Component)this.panHeaderInfo, gridBagConstraints);
        this.panMain.setOpaque(false);
        this.panMain.setLayout(new CardLayout());
        this.panLoading.setMinimumSize(new Dimension(1050, 188));
        this.panLoading.setOpaque(false);
        this.panLoading.setPreferredSize(new Dimension(1050, 188));
        this.panLoading.setLayout(new GridBagLayout());
        this.jProgressBar1.setIndeterminate(true);
        this.jProgressBar1.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.panLoading.add((Component)this.jProgressBar1, gridBagConstraints);
        this.jLabel1.setText(NbBundle.getMessage(SimulationEditor.class, (String)"SimulationEditor.jLabel1.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panLoading.add((Component)this.jLabel1, gridBagConstraints);
        this.panMain.add((Component)this.panLoading, "loading");
        this.panBand.setOpaque(false);
        this.panBand.setLayout(new BorderLayout());
        this.panMain.add((Component)this.panBand, "band");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panHeader.add((Component)this.panMain, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panHeader, gridBagConstraints);
        this.jPanel3.setMinimumSize(new Dimension(1050, 1));
        this.jPanel3.setOpaque(false);
        this.jPanel3.setPreferredSize(new Dimension(1050, 1));
        this.jLabel4.setMaximumSize(new Dimension(1050, 1));
        this.jLabel4.setMinimumSize(new Dimension(1050, 1));
        this.jLabel4.setPreferredSize(new Dimension(1050, 1));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1050, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel4, -2, 1040, -2).addGap(0, 10, Short.MAX_VALUE))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel4, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    private void sldZoomStateChanged(ChangeEvent evt) {
        double zoom = (double)this.sldZoom.getValue() / 10.0;
        for (JBand tmpBand : this.jband) {
            tmpBand.setZoomFactor(zoom);
        }
    }

    private void rbOekPotActionPerformed(ActionEvent evt) {
        this.setGewTyp();
    }

    private void rbZustActionPerformed(ActionEvent evt) {
        this.setGewTyp();
    }

    private void txtNameActionPerformed(ActionEvent evt) {
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.cancel = true;
        this.namePrompt = false;
        this.diaName.setVisible(false);
        this.fillDialog();
    }

    private void butOKActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.namePrompt = false;
        this.diaName.setVisible(false);
        try {
            this.cidsBean.setProperty("name", (Object)this.txtName.getText());
            this.cidsBean.setProperty("beschreibung", (Object)this.taBemerkungen.getText());
            this.cidsBean.setProperty("kosten_fix", (Object)this.cbKostenFix.isSelected());
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot set name", (Throwable)e);
        }
        this.setName();
    }

    private void lblTitleNameMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.diaName.setSize(590, 226);
            this.diaName.pack();
            StaticSwingTools.showDialog((JDialog)this.diaName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jlWKMassnListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            int[] selectedIndices = this.jlWKMassnList.getSelectedIndices();
            this.wkMassnListChangedByUser = true;
            try {
                if (selectedIndices != null && selectedIndices.length > 0) {
                    ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
                    ListModel model = this.jlWKMassnList.getModel();
                    for (int index : selectedIndices) {
                        beans.add((CidsBean)model.getElementAt(index));
                    }
                    for (int bandIndex = 0; bandIndex < this.fgskBands.length; ++bandIndex) {
                        ReadOnlyFgskBand fgskBand = this.fgskBands[bandIndex];
                        ArrayList<ReadOnlyFgskBandMember> validMembers = new ArrayList<ReadOnlyFgskBandMember>();
                        for (int i = 0; i < fgskBand.getNumberOfMembers(); ++i) {
                            BandMember member = fgskBand.getMember(i);
                            ReadOnlyFgskBandMember fgskMember = (ReadOnlyFgskBandMember)member;
                            if (!this.containsAllMassnahmen(fgskMember.getMassnahmen(), beans)) continue;
                            validMembers.add(fgskMember);
                        }
                        this.jband[bandIndex].setSelectedMember(validMembers);
                    }
                }
            }
            finally {
                this.wkMassnListChangedByUser = false;
            }
        }
    }

    private void labMassnPropMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            this.simulationsEditor.generateMassnahmenvorschlag();
        }
    }

    private void formKeyPressed(KeyEvent evt) {
        System.out.println("drin");
    }

    private void labInfoMouseClicked(MouseEvent evt) {
        this.diaName.setSize(590, 226);
        this.diaName.pack();
        StaticSwingTools.showDialog((JDialog)this.diaName);
    }

    private void jbRemActionPerformed(ActionEvent evt) {
        if (this.readOnly) {
            return;
        }
        int[] selectedIndices = this.jlMultiSimList.getSelectedIndices();
        if (selectedIndices != null) {
            for (int index : selectedIndices) {
                MultiMassnahmenContainer container = (MultiMassnahmenContainer)this.jlMultiSimList.getModel().getElementAt(index);
                CidsBean massn = container.massnBean;
                for (CidsBean fgsk : this.getAllSelectedFgsk()) {
                    try {
                        if (!FgskSimulationHelper.isMassnGroupContained(massn, this.cidsBean, fgsk)) continue;
                        this.removeMassnahme(fgsk, massn);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"error adding new object of type sim_massnahmen_anwendung", (Throwable)e);
                    }
                }
            }
        }
        this.refreshMultiFgskListModel(this.getAllSelectedFgsk());
        this.refreshWkFgMassnList();
    }

    private void lblMaKostenMouseClicked(MouseEvent evt) {
    }

    private void lblFlKostenMouseClicked(MouseEvent evt) {
    }

    private void lblNeKostenMouseClicked(MouseEvent evt) {
    }

    private void lblKostenGes4MouseClicked(MouseEvent evt) {
    }

    private void lblSoKostenMouseClicked(MouseEvent evt) {
    }

    private boolean containsAllMassnahmen(List<CidsBean> referenceList, List<CidsBean> containedList) {
        List<CidsBean> massnReferenceList = FgskSimulationHelper.getMassnahmenBeans(referenceList);
        for (CidsBean bean : containedList) {
            if (massnReferenceList.contains(bean)) continue;
            return false;
        }
        return true;
    }

    private List<CidsBean> getAllSelectedFgsk() {
        ArrayList<CidsBean> selectedFgsk = new ArrayList<CidsBean>();
        for (JBand tmp : this.jband) {
            for (BandMemberSelectable bm : tmp.getSelectedBandMemberList()) {
                if (!(bm instanceof ReadOnlyFgskBandMember)) continue;
                selectedFgsk.add(((ReadOnlyFgskBandMember)bm).getCidsBean());
            }
        }
        return selectedFgsk;
    }

    private void setGewTyp() {
        if (this.wkFg.getProperty("b9ausw").equals("nat\u00fcrlich")) {
            this.rbZust.setSelected(true);
        } else {
            this.rbOekPot.setSelected(true);
        }
    }

    public void dispose() {
        this.simulationsEditor.dispose();
        if (!this.initialReadOnly && WrrlMapOptionsPanel.isChangeMapWindowActive()) {
            this.restoreLayout();
        }
        if (this.fgskBands != null) {
            for (JBand band : this.jband) {
                band.dispose();
            }
        }
        if (this.sbm != null) {
            for (int index = 0; index < this.sbm.length; ++index) {
                if (this.sbm[index] == null) continue;
                this.sbm[index].removeBandModelListener(this.modelListener[index]);
            }
        }
    }

    public String getTitle() {
        if (this.cidsBean != null && this.cidsBean.getProperty("wk_key") != null) {
            return "WK: " + String.valueOf(this.cidsBean.getProperty("wk_key"));
        }
        return "";
    }

    public void setTitle(String title) {
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    public static void main(String[] args) throws Exception {
        DevelopmentTools.initSessionManagerFromRMIConnectionOnLocalhost((String)"WRRL_DB_MV", (String)"Administratoren", (String)"admin", (String)"kif");
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost((String)"WRRL_DB_MV", (String)"Administratoren", (String)"admin", (String)"kif", (String)"simulation", (int)9, (int)1280, (int)1024);
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        this.diaName.setSize(590, 156);
        if (this.namePrompt) {
            StaticSwingTools.showDialog((JDialog)this.diaName);
        } else {
            this.cancel = false;
        }
        if (this.simulationsEditor != null) {
            this.simulationsEditor.prepareForSave();
        }
        try {
            this.cidsBean.setProperty("kosten", (Object)Double.parseDouble(this.lblKostenGes4.getText()));
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot set the property kosten", (Throwable)e);
        }
        return !this.cancel;
    }

    public JComponent getTitleComponent() {
        this.lblTitle.setText(this.getTitle());
        return this.panTitle;
    }

    @Override
    public void simulationResultChanged(SimSimulationsabschnittEditor.SimulationResultChangedEvent e) {
        this.refreshMorphometer();
        for (ReadOnlyFgskBand band : this.fgskBands) {
            band.refreshMembers(e.getChangedFgsk(), e.getMassnahmenList());
        }
    }

    private void refreshMultiFgskListModel(List<CidsBean> selectedFgsk) {
        HashMap<CidsBean, MultiMassnahmenContainer> totalMassnMap = new HashMap<CidsBean, MultiMassnahmenContainer>();
        for (CidsBean bean : selectedFgsk) {
            List<CidsBean> massnList = FgskSimulationHelper.getMassnahmenBeans(this.getMassnahmenForFgsk(bean));
            TreeSet<ComparableCidsBean> beansOfCurrentBandMember = new TreeSet<ComparableCidsBean>();
            for (CidsBean massn : massnList) {
                ComparableCidsBean massnWrapper = new ComparableCidsBean(massn);
                if (beansOfCurrentBandMember.contains(massnWrapper)) continue;
                beansOfCurrentBandMember.add(massnWrapper);
                MultiMassnahmenContainer container = (MultiMassnahmenContainer)totalMassnMap.get(massn);
                if (container == null) {
                    container = new MultiMassnahmenContainer(massn, selectedFgsk.size());
                    totalMassnMap.put(massn, container);
                    continue;
                }
                container.increaseCounter();
            }
        }
        ArrayList allContainer = new ArrayList(totalMassnMap.values());
        Collections.sort(allContainer);
        DefaultListModel<MultiMassnahmenContainer> listModel = new DefaultListModel<MultiMassnahmenContainer>();
        for (MultiMassnahmenContainer container : allContainer) {
            listModel.addElement(container);
        }
        this.jlMultiSimList.setModel(listModel);
    }

    static /* synthetic */ MetaObject[] access$1402(SimulationEditor x0, MetaObject[] x1) {
        x0.fgsks = x1;
        return x1;
    }

    static {
        FGSK_CACHE.setTimeToCacheResults(30000L);
        WK_FG_CACHE.setTimeToCacheResults(30000L);
        FL_COSTS_CACHE.setTimeToCacheResults(3000000L);
        Thread t = new Thread("load costs"){

            @Override
            public void run() {
                try {
                    FL_COSTS_CACHE.calcValue((Object)"1");
                }
                catch (Exception e) {
                    LOG.error((Object)"error while loading costs", (Throwable)e);
                }
            }
        };
        t.start();
    }

    private class MultiMassnahmenConainerCellRenderer
    extends DefaultListCellRenderer {
        private MultiMassnahmenConainerCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof MultiMassnahmenContainer && c instanceof JLabel) {
                MultiMassnahmenContainer container = (MultiMassnahmenContainer)value;
                JLabel lab = (JLabel)c;
                if (!container.isUsedByAll()) {
                    lab.setForeground(Color.LIGHT_GRAY);
                    lab.setText(value + " (" + container.getCount() + " Vorkommen)");
                }
            }
            return c;
        }
    }

    private class MultiMassnahmenContainer
    implements Comparable<MultiMassnahmenContainer> {
        private int count = 1;
        private final CidsBean massnBean;
        private final int totalCount;

        public MultiMassnahmenContainer(CidsBean massnBean, int totalCount) {
            this.massnBean = massnBean;
            this.totalCount = totalCount;
        }

        public void increaseCounter() {
            ++this.count;
        }

        public boolean isUsedByAll() {
            return this.count == this.totalCount;
        }

        public int getCount() {
            return this.count;
        }

        public String toString() {
            return this.massnBean.getProperty("key") + " - " + this.massnBean.toString();
        }

        @Override
        public int compareTo(MultiMassnahmenContainer o) {
            if (this.count != o.count) {
                return o.count - this.count;
            }
            return this.toString().compareTo(o.toString());
        }
    }

    public static class MassnBvpCalculator
    implements Calculator<List, MetaObject[]> {
        public MetaObject[] calculate(List input) throws Exception {
            String query = "SELECT " + MC_MASSNAHMEN.getID() + ",  m." + MC_MASSNAHMEN.getPrimaryKey() + " FROM " + MC_MASSNAHMEN.getTableName() + " m join massnahmen_pressure_measure mpm on (m.pressure_measure = mpm.massnahmen_reference)\n\t\t\t\t\t\t\tjoin pressure_measure pm on (mpm.pressure_measure = pm.id)\n\t\t\t\t\t\t\tjoin wfd.de_measure_type_code c on (pm.measure = c.id) , " + MC_WK_FG.getTableName() + " f ";
            if (input.size() > 1) {
                query = query + ", massnahmen_realisierung mr ";
            }
            query = query + " WHERE m.wk_fg = f.id and f.wk_k = '" + String.valueOf(input.get(0)) + "' and c.value::integer in (28, 61, 62, 63, 64, 65, 69, 70, 71, 73, 76, 77, 78, 79, 85, 93, 501)";
            if (input.size() > 1) {
                query = query + " and m.realisierung = mr.id and mr.value <= " + input.get(1).toString() + " and mr.value <> 1 and mr.value <> 3";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for massnahmen: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            return metaObjects;
        }
    }

    private static class WkfgCalculator
    implements Calculator<List, MetaObject[]> {
        private WkfgCalculator() {
        }

        public MetaObject[] calculate(List input) throws Exception {
            String query = "SELECT " + MC_WK_FG.getID() + ",  " + MC_WK_FG.getPrimaryKey() + " FROM " + MC_WK_FG.getTableName() + " WHERE wk_k = '" + String.valueOf(input.get(0)) + "';";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for wk-fg: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            return metaObjects;
        }
    }

    public static class FlCostsCalculator
    implements Calculator<String, List<MetaObject>> {
        public List<MetaObject> calculate(String id) throws Exception {
            AllObjectsSearch objectSeartch = new AllObjectsSearch(Integer.valueOf(MC_SIM_FLAECEHNERWERBSPREIS.getID()), MC_SIM_FLAECEHNERWERBSPREIS.getTableName());
            return (List)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)objectSeartch);
        }
    }

    public static class FgskCalculator
    implements Calculator<List, MetaObject[]> {
        public MetaObject[] calculate(List input) throws Exception {
            String query = "SELECT " + MC_FGSK.getID() + ",  " + MC_FGSK.getPrimaryKey() + " FROM " + MC_FGSK.getTableName() + " WHERE wkk = '" + String.valueOf(input.get(0)) + "' and (historisch is null or not historisch);";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for fgsk: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            return metaObjects;
        }
    }

    private class MultiFgskCidsBeanDropList
    extends JList
    implements CidsBeanDropListener {
        private MultiFgskCidsBeanDropList() {
        }

        public void beansDropped(ArrayList<CidsBean> beans) {
            if (SimulationEditor.this.readOnly) {
                return;
            }
            for (CidsBean massn : beans) {
                if (!massn.getClass().getName().equals("de.cismet.cids.dynamics.Sim_massnahmen_gruppe") && !massn.getClass().getName().equals("de.cismet.cids.dynamics.Sim_massnahme")) continue;
                String hinweis = (String)massn.getProperty("hinweis");
                if (hinweis != null && !hinweis.equals("")) {
                    JOptionPane.showMessageDialog(SimulationEditor.this, hinweis, "Hinweis", 1);
                }
                for (CidsBean fgsk : SimulationEditor.this.getAllSelectedFgsk()) {
                    try {
                        SimulationEditor.this.addMassnahme(fgsk, massn);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"error adding new object of type sim_massnahmen_anwendung", (Throwable)e);
                    }
                }
            }
            SimulationEditor.this.refreshMultiFgskListModel(SimulationEditor.this.getAllSelectedFgsk());
            SimulationEditor.this.refreshWkFgMassnList();
        }
    }

    private class CidsBeanDropPanel
    extends JPanel
    implements CidsBeanDropListener {
        private CidsBeanDropPanel() {
        }

        public void beansDropped(ArrayList<CidsBean> beans) {
            CidsBean tmpBean;
            if (!SimulationEditor.this.isNew || SimulationEditor.this.readOnly) {
                return;
            }
            if (beans.size() > 0 && (tmpBean = beans.get(0)).getClass().getName().equals(SimulationEditor.WK_FG_CLASS_NAME)) {
                SimulationEditor.this.wkFg = tmpBean;
                ((CardLayout)SimulationEditor.this.panMain.getLayout()).show(SimulationEditor.this.panMain, "band");
                try {
                    SimulationEditor.this.cidsBean.setProperty("wk_key", SimulationEditor.this.wkFg.getProperty("wk_k"));
                    SimulationEditor.this.setNamesAndBands();
                    SimulationEditor.this.isNew = false;
                }
                catch (Exception e) {
                    LOG.error((Object)"error while setting the wk_key property", (Throwable)e);
                }
            }
        }
    }

    class RestriktionBandModelListener
    implements BandModelListener {
        private final JBand band;

        public RestriktionBandModelListener(JBand band) {
            this.band = band;
        }

        public void bandModelChanged(BandModelEvent e) {
        }

        public void bandModelSelectionChanged(BandModelEvent e) {
            BandMember bm;
            ArrayList selectedMembers = new ArrayList();
            if (SimulationEditor.this.selectionChangedHandlingInProgress) {
                return;
            }
            SimulationEditor.this.selectionChangedHandlingInProgress = true;
            if (e.isSelectionLost() && !SimulationEditor.this.wkMassnListChangedByUser) {
                for (JBand tmp : SimulationEditor.this.jband) {
                    if (tmp.equals(this.band)) continue;
                    tmp.setSelectedMember(new ArrayList());
                }
                selectedMembers.addAll(this.band.getSelectedBandMemberList());
            } else {
                for (JBand tmp : SimulationEditor.this.jband) {
                    selectedMembers.addAll(tmp.getSelectedBandMemberList());
                }
            }
            this.band.setRefreshAvoided(true);
            SimulationEditor.this.simulationsEditor.dispose();
            if (selectedMembers.isEmpty()) {
                SimulationEditor.this.switchToForm("empty");
                SimulationEditor.this.lblHeading.setText("");
            } else if (selectedMembers.size() == 1) {
                SimulationEditor.this.bgrpDetails.clearSelection();
                SimulationEditor.this.switchToForm("empty");
                SimulationEditor.this.lblHeading.setText("");
                if (((BandMemberSelectable)selectedMembers.get(0)).getBandMember() instanceof ReadOnlyFgskBandMember) {
                    SimulationEditor.this.switchToForm("fgsk>sim");
                    CidsBean bean = ((ReadOnlyFgskBandMember)((BandMemberSelectable)selectedMembers.get(0)).getBandMember()).getCidsBean();
                    SimulationEditor.this.lblHeading.setText("FGSK-Abschnitt: " + bean.toString());
                    SimulationEditor.this.simulationsEditor.setSimulation(SimulationEditor.this.cidsBean);
                    SimulationEditor.this.simulationsEditor.setCustomCosts(SimulationEditor.this.getCustomCostsForFgsk(bean));
                    SimulationEditor.this.simulationsEditor.setMassnahmen(SimulationEditor.this.getMassnahmenForFgsk(bean));
                    SimulationEditor.this.simulationsEditor.setCidsBean(bean);
                }
            } else {
                SimulationEditor.this.switchToForm("fgsk>multiSim");
                ArrayList<CidsBean> selectedFgsk = new ArrayList<CidsBean>();
                for (BandMemberSelectable tmp : selectedMembers) {
                    bm = tmp.getBandMember();
                    if (!(bm instanceof ReadOnlyFgskBandMember)) continue;
                    selectedFgsk.add(((ReadOnlyFgskBandMember)bm).getCidsBean());
                }
                SimulationEditor.this.refreshMultiFgskListModel(selectedFgsk);
            }
            this.band.setRefreshAvoided(false);
            this.band.bandModelChanged(null);
            SimulationEditor.this.selectionChangedHandlingInProgress = false;
            if (!SimulationEditor.this.wkMassnListChangedByUser) {
                SimulationEditor.this.jlWKMassnList.getSelectionModel().clearSelection();
            }
            if (SimulationEditor.this.togZoomToParts.isSelected() && !CismapBroker.getInstance().getMappingComponent().isFixedMapExtent()) {
                ArrayList<Geometry> geomList = new ArrayList<Geometry>();
                for (BandMemberSelectable tmp : selectedMembers) {
                    Geometry tmpGeom;
                    bm = tmp.getBandMember();
                    if (!(bm instanceof ReadOnlyFgskBandMember) || (tmpGeom = (Geometry)((ReadOnlyFgskBandMember)bm).getCidsBean().getProperty("linie.geom.geo_field")) == null) continue;
                    geomList.add(tmpGeom.getEnvelope());
                }
                if (geomList.size() > 0) {
                    GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), ((Geometry)geomList.get(0)).getSRID());
                    Geometry geom = factory.buildGeometry(geomList);
                    if (geom instanceof GeometryCollection) {
                        geom = ((GeometryCollection)geom).union();
                    }
                    if (geom != null) {
                        CismapBroker.getInstance().getMappingComponent().gotoBoundingBox((BoundingBox)new XBoundingBox(geom), true, !CismapBroker.getInstance().getMappingComponent().isFixedMapScale(), 500);
                    }
                }
            }
        }

        public void bandModelValuesChanged(BandModelEvent e) {
        }
    }
}

