/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import de.cismet.cids.custom.objecteditors.wrrl_db_mv.StationArrayEditorListener;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.StationEditor;
import de.cismet.cids.custom.wrrl_db_mv.commons.linearreferencing.LinearReferencingConstants;
import de.cismet.cids.custom.wrrl_db_mv.util.MapUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingHelper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openide.util.NbBundle;

public class StationArrayEditor
extends JPanel
implements DisposableCidsBeanStore,
LinearReferencingConstants {
    private CidsBean cidsBean;
    private String arrayField;
    private Collection<StationEditor> stationEditors = new ArrayList<StationEditor>();
    private HashMap<JButton, StationEditor> stationenMap = new HashMap();
    private Collection<StationArrayEditorListener> listeners = new ArrayList<StationArrayEditorListener>();
    private CidsBeanDropTarget cidsBeanDropTarget;
    private JPanel dropPanel;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private RoundedPanel roundedPanel1;
    private SemiRoundedPanel semiRoundedPanel1;

    public StationArrayEditor() {
        this.initComponents();
    }

    public final void setFields(String arrayField) {
        this.setArrayField(arrayField);
    }

    private void setArrayField(String arrayField) {
        this.arrayField = arrayField;
    }

    public boolean addListener(StationArrayEditorListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(StationArrayEditorListener listener) {
        return this.listeners.remove(listener);
    }

    private void fireStationAdded(StationEditor source) {
        for (StationArrayEditorListener listener : this.listeners) {
            listener.editorAdded(source);
        }
    }

    private void fireStationRemoved(StationEditor source) {
        for (StationArrayEditorListener listener : this.listeners) {
            listener.editorRemoved(source);
        }
    }

    public Collection<CidsBean> getCidsBeans() {
        if (this.cidsBean != null) {
            return (Collection)this.cidsBean.getProperty(this.arrayField);
        }
        return new ArrayList<CidsBean>();
    }

    private void addEditor(StationEditor stationEditor) {
        this.stationEditors.add(stationEditor);
        JPanel panItem = new JPanel(new BorderLayout());
        panItem.setOpaque(false);
        JButton btnRemove = new JButton();
        btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_remove_mini.png")));
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JButton button = (JButton)evt.getSource();
                StationEditor stationEditor = (StationEditor)StationArrayEditor.this.stationenMap.get(button);
                StationArrayEditor.this.removeEditor(stationEditor);
            }
        });
        JPanel panEast = new JPanel(new FlowLayout(1, 5, 5));
        panEast.add(btnRemove);
        panEast.setOpaque(false);
        panItem.add((Component)stationEditor, "Center");
        panItem.add((Component)panEast, "East");
        panItem.add((Component)new JSeparator(), "South");
        this.stationenMap.put(btnRemove, stationEditor);
        this.jPanel1.add(panItem);
        ((GridLayout)this.jPanel1.getLayout()).setRows(this.jPanel1.getComponentCount());
        this.revalidate();
        this.fireStationAdded(stationEditor);
    }

    private void removeEditor(StationEditor stationEditor) {
        Collection<CidsBean> cidsBeans = this.getCidsBeans();
        cidsBeans.remove(stationEditor.getCidsBean());
        this.jPanel1.remove(stationEditor.getParent());
        stationEditor.dispose();
        if (cidsBeans.size() > 0) {
            ((GridLayout)this.jPanel1.getLayout()).setRows(cidsBeans.size());
        } else {
            ((GridLayout)this.jPanel1.getLayout()).setRows(1);
        }
        this.stationEditors.remove(stationEditor);
        this.revalidate();
        this.fireStationRemoved(stationEditor);
    }

    public void dispose() {
        for (StationEditor stationEditor : this.stationEditors) {
            stationEditor.dispose();
        }
    }

    private void initComponents() {
        this.roundedPanel1 = new RoundedPanel();
        this.semiRoundedPanel1 = new SemiRoundedPanel();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.dropPanel = new DropPanel();
        this.jLabel3 = new JLabel();
        this.setMinimumSize(new Dimension(200, 100));
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 2));
        this.semiRoundedPanel1.setBackground(new Color(51, 51, 51));
        this.semiRoundedPanel1.setMinimumSize(new Dimension(55, 24));
        this.semiRoundedPanel1.setPreferredSize(new Dimension(0, 24));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(NbBundle.getMessage(StationArrayEditor.class, (String)"StationArrayEditor.jLabel1.text"));
        this.semiRoundedPanel1.add((Component)this.jLabel1, (Object)"Center");
        this.roundedPanel1.add((Component)this.semiRoundedPanel1, (Object)"North");
        this.jPanel1.setMinimumSize(new Dimension(100, 48));
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridLayout(1, 0));
        this.roundedPanel1.add((Component)this.jPanel1, (Object)"Center");
        this.dropPanel.setOpaque(false);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText(NbBundle.getMessage(StationArrayEditor.class, (String)"StationArrayEditor.jLabel3.text"));
        this.dropPanel.add(this.jLabel3);
        this.roundedPanel1.add((Component)this.dropPanel, (Object)"South");
        this.add((Component)this.roundedPanel1);
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cidsBean = cidsBean;
        Collection<CidsBean> cidsBeans = this.getCidsBeans();
        if (this.cidsBeanDropTarget == null) {
            this.cidsBeanDropTarget = new CidsBeanDropTarget((Component)this.dropPanel);
        }
        if (cidsBeans.size() > 0) {
            ((GridLayout)this.jPanel1.getLayout()).setRows(cidsBeans.size());
        } else {
            ((GridLayout)this.jPanel1.getLayout()).setRows(1);
        }
        for (CidsBean stationBean : cidsBeans) {
            StationEditor stationEditor = new StationEditor();
            stationEditor.setCidsBean(stationBean);
            this.addEditor(stationEditor);
        }
    }

    public Collection<Feature> getZoomFeaturse() {
        ArrayList<Feature> zoomFeatures = new ArrayList<Feature>();
        this.addZoomFeaturesToCollection(zoomFeatures);
        return zoomFeatures;
    }

    public void addZoomFeaturesToCollection(Collection<Feature> collection) {
        for (StationEditor editor : this.stationEditors) {
            editor.addZoomFeaturesToCollection(collection);
        }
    }

    private class DropPanel
    extends JPanel
    implements CidsBeanDropListener {
        private DropPanel() {
        }

        public void beansDropped(ArrayList<CidsBean> beans) {
            for (CidsBean routeBean : beans) {
                if (routeBean.getMetaObject().getMetaClass().getName().equals("route")) {
                    StationEditor editor = new StationEditor();
                    CidsBean stationBean = LinearReferencingHelper.createStationBeanFromRouteBean(routeBean);
                    editor.setCidsBean(stationBean);
                    StationArrayEditor.this.addEditor(editor);
                    MapUtil.zoomToFeatureCollection(editor.getZoomFeatures());
                    StationArrayEditor.this.getCidsBeans().add(editor.getCidsBean());
                    continue;
                }
                return;
            }
        }
    }
}

