/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.LinearReferencedPointEditorListener;
import de.cismet.cids.custom.wrrl_db_mv.commons.linearreferencing.LinearReferencingConstants;
import de.cismet.cids.custom.wrrl_db_mv.util.MapUtil;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.FeatureRegistryListener;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LineEditorDropBehavior;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingHelper;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingSingletonInstances;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeatureListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.CrsChangeListener;
import de.cismet.cismap.commons.interaction.events.CrsChangedEvent;
import de.cismet.tools.CurrentStackTrace;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class StationEditor
extends JPanel
implements DisposableCidsBeanStore,
LinearReferencingConstants,
CidsBeanDropListener,
LinearReferencingSingletonInstances {
    private boolean inited;
    private PropertyChangeListener cidsBeanListener;
    private boolean isSpinnerChangeLocked = false;
    private boolean isFeatureChangeLocked = false;
    private boolean isBeanChangeLocked = false;
    private ImageIcon ico;
    private CidsBean cidsBean;
    private Collection<LinearReferencedPointEditorListener> listeners = new ArrayList<LinearReferencedPointEditorListener>();
    private LinearReferencedPointFeatureListener featureListener;
    private CrsChangeListener crsChangeListener;
    private FeatureRegistryListener mapRegistryListener;
    private LineEditorDropBehavior dropBehavior;
    private Feature badGeomFeature;
    private XBoundingBox boundingbox;
    private boolean isAutoZoomActivated = true;
    private boolean changedSinceDrop = false;
    private boolean isEditable;
    private boolean firstStationInCurrentBB = false;
    private Geometry origGeom = null;
    private JToggleButton badGeomButton;
    private JButton badGeomCorrectButton;
    private JToggleButton geomHistorisch;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel labGwk;
    private JLabel lblError;
    private JLabel lblPointValue;
    private JLabel lblRoute;
    private JPanel panAdd;
    private JPanel panEdit;
    private JPanel panError;
    private JButton splitButton;
    private JSpinner spnPointValue;
    private BindingGroup bindingGroup;

    public StationEditor() {
        this(true);
    }

    protected StationEditor(boolean isEditable) {
        this.initComponents();
        this.setEditable(isEditable);
        if (isEditable) {
            block3: {
                try {
                    new CidsBeanDropTarget((Component)this.panAdd);
                    new CidsBeanDropTarget((Component)this);
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)"error while creating CidsBeanDropTarget");
                }
            }
            this.initSpinnerListener();
            this.initFeatureListener();
            this.initMapRegistryListener();
            this.initCrsChangeListener();
            this.initCidsBeanListener();
            CismapBroker.getInstance().addCrsChangeListener(this.getCrsChangeListener());
        }
    }

    private void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
        this.spnPointValue.setVisible(isEditable);
        this.lblPointValue.setVisible(!isEditable);
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public boolean addListener(LinearReferencedPointEditorListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(LinearReferencedPointEditorListener listener) {
        return this.listeners.remove(listener);
    }

    public void setImageIcon(ImageIcon ico) {
        this.ico = ico;
        if (this.getFeature() != null) {
            this.getFeature().setIconImage(ico);
        }
        this.jLabel5.setIcon(ico);
    }

    private void firePointCreated() {
        for (LinearReferencedPointEditorListener listener : this.listeners) {
            listener.pointCreated();
        }
    }

    public LinearReferencedPointFeature getFeature() {
        return (LinearReferencedPointFeature)FEATURE_REGISTRY.getFeature(this.getCidsBean());
    }

    public void beansDropped(ArrayList<CidsBean> beans) {
        if (this.isEditable()) {
            CidsBean routeBean = null;
            for (CidsBean bean : beans) {
                if (!bean.getMetaObject().getMetaClass().getName().equals("route")) continue;
                if (this.getDropBehavior() == null || this.getDropBehavior().checkForAdding(routeBean)) {
                    routeBean = bean;
                    this.setChangedSinceDrop(false);
                }
                double value = 0.0;
                if (this.isFirstStationInCurrentBB()) {
                    value = this.getPointInCurrentBB(routeBean);
                }
                this.setCidsBean(LinearReferencingHelper.createStationBeanFromRouteBean(routeBean, value));
                if (this.isAutoZoomActivated) {
                    MapUtil.zoomToFeatureCollection(this.getZoomFeatures());
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"no route found in dropped objects");
            }
        }
    }

    private boolean isInited() {
        return this.inited;
    }

    private void setInited(boolean inited) {
        this.inited = inited;
    }

    private JButton getBadGeomCorrectButton() {
        return this.badGeomCorrectButton;
    }

    private Feature getBadGeomFeature() {
        return this.badGeomFeature;
    }

    private void setBadGeomFeature(Feature badGeomFeature) {
        this.badGeomFeature = badGeomFeature;
    }

    private JToggleButton getBadGeomButton() {
        return this.badGeomButton;
    }

    private JSpinner getValueSpinner() {
        return this.spnPointValue;
    }

    private FeatureRegistryListener getMapRegistryListener() {
        return this.mapRegistryListener;
    }

    private void setMapRegistryListener(FeatureRegistryListener mapRegistryListener) {
        this.mapRegistryListener = mapRegistryListener;
    }

    private CrsChangeListener getCrsChangeListener() {
        return this.crsChangeListener;
    }

    private void setCrsChangeListener(CrsChangeListener crsChangeListener) {
        this.crsChangeListener = crsChangeListener;
    }

    private PropertyChangeListener getCidsBeanListener() {
        return this.cidsBeanListener;
    }

    private void setCidsBeanListener(PropertyChangeListener cidsBeanListener) {
        this.cidsBeanListener = cidsBeanListener;
    }

    private LinearReferencedPointFeatureListener getFeatureListener() {
        return this.featureListener;
    }

    private void setFeatureListener(LinearReferencedPointFeatureListener featureListener) {
        this.featureListener = featureListener;
    }

    private JButton getSplitButton() {
        return this.splitButton;
    }

    public LineEditorDropBehavior getDropBehavior() {
        return this.dropBehavior;
    }

    public void setDropBehavior(LineEditorDropBehavior dropBehavior) {
        this.dropBehavior = dropBehavior;
    }

    public boolean isFirstStationInCurrentBB() {
        return this.firstStationInCurrentBB;
    }

    public void setFirstStationInCurrentBB(boolean firstStationInCurrentBB) {
        this.firstStationInCurrentBB = firstStationInCurrentBB;
    }

    public boolean hasChangedSinceDrop() {
        return this.changedSinceDrop;
    }

    private void setChangedSinceDrop(boolean changedSinceDrop) {
        this.changedSinceDrop = changedSinceDrop;
    }

    private void initMapRegistryListener() {
        this.setMapRegistryListener(new FeatureRegistryListener(){

            @Override
            public void FeatureCountChanged() {
                StationEditor.this.updateSplitButton();
            }
        });
    }

    private void initCrsChangeListener() {
        this.setCrsChangeListener(new CrsChangeListener(){

            public void crsChanged(CrsChangedEvent event) {
                if (!StationEditor.this.isCrsSupported(event.getCurrentCrs())) {
                    StationEditor.this.showCrsNotSupported();
                } else {
                    StationEditor.this.init();
                }
            }
        });
    }

    private void showCrsNotSupported() {
        this.cleanup();
        this.setErrorMsg("Das aktuelle CRS wird vom Stationierungseditor nicht unterst\u00fctzt.");
        this.showCard(Card.error);
    }

    private boolean isCrsSupported(Crs crs) {
        return CrsTransformer.extractSridFromCrs((String)crs.getCode()) == 35833 || CrsTransformer.extractSridFromCrs((String)crs.getCode()) == 5650;
    }

    private void initCidsBeanListener() {
        this.setCidsBeanListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getPropertyName().equals("wert")) {
                    StationEditor.this.cidsBeanChanged((Double)pce.getNewValue());
                }
            }
        });
    }

    private void initFeatureListener() {
        this.setFeatureListener(new LinearReferencedPointFeatureListener(){

            public void featureMoved(LinearReferencedPointFeature pointFeature) {
                StationEditor.this.featureChanged(pointFeature.getCurrentPosition());
            }

            public void featureMerged(LinearReferencedPointFeature mergePoint, LinearReferencedPointFeature withPoint) {
                CidsBean withBean = LinearReferencingSingletonInstances.FEATURE_REGISTRY.getCidsBean((Feature)withPoint);
                StationEditor.this.setCidsBean(withBean);
                StationEditor.this.updateSplitButton();
            }
        });
    }

    private void showCard(Card card) {
        switch (card) {
            case edit: {
                ((CardLayout)this.getLayout()).show(this, "edit");
                break;
            }
            case add: {
                ((CardLayout)this.getLayout()).show(this, "add");
                break;
            }
            case error: {
                ((CardLayout)this.getLayout()).show(this, "error");
            }
        }
    }

    private void initSpinnerListener() {
        ((JSpinner.DefaultEditor)this.getValueSpinner().getEditor()).getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                StationEditor.this.spinnerChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                StationEditor.this.spinnerChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                StationEditor.this.spinnerChanged();
            }
        });
        ((JSpinner.DefaultEditor)this.getValueSpinner().getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent fe) {
                LinearReferencingSingletonInstances.MAPPING_COMPONENT.getFeatureCollection().select((Feature)StationEditor.this.getFeature());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spinnerChanged() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"spinner changed", (Throwable)new CurrentStackTrace());
        }
        try {
            this.lockSpinnerChange(true);
            JFormattedTextField.AbstractFormatter formatter = ((JSpinner.DefaultEditor)this.getValueSpinner().getEditor()).getTextField().getFormatter();
            String text = ((JSpinner.DefaultEditor)this.getValueSpinner().getEditor()).getTextField().getText();
            if (!text.isEmpty()) {
                try {
                    this.setPointValue((Double)formatter.stringToValue(text));
                }
                catch (ParseException ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"error parsing spinner", (Throwable)ex);
                    }
                }
            }
        }
        finally {
            this.lockSpinnerChange(false);
        }
    }

    private void featureChanged(double value) {
        try {
            this.lockFeatureChange(true);
            this.setPointValue(value);
        }
        finally {
            this.lockFeatureChange(false);
        }
    }

    private void cidsBeanChanged(double value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("cidsbean changed: " + value), (Throwable)new CurrentStackTrace());
        }
        try {
            this.lockBeanChange(true);
            this.setChangedSinceDrop(true);
            this.setValueToSpinner(value);
            this.setValueToLabel(value);
            this.setValueToFeature(value);
            if (this.isInited() && this.isEditable() && !this.geomHistorisch.isSelected()) {
                this.updateGeometry();
            }
        }
        finally {
            this.lockBeanChange(false);
        }
    }

    private void setValueToLabel(double value) {
        this.getPointValueLabel().setText(Long.toString(Math.round(value)));
    }

    private JLabel getPointValueLabel() {
        return this.lblPointValue;
    }

    private void setValueToSpinner(double value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"change spinner");
        }
        if (!this.isSpinnerChangeLocked()) {
            this.getValueSpinner().setValue(Math.round(value));
        }
    }

    private void setValueToFeature(double value) {
        if (!this.isFeatureChangeLocked()) {
            LinearReferencedPointFeature pointFeature = this.getFeature();
            if (pointFeature != null) {
                pointFeature.setInfoFormat((Format)new DecimalFormat("###"));
                pointFeature.moveToPosition(value);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"there are no feature to move");
            }
        }
    }

    private void updateGeometry() {
        block2: {
            try {
                Geometry geom = LinearReferencedPointFeature.getPointOnLine((double)LinearReferencingHelper.getLinearValueFromStationBean(this.cidsBean), (Geometry)LinearReferencingHelper.getRouteGeometryFromStationBean(this.cidsBean));
                geom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                LinearReferencingHelper.setPointGeometryToStationBean(geom, this.getCidsBean());
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"error while setting the real_pointproperty", (Throwable)ex);
            }
        }
    }

    private void setPointValue(double value) {
        block9: {
            if (this.isEditable()) {
                CidsBean pointBean;
                double oldValue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("change bean value to " + value));
                }
                if ((oldValue = LinearReferencingHelper.getLinearValueFromStationBean(pointBean = this.getCidsBean())) != value) {
                    try {
                        if (!this.isFeatureChangeLocked()) {
                            MAPPING_COMPONENT.getFeatureCollection().select((Feature)this.getFeature());
                        }
                        if (!this.isBeanChangeLocked()) {
                            LinearReferencingHelper.setLinearValueToStationBean(Double.valueOf(Math.round(value)), pointBean);
                        }
                        break block9;
                    }
                    catch (Exception ex) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"error changing bean", (Throwable)ex);
                        }
                        break block9;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("no changes needed, old value was " + oldValue));
                }
            }
        }
    }

    private boolean isSpinnerChangeLocked() {
        return this.isSpinnerChangeLocked;
    }

    private boolean isFeatureChangeLocked() {
        return this.isFeatureChangeLocked;
    }

    private boolean isBeanChangeLocked() {
        return this.isBeanChangeLocked;
    }

    private void lockSpinnerChange(boolean lock) {
        this.isSpinnerChangeLocked = lock;
    }

    private void lockFeatureChange(boolean lock) {
        this.isFeatureChangeLocked = lock;
    }

    private void lockBeanChange(boolean lock) {
        this.isBeanChangeLocked = lock;
    }

    public static Feature createBadGeomFeature(Geometry geom) {
        DefaultStyledFeature dsf = new DefaultStyledFeature();
        dsf.setGeometry(geom);
        dsf.setCanBeSelected(false);
        dsf.setPointAnnotationSymbol(FeatureAnnotationSymbol.newCenteredFeatureAnnotationSymbol((Image)new ImageIcon(StationEditor.class.getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/exclamation-octagon.png")).getImage(), (Image)new ImageIcon(StationEditor.class.getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/exclamation-octagon.png")).getImage()));
        return dsf;
    }

    private void cleanup() {
        CidsBean pointBean = this.getCidsBean();
        if (pointBean != null) {
            pointBean.removePropertyChangeListener(this.getCidsBeanListener());
        }
        if (this.isEditable()) {
            Feature badGeomFeature;
            if (pointBean != null) {
                LinearReferencedPointFeature oldFeature = FEATURE_REGISTRY.removeStationFeature(pointBean);
                if (oldFeature != null) {
                    oldFeature.removeListener(this.getFeatureListener());
                }
                FEATURE_REGISTRY.removeListener(pointBean, this.getMapRegistryListener());
            }
            if ((badGeomFeature = this.getBadGeomFeature()) != null) {
                MAPPING_COMPONENT.getFeatureCollection().removeFeature(badGeomFeature);
                this.setBadGeomFeature(null);
            }
        }
        this.setInited(false);
        if (this.isEditable()) {
            this.showCard(Card.add);
        } else {
            this.setErrorMsg("keine Station zugewiesen");
            this.showCard(Card.error);
        }
    }

    private void init() {
        if (!this.isCrsSupported(CismapBroker.getInstance().getSrs())) {
            this.showCrsNotSupported();
        } else if (!this.isInited()) {
            CidsBean pointBean = this.getCidsBean();
            if (pointBean != null) {
                pointBean.addPropertyChangeListener(this.getCidsBeanListener());
                double pointValue = this.getValue();
                this.setValueToLabel(pointValue);
                this.labGwk.setText(Long.toString(LinearReferencingHelper.getRouteGwkFromStationBean(pointBean)));
                if (this.isEditable()) {
                    this.setValueToFeature(pointValue);
                    this.setValueToSpinner(pointValue);
                    double distance = LinearReferencingHelper.distanceOfStationGeomToRouteGeomFromStationBean(pointBean);
                    if (distance > 1.0) {
                        this.setBadGeomFeature(StationEditor.createBadGeomFeature(LinearReferencingHelper.getPointGeometryFromStationBean(pointBean)));
                    } else {
                        this.setBadGeomFeature(null);
                    }
                    FEATURE_REGISTRY.addListener(pointBean, this.getMapRegistryListener());
                    LinearReferencedPointFeature pointFeature = FEATURE_REGISTRY.addStationFeature(pointBean);
                    if (this.ico != null) {
                        pointFeature.setIconImage(this.ico);
                    }
                    pointFeature.setEditable(true);
                    ((SpinnerNumberModel)this.getValueSpinner().getModel()).setMaximum(Double.valueOf(Math.ceil(pointFeature.getLineGeometry().getLength())));
                    pointFeature.addListener(this.getFeatureListener());
                    this.firePointCreated();
                }
                this.updateBadGeomButton();
                this.updateSplitButton();
                this.showCard(Card.edit);
                this.setInited(true);
            } else if (this.isEditable()) {
                this.showCard(Card.add);
            } else {
                this.setErrorMsg("keine Station zugewiesen");
                this.showCard(Card.error);
            }
        }
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        this.cleanup();
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean);
            this.bindingGroup.bind();
            this.spnPointValue.setEnabled(!this.geomHistorisch.isSelected());
            this.origGeom = LinearReferencingHelper.getPointGeometryFromStationBean(cidsBean);
        }
        this.init();
        this.cidsBeanChanged(this.getValue());
    }

    private void setErrorMsg(String msg) {
        this.lblError.setText(msg);
    }

    private void updateBadGeomButton() {
        boolean visible = this.isEditable() && this.getBadGeomFeature() != null;
        this.getBadGeomButton().setVisible(visible);
        this.getBadGeomCorrectButton().setVisible(visible && this.getBadGeomButton().isSelected());
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void updateSplitButton() {
        if (this.getCidsBean() != null) {
            this.getSplitButton().setVisible(FEATURE_REGISTRY.getCounter(this.getCidsBean()) > 1);
        }
    }

    private void splitPoint() {
        if (this.isEditable()) {
            double oldPosition = this.getFeature().getCurrentPosition();
            CidsBean pointBean = LinearReferencingHelper.createStationBeanFromRouteBean(LinearReferencingHelper.getRouteBeanFromStationBean(this.getCidsBean()));
            this.setCidsBean(pointBean);
            this.getFeature().moveToPosition(oldPosition);
        }
    }

    public void dispose() {
        this.cleanup();
        CismapBroker.getInstance().removeCrsChangeListener(this.getCrsChangeListener());
    }

    public double getValue() {
        if (this.cidsBean != null) {
            return LinearReferencingHelper.getLinearValueFromStationBean(this.cidsBean);
        }
        return 0.0;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panEdit = new JPanel();
        this.spnPointValue = new JSpinner();
        this.jLabel5 = new JLabel();
        this.labGwk = new JLabel();
        this.splitButton = new JButton();
        this.badGeomButton = new JToggleButton();
        this.jPanel2 = new JPanel();
        this.badGeomCorrectButton = new JButton();
        this.jPanel3 = new JPanel();
        this.geomHistorisch = new JToggleButton();
        this.lblPointValue = new JLabel();
        this.lblRoute = new JLabel();
        this.panAdd = new AddPanel();
        this.jLabel3 = new JLabel();
        this.panError = new JPanel();
        this.lblError = new JLabel();
        this.setEnabled(false);
        this.setOpaque(false);
        this.setLayout(new CardLayout());
        this.panEdit.setOpaque(false);
        this.panEdit.setLayout(new GridBagLayout());
        this.spnPointValue.setModel(new SpinnerNumberModel(0.0, 0.0, 0.0, 1.0));
        this.spnPointValue.setEditor(new JSpinner.NumberEditor(this.spnPointValue, "###"));
        this.spnPointValue.setMaximumSize(new Dimension(100, 28));
        this.spnPointValue.setMinimumSize(new Dimension(100, 28));
        this.spnPointValue.setPreferredSize(new Dimension(100, 28));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.panEdit.add((Component)this.spnPointValue, gridBagConstraints);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/station.png")));
        this.jLabel5.setText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEdit.add((Component)this.jLabel5, gridBagConstraints);
        this.labGwk.setHorizontalAlignment(2);
        this.labGwk.setText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.labGwk.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEdit.add((Component)this.labGwk, gridBagConstraints);
        this.splitButton.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/sql-join-left.png")));
        this.splitButton.setText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.splitButton.text"));
        this.splitButton.setToolTipText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.splitButton.toolTipText"));
        this.splitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationEditor.this.splitButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.panEdit.add((Component)this.splitButton, gridBagConstraints);
        this.badGeomButton.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/exclamation.png")));
        this.badGeomButton.setText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.badGeomButton.text"));
        this.badGeomButton.setToolTipText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.badGeomButton.toolTipText"));
        this.badGeomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationEditor.this.badGeomButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.panEdit.add((Component)this.badGeomButton, gridBagConstraints);
        this.jPanel2.setMaximumSize(new Dimension(32, 0));
        this.jPanel2.setMinimumSize(new Dimension(32, 0));
        this.jPanel2.setOpaque(false);
        this.jPanel2.setPreferredSize(new Dimension(32, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panEdit.add((Component)this.jPanel2, gridBagConstraints);
        this.badGeomCorrectButton.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/node-delete.png")));
        this.badGeomCorrectButton.setText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.badGeomCorrectButton.text"));
        this.badGeomCorrectButton.setToolTipText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.badGeomCorrectButton.toolTipText"));
        this.badGeomCorrectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationEditor.this.badGeomCorrectButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.panEdit.add((Component)this.badGeomCorrectButton, gridBagConstraints);
        this.jPanel3.setMaximumSize(new Dimension(32, 0));
        this.jPanel3.setMinimumSize(new Dimension(32, 0));
        this.jPanel3.setOpaque(false);
        this.jPanel3.setPreferredSize(new Dimension(32, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.panEdit.add((Component)this.jPanel3, gridBagConstraints);
        this.geomHistorisch.setText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.geomHistorisch.text", (Object[])new Object[0]));
        this.geomHistorisch.setToolTipText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.geomHistorisch.toolTipText", (Object[])new Object[0]));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.ohne_route}"), (Object)this.geomHistorisch, (Property)BeanProperty.create((String)"selected"));
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        this.geomHistorisch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationEditor.this.geomHistorischActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.panEdit.add((Component)this.geomHistorisch, gridBagConstraints);
        this.lblPointValue.setHorizontalAlignment(11);
        this.lblPointValue.setText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.lblPointValue.text_1"));
        this.lblPointValue.setBorder(BorderFactory.createEtchedBorder());
        this.lblPointValue.setMaximumSize(new Dimension(100, 28));
        this.lblPointValue.setMinimumSize(new Dimension(100, 28));
        this.lblPointValue.setPreferredSize(new Dimension(100, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.panEdit.add((Component)this.lblPointValue, gridBagConstraints);
        this.lblRoute.setHorizontalAlignment(4);
        this.lblRoute.setText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.lblRoute.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.panEdit.add((Component)this.lblRoute, gridBagConstraints);
        this.add((Component)this.panEdit, "edit");
        this.panAdd.setOpaque(false);
        this.panAdd.setLayout(new GridBagLayout());
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.jLabel3.text"));
        this.panAdd.add((Component)this.jLabel3, new GridBagConstraints());
        this.add((Component)this.panAdd, "add");
        this.panError.setOpaque(false);
        this.panError.setLayout(new GridBagLayout());
        this.lblError.setText(NbBundle.getMessage(StationEditor.class, (String)"StationEditor.lblError.text"));
        this.panError.add((Component)this.lblError, new GridBagConstraints());
        this.add((Component)this.panError, "error");
        this.bindingGroup.bind();
    }

    private void splitButtonActionPerformed(ActionEvent evt) {
        this.splitPoint();
    }

    private void badGeomButtonActionPerformed(ActionEvent evt) {
        this.switchBadGeomVisibility();
    }

    private void badGeomCorrectButtonActionPerformed(ActionEvent evt) {
        this.correctBadGeomCorrect();
    }

    private void geomHistorischActionPerformed(ActionEvent evt) {
        this.spnPointValue.setEnabled(!this.geomHistorisch.isSelected());
        if (this.geomHistorisch.isSelected()) {
            try {
                this.origGeom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                LinearReferencingHelper.setPointGeometryToStationBean(this.origGeom, this.getCidsBean());
            }
            catch (Exception e) {
                LOG.error((Object)"Error while setting origin geom", (Throwable)e);
            }
        }
    }

    private void switchBadGeomVisibility() {
        if (this.isEditable()) {
            Feature badGeomFeature = this.getBadGeomFeature();
            LinearReferencedPointFeature pointFeature = this.getFeature();
            boolean selected = this.getBadGeomButton().isSelected();
            if (selected) {
                this.boundingbox = (XBoundingBox)MAPPING_COMPONENT.getCurrentBoundingBox();
                MAPPING_COMPONENT.getFeatureCollection().addFeature(badGeomFeature);
                MAPPING_COMPONENT.getFeatureCollection().select((Feature)pointFeature);
                this.zoomToBadFeature();
            } else {
                MAPPING_COMPONENT.getFeatureCollection().removeFeature(badGeomFeature);
                MAPPING_COMPONENT.gotoBoundingBoxWithoutHistory((BoundingBox)this.boundingbox);
            }
            this.getBadGeomCorrectButton().setVisible(selected);
        }
    }

    private void correctBadGeomCorrect() {
        if (this.isEditable()) {
            LinearReferencedPointFeature feature = this.getFeature();
            Feature badFeature = this.getBadGeomFeature();
            feature.moveTo(badFeature.getGeometry().getCoordinate(), null);
            this.zoomToBadFeature();
        }
    }

    private void zoomToBadFeature() {
        Feature badGeomFeature = this.getBadGeomFeature();
        ArrayList<Object> aFeatureCollection = new ArrayList<Object>();
        aFeatureCollection.add(badGeomFeature);
        aFeatureCollection.add(this.getFeature());
        MAPPING_COMPONENT.zoomToAFeatureCollection(aFeatureCollection, false, MAPPING_COMPONENT.isFixedMapScale());
    }

    public Collection<Feature> getZoomFeatures() {
        ArrayList<Feature> zoomFeatures = new ArrayList<Feature>();
        this.addZoomFeaturesToCollection(zoomFeatures);
        return zoomFeatures;
    }

    public void addZoomFeaturesToCollection(Collection<Feature> collection) {
        LinearReferencedPointFeature pointFeature = this.getFeature();
        if (pointFeature != null) {
            PureNewFeature boundedFeature = new PureNewFeature(pointFeature.getGeometry().buffer(500.0));
            collection.add((Feature)boundedFeature);
        }
    }

    private double getPointInCurrentBB(CidsBean routeBean) {
        XBoundingBox boundingBox = (XBoundingBox)MAPPING_COMPONENT.getCurrentBoundingBox();
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(boundingBox.getX1(), boundingBox.getY1()));
        coordinates.add(new Coordinate(boundingBox.getX2(), boundingBox.getY1()));
        coordinates.add(new Coordinate(boundingBox.getX2(), boundingBox.getY2()));
        coordinates.add(new Coordinate(boundingBox.getX1(), boundingBox.getY2()));
        coordinates.add(new Coordinate(boundingBox.getX1(), boundingBox.getY1()));
        GeometryFactory gf = new GeometryFactory();
        LinearRing shell = gf.createLinearRing(coordinates.toArray(new Coordinate[coordinates.size()]));
        Polygon boundingBoxGeom = gf.createPolygon(shell, new LinearRing[0]);
        Geometry routeGeom = (Geometry)routeBean.getProperty("geom.geo_field");
        Geometry pointZero = LinearReferencedPointFeature.getPointOnLine((double)0.0, (Geometry)routeGeom);
        if (pointZero.within((Geometry)boundingBoxGeom)) {
            return 0.0;
        }
        LineString boundingBoxLineGeom = gf.createLineString(coordinates.toArray(new Coordinate[coordinates.size()]));
        double bestPosition = 0.0;
        Geometry intersectionGeom = routeGeom.intersection((Geometry)boundingBoxLineGeom);
        for (Coordinate coord : intersectionGeom.getCoordinates()) {
            double position = LinearReferencedPointFeature.getPositionOnLine((Coordinate)coord, (Geometry)routeGeom);
            if (bestPosition == 0.0) {
                bestPosition = position;
                continue;
            }
            if (!(position < bestPosition)) continue;
            bestPosition = position;
        }
        return bestPosition;
    }

    class AddPanel
    extends JPanel
    implements CidsBeanDropListener {
        AddPanel() {
        }

        public void beansDropped(ArrayList<CidsBean> beans) {
            if (StationEditor.this.isEditable()) {
                CidsBean routeBean = null;
                for (CidsBean bean : beans) {
                    if (!bean.getMetaObject().getMetaClass().getName().equals("route")) continue;
                    if (StationEditor.this.getDropBehavior() == null || StationEditor.this.getDropBehavior().checkForAdding(routeBean)) {
                        routeBean = bean;
                        StationEditor.this.setChangedSinceDrop(false);
                    }
                    double value = 0.0;
                    if (StationEditor.this.isFirstStationInCurrentBB()) {
                        value = StationEditor.this.getPointInCurrentBB(routeBean);
                    }
                    StationEditor.this.setCidsBean(LinearReferencingHelper.createStationBeanFromRouteBean(routeBean, value));
                    if (StationEditor.this.isAutoZoomActivated) {
                        MapUtil.zoomToFeatureCollection(StationEditor.this.getZoomFeatures());
                    }
                    return;
                }
                if (LinearReferencingSingletonInstances.LOG.isDebugEnabled()) {
                    LinearReferencingSingletonInstances.LOG.debug((Object)"no route found in dropped objects");
                }
            }
        }
    }

    private static enum Card {
        edit,
        add,
        error;

    }
}

