/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupUmlandnutzungEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.LinearReferencedLineEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.VermessungBandElementEditor;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.LineBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.MassnBezugListListener;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.StationLineBackup;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.UmlandnutzungRWBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.UmlandnutzungRWBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.VermessungsbandHelper;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.VermessungsbandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.WKBand;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingHelper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.jbands.BandModelEvent;
import de.cismet.tools.gui.jbands.JBand;
import de.cismet.tools.gui.jbands.SimpleBandModel;
import de.cismet.tools.gui.jbands.interfaces.Band;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandModel;
import de.cismet.tools.gui.jbands.interfaces.BandModelListener;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.observablecollections.ObservableList;
import org.jdesktop.observablecollections.ObservableListListener;
import org.openide.util.NbBundle;

public class UmlandnutzungRouteEditor
extends JPanel
implements CidsBeanRenderer,
FooterComponentProvider,
EditorSaveListener {
    private static final String COLLECTION_PROPERTY = "umlandnutzung";
    private static final Logger LOG = Logger.getLogger(UmlandnutzungRouteEditor.class);
    private static final String GUP_UMLANDNUTZUNG = "gup_umlandnutzung";
    private final UmlandnutzungRWBand umlandnutzung_links = new UmlandnutzungRWBand("Umlandnutzung links", "gup_umlandnutzung");
    private final UmlandnutzungRWBand umlandnutzung_rechts = new UmlandnutzungRWBand("Umlandnutzung rechts", "gup_umlandnutzung");
    private List<CidsBean> rechtesUferList = new ArrayList<CidsBean>();
    private List<CidsBean> linkesUferList = new ArrayList<CidsBean>();
    private WKBand wkband;
    private final JBand jband;
    private final VermessungBandElementEditor vermessungsEditor = new VermessungBandElementEditor();
    private VermessungsbandHelper vermessungsband;
    private final BandModelListener modelListener = new UmlandnutzungBandModelListener();
    private final SimpleBandModel sbm = new SimpleBandModel();
    private CidsBean cidsBean;
    private GupUmlandnutzungEditor umlandnutzungEditor;
    private boolean readOnly = false;
    private final StationLineBackup stationBackup = new StationLineBackup("linie");
    private boolean isNew = false;
    private ButtonGroup bgrpDetails;
    private JToggleButton butStationierung;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JButton jbApply;
    private JButton jbApply1;
    private JLabel lblFoot;
    private JLabel lblHeading;
    private JLabel lblSubTitle;
    private LinearReferencedLineEditor linearReferencedLineEditor;
    private JPanel panApply;
    private JPanel panApplyBand;
    private JPanel panBand;
    private JPanel panControls;
    private JPanel panEmpty;
    private JPanel panFooter;
    private SemiRoundedPanel panHeadInfo;
    private JPanel panHeader;
    private JPanel panHeaderInfo;
    private RoundedPanel panInfo;
    private JPanel panInfoContent;
    private JPanel panNew;
    private JPanel panUmlandnutzung;
    private JPanel panVermessung;
    private JSlider sldZoom;
    private JToggleButton togApplyStats;

    public UmlandnutzungRouteEditor() {
        this(false);
    }

    public UmlandnutzungRouteEditor(boolean readOnly) {
        this.readOnly = readOnly;
        this.jband = new JBand(readOnly);
        this.initComponents();
        this.umlandnutzungEditor = new GupUmlandnutzungEditor(readOnly);
        this.umlandnutzung_rechts.setReadOnly(readOnly);
        this.umlandnutzung_rechts.setSide(1);
        this.sbm.addBand((Band)this.umlandnutzung_rechts);
        this.umlandnutzung_links.setReadOnly(readOnly);
        this.umlandnutzung_links.setSide(2);
        this.sbm.addBand((Band)this.umlandnutzung_links);
        this.panVermessung.add((Component)this.vermessungsEditor, "Center");
        this.jband.setModel((BandModel)this.sbm);
        this.panBand.add((Component)this.jband, "Center");
        this.jband.setHorizontalScrollBarPolicy(32);
        this.switchToForm("empty");
        this.lblHeading.setText("Allgemeine Informationen");
        this.panUmlandnutzung.add((Component)this.umlandnutzungEditor, "Center");
        this.sbm.addBandModelListener(this.modelListener);
        this.sldZoom.setPaintTrack(false);
        if (!readOnly) {
            this.vermessungsband = new VermessungsbandHelper(this.jband, this.modelListener, this.panBand, this.panApplyBand, this.panApply, this.togApplyStats);
        } else {
            this.togApplyStats.setVisible(false);
        }
    }

    private void switchToForm(final String id) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ((CardLayout)UmlandnutzungRouteEditor.this.panInfoContent.getLayout()).show(UmlandnutzungRouteEditor.this.panInfoContent, id);
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cidsBean = cidsBean;
        this.switchToForm("empty");
        this.lblHeading.setText("");
        if (cidsBean != null) {
            if (!this.readOnly) {
                this.vermessungsband.setCidsBean(cidsBean);
            }
            boolean bl = this.isNew = cidsBean.getProperty("linie") == null;
            if (cidsBean.getProperty("linie") == null) {
                this.panBand.removeAll();
                this.panBand.add((Component)this.panNew, "Center");
                this.linearReferencedLineEditor.setLineField("linie");
                this.linearReferencedLineEditor.setCidsBean(cidsBean);
            } else {
                this.setNamesAndBands();
            }
        }
    }

    private void setNamesAndBands() {
        CidsBean route = LinearReferencingHelper.getRouteBeanFromStationBean((CidsBean)this.cidsBean.getProperty("linie.von"));
        double from = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty("linie.von"));
        double till = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty("linie.bis"));
        this.sbm.setMin(from);
        this.sbm.setMax(till);
        this.wkband = new WKBand(from, till);
        if (!this.readOnly) {
            this.vermessungsband.setVwkBand(new WKBand(this.sbm.getMin(), this.sbm.getMax()));
        }
        this.jband.setMinValue(from);
        this.jband.setMaxValue(till);
        this.umlandnutzung_links.setRoute(route);
        this.umlandnutzung_rechts.setRoute(route);
        List all = this.cidsBean.getBeanCollectionProperty(COLLECTION_PROPERTY);
        this.rechtesUferList = new ArrayList<CidsBean>();
        this.linkesUferList = new ArrayList<CidsBean>();
        for (CidsBean tmp : all) {
            Integer kind = (Integer)tmp.getProperty("wo.id");
            switch (kind) {
                case 2: {
                    this.linkesUferList.add(tmp);
                    break;
                }
                case 1: {
                    this.rechtesUferList.add(tmp);
                }
            }
        }
        this.rechtesUferList = ObservableCollections.observableList(this.rechtesUferList);
        this.linkesUferList = ObservableCollections.observableList(this.linkesUferList);
        ((ObservableList)this.rechtesUferList).addObservableListListener((ObservableListListener)new MassnBezugListListener(1, this.cidsBean, COLLECTION_PROPERTY));
        ((ObservableList)this.linkesUferList).addObservableListListener((ObservableListListener)new MassnBezugListListener(2, this.cidsBean, COLLECTION_PROPERTY));
        this.umlandnutzung_rechts.setCidsBeans(this.rechtesUferList);
        this.umlandnutzung_links.setCidsBeans(this.linkesUferList);
        String rname = String.valueOf(route.getProperty("routenname"));
        this.lblSubTitle.setText(rname + " [" + (int)this.sbm.getMin() + "," + (int)this.sbm.getMax() + "]");
        this.wkband.fillAndInsertBand(this.sbm, String.valueOf(route.getProperty("gwk")), this.jband, this.vermessungsband);
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void initComponents() {
        this.panFooter = new JPanel();
        this.lblFoot = new JLabel();
        this.bgrpDetails = new ButtonGroup();
        this.panNew = new JPanel();
        this.linearReferencedLineEditor = new LinearReferencedLineEditor();
        this.jbApply = new JButton();
        this.panApply = new JPanel();
        this.jbApply1 = new JButton();
        this.panApplyBand = new JPanel();
        this.panInfo = new RoundedPanel();
        this.panHeadInfo = new SemiRoundedPanel();
        this.lblHeading = new JLabel();
        this.panInfoContent = new JPanel();
        this.panUmlandnutzung = new JPanel();
        this.panEmpty = new JPanel();
        this.panVermessung = new JPanel();
        this.panHeader = new JPanel();
        this.panHeaderInfo = new JPanel();
        this.jLabel3 = new JLabel();
        this.lblSubTitle = new JLabel();
        this.jLabel5 = new JLabel();
        this.sldZoom = new JSlider();
        this.panControls = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.panBand = new JPanel();
        this.jPanel5 = new JPanel();
        this.butStationierung = new JToggleButton();
        this.togApplyStats = new JToggleButton();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.panFooter.setMinimumSize(new Dimension(1050, 48));
        this.panFooter.setOpaque(false);
        this.panFooter.setPreferredSize(new Dimension(1050, 48));
        this.panFooter.setLayout(new GridBagLayout());
        this.lblFoot.setFont(new Font("Tahoma", 1, 12));
        this.lblFoot.setForeground(new Color(255, 255, 255));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 25, 7, 25);
        this.panFooter.add((Component)this.lblFoot, gridBagConstraints);
        this.panNew.setOpaque(false);
        this.panNew.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panNew.add((Component)this.linearReferencedLineEditor, gridBagConstraints);
        this.jbApply.setText(NbBundle.getMessage(UmlandnutzungRouteEditor.class, (String)"GupGewaesserabschnitt"));
        this.jbApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UmlandnutzungRouteEditor.this.jbApplyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panNew.add((Component)this.jbApply, gridBagConstraints);
        this.panApply.setOpaque(false);
        this.panApply.setLayout(new GridBagLayout());
        this.jbApply1.setText(NbBundle.getMessage(UmlandnutzungRouteEditor.class, (String)"GupGewaesserabschnitt"));
        this.jbApply1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UmlandnutzungRouteEditor.this.jbApply1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(25, 5, 5, 5);
        this.panApply.add((Component)this.jbApply1, gridBagConstraints);
        this.panApplyBand.setOpaque(false);
        this.panApplyBand.setPreferredSize(new Dimension(300, 100));
        this.panApplyBand.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.panApply.add((Component)this.panApplyBand, gridBagConstraints);
        this.setMinimumSize(new Dimension(1050, 700));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(1050, 700));
        this.setLayout(new GridBagLayout());
        this.panInfo.setMinimumSize(new Dimension(640, 310));
        this.panInfo.setPreferredSize(new Dimension(640, 310));
        this.panHeadInfo.setBackground(new Color(51, 51, 51));
        this.panHeadInfo.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading.setForeground(new Color(255, 255, 255));
        this.lblHeading.setText("Informationen");
        this.panHeadInfo.add((Component)this.lblHeading);
        this.panInfo.add((Component)this.panHeadInfo, (Object)"North");
        this.panInfoContent.setOpaque(false);
        this.panInfoContent.setLayout(new CardLayout());
        this.panUmlandnutzung.setOpaque(false);
        this.panUmlandnutzung.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panUmlandnutzung, COLLECTION_PROPERTY);
        this.panEmpty.setOpaque(false);
        this.panEmpty.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panEmpty, "empty");
        this.panVermessung.setOpaque(false);
        this.panVermessung.setLayout(new BorderLayout());
        this.panInfoContent.add((Component)this.panVermessung, "vermessung");
        this.panInfo.add((Component)this.panInfoContent, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.add((Component)this.panInfo, gridBagConstraints);
        this.panHeader.setOpaque(false);
        this.panHeader.setLayout(new GridBagLayout());
        this.panHeaderInfo.setMinimumSize(new Dimension(531, 102));
        this.panHeaderInfo.setOpaque(false);
        this.panHeaderInfo.setPreferredSize(new Dimension(531, 102));
        this.panHeaderInfo.setLayout(null);
        this.jLabel3.setFont(new Font("Lucida Grande", 0, 18));
        this.jLabel3.setText("Gew\u00e4sser:");
        this.jLabel3.setMinimumSize(new Dimension(91, 22));
        this.panHeaderInfo.add(this.jLabel3);
        this.jLabel3.setBounds(12, 40, 92, 22);
        this.lblSubTitle.setFont(new Font("Lucida Grande", 0, 18));
        this.lblSubTitle.setText("Warnow KM 0 - 4711");
        this.panHeaderInfo.add(this.lblSubTitle);
        this.lblSubTitle.setBounds(110, 40, 350, 22);
        this.jLabel5.setFont(new Font("Lucida Sans", 0, 18));
        this.jLabel5.setText("Zoom:");
        this.jLabel5.setMaximumSize(new Dimension(92, 22));
        this.jLabel5.setMinimumSize(new Dimension(92, 22));
        this.jLabel5.setPreferredSize(new Dimension(92, 22));
        this.panHeaderInfo.add(this.jLabel5);
        this.jLabel5.setBounds(12, 68, 80, 20);
        this.sldZoom.setMaximum(200);
        this.sldZoom.setValue(0);
        this.sldZoom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                UmlandnutzungRouteEditor.this.sldZoomStateChanged(evt);
            }
        });
        this.panHeaderInfo.add(this.sldZoom);
        this.sldZoom.setBounds(110, 72, 350, 16);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        this.panHeader.add((Component)this.panHeaderInfo, gridBagConstraints);
        this.panControls.setOpaque(false);
        this.panControls.setLayout(new GridBagLayout());
        this.jPanel1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panControls.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panControls.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel4.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.panControls.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 24;
        this.panHeader.add((Component)this.panControls, gridBagConstraints);
        this.panBand.setOpaque(false);
        this.panBand.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panHeader.add((Component)this.panBand, gridBagConstraints);
        this.jPanel5.setOpaque(false);
        this.jPanel5.setLayout(new GridBagLayout());
        this.butStationierung.setText("Stationierung");
        this.butStationierung.setPreferredSize(new Dimension(117, 25));
        this.butStationierung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UmlandnutzungRouteEditor.this.butStationierungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(37, 12, 38, 0);
        this.jPanel5.add((Component)this.butStationierung, gridBagConstraints);
        this.togApplyStats.setText("Vermessen");
        this.togApplyStats.setPreferredSize(new Dimension(117, 25));
        this.togApplyStats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UmlandnutzungRouteEditor.this.togApplyStatsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 7);
        this.jPanel5.add((Component)this.togApplyStats, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.panHeader.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panHeader, gridBagConstraints);
        this.jPanel3.setMinimumSize(new Dimension(1050, 1));
        this.jPanel3.setOpaque(false);
        this.jPanel3.setPreferredSize(new Dimension(1050, 1));
        this.jLabel4.setMaximumSize(new Dimension(1050, 1));
        this.jLabel4.setMinimumSize(new Dimension(1050, 1));
        this.jLabel4.setPreferredSize(new Dimension(1050, 1));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1050, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 5, Short.MAX_VALUE).addComponent(this.jLabel4, -2, 1040, -2).addGap(0, 5, Short.MAX_VALUE))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel4, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    private void sldZoomStateChanged(ChangeEvent evt) {
        double zoom = (double)this.sldZoom.getValue() / 10.0;
        this.jband.setZoomFactor(zoom);
        if (this.vermessungsband != null) {
            this.vermessungsband.setZoomFactor(zoom);
        }
    }

    private void jbApplyActionPerformed(ActionEvent evt) {
        if (this.isNew) {
            this.panBand.removeAll();
            this.panBand.add((Component)this.jband, "Center");
            this.setNamesAndBands();
            this.linearReferencedLineEditor.dispose();
            if (!this.readOnly) {
                this.vermessungsband.showRoute();
                this.togApplyStats.setEnabled(true);
            }
            this.isNew = false;
        } else {
            int resp = JOptionPane.showConfirmDialog(this, "Ziele, die nicht mehr innerhalb des Routenabschnitts liegen, werden entfernt.", "Achtung", 2);
            if (resp == 0) {
                Integer routeId = (Integer)LinearReferencingHelper.getRouteBeanFromStationBean((CidsBean)this.cidsBean.getProperty("linie.von")).getProperty("id");
                double from = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty("linie.von"));
                double till = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty("linie.bis"));
                List all = this.cidsBean.getBeanCollectionProperty(COLLECTION_PROPERTY);
                this.stationBackup.cutSubobjects(all, from, till, routeId);
                this.panBand.removeAll();
                this.panBand.add((Component)this.jband, "Center");
                this.repaint();
                this.sbm.removeBand((Band)this.wkband);
                this.vermessungsband.reset();
                this.butStationierung.setSelected(!this.butStationierung.isSelected());
                this.setNamesAndBands();
                this.linearReferencedLineEditor.dispose();
                if (!this.readOnly) {
                    this.vermessungsband.showRoute();
                    this.togApplyStats.setEnabled(true);
                }
            }
        }
    }

    private void togApplyStatsActionPerformed(ActionEvent evt) {
        if (this.togApplyStats.isSelected()) {
            if (this.isNew) {
                this.vermessungsband.savePositions();
                this.jbApplyActionPerformed(null);
                this.vermessungsband.showVermessungsbandFromSavedPositions();
                if (this.butStationierung.isSelected()) {
                    this.butStationierung.setSelected(false);
                }
            } else {
                this.vermessungsband.showVermessungsband();
                if (this.butStationierung.isSelected()) {
                    this.butStationierung.setSelected(false);
                    this.stationBackup.restoreStationValues(this.cidsBean);
                }
            }
        } else {
            this.vermessungsband.hideVermessungsband();
        }
        this.updateUI();
        this.repaint();
    }

    private void jbApply1ActionPerformed(ActionEvent evt) {
        LineBand[] bands = new UmlandnutzungRWBand[]{this.umlandnutzung_links, this.umlandnutzung_rechts};
        this.vermessungsband.applyStats(this, bands, GUP_UMLANDNUTZUNG);
        this.updateUI();
        this.repaint();
    }

    private void butStationierungActionPerformed(ActionEvent evt) {
        if (this.butStationierung.isSelected()) {
            this.panBand.removeAll();
            this.panBand.add((Component)this.panNew, "Center");
            if (this.togApplyStats.isSelected()) {
                this.togApplyStats.setSelected(false);
            }
            this.stationBackup.save(this.cidsBean);
            this.linearReferencedLineEditor.setLineField("linie");
            this.linearReferencedLineEditor.setOtherLinesEnabled(false);
            this.linearReferencedLineEditor.setCidsBean(this.cidsBean);
            this.repaint();
        } else {
            this.stationBackup.restoreStationValues(this.cidsBean);
            this.panBand.removeAll();
            this.panBand.add((Component)this.jband, "Center");
            this.repaint();
        }
    }

    public void dispose() {
        this.umlandnutzungEditor.dispose();
        this.vermessungsEditor.dispose();
        if (!this.readOnly) {
            this.vermessungsband.dispose();
        }
        this.linearReferencedLineEditor.dispose();
        this.sbm.removeBandModelListener(this.modelListener);
        this.jband.dispose();
    }

    public String getTitle() {
        return this.cidsBean.toString();
    }

    public void setTitle(String title) {
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    public static void main(String[] args) throws Exception {
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost((String)"WRRL_DB_MV", (String)"Administratoren", (String)"admin", (String)"x", (String)"gup_gewaesserabschnitt", (int)1, (int)1280, (int)1024);
    }

    public void editorClosed(EditorClosedEvent event) {
        this.linearReferencedLineEditor.editorClosed(event);
        this.vermessungsband.editorClosed(event);
    }

    public boolean prepareForSave() {
        return this.linearReferencedLineEditor.prepareForSave();
    }

    class UmlandnutzungBandModelListener
    implements BandModelListener {
        UmlandnutzungBandModelListener() {
        }

        public void bandModelChanged(BandModelEvent e) {
        }

        public void bandModelSelectionChanged(BandModelEvent e) {
            BandMember bm;
            if (UmlandnutzungRouteEditor.this.togApplyStats.isSelected()) {
                bm = UmlandnutzungRouteEditor.this.vermessungsband.getSelectedMember();
                UmlandnutzungRouteEditor.this.vermessungsband.setRefreshAvoided(true);
            } else {
                bm = UmlandnutzungRouteEditor.this.jband.getSelectedBandMember();
                UmlandnutzungRouteEditor.this.jband.setRefreshAvoided(true);
            }
            UmlandnutzungRouteEditor.this.umlandnutzungEditor.dispose();
            if (bm != null) {
                UmlandnutzungRouteEditor.this.bgrpDetails.clearSelection();
                UmlandnutzungRouteEditor.this.switchToForm("empty");
                UmlandnutzungRouteEditor.this.lblHeading.setText("");
                if (bm instanceof UmlandnutzungRWBandMember) {
                    UmlandnutzungRouteEditor.this.switchToForm(UmlandnutzungRouteEditor.COLLECTION_PROPERTY);
                    UmlandnutzungRouteEditor.this.lblHeading.setText("Umlandnutzung");
                    UmlandnutzungRWBand band = (UmlandnutzungRWBand)((UmlandnutzungRWBandMember)bm).getParentBand();
                    List<CidsBean> otherBeans = band.getSide() == 1 ? CidsBeanSupport.getBeanCollectionFromProperty(UmlandnutzungRouteEditor.this.cidsBean, "umlandnutzung_rechts") : CidsBeanSupport.getBeanCollectionFromProperty(UmlandnutzungRouteEditor.this.cidsBean, "umlandnutzung_links");
                    UmlandnutzungRouteEditor.this.umlandnutzungEditor.setOthers(otherBeans);
                    UmlandnutzungRouteEditor.this.umlandnutzungEditor.setCidsBean(((UmlandnutzungRWBandMember)bm).getCidsBean());
                } else if (bm instanceof VermessungsbandMember) {
                    UmlandnutzungRouteEditor.this.switchToForm("vermessung");
                    UmlandnutzungRouteEditor.this.lblHeading.setText("Vermessungselement");
                    List<CidsBean> others = UmlandnutzungRouteEditor.this.vermessungsband.getAllMembers();
                    UmlandnutzungRouteEditor.this.vermessungsEditor.setOthers(others);
                    UmlandnutzungRouteEditor.this.vermessungsEditor.setCidsBean(((VermessungsbandMember)bm).getCidsBean());
                }
            } else {
                UmlandnutzungRouteEditor.this.switchToForm("empty");
                UmlandnutzungRouteEditor.this.lblHeading.setText("");
            }
            if (UmlandnutzungRouteEditor.this.togApplyStats.isSelected()) {
                UmlandnutzungRouteEditor.this.vermessungsband.setRefreshAvoided(false);
                UmlandnutzungRouteEditor.this.vermessungsband.bandModelChanged();
            } else {
                UmlandnutzungRouteEditor.this.jband.setRefreshAvoided(false);
                UmlandnutzungRouteEditor.this.jband.bandModelChanged(null);
            }
        }

        public void bandModelValuesChanged(BandModelEvent e) {
        }
    }
}

