/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import de.cismet.cids.custom.objecteditors.wrrl_db_mv.WasserkoerperLabel;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.GUPTableModel;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.log4j.Logger;

public class Unterhaltungsabschnittsfeld
extends JPanel
implements MouseListener,
ActionListener,
CidsBeanDropListener {
    private static final Logger LOG = Logger.getLogger(Unterhaltungsabschnittsfeld.class);
    final JRadioButton normalScale = new JRadioButton("normal");
    final JRadioButton logScale = new JRadioButton("logarithmisch");
    private ButtonGroup scaleGroup = new ButtonGroup();
    private final JPanel controlPanel = new JPanel();
    private List<ActionListener> actionListener = new ArrayList<ActionListener>();
    private List<CidsBeanDropListener> cidsBeanDropListener = new ArrayList<CidsBeanDropListener>();
    private HashMap<JComponent, ComponentInformation> componentActionTextMap = new HashMap();
    private GUPTableModel model;

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.normalScale.addActionListener(this);
        this.logScale.addActionListener(this);
        this.scaleGroup.add(this.normalScale);
        this.scaleGroup.add(this.logScale);
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Unterhaltungsabschnittsfeld.createGridBagConstraint(0, 0, 0.0, 0.0, 1, 0);
        this.controlPanel.add((Component)this.normalScale, gridBagConstraints);
        gridBagConstraints = Unterhaltungsabschnittsfeld.createGridBagConstraint(1, 0, 1.0, 0.0, 1, 0);
        gridBagConstraints.anchor = 17;
        this.controlPanel.add((Component)this.logScale, gridBagConstraints);
        gridBagConstraints = Unterhaltungsabschnittsfeld.createGridBagConstraint(0, 0, 0.0, 0.0, 2, 2);
        this.add((Component)this.controlPanel, gridBagConstraints);
        this.scaleGroup.setSelected(this.normalScale.getModel(), true);
        if (this.model.showVerticalHeader()) {
            for (int i = 0; i < this.model.getRows(); ++i) {
                JComponent wkLab = this.model.getVerticalHeader(i);
                gridBagConstraints = Unterhaltungsabschnittsfeld.createGridBagConstraint(0, i + 1, 0.0, 0.0, 1, 2);
                this.add((Component)wkLab, gridBagConstraints);
            }
        }
        for (int row = 0; row < this.model.getRows(); ++row) {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            int cols = this.model.getCols(row);
            for (int col = 0; col < cols; ++col) {
                JComponent comp = this.model.getValue(col, row);
                gridBagConstraints = this.model.getConstraint(col, row);
                this.componentActionTextMap.put(comp, new ComponentInformation(col, row, gridBagConstraints));
                comp.addMouseListener(this);
                comp.setMinimumSize(new Dimension(1, 1));
                panel.add((Component)comp, gridBagConstraints);
            }
            gridBagConstraints = Unterhaltungsabschnittsfeld.createGridBagConstraint(1, row + 1, 1.0, this.model.getRowWeight(row), 1, 1);
            this.add((Component)panel, gridBagConstraints);
        }
    }

    private void refreshScale() {
        for (JComponent tmp : this.componentActionTextMap.keySet()) {
            ComponentInformation cp = this.componentActionTextMap.get(tmp);
            double weight = this.scaleGroup.getSelection() == this.logScale.getModel() ? this.model.getWeight(cp.getX(), cp.getY(), true) : this.model.getWeight(cp.getX(), cp.getY(), false);
            System.out.println("weight: " + weight);
            cp.getConstraints().weightx = weight;
            Container c = tmp.getParent();
            c.remove(tmp);
            c.add((Component)tmp, cp.getConstraints());
        }
        this.validate();
    }

    private static GridBagConstraints createGridBagConstraint(int gridx, int gridy, double weightx, double weighty, int gridwidth, int fill) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.fill = fill;
        gridBagConstraints.weightx = weightx;
        gridBagConstraints.weighty = weighty;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = gridwidth;
        return gridBagConstraints;
    }

    public void setModel(GUPTableModel model) {
        this.model = model;
        this.init();
    }

    public void refresh() {
        Component[] comps;
        for (Component tmp : comps = this.getComponents()) {
            this.remove(tmp);
        }
        this.init();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new GridLayout(1, 1));
        Unterhaltungsabschnittsfeld uaf = new Unterhaltungsabschnittsfeld();
        uaf.setModel(new GUPTableModel(){
            final List<WkUnterhaltung> l = new ArrayList<WkUnterhaltung>();
            {
                WasserkoerperLabel wkLab = new WasserkoerperLabel();
                wkLab.setWKName("NAM-200");
                ArrayList<Double> uasLaenge = new ArrayList<Double>();
                uasLaenge.add(100.0);
                uasLaenge.add(2.0);
                uasLaenge.add(4000.0);
                uasLaenge.add(300.0);
                uasLaenge.add(350.0);
                uasLaenge.add(210.0);
                uasLaenge.add(180.0);
                uasLaenge.add(230.0);
                uasLaenge.add(360.0);
                uasLaenge.add(400.0);
                uasLaenge.add(120.0);
                uasLaenge.add(50.0);
                ArrayList<JLabel> uas = new ArrayList<JLabel>();
                JLabel tmp = new JLabel();
                tmp.setText("ua-1");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-2");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-3");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-6");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-7");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-8");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-9");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-10");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-11");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-12");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-13");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-14");
                uas.add(tmp);
                WkUnterhaltung wk = new WkUnterhaltung(wkLab, uas, uasLaenge);
                this.l.add(wk);
                uasLaenge = new ArrayList();
                uasLaenge.add(150.0);
                uasLaenge.add(200.0);
                uasLaenge.add(250.0);
                uasLaenge.add(300.0);
                uasLaenge.add(400.0);
                uasLaenge.add(230.0);
                uasLaenge.add(100.0);
                uasLaenge.add(80.0);
                uas = new ArrayList();
                tmp = new JLabel();
                tmp.setText("ua-4");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-5");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-15");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-16");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-17");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-18");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-19");
                uas.add(tmp);
                tmp = new JLabel();
                tmp.setText("ua-20");
                uas.add(tmp);
                wkLab = new WasserkoerperLabel();
                wkLab.setWKName("OTOL-200");
                wk = new WkUnterhaltung(wkLab, uas, uasLaenge);
                this.l.add(wk);
            }

            @Override
            public JComponent getValue(int x, int y) {
                if (y == 0) {
                    WasserkoerperLabel res = this.l.get(x).getWkLab();
                    this.confSize(res);
                    return res;
                }
                if (y == 1) {
                    int n = 0;
                    for (WkUnterhaltung tmp : this.l) {
                        if (tmp.getUnterhaltungsabschnitte().size() > x - n) {
                            JLabel res = tmp.getUnterhaltungsabschnitte().get(x - n);
                            res.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
                            res.setText("<html>&nbsp;</html>");
                            this.confSize(res);
                            return res;
                        }
                        n += tmp.getUnterhaltungsabschnitte().size();
                    }
                    return null;
                }
                return null;
            }

            @Override
            public int getRows() {
                return 2;
            }

            @Override
            public int getCols(int row) {
                if (row == 0) {
                    return this.l.size();
                }
                int n = 0;
                for (WkUnterhaltung tmp : this.l) {
                    n += tmp.getUnterhaltungsabschnitte().size();
                }
                return n;
            }

            @Override
            public double getWeight(int x, int y, boolean log) {
                double result;
                block4: {
                    block5: {
                        result = 0.0;
                        if (y != 0) break block5;
                        List<Double> lengths = this.l.get(x).getUnterhaltungsabschnitteLaenge();
                        for (Double tmp : lengths) {
                            if (log) {
                                result += Math.log10(tmp);
                                continue;
                            }
                            result += tmp.doubleValue();
                        }
                        break block4;
                    }
                    if (y != 1) break block4;
                    int n = 0;
                    for (WkUnterhaltung tmp : this.l) {
                        if (tmp.getUnterhaltungsabschnitteLaenge().size() > x - n) {
                            result = log ? Math.log10(tmp.getUnterhaltungsabschnitteLaenge().get(x - n)) : tmp.getUnterhaltungsabschnitteLaenge().get(x - n);
                            break;
                        }
                        n += tmp.getUnterhaltungsabschnitteLaenge().size();
                    }
                }
                return result;
            }

            private void confSize(JComponent comp) {
                Dimension d = new Dimension(1, 20);
                comp.setPreferredSize(d);
                comp.setMinimumSize(d);
                comp.setMaximumSize(d);
                comp.setSize(0, 0);
            }

            @Override
            public GridBagConstraints getConstraint(int x, int y) {
                return Unterhaltungsabschnittsfeld.createGridBagConstraint(x, 0, this.getWeight(x, y, false), y != 0 ? 1 : 0, 1, y == 0 ? 2 : 1);
            }

            @Override
            public double getRowWeight(int row) {
                return row;
            }

            @Override
            public JComponent getVerticalHeader(int row) {
                if (row == 0) {
                    JLabel lab = new JLabel("WK:");
                    lab.setSize(20, 20);
                    return lab;
                }
                JLabel lab = new JLabel("UA:");
                lab.setSize(20, 20);
                return lab;
            }

            @Override
            public boolean showVerticalHeader() {
                return true;
            }

            @Override
            public boolean fullScreen() {
                return false;
            }

            class WkUnterhaltung {
                private WasserkoerperLabel wkLab;
                private List<JLabel> unterhaltungsabschnitte;
                private List<Double> unterhaltungsabschnitteLaenge;

                public WkUnterhaltung(WasserkoerperLabel wkLab, List<JLabel> unterhaltungsabschnitte, List<Double> unterhaltungsabschnitteLaenge) {
                    this.wkLab = wkLab;
                    this.unterhaltungsabschnitte = unterhaltungsabschnitte;
                    this.unterhaltungsabschnitteLaenge = unterhaltungsabschnitteLaenge;
                }

                public void addUnterhaltungsabschnitt(JLabel unterhaltungsabschnitt) {
                    this.getUnterhaltungsabschnitte().add(unterhaltungsabschnitt);
                }

                public WasserkoerperLabel getWkLab() {
                    return this.wkLab;
                }

                public List<JLabel> getUnterhaltungsabschnitte() {
                    return this.unterhaltungsabschnitte;
                }

                public List<Double> getUnterhaltungsabschnitteLaenge() {
                    return this.unterhaltungsabschnitteLaenge;
                }

                private void normalizeWeights() {
                    double sum = 0.0;
                    ArrayList<Double> unterhaltungsabschnitteTmp = new ArrayList<Double>();
                    for (Double tmp : this.unterhaltungsabschnitteLaenge) {
                        sum += tmp.doubleValue();
                    }
                    for (Double tmp : this.unterhaltungsabschnitteLaenge) {
                        unterhaltungsabschnitteTmp.add(tmp / sum);
                    }
                    this.unterhaltungsabschnitteLaenge = unterhaltungsabschnitteTmp;
                }
            }
        });
        frame.getContentPane().add(uaf);
        frame.setDefaultCloseOperation(3);
        frame.setSize(1300, 75);
        frame.setVisible(true);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!e.isPopupTrigger() && e.getButton() == 1) {
            ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), this.componentActionTextMap.get((JComponent)e.getSource()).toString(), e.getWhen(), e.getModifiers());
            LOG.error((Object)("mouse" + this.componentActionTextMap.get((JComponent)e.getSource())));
            for (ActionListener listener : this.actionListener) {
                listener.actionPerformed(ae);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void beansDropped(ArrayList<CidsBean> beans) {
        for (CidsBeanDropListener tmp : this.cidsBeanDropListener) {
            tmp.beansDropped(beans);
        }
    }

    public void addCidsBeanDropListener(CidsBeanDropListener listener) {
        this.cidsBeanDropListener.add(listener);
    }

    public void removeCidsBeanDropListener(CidsBeanDropListener listener) {
        this.cidsBeanDropListener.remove(listener);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListener.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListener.remove(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.refreshScale();
    }

    private class ComponentInformation {
        private int x;
        private int y;
        private GridBagConstraints constraints;

        public ComponentInformation(int x, int y, GridBagConstraints constraints) {
            this.x = x;
            this.y = y;
            this.constraints = constraints;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public String toString() {
            return this.x + ", " + this.y;
        }

        public GridBagConstraints getConstraints() {
            return this.constraints;
        }

        public void setConstraints(GridBagConstraints constraints) {
            this.constraints = constraints;
        }
    }
}

