/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.UIUtil;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public class WirkungPan
extends JPanel
implements DisposableCidsBeanStore,
CidsBeanDropListener,
EditorSaveListener {
    private static final Logger LOG = Logger.getLogger(WirkungPan.class);
    private static final int FG_ART = 1;
    private static final int SG_ART = 2;
    private static final int KG_ART = 3;
    private static final int GW_ART = 4;
    private static final int PLE_ART = 5;
    private static final int FGE_ART = 7;
    private static final int BG_ART = 6;
    private WbModel wbListModel = new WbModel();
    private CidsBean cidsBean;
    private boolean readOnly = false;
    private ArrayList<CidsBean> beansToDelete = new ArrayList();
    private JButton btnRemWirkung;
    private JLabel jLabel1;
    private JList lstWirkung;
    private SemiRoundedPanel panHeadInfo;
    private RoundedPanel panInfo;
    private JPanel panInfoContent;
    private JPanel panwirk;
    private JScrollPane scpWirkung;

    public WirkungPan() {
        this(false);
    }

    public WirkungPan(boolean readOnly) {
        this.readOnly = readOnly;
        this.initComponents();
        this.lstWirkung.setModel(this.wbListModel);
        if (!readOnly) {
            try {
                new CidsBeanDropTarget((Component)this);
            }
            catch (Exception ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"error while creating CidsBeanDropTarget", (Throwable)ex);
                }
            }
        } else {
            this.panwirk.setVisible(false);
        }
    }

    private void initComponents() {
        this.panInfo = new RoundedPanel();
        this.panHeadInfo = new SemiRoundedPanel();
        this.jLabel1 = new JLabel();
        this.panInfoContent = new JPanel();
        this.panwirk = new JPanel();
        this.btnRemWirkung = new JButton();
        this.scpWirkung = new JScrollPane();
        this.lstWirkung = new JList();
        this.setMinimumSize(new Dimension(995, 175));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(995, 175));
        this.setLayout(new BorderLayout());
        this.panHeadInfo.setBackground(new Color(51, 51, 51));
        this.panHeadInfo.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo.setLayout((LayoutManager)new FlowLayout());
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Wirkung");
        this.panHeadInfo.add((Component)this.jLabel1);
        this.panInfo.add((Component)this.panHeadInfo, (Object)"North");
        this.panInfoContent.setOpaque(false);
        this.panInfoContent.setLayout(new GridBagLayout());
        this.panwirk.setOpaque(false);
        this.panwirk.setLayout(new GridBagLayout());
        this.btnRemWirkung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_remove_mini.png")));
        this.btnRemWirkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WirkungPan.this.btnRemWirkungActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.panwirk.add((Component)this.btnRemWirkung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.panInfoContent.add((Component)this.panwirk, gridBagConstraints);
        this.scpWirkung.setMinimumSize(new Dimension(300, 60));
        this.scpWirkung.setPreferredSize(new Dimension(300, 60));
        this.lstWirkung.setSelectionMode(0);
        this.scpWirkung.setViewportView(this.lstWirkung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panInfoContent.add((Component)this.scpWirkung, gridBagConstraints);
        this.panInfo.add((Component)this.panInfoContent, (Object)"Center");
        this.add((Component)this.panInfo, "Center");
    }

    private void btnRemWirkungActionPerformed(ActionEvent evt) {
        Object selection = this.lstWirkung.getSelectedValue();
        if (selection != null) {
            int answer;
            String typeString = "den Wasserk\u00f6rper";
            Object kind = ((CidsBean)selection).getProperty("art");
            if (kind != null) {
                if (kind.equals(5)) {
                    typeString = "die Planungseinheit";
                } else if (kind.equals(7)) {
                    typeString = "die Flussgebietseinheit";
                } else if (kind.equals(6)) {
                    typeString = "das Bearbeitungsgebiet";
                }
            }
            if ((answer = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Soll die Wirkung auf " + typeString + " '" + selection.toString() + "' wirklich gel\u00f6scht werden?", "Wirkung entfernen", 0)) == 0) {
                try {
                    CidsBean bean = (CidsBean)selection;
                    this.removeWB(bean);
                    this.wbListModel.removeElement(bean);
                }
                catch (Exception e) {
                    UIUtil.showExceptionToUser(e, this);
                }
            }
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
        }
        this.wbListModel.setElements();
    }

    public void dispose() {
        this.setCidsBean(null);
    }

    public void beansDropped(ArrayList<CidsBean> beans) {
        if (this.cidsBean != null && !this.readOnly) {
            for (CidsBean bean : beans) {
                if (!bean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_fg") && !bean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_sg") && !bean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_kg") && !bean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_gw") && !bean.getClass().getName().equals("de.cismet.cids.dynamics.Planungseinheit") && !bean.getClass().getName().equals("de.cismet.cids.dynamics.Flussgebietseinheit") && !bean.getClass().getName().equals("de.cismet.cids.dynamics.Bearbeitungsgebiet")) continue;
                this.addWB(bean);
            }
        }
    }

    private void removeWB(CidsBean bean) {
        Object beanColl = this.cidsBean.getProperty("wirkung_wk");
        if (beanColl instanceof Collection) {
            ((Collection)beanColl).remove(bean);
            try {
                bean.delete();
                this.beansToDelete.add(bean);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while deleting a bean.", (Throwable)e);
            }
        }
    }

    private void addWB(CidsBean wkBean) {
        CidsBean wirkung = WirkungPan.addWB(this.cidsBean, wkBean);
        if (wirkung != null) {
            this.wbListModel.addElement(wirkung);
        }
    }

    public static CidsBean addWB(CidsBean measureType, CidsBean wkBean) {
        Collection collection = (Collection)measureType.getProperty("wirkung_wk");
        if (collection == null) {
            LOG.error((Object)"Collection of property wirkung_wk is null");
            return null;
        }
        try {
            CidsBean w = CidsBeanSupport.createNewCidsBeanFromTableName("wirkung_wk");
            w.setProperty("wk_id", wkBean.getProperty("id"));
            if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_fg")) {
                w.setProperty("art", (Object)1);
                w.setProperty("name", wkBean.getProperty("wk_k"));
            } else if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_sg")) {
                w.setProperty("art", (Object)2);
                w.setProperty("name", wkBean.getProperty("wk_k"));
            } else if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_kg")) {
                w.setProperty("art", (Object)3);
                w.setProperty("name", wkBean.getProperty("name"));
            } else if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Wk_gw")) {
                w.setProperty("art", (Object)4);
                w.setProperty("name", wkBean.getProperty("name"));
            } else if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Planungseinheit")) {
                w.setProperty("art", (Object)5);
                w.setProperty("name", wkBean.getProperty("kuerzel"));
            } else if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Flussgebietseinheit")) {
                w.setProperty("art", (Object)7);
                w.setProperty("name", wkBean.getProperty("nr"));
            } else if (wkBean.getClass().getName().equals("de.cismet.cids.dynamics.Bearbeitungsgebiet")) {
                w.setProperty("art", (Object)6);
                w.setProperty("name", wkBean.getProperty("kuerzel"));
            } else {
                LOG.error((Object)"Invalid bean type found.");
                return null;
            }
            if (!WirkungPan.containsWirkung(collection, w)) {
                collection.add(w);
                return w;
            }
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot add object.", (Throwable)e);
            return null;
        }
    }

    private static boolean containsWirkung(Collection<CidsBean> collection, CidsBean wirkung) {
        Object art = wirkung.getProperty("art");
        Object id = wirkung.getProperty("wk_id");
        for (CidsBean tmp : collection) {
            if (!tmp.getProperty("wk_id").equals(id) || !tmp.getProperty("art").equals(art)) continue;
            return true;
        }
        return false;
    }

    public void addWirkungToListModel(CidsBean w) {
        this.wbListModel.addElement(w);
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        for (CidsBean bean : this.beansToDelete) {
            try {
                bean.persist();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while deleting bean", (Throwable)e);
            }
        }
        this.beansToDelete.clear();
        return true;
    }

    private class WbModel
    implements ListModel {
        List<ListDataListener> listDataListener = new ArrayList<ListDataListener>();
        List<CidsBean> elements = new ArrayList<CidsBean>();

        public WbModel() {
            this.setElements();
        }

        @Override
        public int getSize() {
            return this.elements.size();
        }

        public Object getElementAt(int index) {
            return this.elements.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listDataListener.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listDataListener.remove(l);
        }

        public void removeElement(CidsBean o) {
            this.elements.remove(o);
            this.fireContentChangedEvent();
        }

        public void addElement(CidsBean o) {
            this.elements.add(o);
            this.fireContentChangedEvent();
        }

        private void fireContentChangedEvent() {
            ListDataEvent event = new ListDataEvent(this, 0, 0, this.elements.size());
            for (ListDataListener listener : this.listDataListener) {
                listener.contentsChanged(event);
            }
        }

        public void setElements() {
            Collection collection;
            this.elements.clear();
            if (WirkungPan.this.cidsBean != null && (collection = (Collection)WirkungPan.this.cidsBean.getProperty("wirkung_wk")) != null) {
                for (CidsBean bean : collection) {
                    this.elements.add(bean);
                }
            }
            this.fireContentChangedEvent();
        }

        public void clear() {
            this.elements.clear();
            this.fireContentChangedEvent();
        }
    }
}

